<?php
class newmbaController Extends baseController
{
    public function index()
    {
        if ($_SERVER['REQUEST_URI'] == '/?page=newmba') {
            return header('Location: /NEW-MBA');
        }
        if (strpos($_SERVER['REQUEST_URI'], '?offer_id') !== false) {
            $explode = explode('?offer_id', $_SERVER['REQUEST_URI']);
            $implode = implode('&offer_id', $explode);
            return header('Location: ' . $implode);
        }
        global $location;
        $location = $this->getlocation();
        $module_id = get('module_id');
        if (!empty($module_id)) {
            $category=null;
            $category_id=get('category_id');
            if($category_id){
                $category=$this->registry->newmba->getmbacategory($category_id);
                if(!isset($category)){
                    self::redirect404();
                    exit;
                }
                $this->registry->template->category=$category;
            }
            $module = $this->registry->newmba->getsinglembamodule($module_id,"",null,$category);
            if (!isset($module->id)) {
                self::redirect404();
                exit;
            }

            if(isset($_GET['action'])&&$_GET['action']=='projectTab'){
                $user_id=$this->getuserid();
                $projectData=$this->registry->newmba->getModuleProjectData($module->id,$user_id,$module->hasModule);
                $this->registry->template->projectData=$projectData;
                $summary=$this->registry->newmba->getModuleUserSummary($module->id,$user_id);
                $this->registry->template->summary=$summary;
            }
            if(isset($_GET['action'])&&$_GET['action']=='summaryTab'){
                $user_id=$this->getuserid();
                $summary=$this->registry->newmba->getModuleUserSummary($module->id,$user_id);
                $this->registry->template->summary=$summary;
            }
            self::display_single_mba_module($module_id, $module);
        } else {
            self::get_all_mba();
        }
    }

    public function display_single_mba_module($module_id, $module)
    {
        $user_id = self::getuserid();
        if($user_id<1){
            return header('Location: /login');exit;
        }
        if(!$module->hasModule&&!get('preview')){return header('Location: /subscription');exit;}
        $courses=$this->registry->newmba->getmbamodulecourses($module->hasModule," and  new_mba.url='$module_id' ");
        $part2courses=$this->registry->newmba->getmbamodulecoursespart2($module->hasModule," and  new_mba.url='$module_id'");

        $summary=$this->registry->newmba->getModuleUserSummary($module->id,$user_id,$part2courses);
//        if($user_id==877074){
//            print_r($summary);die();
//        }
        $this->registry->template->coursespart2=$part2courses;
        $this->registry->template->summary=$summary;
        $this->registry->template->courses=$courses;
        $this->registry->template->module=$module;
//
        $this->registry->template->page_body = getviewslink() . '/academy/new-mba/singlemba';
        $this->registry->template->show('index_home');
    }
    public function get_all_mba()
    {
        $mba = $this->registry->newmba->getallmba();
        $accreditations=$this->registry->users->getaccreditationstype('new_mba',1);
        $brochure = $this->registry->newmba->getmbabrochure();
        $mbaCategories = $this->registry->newmba->getallmbacategoris();
        $this->registry->template->mba = $mba;
        $this->registry->template->brochure = $brochure;

        $this->registry->template->mbaCategories = $mbaCategories;
        $user_id=$this->getuserid();
        $this->registry->template->hasMBA = $this->registry->newmba->hasMBA($user_id);
        $Category= $this->registry->newmba->hasCategory($user_id);
        $this->registry->template->category =$Category;

        $projectData=$this->registry->newmba->getCategoryProjectData($Category->category_id,$user_id);
        $this->registry->template->projectData=$projectData;

        $summary=$this->registry->newmba->getCategoryProjectSummary($Category->category_id,$user_id);
        $this->registry->template->summary=$summary;
        $accreditations=$this->registry->users->getaccreditationstype('new_mba',1);
        $this->registry->template->accreditations=$accreditations;

        $this->registry->template->page_body = getviewslink() . '/academy/new-mba/mba';
        $this->registry->template->show('index_home');
    }
    public function category(){
        $category_id=get('category_id');
        $user_id=$this->getuserid();
        if($category_id){
            $category=$this->registry->newmba->getmbacategory($category_id);
            if(isset($category->id)){
                $this->registry->template->category=$category;
                $mba=$this->registry->newmba->getmbacategorymodules($category->id);
                $this->registry->template->mba=$mba;
                $this->registry->template->hasMBA=$this->registry->newmba->hasMBACategory($category->id,$user_id);
                $this->registry->template->page_body = getviewslink() . '/academy/new-mba/mba-category';
                $this->registry->template->show('index_home');
            }else{
                return self::get_all_mba();
            }
        }else{
            return self::get_all_mba();
        }
    }
    public function downloadProject(){
        $project_id=post('project_id');
        $module_id=post('module_id');
        $user_id=$this->getuserid();
        $this->registry->newmba->downloadProject($user_id,$project_id,$module_id);
    }
    public function uploadProject(){
        $user_action='Upload Project New Mba';
        $user_action_table='new_mba_modules_users_projects';
        $user_action_table_id=post('project_id');
        $this->registry->users->activity_action($user_action,$user_action_table,$user_action_table_id);
        $project_id=post('project_id');
        $module_id=post('module_id');
        $user_id=$this->getuserid();
        $this->registry->newmba->uploadProject($user_id,$project_id,$module_id);
    }
    public function downloadcategoryProject(){
        $project_id=post('project_id');
        $category_id=post('category_id');
        $user_id=$this->getuserid();
        $this->registry->newmba->downloadcategoryProject($user_id,$project_id,$category_id);
    }
    public function uploadCategoryProject(){
        $user_action='Upload Project New Mba Category';
        $user_action_table='new_mba_category_users_projects';
        $user_action_table_id=post('project_id');
        $this->registry->users->activity_action($user_action,$user_action_table,$user_action_table_id);
        $project_id=post('project_id');
        $category_id=post('category_id');
        $user_id=$this->getuserid();
        $this->registry->newmba->uploadCategoryProject($user_id,$project_id,$category_id);
    }
    public function helperCourses(){
        $user_id=$this->getuserid();
        $hasModule=$this->registry->newmba->hasMBA($user_id);
        $this->registry->template->hasMBA =$hasModule ;
        $this->registry->template->courses = $this->registry->newmba->getMbaHelperCourses($hasModule);
        $this->registry->template->page_body = getviewslink() . '/academy/new-mba/mba';
        $this->registry->template->show('index_home');
    }
    public function singleHelperCourse(){
        $user_id=$this->getuserid();
        $hasModule=$this->registry->newmba->hasMBA($user_id);
        $this->registry->template->hasMBA =$hasModule ;
        $course_id=get('course_id');
        if($course_id){
            $course=$this->registry->newmba->getSingleMbaHlperCoure($course_id);
            if(isset($course->id)){
                $course->hasCourse=$hasModule;
                $helperCourse=$hasModule;
                $this->registry->template->helperCourse=$helperCourse;
                $this->registry->template->course=$course;
                $sections=$this->registry->newmba->getcourse_sections($course->id);
                $this->registry->template->sections=$sections;
                if($this->getuserid()){
                    $this->registry->template->courses_questions=$this->registry->newmba->getCourseQuestionsAnswers($course->id,$this->getuserid());
                }
                //$courses=$this->registry->newmba->getallcourses();
                //	$this->registry->template->courses=$courses;
                //faq
                $faqs=$this->registry->newmba->getfaq($course->id);
                $this->registry->template->faqs=$faqs;
                //faq
                $this->registry->template->page_body = getviewslink().'/academy/new-mba/singlecourse';
                $this->registry->template->show('index_home');
            }else{
                self::helperCourses();
            }
        }
    }
    public function showCurriculum(){
        $course_id=get('course_id');
        $course_curriculum_id=get('curriculum_id');
        $user_id=$this->getuserid();
        if($user_id){
            $hasModule=$this->registry->newmba->hasMBA($user_id);
            $nextVide = $this->getNextVideo($course_id, $course_curriculum_id, $hasModule);
            $this->registry->users->update_last_login_new_mba($this->getuserid(),$course_id);
            $course->hasCourse=$hasModule;
            $this->registry->template->course=$nextVide['course'];
            $this->registry->template->video=$nextVide['video'];
            $sections=$this->registry->users->getCourseCurriculumSections($course_id);
            $this->registry->template->sections=$sections;
            $this->registry->template->show('/academy/showvideo');
        }else{
            //$this->registry->sessionhandler->put('HTTP_REFERER','courses/'.$course_id.'/showCurriculum/'.$course_curriculum_id);
            return header('Location: /login');
        }
    }
    public function showCurriculumaudio(){
        $course_id=get('course_id');
        $course_curriculum_id=get('curriculum_id');
        $user_id=$this->getuserid();
        if($user_id){
            $hasModule=$this->registry->newmba->hasMBA($user_id);
            $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
            if($hasModule||$video->isfree){
                $this->registry->template->hasMBA =$hasModule ;
                $this->registry->template->helperCourse =true ;
                $course=$this->registry->newmba->getSingleMbaHlperCoure($course_id);
                if(isset($course->id)){
                    $this->registry->users->update_last_login_new_mba($this->getuserid(),$course->id);
                    $course->hasCourse=$hasModule;
                    $this->registry->template->course=$course;
                    $this->registry->template->video=$video;
                    $sections=$this->registry->users->getCourseCurriculumSections($course_id);
                    $this->registry->template->sections=$sections;
                    $this->registry->template->show('academy/showaudio');
                }
            }
        }else{
            //$this->registry->sessionhandler->put('HTTP_REFERER','courses/'.$course_id.'/showCurriculum/'.$course_curriculum_id);
            return header('Location: /login');
        }
    }
    public function mbaCourse(){

        $mba_id=get('mba_id');
        $course_id=get('course_id');
        $category=null;
        $category_id=get('category_id');
        if($category_id){
            $category=$this->registry->newmba->getmbacategory($category_id);
            if(!isset($category)){
                self::redirect404();
                exit;
            }
            $this->registry->template->category=$category;
        }
        $module=$this->registry->newmba->getsinglembamodule($mba_id,"",null,$category);
        $course=$this->registry->newmba->getmbasinglecourse($course_id);
        if($module->hasModule||get('preview')){
            if(isset($course->id)){

                $this->registry->template->hasMBA=$module->hasModule;
                $course->hasCourse=true;
                $course->hasDiplomaExam =false;
                $this->registry->template->course=$course;
                //$sections=$this->registry->newmba->getcourse_sections($course->id);
                //$this->registry->template->sections=$sections;
                $sections=$this->registry->users->getcourse_sectionsWithNumbers($course->id);
                $this->registry->template->sections=$sections['sections'];
                $this->registry->template->hours_numbers=$sections['hours_numbers'];
                $this->registry->template->sections_numbers=$sections['sections_numbers'];
                $this->registry->template->module=$module;
                if($this->getuserid()){
                    $this->registry->users->update_last_login_new_mba($this->getuserid(),$course->id);
                    $this->registry->template->courses_questions=$this->registry->users->getCourseQuestionsAnswers($course->id,$this->getuserid());
                }
                //$courses=$this->registry->newmba->getallcourses();
                //	$this->registry->template->courses=$courses;
                //faq
                $faqs=$this->registry->users->getfaq($course->id);
                $this->registry->template->faqs=$faqs;
                //faq
                $accreditations=$this->registry->users->getaccreditationstype('course',1);
                $this->registry->template->accreditations=$accreditations;
                $this->registry->template->showTraining=$this->registry->newmba->showTraining();
                $this->registry->template->page_body = getviewslink().'/academy/singlecourse';
                $this->registry->template->show('index_home');
            }else{
                self::redirect404();
            }
        }else{
            self::redirect404();
        }
    }
    public function mbaCourseShowCurriculum(){
        $course_id=get('course_id');
        $course_curriculum_id=get('curriculum_id');
        $mba_id=get('mba_id');
        //echo $username;

        $userID=$this->getuserid();

        if($userID){
            $module=$this->registry->newmba->getsinglembamodule($mba_id);
            if(isset($module->id)){
                if($course_curriculum_id>0) {
                    $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
                }
                if ($video->isfree=='yes'){
                    $allowPage=true;
                }elseif($module->hasModule){
                    $allowPage=true;
                }

                if($allowPage){
                    global  $location;
                    $location = $this->getlocation();
                    if (!empty($course_id)) {
                        $course = $this->registry->newmba->getmbasinglecourse($course_id, $location);
                        if (!isset($course->id)) {
                            self::get_all_mba();
                            exit;
                        }
                        $this->registry->template->hasMBA=$module->hasModule;
                        $course->hasCourse=true;
                        $course->hasDiplomaExam =false;
                        if($course_curriculum_id>0){
                            $video=$this->registry->users->getCourseCurriculum($course_id,$course_curriculum_id);

                            if(isset($video->id)){
                                if($course->hasCourse||$video->isfree=='yes'){
                                    $this->registry->template->module=$module;
                                    $this->registry->template->course=$course;
                                    $this->registry->template->video=$video;
                                    $sections=$this->registry->users->getCourseCurriculumSections($course_id);
                                    $this->registry->template->sections=$sections;
                                    $this->registry->template->show('/academy/showvideo');
                                }else{
                                    return header('Location: /subscribe');
                                }
                            }else{
                                self::display_all_courses();
                            }
                        }else{
                            self::display_all_courses();
                        }
                    }else{
                        self::display_all_courses();
                    }
                }else{
                    return header('Location: /subscribe');
                }
            }else{
                return $this->redirect404();
            }

        }else{
            $this->registry->sessionhandler->put('HTTP_REFERER','MBA/'.$mba_id.'/showCurriculum/'.$course_curriculum_id.'/'.$course_id);
            return header('Location: /login');
        }

    }
    public function mbaCourseShowCurriculumaudio(){
        $course_id=get('course_id');
        $course_curriculum_id=get('curriculum_id');
        $mba_id=get('mba_id');
        //echo $username;

        $userID=$this->getuserid();

        if($userID){
            $module=$this->registry->newmba->getsinglembamodule($mba_id);
            if(isset($module->id)){
                if($course_curriculum_id>0) {
                    $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
                }
                if ($video->isfree=='yes'){
                    $allowPage=true;
                }elseif($module->hasModule){
                    $allowPage=true;
                }

                if($allowPage){
                    global  $location;
                    $location = $this->getlocation();
                    if (!empty($course_id)) {
                        $course = $this->registry->newmba->getmbasinglecourse($course_id, $location);
                        if (!isset($course->id)) {
                            self::display_all_courses();
                            exit;
                        }
                        $this->registry->template->hasMBA=$module->hasModule;
                        $course->hasCourse=true;
                        $course->hasDiplomaExam =false;
                        if($course_curriculum_id>0){
                            $video=$this->registry->users->getCourseCurriculum($course_id,$course_curriculum_id);

                            if(isset($video->id)){
                                if($course->hasCourse||$video->isfree=='yes'){
                                    $this->registry->template->module=$module;
                                    $this->registry->template->course=$course;
                                    $this->registry->template->video=$video;
                                    $sections=$this->registry->users->getCourseCurriculumSections($course_id);
                                    $this->registry->template->sections=$sections;
                                    $this->registry->template->show('academy/showaudio');
                                }else{
                                    return header('Location: /subscribe');
                                }
                            }else{
                                self::display_all_courses();
                            }
                        }else{
                            self::display_all_courses();
                        }
                    }else{
                        self::display_all_courses();
                    }
                }else{
                    return header('Location: /subscribe');
                }
            }else{
                return $this->redirect404();
            }

        }else{
            $this->registry->sessionhandler->put('HTTP_REFERER','MBA/'.$mba_id.'/showCurriculum/'.$course_curriculum_id.'/'.$course_id);
            return header('Location: /login');
        }
    }
    public function startModule(){
        $module_url=post('module_url');
        echo $this->registry->newmba->startModule($module_url);
    }
    public function showExam(){
//        self::exam();
//        return'';
        $user_id = $this->getuserid();

        if($user_id){
            $module_id = get('module_id');
            $module = $this->registry->newmba->getsinglembamodule($module_id);
            if(!isset($module->id)){return self::index();}
            $this->registry->template->module = $module;
            $this->registry->template->page_body = getviewslink() . '/academy/new-mba/mbaexamlanguage';
            $this->registry->template->show('index_home');
        }else{
            return self::index();
        }
    }
    public function exam()
    {

        $user_id = $this->getuserid();
        if($user_id){
            $module_id = get('module_id');
            $lang = get('lang');
            if(!$lang){
                $lang='ar';
                $_GET['lang']='ar';
            }
            $module = $this->registry->newmba->getsinglembamodule($module_id);
            if($module_id&&$module->hasModule){
                $this->registry->template->course = $module;
                $hasExam=$this->registry->newmba->hasMakeModuleExam($module->id);
                $this->registry->template->hasExam=$hasExam;
                $exam_quetions = $this->registry->newmba->getMbaModuleExamQuestions($module->id,$module->partone_questions_numbers,$module->parttwo_questions_numbers,$lang);
                $module_language = $this->registry->newmba->getModuleLang($module->id);
                $this->registry->template->exam_quetions = $exam_quetions;
                $this->registry->template->module_language = $module_language;
                $user_action='New Mba Exam';
                $user_action_table='new_mba_exams';
                $user_action_table_id=$module->id;
                $this->registry->users->activity_action($user_action,$user_action_table,$user_action_table_id);
                $this->registry->template->page_body = getviewslink() . '/academy/new-mba/mbasingleexam';
                $this->registry->template->show('index_home');
            }else{
                return self::index();
            }
        }else{
            return self::index();
        }

    }
    public function endExam()
    {

        $user_id = $this->getuserid();
        if ($user_id) {
            $module_id = get('module_id');
            if ($module_id) {
                $module = $this->registry->newmba->getsinglembamodule($module_id);
                if ($module->hasModule) {
                    if (isset($_POST['questions'])) {
                        $questions = $_POST['questions'];
                        $lang=(isset($_GET['lang']))?$_GET['lang']:'ar';
                        $this->registry->newmba->completeMbaExamQuetions($questions,$module->partone_questions_numbers,$module->parttwo_questions_numbers,$module->id,$lang);
                    } else {
                        $errorMessage = 'تأكد من الإجابه على جميع الاسئله';
                        include 'views/message/error_message.php';
                    }
                }
            }
        }
    }

    public function showTraining(){
        $user_id = $this->getuserid();
        if($user_id){
            $module_id = get('module_id');
            $training_id = get('training_id');
            $module = $this->registry->newmba->getsinglembamodule($module_id);
            if(!isset($module->id)){return self::index();}
            $this->registry->template->module = $module;
            $this->registry->template->page_body = getviewslink() . '/academy/new-mba/mbatraininglanguage';
            $this->registry->template->show('index_home');
        }else{
            return self::index();
        }
    }

    public function training()
    {
        $user_action='New Mba Training';
        $user_action_table='modules_trainings';
        $user_action_table_id=get('training_id');
        $this->registry->users->activity_action($user_action,$user_action_table,$user_action_table_id);
        $user_id = $this->getuserid();
        if($user_id){
            $module_id = get('module_id');
            $training_id = get('training_id');
            $lang = get('lang');
            $module = $this->registry->newmba->getsinglembamodule($module_id);
            $training=$this->registry->newmba->getsinglembamoduletraining($module->id,$training_id);
            if($module_id&&$module->hasModule&&isset($training->id)){
                $this->registry->template->course = $module;
                $this->registry->template->training = $training;
                //print_r($module);
                $exam_quetions = $this->registry->newmba->getMbaModuleTrainingQuestions($module->id,$training->questions_numbers,$training_id,$lang);
                $this->registry->template->exam_quetions = $exam_quetions;
                //var_dump($exam_quetions);
                $this->registry->template->page_body = getviewslink() . '/academy/new-mba/mbasingletraining';
                $this->registry->template->show('index_home');
            }else{
                return self::index();
            }
        }else{
            return self::index();
        }

    }
    public function endTraining()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $module_id = get('module_id');
            $training_id = get('training_id');
            if ($module_id) {
                $module = $this->registry->newmba->getsinglembamodule($module_id);
                $training=$this->registry->newmba->getsinglembamoduletraining($module->id,$training_id);
                if ($module->hasModule&&isset($training->id)) {
                    if (isset($_POST['questions'])) {
                        $questions = $_POST['questions'];

                        $this->registry->newmba->completeMbaTrainingQuetions($questions,$training->questions_numbers,$module->id,$training_id);
                    } else {
                        $errorMessage = 'تأكد من الإجابه على جميع الاسئله';
                        include 'views/message/error_message.php';
                    }
                }
            }
        }
    }
    public function resultView(){
        if($this->getuserid()) {
            $result_id = get('result_id');
            if ($result_id) {
                $lang=get('lang');
                $answer = $this->registry->newmba->getMbaExamAnswers($result_id,$lang);
                if($answer){
                    $this->registry->template->answer=$answer;
                    $this->registry->template->showAnswers=(isset($_GET['showAnswers'])?true:false);
                    $this->registry->template->page_body = getviewslink().'/academy/new-mba/mbasinglereport';
                    $this->registry->template->show('index_home');
                }else {
                    self::index();
                }
            } else {
                self::index();
            }
        }else{
            self::index();
        }
    }
    public function resultTrainingView(){
        if($this->getuserid()) {
            $result_id = get('result_id');
            if ($result_id) {
                $lang=get('lang');
                $answer = $this->registry->newmba->getMbaTrainingAnswers($result_id,$lang);
                if($answer){
                    $this->registry->template->answer=$answer;
                    $this->registry->template->showAnswers=true;
                    $this->registry->template->page_body = getviewslink().'/academy/new-mba/mbasinglereport';
                    $this->registry->template->show('index_home');
                }else {
                    self::index();
                }
            } else {
                self::index();
            }
        }else{
            self::index();
        }
    }

    private function getNextVideo($course_id, $course_curriculum_id, $hasModule){
        $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
        if(($hasModule||$video->isfree) && !in_array($video->type ,['exam', 'training'])){
            $this->registry->template->hasMBA =$hasModule;
            $this->registry->template->helperCourse =true ;
            $course=$this->registry->newmba->getSingleMbaHlperCoure($course_id);
            if(isset($course->id)){
                return ['course' => $course, 'video' => $video];
            }
        }
        return $this->getNextVideo($course_id, $video->id, $hasModule);
    }
}
