<?php

Class diplomasSupplementaryExamsController Extends baseController {

    /****
     * Start index() method
     * The root method of the controller
     */

    public function index() {
        return header('Location: /searchcertificate');
    }

    /****
     * End index() method
     * The root method of the controller
     */

    /***
     * Start Function exam()
     * that display the user certificate supplementary exam questions
     */

    public function exam(){

        $user_id=$this->getuserid(); // get user id

        if( isset($user_id) && !empty($user_id) ) { // check if there is a login user

            $diploma_url = $_REQUEST['diploma_id']; // get diploma url [ diploma id ]

            // get diploma info
            $diploma = $this->registry->users->getsinglediploma($diploma_url);

            $diploma_id = $diploma->id;
            $diploma_name = $diploma->name;

            // check if the login user has a certificate in the specified diploma

            $loginUserHasCertificateInSpecifiedDiploma = $this->registry->users->loginUserHasCertificateInSpecifiedDiploma($user_id,$diploma_id);
             if($loginUserHasCertificateInSpecifiedDiploma) {

                 // get exam id
                $exam_info = $this->registry->users->getDiplomasSupplementaryTestsInfo($diploma_id);
                $exam_id   = $exam_info->id;

                 // get questions details
                $exam = $this->registry->users->getSupplementaryExamWithQuestions($exam_id);
                 if($exam) {

                     $hasExam=$this->registry->users->hasMakeSupplementaryExam($exam_id);
                     $this->registry->template->diploma_name=$diploma_name; 
                     $this->registry->template->diploma_url=$diploma_url;
                     $this->registry->template->exam=$exam;
                     $this->registry->template->exam_id=$exam_id;
                     $this->registry->template->hasExam=$hasExam;
                     $this->registry->template->SupplementaryExam=true;
                     $this->registry->template->page_body = getviewslink().'/academy/singleSupplementaryExam';
                     $this->registry->template->show('index_home');

                 }else {
                     self::index();
                 }

             }else {
                 self::index();
             }
        }else {
            self::index();
        }
    }

    /***
     * End Function exam()
     * that display the user certificate supplementary exam questions
     */


    /***
     * Start Function endExam()
     * that terminate user login supplementary exam
     */

     public function endExam() {

         $user_id = $this->getuserid(); // get user id

         if(isset($user_id) && !empty($user_id) ) {

              $diploma_id = get("diploma_id");

              $exam_id    = get("exam_id");

              if($diploma_id) {

                  $diploma = $this->registry->users->getsinglediploma($diploma_id);

                  if($diploma) {

                      $exam = $this->registry->users->getSingleSupplementarySection($exam_id,'exam');

                      if($exam) {

                          if(isset($_POST['questions']) && !empty($_POST['questions'])){ 
                              $questions=$_POST['questions'];
                              $this->registry->users->completeSupplementaryQuestions($questions,$exam_id,'exam');
                          }
                          else{
                              $errorMessage= 'تأكد من الإجابه على جميع الاسئله';
                              include 'views/message/error_message.php';
                          }

                      }else {

                          self::index();

                      }

                  }else {

                      self::index();

                  }

              }else {

                  self::index();

              }

         }else {

             self::index();

         }

     }

    /***
     * End Function endExam()
     * that terminate user login supplementary exam
     */

    /***
     * Start Function resultView()
     * that displays a report of user supplementary
     * exam answers
     */

    public function resultView() {

         if($this->getuserid()){
             $result_id = get('result_id');
             if($result_id) {
                 $answer = $this->registry->users->getSupplementaryCurriculumAnswers($result_id);
                 if($answer) {
                     $this->registry->template->answer=$answer;
                     $this->registry->template->page_body = getviewslink().'/academy/singleSupplementaryReport';
                     $this->registry->template->show('index_home');
                 }else {
                     self::index();

                 }

             }else {

                 self::index();

             }

         }else {

             self::index();

         }

    }

    /***
     * End Function resultView()
     * that displays a report of user supplementary
     * exam answers
     */

}
