<?php
class dbaController Extends baseController
{
    public function index()
    {
        if ($_SERVER['REQUEST_URI'] == '/?page=dba') {
            return header('Location: /DBA');
        }
        if (strpos($_SERVER['REQUEST_URI'], '?offer_id') !== false) {
            $explode = explode('?offer_id', $_SERVER['REQUEST_URI']);
            $implode = implode('&offer_id', $explode);
            return header('Location: ' . $implode);
        }
        $hasDBA=$this->registry->dba->hasDBA();
        $this->registry->template->dbaData=$this->registry->dba->getDBAData();
        $this->registry->template->courses=$this->registry->users->getDBACourses($hasDBA);
        $this->registry->template->dbaFaq=$this->registry->dba->getDBAFaq();
        $this->registry->template->hasDBA=$hasDBA;
        if($hasDBA){
            $this->registry->template->dbaProgress=$this->registry->dba->getDBAProgress();
            $this->registry->template->dbaChecklists=$this->registry->dba->getDBAChecklists();
            $this->registry->template->dbaUserQuestions=$this->registry->dba->getDBAUserQuestions();
            $this->registry->template->dbaDoctorsFileProgress=$this->registry->dba->getDPADoctorsFileProgress();
            $this->registry->template->dbaPreliminaryCertificate=$this->registry->dba->getDPAPreliminaryCertificate();

        }
        $accreditations=$this->registry->users->getaccreditationstype('dba',1);
        $this->registry->template->accreditations=$accreditations;
        $this->registry->template->page_body = getviewslink() . '/academy/dba/single';
        $this->registry->template->show('index_home');
    }
    public function addNewQuestion(){
        $hasDBA=$this->registry->dba->hasDBA();
        if($hasDBA){
            $this->registry->dba->getDBAAddNewQuestion();
        }else{
            $errorMessage= 'ليس لديك اشتراك في DBA';
            include 'views/message/error_message.php';
        }

    }
    public function dbaCourse(){
        $hasDBA=$this->registry->dba->hasDBA();
        $this->registry->template->hasDBA=$hasDBA;
        if($hasDBA){
            $course_id=get('course_id');
            $course=$this->registry->users->getDBASingleCourse($course_id);
            $this->registry->template->course=$course;
            $course->hasDiplomaExam =false;
            $sections=$this->registry->users->getcourse_sectionsWithNumbers($course->id);
            $this->registry->template->sections=$sections['sections'];
            $this->registry->template->hours_numbers=$sections['hours_numbers'];
            $this->registry->template->sections_numbers=$sections['sections_numbers'];
            //faq
            $faqs=$this->registry->users->getfaq($course->id);
            $this->registry->template->faqs=$faqs;
            //faq
            $accreditations=$this->registry->users->getaccreditationstype('course',1);
            $this->registry->template->accreditations=$accreditations;
            $this->registry->template->page_body = getviewslink().'/academy/singlecourse';
            $this->registry->template->show('index_home');
        }
        else{
            $hasLiteVersion=$this->registry->users->hasLiteVersion();
            $this->registry->template->hasLiteVersion=$hasLiteVersion;
            $this->registry->template->page_body = getviewslink().'/academy/subscribe';
            $this->registry->template->show('index_home');
        }
    }
    public function dbaCourseShowCurriculum(){
        $course_id=get('course_id');
        $course_curriculum_id=get('curriculum_id');
        $hasDBA=$this->registry->dba->hasDBA();
        if($hasDBA){
            $course_id=get('course_id');
            $course=$this->registry->users->getDBASingleCourse($course_id);
            $this->registry->template->course=$course;
            $course->hasCourse=true;
            $course->hasDiplomaExam =false;
            $video=$this->registry->users->getCourseCurriculum($course_id,$course_curriculum_id);
            if(isset($video->id)){
                if($course->hasCourse||$video->isfree=='yes'){
                    $this->registry->template->course=$course;
                    $this->registry->template->video=$video;
                    $sections=$this->registry->users->getCourseCurriculumSections($course_id);
                    $this->registry->template->sections=$sections;
                    $this->registry->template->show('academy/showvideo');
                }else{
                    return header('Location: /subscribe');
                }
            }else{
                self::index();
            }
        }

    }
    public function dbaCourseShowCurriculumaudio(){
        $course_id=get('course_id');
        $course_curriculum_id=get('curriculum_id');
        $hasDBA=$this->registry->dba->hasDBA();
        if($hasDBA){
            $course=$this->registry->users->getDBASingleCourse($course_id);
            $this->registry->template->course=$course;
            $course->hasCourse=true;
            $course->hasDiplomaExam =false;
            $video=$this->registry->users->getCourseCurriculum($course_id,$course_curriculum_id);
            if(isset($video->id)){
                if($course->hasCourse||$video->isfree=='yes'){
                    $this->registry->template->course=$course;
                    $this->registry->template->video=$video;
                    $sections=$this->registry->users->getCourseCurriculumSections($course_id);
                    $this->registry->template->sections=$sections;
                    $this->registry->template->show('academy/showaudio');
                }else{
                    return header('Location: /subscribe');
                }
            }else{
                self::index();
            }
        }

    }
    public function uploadDBADoctorFile(){
        $this->registry->dba->uploadDBADoctorFile();
    }




}
