<?php

class customcoursesController extends baseController
{

    public function index()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $hasSubscription = $this->registry->users->hasCustomSubscription($user_id);
            if ($hasSubscription) {
                $courses_count = $this->registry->users->getCustomCoursesCount($this->getuserid());
                $user_courses = $this->registry->users->getCustomUserCoursesCount($this->getuserid());
                $this->registry->template->courses_count = $courses_count;
                $this->registry->template->user_courses = $user_courses;
                $this->registry->template->page_body = getviewslink() . '/academy/custom-courses';
                $this->registry->template->show('index_home');

            } else {
                return header('Location: /subscriptions');
            }

        } else {
            return header('Location: /login');
        }
    }

}
