<?php

class coursesPlansController extends baseController
{
    public function checkUserIsLogin(){
        $user_id=self::getuserid();
        if(!$user_id){
            header('Location: /login');
            return '';
        }
        return $user_id;
    }
    public function index()
    {
        $this->checkUserIsLogin();
        $this->registry->template->page_body = getviewslink() . '/academy/courses_plan/plans_details';
        $this->registry->template->show('index_home');
    }
    public function plansDetailsCalender(){
        $this->checkUserIsLogin();
        $this->registry->template->plansDetails=$this->registry->coursesplan->getPlansDetails('data');
        $this->registry->template->page_body = getviewslink() . '/academy/courses_plan/plans_details_calender';
        $this->registry->template->show('index_home');
    }
    public function showPlans(){
        $this->checkUserIsLogin();
        $this->registry->template->page_body = getviewslink() . '/academy/courses_plan/plans';
        $this->registry->template->show('index_home');
    }

    public function  addPlan() {
        $this->checkUserIsLogin();
        $this->registry->template->courses=$this->registry->coursesplan->getSubscriptionCourses();
        $this->registry->template->page_body = getviewslink() . '/academy/courses_plan/add_plan';
        $this->registry->template->show('index_home');
    }
    public function savePlan(){
        $this->checkUserIsLogin();
        $this->registry->coursesplan->savePlan();
    }
    public function getPlans(){
        $this->checkUserIsLogin();
        $this->registry->coursesplan->getPlans();
    }
    public function getPlansDetails(){
        $this->checkUserIsLogin();
        $this->registry->coursesplan->getPlansDetails();
    }
    public function deletePlan(){
        $this->checkUserIsLogin();
        $this->registry->coursesplan->deletePlan();
    }
    public function markAsDone(){
        $this->checkUserIsLogin();
        $this->registry->coursesplan->markAsDone();
    }
    public function cronJob(){
        $this->registry->coursesplan->cronJob($this->registry->emails);
    }
}
