<?php

class coursesController extends baseController
{

    public function index()
    {


        if ($_SERVER['REQUEST_URI'] == '/?page=courses') {
            return header('Location: /courses');
        }
        if (strpos($_SERVER['REQUEST_URI'], '?offer_id') !== false) {
            $explode = explode('?offer_id', $_SERVER['REQUEST_URI']);
            $implode = implode('&offer_id', $explode);
            return header('Location: ' . $implode);
        }
        global  $location;
        $location = $this->getlocation();
        $course_id = get('course_id');
        if (!empty($course_id)) {
            $course = $this->registry->users->getCourseByIDURL($course_id);
            if (count($course)) {
                if (strpos($_SERVER['REQUEST_URI'], '&offer_id') !== false) {
                    $explode = explode('&offer_id', $_SERVER['REQUEST_URI']);
                    return header('Location: /courses/' . $course->url . '&offer_id' . $explode[1]);
                } else {
                    return header('Location: /courses/' . $course->url);
                }
            }
            $courseURL = explode('-', $course_id);
            if (isset($courseURL[0]) && $courseURL[0] != 'كورس') {
                $course = $this->registry->users->getCourseByIDURL('كورس-' . $course_id, true);
                if (count($course)) {
                    if (strpos($_SERVER['REQUEST_URI'], '&offer_id') !== false) {
                        $explode = explode('&offer_id', $_SERVER['REQUEST_URI']);
                        return header('Location: /courses/' . $course->url . '&offer_id' . $explode[1]);
                    }
                }
            }

            $course = $this->registry->users->getsinglecourse($course_id, $location);
            if (!isset($course->id)) {
                $course_url = $this->registry->users->getOldUrl($course_id, 'courses');
                //die($course_url);
                if ($course_url && $course_url != $course_id) {
                    return header('Location: /courses/' . $course_url);
                } else {
                    $course = $this->registry->users->checkCourseSubscription($course_id);
                    if (isset($course->id)) {
                        $this->registry->template->course = $course;
                        $this->registry->template->page_body = getviewslink() . '/academy/courses_subscribe/' . $course->show_on;
                        $this->registry->template->show('index_home');
                        exit();
                    }

                    self::redirect404();
                    exit;
                }
            }
            self::display_single_course($course_id, $course);
        } else {
            self::display_all_courses();
        }
    }
    function search_instractores(){
        $term='';
        if(isset($_POST['name'])){
            $term=$_POST['name'];
        }
        $catCoursesIds=$this->registry->users->getCatCoursesIds();
        ///
        $instructors_ids=$this->registry->users->getInstructorsIDs(" where  id IN ($catCoursesIds)");
        $instructors =$this->registry->users->getallinstructor(" And id IN ($instructors_ids) And name LIKE '%$term%'");


        include(getviewslink() . '/academy/wedget/instractors_content.php');
    }

    function display_all_courses()
    {
        global  $location;
        $mysession =  $this->registry->sessionhandler->get($this->registry->useridstr); // bonjour
        $user_id = $this->getuserid();
//		$user_id=180;

        ///

        $condition = " AND ( show_on IN('all','courses') " . (($user_id) ? " OR (id='138' AND '$user_id'='74893') OR id IN(SELECT course_id FROM courses_users_exceptions WHERE user_id='$user_id')  OR  (id='123' AND '$user_id' IN (SELECT user_id FROM pmp_course_users))" : "") . " ";
//var_dump($condition);die();


        $page = 1;

        $condition .= ") order by sort DESC";
        $catCoursesIds=$this->registry->users->getCatCoursesIds();
        ///
        $instructors_ids=$this->registry->users->getInstructorsIDs(" where  id IN ($catCoursesIds)");
        $instructors =$this->registry->users->getallinstructor(" And id IN ($instructors_ids)");
        $number = $this->registry->users->getallcoursesCount(" $location $condition ");
        $pages = ceil($number / 45);
        $page_first_result = ($page - 1) * 45;

        $this->registry->template->pages = $pages;
        $this->registry->template->current_page = 1;
        $coursesCondition="$location AND ( show_on IN('all','courses') ".(($user_id)?" OR (id='138' AND '$user_id'='74893') OR id IN(SELECT course_id FROM courses_users_exceptions WHERE user_id='$user_id')  OR  (id='123' AND '$user_id' IN (SELECT user_id FROM pmp_course_users)) OR  (id='471' AND '$user_id' IN (SELECT user_id FROM facebook_advertising_tactics_course_users)) OR (id IN(SELECT course_id FROM deleted_course_users WHERE user_id='$user_id')) OR  (id='131' AND '$user_id' IN (SELECT user_id FROM marketing_through_facebook_course_users))   ":"")." )";
        $current_courses=$this->registry->users->getallcourses(" $coursesCondition   order by sort DESC limit $page_first_result,45");
//var_dump($current_courses);die();
        $this->registry->template->current_courses = $current_courses;
        $this->registry->template->instructors = $instructors;
        //error_log("END session current_courses : $mysession ".date("Y-m-d H:i:s").'/r/n', 3, "my-errors.log");

        //error_log("start session getallcourses : $mysession ".date("Y-m-d H:i:s").'/r/n', 3, "my-errors.log");
        //$courses=$this->registry->users->getallcourses("  $location AND show_on IN('all','courses') and isclose=1 order by id desc ");
        //$this->registry->template->courses=$courses;
        if($_SERVER['REQUEST_URI']=='/custom-courses' ){
            if ($user_id) {
                $hasSubscription = $this->registry->users->hasCustomSubscription($user_id);
                if ($hasSubscription) {
                    $courses_count = $this->registry->users->getCustomCoursesCount($this->getuserid());
                    $user_courses = $this->registry->users->getCustomUserCoursesCount($this->getuserid());
                    $this->registry->template->courses_count = $courses_count;
                    $this->registry->template->user_courses = $user_courses;
                    $this->registry->template->page_body = getviewslink() . '/academy/custom-courses';

                } else {
                    return header('Location: /subscriptions');
                }

            } else {
                $this->registry->sessionhandler->put('HTTP_REFERER', $this->siteURL .'custom-courses');
                return header('Location: /login');
            }

        }
        else{
            $this->registry->template->page_body = getviewslink() . '/academy/courses';
        }

        //error_log("End session getallcourses : $mysession ".date("Y-m-d H:i:s").'/r/n', 3, "my-errors.log");

        //error_log("start session categories : $mysession ".date("Y-m-d H:i:s").'/r/n', 3, "my-errors.log");

        $categories = $this->registry->users->getAllCategories(" order by id desc limit 7 ");

        $this->registry->template->categories = $categories;
        //error_log("End session categories : $mysession ".date("Y-m-d H:i:s").'/r/n', 3, "my-errors.log");
        $this->registry->template->show('index_home');
        /*$topcourses=$this->registry->users->getallcourses( " $location AND show_on IN('all','courses') order by id desc limit 1");
        $topcourse = (object) $topcourses[0];
        $this->registry->template->topcourse=$topcourse;
        $categoriesCourses=$this->registry->users->getallCategoriesWithCourses();
        $this->registry->template->categories_courses=$categoriesCourses;
        $this->registry->template->page_body = getviewslink().'/academy/courses';
        $this->registry->template->show('index_home');*/
    }
    public function customsearchFilter()
    {

        global  $location;
        $user_id = self::getuserid();

        $IsLogin=false;
        if ($user_id>0){
            $IsLogin=true;
        }
        $condition = " AND ( show_on IN('all','courses') " . (($user_id) ? " OR (id='138' AND '$user_id'='74893') OR id IN(SELECT course_id FROM courses_users_exceptions WHERE user_id='$user_id')  OR  (id='123' AND '$user_id' IN (SELECT user_id FROM pmp_course_users))" : "") . " )";

        if (isset($_POST['instractors'])&&$_POST['instractors']!='') {
            $instractors = $_POST['instractors'];
            $condition .= " AND instractor in ($instractors)";
        }

        if (isset($_POST['rate'])) {
            $rating = $_POST['rate'];
            $condition .= " AND rating = $rating";
        }


        if (isset($_POST['search'])&&$_POST['search']!='') {
            $search = $_POST['search'];
            $condition .= " AND name REGEXP '$search'";
        }

        if (isset($_POST['page'])) {
            $page = $_POST['page'];
        } else {
            $page = 1;
        }
        if(isset($_POST['newest'])&&$_POST['newest']==1){
            $condition .= " order by id DESC";
        }elseif(isset($_POST['views'])&&$_POST['views']==1){
            $condition .= " order by view DESC";
        }else {
            $condition .= " order by sort DESC";
        }
        $current_page=$page;
        // $condition .=" courses.rating = 5 AND ( show_on IN('all','courses') ".(($user_id)?" OR (id='138' AND '$user_id'='74893') OR id IN(SELECT course_id FROM courses_users_exceptions WHERE user_id='$user_id')  OR  (id='123' AND '$user_id' IN (SELECT user_id FROM pmp_course_users))":"")." ) ";
        $number = $this->registry->users->getallcoursesCount(" $location $condition");


        $pages = ceil($number / 45);

        // die();
        $page_first_result = ($page - 1) * 45;
        $IsLogin=$IsLogin;
        $current_courses = $this->registry->users->getallcourses(" $location $condition limit $page_first_result,45");
        $courses_count = $this->registry->users->getCustomCoursesCount($this->getuserid());
        $user_courses = $this->registry->users->getCustomUserCoursesCount($this->getuserid());
        $this->registry->template->courses_count = $courses_count;
        $this->registry->template->user_courses = $user_courses;
//var_dump($current_courses);die();
        global $config;
        $assets_path=$config['assets_path'];
            include(getviewslink() . '/academy/wedget/custom-courses-content.php');

    }
    public function searchFilter()
    {

        global  $location;
        $user_id = self::getuserid();

        $IsLogin=false;
        if ($user_id>0){
            $IsLogin=true;
        }
        $condition = " AND ( show_on IN('all','courses') " . (($user_id) ? " OR (id='138' AND '$user_id'='74893') OR id IN(SELECT course_id FROM courses_users_exceptions WHERE user_id='$user_id')  OR  (id='123' AND '$user_id' IN (SELECT user_id FROM pmp_course_users))" : "") . " )";

        if (isset($_POST['instractors'])&&$_POST['instractors']!='') {
            $instractors = $_POST['instractors'];
            $condition .= " AND instractor in ($instractors)";
        }

        if (isset($_POST['rate'])) {
            $rating = $_POST['rate'];
            $condition .= " AND rating = $rating";
        }


        if (isset($_POST['search'])&&$_POST['search']!='') {
            $search = $_POST['search'];
            $condition .= " AND name REGEXP '$search'";
        }

        if (isset($_POST['page'])) {
            $page = $_POST['page'];
        } else {
            $page = 1;
        }
        if(isset($_POST['newest'])&&$_POST['newest']==1){
            $condition .= " order by id DESC";
        }elseif(isset($_POST['views'])&&$_POST['views']==1){
            $condition .= " order by view DESC";
        }else {
            $condition .= " order by sort DESC";
        }
        $current_page=$page;
        // $condition .=" courses.rating = 5 AND ( show_on IN('all','courses') ".(($user_id)?" OR (id='138' AND '$user_id'='74893') OR id IN(SELECT course_id FROM courses_users_exceptions WHERE user_id='$user_id')  OR  (id='123' AND '$user_id' IN (SELECT user_id FROM pmp_course_users))":"")." ) ";
        $number = $this->registry->users->getallcoursesCount(" $location $condition");


        $pages = ceil($number / 45);

        // die();
        $page_first_result = ($page - 1) * 45;
        $IsLogin=$IsLogin;
        $current_courses = $this->registry->users->getallcourses(" $location $condition limit $page_first_result,45");

//var_dump($current_courses);die();
        global $config;
        $assets_path=$config['assets_path'];
            include(getviewslink() . '/academy/wedget/courses-content.php');

    }
    public function filter()
    {

        $filter = post('filter');
        $orders = post('orders');
        $start = post('start');
        $end = post('end');
        $hasChange = post('hasChange');
        if ($filter && in_array($filter, ['courses', 'seen_courses', 'un_seen_courses']) && in_array($orders, [0, 1, 2, 3, 4])) {
            $location = $this->getlocation();
            $websitename = $GLOBALS['config']['websitename'];
            $assets_path = $GLOBALS['config']['assets_path'];
            $currentCoursesQuery = "";
            $coursesQuery = "";
            switch ($filter) {
                case 'courses':
                    //$current_courses=$this->registry->users->getallcourses("  $location AND show_on IN('all','courses') and id not in ($id) and  isclose=0 order by id desc ");
                    //$current_courses=$this->registry->users->getallcourses("  $location AND show_on IN('all','courses') order by id desc ");
                    //$courses=$this->registry->users->getallcourses("  $location AND show_on IN('all','courses') and isclose=1 order by id desc ");
                    $currentCoursesQuery .= " $location AND show_on IN('all','courses') ";
                    $coursesQuery .= " $location AND show_on IN('all','courses') and isclose=1 ";
                    break;
                case 'seen_courses':
                    //$current_courses=$this->registry->users->getallcourses("  $location AND show_on IN('all','courses') and id not in ($id) and  isclose=0 and persentage>0 order by persentage desc ");
                    //$current_courses=$this->registry->users->getallcourses("  $location AND show_on IN('all','courses') and persentage>0 order by persentage desc ");
                    //$courses=$this->registry->users->getallcourses("  $location AND show_on IN('all','courses') and isclose=1 and persentage>0 order by persentage desc ");
                    $currentCoursesQuery .= " $location AND show_on IN('all','courses') and persentage>0 ";
                    $coursesQuery .= " $location AND show_on IN('all','courses') and isclose=1 and persentage>0 ";
                    break;
                case 'un_seen_courses':
                    //$current_courses=$this->registry->users->getallcourses("  $location and id not in ($id) and  isclose=0 and persentage=0 order by id desc ");
                    //$current_courses=$this->registry->users->getallcourses("  $location AND show_on IN('all','courses') and persentage=0 order by id desc ");
                    //$courses=$this->registry->users->getallcourses("  $location AND show_on IN('all','courses') and isclose=1 and persentage=0 order by id desc ");
                    $currentCoursesQuery .= " $location AND show_on IN('all','courses') and persentage=0 ";
                    $coursesQuery .= " $location AND show_on IN('all','courses') and isclose=1 and persentage=0 ";
                    break;
            }
            if ($start && $end && $hasChange) {
                $currentCoursesQuery .= "  AND createdtime BETWEEN '$start' AND '$end' ";
                $coursesQuery .= "   AND createdtime BETWEEN '$start' AND '$end' ";
            }
            switch ($orders) {
                case 0:
                    $currentCoursesQuery .= "  ORDER BY id DESC";
                    $coursesQuery .= "  ORDER BY id DESC";
                    break;
                case 1:
                    $currentCoursesQuery .= "  ORDER BY view DESC";
                    $coursesQuery .= "  ORDER BY view DESC";
                    break;
                case 2:
                    $currentCoursesQuery .= "  ORDER BY view ASC";
                    $coursesQuery .= "  ORDER BY view ASC";
                    break;
                case 3:
                    $currentCoursesQuery .= "  ORDER BY rating DESC";
                    $coursesQuery .= "  ORDER BY id desc";
                    break;
                case 4:
                    $currentCoursesQuery .= "  ORDER BY rating ASC";
                    $coursesQuery .= " ORDER BY rating ASC";
                    break;
            }
            $current_courses = $this->registry->users->getallcourses($currentCoursesQuery);
            $courses = $this->registry->users->getallcourses($coursesQuery);
            $helper = new objects();

                include(getviewslink() . '/academy/wedget/courses-content.php');


        }
    }
    public function selling()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $course_id = 'فن-البيع';
            $course = $this->registry->users->getsinglecourse($course_id, " AND show_on IN('all','courses')");
            $this->registry->template->course = $course;
            $sections = $this->registry->users->getcourse_sections($course->id);
            $this->registry->template->sections = $sections;
            $this->registry->template->page_body = getviewslink() . '/academy/singlecourse';
            $this->registry->template->show('index_home');
        } else {
            $this->registry->sessionhandler->put('HTTP_REFERER', '?page=courses&action=selling');
            return header('Location: /login');
        }
    }
    public function sellingCurriculum()
    {
        $user_id = $this->getuserid();
        $course_id = 'فن-البيع';
        $course_curriculum_id = get('curriculum_id');
        if ($user_id) {
            $allowPage = false;
            if ($course_curriculum_id > 0) {
                $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
            }
            if (count($video)) {
                $allowPage = true;
            }
            if ($video->isfree == 'yes') {
                $allowPage = true;
            }
            if ($allowPage) {
                global  $location;
                $location = $this->getlocation();
                if (!empty($course_id)) {
                    $course = $this->registry->users->getsinglecourse($course_id, $location . " AND show_on IN('all','courses')");
                    if (!isset($course->id)) {
                        self::display_all_courses();
                        exit;
                    }
                    if ($course_curriculum_id > 0) {
                        $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
                        if (isset($video->id)) {
                            $this->registry->template->course = $course;
                            $this->registry->template->video = $video;
                            $sections = $this->registry->users->getCourseCurriculumSections($course_id);
                            $this->registry->template->sections = $sections;
                            $this->registry->template->page_body = getviewslink() . '/academy/showvideo';
                            $this->registry->template->show('index_home');
                        } else {
                            self::display_all_courses();
                        }
                    } else {
                        self::display_all_courses();
                    }
                } else {
                    self::display_all_courses();
                }
            } else {
                $this->registry->sessionhandler->put('HTTP_REFERER', '?page=courses&action=sellingCurriculum&curriculum_id=' . $course_curriculum_id);
                return header('Location: /login');
            }
        } else {
            $this->registry->sessionhandler->put('HTTP_REFERER', '?page=courses&action=sellingCurriculum&curriculum_id=' . $course_curriculum_id);
            return header('Location: /login');
        }
    }
    public function sellingTraining()
    {
        $user_id = $this->getuserid();
        $course_id = 'فن-البيع';
        $training_id = get('curriculum_id');
        if ($user_id) {
            //echo 	$course_id .$training_id;
            if ($course_id) {
                $course = $this->registry->users->getsinglecourse($course_id, " AND show_on IN('all','courses')");
                if ($course) {
                    $exam = $this->registry->users->getSectionWithQuestions($training_id, 'training');
                    if ($exam) {
                        $this->registry->template->course = $course;
                        $this->registry->template->exam = $exam;
                        $this->registry->template->page_body = getviewslink() . '/academy/singleexam';
                        $this->registry->template->show('index_home');
                    } else {
                        self::index();
                    }
                } else {
                    self::index();
                }
            } else {
                self::index();
            }
        } else {
            $this->registry->sessionhandler->put('HTTP_REFERER', '?page=courses&action=sellingTraining&curriculum_id=' . $training_id);
            return header('Location: /login');
        }
    }
    public function endSellingTraining()
    {
        $user_id = $this->getuserid();
        $course_id = 'فن-البيع';
        $training_id = get('training_id');
        if ($user_id) {
            if ($course_id) {
                $course = $this->registry->users->getsinglecourse($course_id, " AND show_on IN('all','courses')");
                if ($course) {
                    $exam = $this->registry->users->getSingleSection($training_id, 'training');
                    if ($exam) {
                        if (isset($_POST['questions'])) {
                            $questions = $_POST['questions'];
                            $this->registry->users->completeQuetions($questions, $training_id, 'training');
                        } else {
                            $errorMessage = 'تأكد من الإجابه على جميع الاسئله';
                            include 'views/message/error_message.php';
                        }
                    }
                }
            }
        }
    }
    public function sellingResultView()
    {
        $user_id = $this->getuserid();
        $result_id = get('result_id');
        if ($user_id) {
            if ($result_id) {
                $answer = $this->registry->users->getCurriculumAnswers($result_id);
                if ($answer) {
                    $this->registry->template->answer = $answer;
                    $this->registry->template->page_body = getviewslink() . '/academy/singlereport';
                    $this->registry->template->show('index_home');
                } else {
                    self::index();
                }
            } else {
                self::index();
            }
        } else {
            $this->registry->sessionhandler->put('HTTP_REFERER', '?page=courses&action=sellingResultView&result_id=' . $result_id);
            return header('Location: /login');
        }
    }
    function calculateTimes()
    {
        $sections = $this->registry->users->getcourse_sectionsWithNumbers(7);
    }

    function display_single_course($course_id, $course)
    {
        global  $location;
        //$course=$this->registry->users->getsinglecourse($course_id," AND show_on IN('all','courses')");
        $accreditations=$this->registry->users->getaccreditationstype('course',1);
        $this->registry->template->accreditations=$accreditations;

        $this->registry->template->course = $course;
        //$sections=$this->registry->users->getcourse_sections($course->id);
        //$this->registry->template->sections=$sections;
        $this->registry->template->userId = $this->getuserid();
        $sections = $this->registry->users->getcourse_sectionsWithNumbers($course->id);
        $condition = " AND id != ".$course->id;
        $condition .= " AND instractor =" .$course->instractor;
        $condition .= " order by sort DESC limit 3 ";
        $instractorCourses= $this->registry->users->getallcourses(" $location $condition");
        $this->registry->template->instractorCourses = $instractorCourses;

        //        if($_GET['debug']){
        //        	print_r($sections);die();
        //		}
        $this->registry->template->sections = $sections['sections'];
        $this->registry->template->hours_numbers = $sections['hours_numbers'];
        $this->registry->template->sections_numbers = $sections['sections_numbers'];
        if ($this->getuserid()) {
            $this->registry->template->courses_questions = $this->registry->users->getCourseQuestionsAnswers($course->id, $this->getuserid());
            $this->registry->users->update_last_login_diploma($this->getuserid(), $course->id);
        }
        //$courses=$this->registry->users->getallcourses();
        //	$this->registry->template->courses=$courses;
        //faq
        $faqs = $this->registry->users->getfaq($course->id);
        $this->registry->template->faqs = $faqs;
        //faq
        $this->registry->template->page_body = getviewslink() . '/academy/singlecourse';
        $this->registry->template->show('index_home');
    }

    public function searchfaqs()
    {
        $key = get('isTyping');
        $course_id = get('course_id');
        $getresult = $this->registry->users->searchfaq($key, $course_id);
        $this->registry->template->resultsearch = $getresult;
        $x = 1;
        foreach ($getresult as $data) {
            $data = (object)$data;
            echo '<div class="panel panel-default">
      <div class="panel-heading">
        <h4 data-toggle="collapse" data-parent="#accordion" href="#collapse' . $x . '" class="panel-title expand collapsed" aria-expanded="false">
           <div class="right-arrow pull-left">+</div>
          <a href="#">' . $data->question . '</a>
        </h4>
      </div>
      <div id="collapse' . $x . '" class="panel-collapse collapse" aria-expanded="false" style="">
        <div class="panel-body">' . $data->answer . '</div>
      </div>
    </div>';
            $x++;
        }
    }
    public function category()
    {

        $categoryID = get('category_id');
        $location = $this->getlocation();
        if ($categoryID) {
            $category = $this->registry->users->getSingleCategory($categoryID);
            if ($category) {
                $topcourses = $this->registry->users->getallcourses("  $location AND show_on IN('all','courses') and category_id='$categoryID' order by id desc limit 1");
                $topcourse = (object) $topcourses[0];
                $this->registry->template->topcourse = $topcourse;
                $this->registry->template->category = $category;
                $current_courses = $this->registry->users->getallcourses(" $location AND show_on IN('all','courses') and category_id='$categoryID' and isclose=0 order by id desc ");
                $this->registry->template->current_courses = $current_courses;

                $courses = $this->registry->users->getallcourses(" $location AND show_on IN('all','courses') and category_id='$categoryID' and isclose=1 order by id desc ");
                $this->registry->template->courses = $courses;
                $this->registry->template->page_body = getviewslink() . '/academy/category_courses';
                $this->registry->template->show('index_home');
            } else {
                self::index();
            }
        } else {
            self::index();
        }
    }
    public function examMessage()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $course_id = get('course_id');
            $exam_id = get('exam_id');
            if ($course_id) {
                $course = $this->registry->users->getsinglecourse($course_id);
                if ($course) {
                    $isExpired = $this->registry->users->isExpired($this->getuserid(), $course->id);
                    if (!$isExpired || $course->hasCourse) {
                        $exam = $this->registry->users->getSectionWithQuestions($exam_id, 'exam');
                        if ($exam) {
                            $hasExam = $this->registry->users->hasMakeExam($exam_id);
                            $this->registry->template->course = $course;
                            $this->registry->template->exam = $exam;
                            $this->registry->template->hasExam = $hasExam;
                            $this->registry->template->page_body = getviewslink() . '/academy/singleexammessage';
                            $this->registry->template->show('index_home');
                        } else {
                            self::index();
                        }
                    } else {
                        return header('Location: /expired');
                    }
                } else {
                    self::index();
                }
            } else {
                self::index();
            }
        } else {
            self::index();
        }
    }
    public function examMessageLanguage()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $course_id = get('course_id');
            $exam_id = get('exam_id');
            if ($course_id) {
                $course = $this->registry->users->getsinglecourse($course_id);
                if ($course) {
                    $isExpired = $this->registry->users->isExpired($this->getuserid(), $course->id);
                    if (!$isExpired || $course->hasCourse) {
                        $exam = $this->registry->users->getSectionWithQuestions($exam_id, 'exam');
                        if ($exam) {
                            $hasExam = $this->registry->users->hasMakeExam($exam_id);
                            $this->registry->template->course = $course;
                            $this->registry->template->exam = $exam;
                            $this->registry->template->hasExam = $hasExam;
                            $this->registry->template->page_body = getviewslink() . '/academy/singleexammessagelanguage';
                            $this->registry->template->show('index_home');
                        } else {
                            self::index();
                        }
                    } else {
                        return header('Location: /expired');
                    }
                } else {
                    self::index();
                }
            } else {
                self::index();
            }
        } else {
            self::index();
        }
    }
    public function exam()
    {
        $user_action = 'Exam';
        $user_action_table = 'cources_curriculum';
        $user_action_table_id = get('exam_id');
        $this->registry->users->activity_action($user_action, $user_action_table, $user_action_table_id);
        if ($course = $this->registry->users->hasDemo()) {
            self::index();
        }

        $user_id = $this->getuserid();
        if ($user_id) {
            $course_id = get('course_id');
            $exam_id = get('exam_id');

            if ($course_id) {
                $course = $this->registry->users->getsinglecourse($course_id);
                //var_dump($course);die();
                if ($course) {

                    $isExpired = $this->registry->users->isExpired($this->getuserid(), $course->id);
                    if (!$isExpired || $course->hasCourse) {
                        $exam = $this->registry->users->getSectionWithQuestions($exam_id, 'exam');
                        if ($exam) {
                            $hasExam = $this->registry->users->hasMakeExam($exam_id);
                            $this->registry->template->course = $course;
                            $this->registry->template->exam = $exam;
                            $this->registry->template->hasExam = $hasExam;
                            $this->registry->template->page_body = getviewslink() . '/academy/singleexam';
                            $this->registry->template->show('index_home');
                        } else {
                            self::index();
                        }
                    } else {
                        return header('Location: /expired');
                    }
                } else {
                    self::index();
                }
            } else {
                self::index();
            }
        } else {
            self::index();
        }
    }
    public function endExam()
    {
        if ($course = $this->registry->users->hasDemo()) {
            self::index();
        }
        $user_id = $this->getuserid();
        if ($user_id) {
            $course_id = get('course_id');
            $exam_id = get('exam_id');
            if ($course_id) {
                $course = $this->registry->users->getsinglecourse($course_id);
                if ($course) {

                    $isExpired = $this->registry->users->isExpired($this->getuserid(), $course->id);
                    if (!$isExpired || $course->hasCourse) {

                        $exam = $this->registry->users->getSingleSection($exam_id, 'exam');
                        if ($exam) {
                            if (isset($_POST['questions'])) {
                                $questions = $_POST['questions'];
                                $this->registry->users->completeQuetions($questions, $exam_id, 'exam');
                            } else {
                                $errorMessage = 'تأكد من الإجابه على جميع الاسئله';
                                include 'views/message/error_message.php';
                            }
                        }
                    } else {
                        return header('Location: /expired');
                    }
                }
            }
        }
    }
    public function trial_exam()
    {
        //        $user_id = $this->getuserid();
        //        if ($user_id) {
        $cat_id = get('cat_id');

        $exam_id = get('exam_id');
        $category = $this->registry->users->getcategory_exam($cat_id);
        $exam = $this->registry->users->getSectionWithtrQuestions($exam_id, 'exam');
        if ($exam) {
            //$hasExam = $this->registry->users->hasMakeExamtrial($exam_id);
            $this->registry->template->category = $category;
            $this->registry->template->exam_id = $exam_id;
            $this->registry->template->exam = $exam;
            //$this->registry->template->hasExam = $hasExam;
            $this->registry->template->page_body = getviewslink() . '/academy/singletrailexam';
            //$this->registry->template->page_body = getviewslink() . '/academy/singleexam';
            $this->registry->template->show('index_home');
        } else {
            self::index();
        }

        //        } else {
        //            self::index();
        //        }
    }

    public function trial_endExam()
    {
        //$user_id = $this->getuserid();
        // if ($user_id) {
        $cat_id = get('cat_id');
        $exam_id = get('exam_id');
        $exam = $this->registry->users->getSingleSectioncat($exam_id, 'exam');
        if ($exam) {
            if (isset($_POST['questions'])) {
                $questions = $_POST['questions'];
                $this->registry->users->trial_completeQuetions($questions, $exam_id, 'exam');
            } else {
                $errorMessage = 'تأكد من الإجابه على جميع الاسئله';
                include 'views/message/error_message.php';
            }
        }

        //}
    }
    public function trial_exam_old_16_5_2019()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $cat_id = get('cat_id');

            $exam_id = get('exam_id');
            $category = $this->registry->users->getcategory_exam($cat_id);
            $exam = $this->registry->users->getSectionWithtrQuestions($exam_id, 'exam');
            if ($exam) {
                //$hasExam = $this->registry->users->hasMakeExamtrial($exam_id);
                $this->registry->template->category = $category;
                $this->registry->template->exam_id = $exam_id;
                $this->registry->template->exam = $exam;
                //$this->registry->template->hasExam = $hasExam;
                $this->registry->template->page_body = getviewslink() . '/academy/singletrailexam';
                //$this->registry->template->page_body = getviewslink() . '/academy/singleexam';
                $this->registry->template->show('index_home');
            } else {
                self::index();
            }
        } else {
            self::index();
        }
    }

    public function trial_endExam_old_16_5_2019()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $cat_id = get('cat_id');
            $exam_id = get('exam_id');
            $exam = $this->registry->users->getSingleSectioncat($exam_id, 'exam');
            if ($exam) {
                if (isset($_POST['questions'])) {
                    $questions = $_POST['questions'];
                    $this->registry->users->trial_completeQuetions($questions, $exam_id, 'exam');
                } else {
                    $errorMessage = 'تأكد من الإجابه على جميع الاسئله';
                    include 'views/message/error_message.php';
                }
            }
        }
    }
    public function trainingLanguage()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $course_id = get('course_id');
            $training_id = get('training_id');
            if ($course_id) {
                $course = $this->registry->users->getsinglecourse($course_id);
                if ($course) {
                    $isExpired = $this->registry->users->isExpired($this->getuserid(), $course->id);
                    if (!$isExpired || $course->hasCourse) {
                        $exam = $this->registry->users->getSectionWithQuestions($training_id, 'training');
                        if ($exam) {
                            $this->registry->template->course = $course;
                            $this->registry->template->exam = $exam;
                            $this->registry->template->page_body = getviewslink() . '/academy/singleexamlanguage';
                            $this->registry->template->show('index_home');
                        } else {
                            self::index();
                        }
                    } else {
                        return header('Location: /expired');
                    }
                } else {
                    self::index();
                }
            } else {
                self::index();
            }
        } else {
            self::index();
        }
    }
    public function training()
    {
        //    echo 'start';
        $user_id = $this->getuserid();
        if ($user_id) {
            $course_id = get('course_id');
            $training_id = get('training_id');
            //echo 	$course_id .$training_id;
            if ($course_id) {
                $course = $this->registry->users->getsinglecourse($course_id);
                if ($course) {
                    $isExpired = $this->registry->users->isExpired($this->getuserid(), $course->id);
                    if (!$isExpired || $course->hasCourse) {
                        $exam = $this->registry->users->getSectionWithQuestions($training_id, 'training');
                        if ($exam) {
                            $this->registry->template->course = $course;
                            $this->registry->template->exam = $exam;
                            $user_action = 'Training';
                            $user_action_table = 'cources_curriculum';
                            $user_action_table_id = get('training_id');
                            $this->registry->users->activity_action($user_action, $user_action_table, $user_action_table_id);
                            $this->registry->template->page_body = getviewslink() . '/academy/singleexam';
                            $this->registry->template->show('index_home');
                        } else {
                            self::index();
                        }
                    } else {
                        return header('Location: /expired');
                    }
                } else {
                    self::index();
                }
            } else {
                self::index();
            }
        } else {
            self::index();
        }
    }
    public function endTraining()
    {
        if ($this->getuserid()) {
            $course_id = get('course_id');
            $training_id = get('training_id');
            if ($course_id) {
                $course = $this->registry->users->getsinglecourse($course_id);
                if ($course) {
                    $isExpired = $this->registry->users->isExpired($this->getuserid(), $course->id);
                    if (!$isExpired || $course->hasCourse) {
                        $exam = $this->registry->users->getSingleSection($training_id, 'training');
                        if ($exam) {
                            if (isset($_POST['questions'])) {
                                $questions = $_POST['questions'];
                                $this->registry->users->completeQuetions($questions, $training_id, 'training');
                            } else {
                                $errorMessage = 'تأكد من الإجابه على جميع الاسئله';
                                include 'views/message/error_message.php';
                            }
                        }
                    } else {
                        return header('Location: /expired');
                    }
                }
            }
        } else {
            self::index();
        }
    }
    public function resultView()
    {
        if ($this->getuserid()) {
            $result_id = get('result_id');
            if ($result_id) {
                $answer = $this->registry->users->getCurriculumAnswers($result_id);
                if ($answer) {
                    $this->registry->template->answer = $answer;
                    $this->registry->template->page_body = getviewslink() . '/academy/singlereport';
                    $this->registry->template->show('index_home');
                } else {
                    self::index();
                }
            } else {
                self::index();
            }
        } else {
            self::index();
        }
    }
    public function addNewQuestion()
    {
        $email = get('email');
        $user_id = ($email) ? $this->registry->users->getuseridbyemail($email) : $this->registry->encryption->decode($this->registry->sessionhandler->get($GLOBALS['useridstr']));
        if ($user_id) {
            $course_id = get('course_id');
            if ($email) {
                $course_id = intval($course_id);
            }
            $course = $this->registry->users->getsinglecourse($course_id, "", $email, "('medical')");
            if (isset($course->id)) {
                $question = post('question');
                $section_id = post('section_id');
                $curriculum_id = post("curriculum_id");
                $course_id = $course->id;
                //				echo $course_id.$this->getuserid().$question.$section_id;
                $this->registry->users->addNewCourseQuestion($course_id, $user_id, $question, $section_id, $curriculum_id);
            }
        }
    }
    public function saveCoursesData()
    {
        $this->registry->users->saveCoursesData($this->getuserid());
    }
    public function showTestVideo()
    {
        $this->registry->template->show('academy/showtestvideo');
    }
    public function showVideo2()
    {
        $this->registry->template->show('academy/showvideo2');
    }
    public function showCurriculum()
    {
        $preview = (isset($_GET['preview']) && $_GET['preview'] == 1) ? true : false;
        $course_id = get('course_id');
        //  $course_id=7;
        $course_curriculum_id = get('curriculum_id');
        //  $course_curriculum_id=28;
        $allowPage = false;
        $username = get('username');
        $password = get('password');
        //echo $username;
        $userID = $this->getuserid();
        if ($course_curriculum_id > 0) {
            $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
        }
        if ($video->isfree == 'yes') {
            $allowPage = true;
        } elseif ($username && $password) {
            $id = $this->registry->users->loginuser($username, $password);
            if ($id > 0) {
                $decoded_id = $this->registry->encryption->encode($id);
                $this->registry->sessionhandler->put($this->registry->useridstr, $decoded_id);
                $session_id = $this->registry->sessionhandler->id();
                $this->registry->sessionhandler->put('session_user', $session_id);
                $this->registry->users->update_usersession($session_id);
                $allowPage = true;
            }
        } elseif ($userID || $preview) {
            $allowPage = true;
        }
        if ($allowPage) {
            global  $location;
            $location = $this->getlocation();
            if (!empty($course_id)) {
                $course = $this->registry->users->getsinglecourse($course_id, $location);
                $isExpired = $this->registry->users->isExpired($this->getuserid(), $course->id);
                if ($isExpired && $video->isfree == 'no' && !$course->hasCourse && !$preview) {
                    $this->registry->sessionhandler->put('HTTP_REFERER', 'courses/' . $course_id . '/showCurriculum/' . $course_curriculum_id);
                    return header('Location: /expired');
                }
                if (!isset($course->id)) {
                    self::display_all_courses();
                    exit;
                }
                if ($course_curriculum_id > 0) {
                    $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
                    if (isset($video->id)) {
                        if ($course->hasCourse || $video->isfree == 'yes' || $preview) {
                            $this->registry->users->update_last_login_diploma($this->getuserid(), $course->id);
                            $this->registry->template->course = $course;
                            $this->registry->template->video = $video;
                            $sections = $this->registry->users->getCourseCurriculumSections($course_id);
                            $this->registry->template->sections = $sections;
//                            $this->registry->template->page_body = getviewslink() . '/academy/showvideo';
                            $this->registry->template->show('/academy/showvideo');
                        } else {
                            return header('Location: /subscribe');
                        }
                    } else {
                        self::display_all_courses();
                    }
                } else {
                    self::display_all_courses();
                }
            } else {
                self::display_all_courses();
            }
        } else {
            $this->registry->sessionhandler->put('HTTP_REFERER', 'courses/' . $course_id . '/showCurriculum/' . $course_curriculum_id);
            return header('Location: /login');
        }
    }


    public function showCurriculumaudio()
    {
        $preview = (isset($_GET['preview']) && $_GET['preview'] == 1) ? true : false;
        $course_id = get('course_id');
        $course_curriculum_id = get('curriculum_id');
        $allowPage = false;
        $username = get('username');
        $password = get('password');

        //echo $username;
        $userID = $this->getuserid();
        if ($course_curriculum_id > 0) {
            $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
        }
        if ($video->isfree == 'yes' || $preview) {
            $allowPage = true;
        } elseif ($username && $password) {
            $id = $this->registry->users->loginuser($username, $password);
            if ($id > 0) {
                $decoded_id = $this->registry->encryption->encode($id);
                $this->registry->sessionhandler->put($this->registry->useridstr, $decoded_id);
                $session_id = $this->registry->sessionhandler->id();
                $this->registry->sessionhandler->put('session_user', $session_id);
                $this->registry->users->update_usersession($session_id);
                $allowPage = true;
            }
        } elseif ($userID) {
            $allowPage = true;
        }
        if ($allowPage) {
            global  $location;
            $location = $this->getlocation();
            if (!empty($course_id)) {
                $course = $this->registry->users->getsinglecourse($course_id, $location);
                $isExpired = $this->registry->users->isExpired($this->getuserid(), $course->id);
                if ($isExpired && $video->isfree == 'no' && !$course->hasCourse && !$preview) {
                    $this->registry->sessionhandler->put('HTTP_REFERER', 'courses/' . $course_id . '/showCurriculumaudio/' . $course_curriculum_id);
                    return header('Location: /expired');
                }
                if (!isset($course->id)) {
                    self::display_all_courses();
                    exit;
                }
                if ($course_curriculum_id > 0) {
                    $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
                    if (isset($video->id)) {
                        if ($course->hasCourse || $video->isfree == 'yes' || $preview) {
                            $this->registry->users->update_last_login_diploma($this->getuserid(), $course->id);
                            $this->registry->template->course = $course;
                            $this->registry->template->video = $video;
                            $sections = $this->registry->users->getCourseCurriculumSections($course_id);
                            $this->registry->template->sections = $sections;
                            $this->registry->template->page_body = getviewslink().'/academy/showaudio';
                            $this->registry->template->show('index_home');
                        } else {
                            return header('Location: /subscribe');
                        }
                    } else {
                        self::display_all_courses();
                    }
                } else {
                    self::display_all_courses();
                }
            } else {
                self::display_all_courses();
            }
        } else {
            $this->registry->sessionhandler->put('HTTP_REFERER', 'courses/' . $course_id . '/showCurriculumaudio/' . $course_curriculum_id);
            return header('Location: /login');
        }
    }



    public function showCurriculumforandroid()
    {
        $course_id = get('course_id');
        $course_curriculum_id = get('curriculum_id');
        $allowPage = false;
        $username = get('username');
        $password = get('password');

        //echo $username;
        $userID = $this->getuserid();
        if ($course_curriculum_id > 0) {
            $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
        }
        if ($video->isfree == 'yes') {
            $allowPage = true;
        } elseif ($username && $password) {
            $id = $this->registry->users->loginuser($username, $password);
            if ($id > 0) {
                $decoded_id = $this->registry->encryption->encode($id);
                $this->registry->sessionhandler->put($this->registry->useridstr, $decoded_id);
                $session_id = $this->registry->sessionhandler->id();
                $this->registry->sessionhandler->put('session_user', $session_id);
                $this->registry->users->update_usersession($session_id);
                $allowPage = true;
            }
        } elseif ($userID) {
            $allowPage = true;
        }
        if ($allowPage) {
            global  $location;
            $location = $this->getlocation();
            if (!empty($course_id)) {
                $course = $this->registry->users->getsinglecourse($course_id, $location);
                $isExpired = $this->registry->users->isExpired($this->getuserid(), $course->id);
                if ($isExpired && $video->isfree == 'no' && !$course->hasCourse) {
                    //$this->registry->sessionhandler->put('HTTP_REFERER','courses/'.$course_id.'/showCurriculum/'.$course_curriculum_id);
                    //return header('Location: /expired');
                    echo "<script>   Android.openexpired();</script>";
                    return;
                }
                if (!isset($course->id)) {
                    self::display_all_courses();
                    exit;
                }
                if ($course_curriculum_id > 0) {
                    $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
                    if (isset($video->id)) {
                        if ($course->hasCourse || $video->isfree == 'yes') {
                            $this->registry->template->course = $course;
                            $this->registry->template->video = $video;
                            $sections = $this->registry->users->getCourseCurriculumSections($course_id);
                            $this->registry->template->sections = $sections;
                            $this->registry->template->page_body = getviewslink() . '/academy/showvideo';
                            $this->registry->template->show('index_home');
                        } else {
                            //return header('Location: /subscribe');
                            echo "<script>   Android.opensubscrip();</script>";
                            return;
                        }
                    } else {
                        self::display_all_courses();
                    }
                } else {
                    self::display_all_courses();
                }
            } else {
                self::display_all_courses();
            }
        } else {
            //$this->registry->sessionhandler->put('HTTP_REFERER','courses/'.$course_id.'/showCurriculum/'.$course_curriculum_id);
            //return header('Location: /login');

            echo "<script>   Android.openlogin();</script>";
            return;
        }
    }
    public function testVideo()
    {
        $this->registry->template->show('test_video');
    }


    public function getCourseSectionCurriculums()
    {

        $course_id = post("courseId");

        $section_id = post("sectionId");

        $user_id = post("userId");

        echo $this->registry->users->getSectionCurriculums($course_id, $section_id, $user_id);
    }

    public  function jsonResponse($data){
        header('Content-Type:application/json');
        echo json_encode($data);
        return '';
    }


    public function AddToCustomCourses() {

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {

            $course_id = post('course_id');
            $courses_count = post('courses_count');
            $user_courses = post('user_courses');

            if($courses_count == $user_courses ){
                return $this->jsonResponse(['success'=>false]);

            }
            $user_id = $this->getuserid();
            $result = $this->registry->users->addtocustomcourses($course_id, $user_id);
            if($result)
                return $this->jsonResponse(['success'=>true]);
            return $this->jsonResponse(['success'=>false]);
        }


    }
    public function RemoveFromCustomCourses() {

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {

            $course_id = post('course_id');
            $courses_count = post('courses_count');
            $user_courses = post('user_courses');


            $user_id = $this->getuserid();
            $result = $this->registry->users->removefromcustomcourses($course_id, $user_id);
            if($result)
                return $this->jsonResponse(['success'=>true]);
            return $this->jsonResponse(['success'=>false]);
        }

    }
}
