<?php
Class booksController Extends baseController {

    public function index(){
        if($_SERVER['REQUEST_URI']=='/?page=books'){
            echo '<meta http-equiv="refresh" content="0;url=/books" />';
            return header('Location: /books');
        }
        $book_id=get('book_id');
        if (!empty($book_id)){
            $book=$this->registry->users->getSingleBookByID($book_id);
            if(isset($book->id)){
                return header('Location: /books/'.$book->url);
            }
            $book=$this->registry->users->getSingleBook($book_id);
            if (!isset($book->id)){
                $book_url=$this->registry->users->getOldUrl($book_id,'books');
                if($book_url){
                    return header('Location: /books/'.$book_url);
                }else{
                    self::redirect404();exit;
                }
            }
            self::display_single_book($book_id,$book);
        }else
        {
            self::display_all_books();
        }

    }

    public function display_all_books(){
        $user_id = self::getuserid();
        $IsExpired=0;
        $email='';
        if($user_id>0) {
            $email = $this->registry->users->getuserdetails($user_id)->Email;

        }
       /* $topBook=$this->registry->users->getAllBooks(" ORDER BY id DESC LIMIT 1");
        $topBook = (object) $topBook[0];

        $this->registry->template->topBook=$topBook;*/
        if($this->registry->users->hasDemo()){
            $currentBooks=$this->registry->users->getAllBooks(" ORDER BY view DESC LIMIT 0,5",$email);
        }else{
            $currentBooks=$this->registry->users->getAllBooks(" ORDER BY id DESC LIMIT 0,100",$email);
        }


        $this->registry->template->currentBooks=$currentBooks;

        $this->registry->template->page_body = getviewslink().'/academy/books';

        $this->registry->template->show('index_home');

    }


    public function display_single_book($book_id,$book){

        $this->registry->template->book=$book;
        $this->registry->template->relatedBooks=$this->registry->users->getAllBooks(" AND books.id!='$book->id' ORDER BY id DESC LIMIT 0,6");
        $this->registry->template->page_body = getviewslink().'/academy/singlebook';
        $this->registry->template->show('index_home');

    }

    public function viewAudio(){
        $id=get('id');
        if($id){
            $file='/home/ebacademy/public_html/sa.e3melbusiness.com/assets/img/audio_books/'.$id;
            if(file_exists($file)){
                $type=mime_content_type($file);
                $fileSize=filesize($file);
//                header("Content-type:$type");
//                echo file_get_contents($file);
                header("Content-Description: File Transfer");
                //header("Content-Type: $type");
                header('Content-Type: application/octet-stream');
                header("Content-Disposition: attachment; filename*=UTF-8'$this->siteURL.'");
                header("Content-Length: $fileSize");
                header("Pragma: public");
                header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
                header("Expires: 0");
                //echo file_get_contents($file);
                ob_clean();
                flush();
                readfile($file);
                exit;
            }else{
                return self::redirect404();
            }
        }else{
            return self::redirect404();
        }

    }
    public function displayAudio(){
        $this->registry->template->page_body = getviewslink().'/academy/singleaudiobook';
        $this->registry->template->show('index_home');
    }
    public function playlist(){
        $book_id=get('book_id');
        $book=$this->registry->users->getSingleBook($book_id);
        if(isset($book->id)){
            $playlist=$this->registry->users->getSingleBookPlayLists($book->id);
            $this->registry->template->playlist=$playlist;
            $this->registry->template->book=$book;
            $this->registry->template->show('/academy/singlebookplaylist');
        }
    }

    public function searchBookFilter()
    {
        $user_id = self::getuserid();
        $IsExpired=0;
        $email='';
        if($user_id>0) {
            $email = $this->registry->users->getuserdetails($user_id)->Email;

        }

        global  $location;
        $user_id = self::getuserid();
        $condition ='';
        if (isset($_POST['search'])&&$_POST['search']!='') {
            $search = $_POST['search'];
            $condition .= " AND title REGEXP '$search'";
        }

        if(isset($_POST['newest'])&&$_POST['newest']==1){
            $condition .= " order by id DESC";
        }elseif(isset($_POST['views'])&&$_POST['views']==1){
            $condition .= " order by view DESC";
        }
        else {
            $condition .= " ORDER BY id asc";
        }


        $IsLogin=false;
        if ($user_id>0){
            $IsLogin=true;
        }
        $currentBooks = $this->registry->users->getAllBooks(" $condition",$email);
        global $config;
        $assets_path=$config['assets_path'];
        include(getviewslink() . '/academy/wedget/all_book_content.php');
    }
    public function searchFilter()
    {

        global  $location;
        $user_id = self::getuserid();
        $email='';
        $IsLogin=false;
        if ($user_id>0){
            $IsLogin=true;
            $email = $this->registry->users->getuserdetails($user_id)->Email;

        }
        $condition='';
        if (isset($_POST['search'])&&$_POST['search']!='') {
            $search = $_POST['search'];
            $condition .= " AND title REGEXP '$search'";
        }

        $currentBooks = $this->registry->users->getAllBooks("$condition",$email);
        global $config;
        $assets_path=$config['assets_path'];
        include(getviewslink() . '/academy/wedget/all_book_content.php');
    }


}

?>

