<?php
Class allPaymentsController Extends baseController {

    protected $allowedPaymentMethods=[
        'alahly_bank_online_card',
        'paymob_online_card',
        'winwin_online_card',
        'fawry_online_card',
        'paymob_mobile_wallet',
        'fawry_mobile_wallet',
        'paymob_accept_kiosk_machine',
        'aman_machine',
        'msari_machine',
        'mmkn_machine',
        'fawry_machine',
        'vodafone_cash',
    ];
    public function index()
    {
        $this->registry->template->countries =$this->registry->helper->getcountries();
        $this->registry->template->show('/academy/payment/payment_form');
    }
    public function addTransaction(){
        $user_id=self::getuserid();
        $data=[
            'user_id'=>($user_id)?$user_id:0,
            'first_name'=>post('first_name'),
            'last_name'=>post('last_name'),
            'email'=>post('email'),
            'mobile'=>post('phoneValue'),
            'country_id'=>post('country'),

            'charge_table'=>'charge_transaction',
            'charge_name'=>'اشتراك سنوي',
            'period'=>12,
            'amount'=>800,
            'currency'=>'USD',
            'created_at'=>date('Y-m-d H:i:s'),
        ];
        $query="INSERT INTO all_payments_transactions SET ";
        end($data);
        $lastKey= key($data);
        foreach ($data as $key=>$val){
            if($lastKey==$key){
                $query.=" $key='$val' ";
            }else{
                $query.=" $key='$val', ";
            }
        }
        $db=new db(null);
        $id=$db->execquery_id($query);
        if($id>0){
            $decoded_id=$this->registry->encryption->encode($id);
            header('Location: ?page=allPayments&action=paymentMethods&payment_id='.$decoded_id);
        }
    }
    public function paymentMethods(){
        $payment_id=get('payment_id');
        if($payment_id){
            $db=new db(null);
            $payment_id=$this->registry->encryption->decode($payment_id);
            $query="SELECT * FROM all_payments_transactions WHERE id='$payment_id'";
            $result=$db->execquery($query);
            if($result&&$result->num_rows){
                $this->registry->template->payment =$result->fetch_object();
                $this->registry->template->error_message=$this->registry->sessionhandler->get('error_message');
                $this->registry->sessionhandler->forget('error_message');
                $this->registry->template->show('/academy/payment/payment_methods');
            }

        }

    }
    public function addPaymentMethod(){
        $payment_id=get('payment_id');
        $payment_method=post('payment_method');
        if(!$payment_method){
            $this->registry->sessionhandler->put('error_message','من فضلك تاكد من اختيار وسيلة الدفع');
            header('Location: ?page=allPayments&action=paymentMethods&payment_id='.$payment_id);
            return'';
        }
        if(!in_array($payment_method,$this->allowedPaymentMethods)){
            $this->registry->sessionhandler->put('error_message','من فضلك تاكد من اختيار وسيلة الدفع');
            header('Location: ?page=allPayments&action=paymentMethods&payment_id='.$payment_id);
            return'';
        }
        $db=new db(null);
        $payment_id=$this->registry->encryption->decode($payment_id);
        $query="SELECT * FROM all_payments_transactions WHERE id='$payment_id'";
        $result=$db->execquery($query);
        if($result&&$result->num_rows){
            $payment =$result->fetch_object();
            $query="UPDATE all_payments_transactions SET payment_method='$payment_method' WHERE id='$payment_id'";
            $db->execquery($query);
            switch ($payment_method){
                case 'alahly_bank_online_card':
                    $data=[
                        'email'=>$payment->email,
                        'amount'=>$payment->amount,
                        'currency'=>($payment->currency=='USD')?5:1,
                        'percentage'=>0,
                        'subscribe'=>$payment->charge_table,
                        'period'=>$payment->period,
                        'user_id'=>$payment->user_id,
                    ];
                    $query="INSERT INTO payment  SET ";
                    end($data);
                    $lastKey= key($data);
                    foreach ($data as $key=>$val){
                        if($lastKey==$key){
                            $query.=" $key='$val' ";
                        }else{
                            $query.=" $key='$val', ";
                        }
                    }
                    $id=$db->execquery_id($query);
                    $redirectUrl='?page=e3melbusinessPayment&action=payment&id='.$this->registry->encryption->encode($id);
                    header('Location: '.$redirectUrl);
                    break;
                case 'paymob_online_card':
                    $data=[
                        'amount'=>$payment->amount,
                        'user_id'=>$payment->user_id,
                        'email'=>$payment->email,
                        'mobile'=>$payment->mobile,
                        'first_name'=>$payment->first_name,
                        'last_name'=>$payment->last_name,
                        'charge_table'=>$payment->charge_table,
                        'charge_name'=>$payment->charge_name,
                        'period'=>$payment->period,
                        'currency'=>$payment->currency,
                        'payment_method'=>'online_card',
                    ];
                    $query="INSERT INTO paymob_payments SET ";
                    end($data);
                    $lastKey= key($data);
                    foreach ($data as $key=>$val){
                        if($lastKey==$key){
                            $query.=" $key='$val' ";
                        }else{
                            $query.=" $key='$val', ";
                        }
                    }
                    $id=$db->execquery_id($query);
                    $redirectUrl='?page=PaymobPayment&id='.$this->registry->encryption->encode($id);
                    header('Location: '.$redirectUrl);
                    break;
                case 'winwin_online_card':
                    if ($payment->charge_table=='charge_transaction'){
                        $lifetime='-lifetime';
                    }else if ($payment->charge_table=='mba_charge_transaction'){
                        $lifetime='-mba';
                    }else {
                        $lifetime='-other';
                    }
                    $onlineemail=str_replace('-','%20',$payment->email);
                    $en_email= $onlineemail.'-0-'.$payment->amount.'-'.intval($payment->period).'-offer';
                    if ($lifetime!=''){
                        $en_email=   $en_email.$lifetime;
                    }

                    //$en_email=Encryption::encode($en_email);
                    $en_email=$this->registry->encryption->encode($en_email);
                    // echo $project_id;
                    $redirectUrl='https://winwinbiz.com/?page=subscribe_offer&id='.$en_email;
                    header('Location: '.$redirectUrl);
                    break;
                case 'fawry_online_card':
                    break;
                case 'paymob_mobile_wallet':
                    $redirectUrl='?page=allPayments&action=paymentWallet&payment_id='.$this->registry->encryption->encode($payment_id);
                    header('Location: '.$redirectUrl);
                    break;
                case 'fawry_mobile_wallet':
                    $redirectUrl='?page=allPayments&action=paymentWallet&payment_id='.$this->registry->encryption->encode($payment_id);
                    header('Location: '.$redirectUrl);
                    break;
                case 'paymob_accept_kiosk_machine':
                    $data=[
                        'amount'=>$payment->amount,
                        'user_id'=>$payment->user_id,
                        'email'=>$payment->email,
                        'mobile'=>$payment->mobile,
                        'first_name'=>$payment->first_name,
                        'last_name'=>$payment->last_name,
                        'charge_table'=>$payment->charge_table,
                        'charge_name'=>$payment->charge_name,
                        'period'=>$payment->period,
                        'currency'=>$payment->currency,
                        'payment_method'=>'accept_kiosk',
                    ];
                    $query="INSERT INTO paymob_payments SET ";
                    end($data);
                    $lastKey= key($data);
                    foreach ($data as $key=>$val){
                        if($lastKey==$key){
                            $query.=" $key='$val' ";
                        }else{
                            $query.=" $key='$val', ";
                        }
                    }
                    $id=$db->execquery_id($query);
                    $redirectUrl='?page=PaymobPayment&id='.$this->registry->encryption->encode($id);
                    header('Location: '.$redirectUrl);
                    break;
                case 'aman_machine':
                    break;
                case 'msari_machine':
                    break;
                case 'mmkn_machine':
                    break;
                case 'fawry_machine':
                    break;
            }
        }



    }
    public function paymentWallet(){
        $payment_id=get('payment_id');
        if($payment_id){
            $db=new db(null);
            $payment_id=$this->registry->encryption->decode($payment_id);
            $query="SELECT * FROM all_payments_transactions WHERE id='$payment_id'";
            $result=$db->execquery($query);
            if($result&&$result->num_rows){
                $payment =$result->fetch_object();
                if (strpos($payment->payment_method, 'wallet') !== false) {
                    $this->registry->template->show('/academy/payment/payment_wallet');
                }
            }
        }


    }
    public function addWallet(){
        $payment_id=get('payment_id');
        $phone=post('phone');
        print_r($_POST);
        if($payment_id) {
            $db = new db(null);
            $payment_id = $this->registry->encryption->decode($payment_id);
            $query = "SELECT * FROM all_payments_transactions WHERE id='$payment_id'";
            $result = $db->execquery($query);
            if ($result && $result->num_rows) {
                $payment =$result->fetch_object();
                $query="UPDATE all_payments_transactions SET wallet_phone='$phone' WHERE id='$payment_id'";
                $db->execquery($query);
                if($payment->payment_method=='paymob_mobile_wallet'){
                    $data=[
                        'amount'=>$payment->amount,
                        'user_id'=>$payment->user_id,
                        'email'=>$payment->email,
                        'mobile'=>$payment->mobile,
                        'first_name'=>$payment->first_name,
                        'last_name'=>$payment->last_name,
                        'charge_table'=>$payment->charge_table,
                        'charge_name'=>$payment->charge_name,
                        'period'=>$payment->period,
                        'currency'=>$payment->currency,
                        'payment_method'=>'mobile_wallet',
                    ];
                    $query="INSERT INTO paymob_payments SET ";
                    end($data);
                    $lastKey= key($data);
                    foreach ($data as $key=>$val){
                        if($lastKey==$key){
                            $query.=" $key='$val' ";
                        }else{
                            $query.=" $key='$val', ";
                        }
                    }
                    $id=$db->execquery_id($query);
                    $redirectUrl='?page=PaymobPayment&id='.$this->registry->encryption->encode($id);
                    header('Location: '.$redirectUrl);
                }
            }
        }
    }
}
