<?php
Class TamaraPaymentController Extends baseController {
    public function __construct($registry)
    {
        parent::__construct($registry);
        $this->_MODE='TEST';
//        $this->_MODE='LIVE';
        /*test*/
        $this->_BASE_URL_TEST='https://api-sandbox.tamara.co';
        $this->_API_TOKEN_TEST='eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJhY2NvdW50SWQiOiJlMDViMzIwMS1lZDlkLTQzZDYtOGZlOC01YzFmZTMwNDU3ZmMiLCJ0eXBlIjoibWVyY2hhbnQiLCJzYWx0IjoiMTI0MjJlODFjNzU4NmJjN2M2ODcyMGNjYzg4YWM0NTUiLCJyb2xlcyI6WyJST0xFX01FUkNIQU5UIl0sImlhdCI6MTY5NzQxNjQyNywiaXNzIjoiVGFtYXJhIn0.yIhlxVUTvneewlJkSLAn0c9cQZcRm-gvIleLMcAGejY5e17PgCfRJKR15nsuFfmvfPvGy8xduHsD4BTwgb-lRjbO5dNvRa8OY2VJdVscY_ZsVyFgLgR07joj7G4qQQs_B_RKG8cGT_VmVQEu5mtIwwS-21Opa9rG_ycqi3UwHkG_Y7VERUA9dOnVcdQpt8xFlMkxxuKBTof9NaoK7bJQ2DsEmfVcaeoLuTPgSf-qidEsD9cxU4esRlH1dEXPzBImCiNW3WAw4tKwkuDhYNqcnN1H3N59RX6G15TLAOd85nqzsoeobOwE9gvsBGvNLSz9iZ6mRYAUVAIi7MKo0azTSA';
        /*live*/
        $this->_BASE_URL_LIVE='';

        $this->_NEWDB=new db(null);
    }
    public function index()
    {
        $date=date('Y-m-d\TH:i:s\Z');
        header("Content-Type: application/json; charset=utf-8");
        //id=1
        //https://www.e3melbusiness.com/?page=PaymobPayment&id=oOb9BB7S3autcMyDAYz19_Tbj4ajYBExdkQhYfjAtUAi
        if(get('id')){
            //echo $this->registry->encryption->encode(1);die();
            $id=$this->registry->encryption->decode(get('id'));
            //echo $id;die();
            $query="SELECT * FROM tamara_payments WHERE id='$id'";
            $result=$this->_NEWDB->execquery($query);
            if($result&&$result->num_rows){
                $tamara_payment=$result->fetch_object();
                $query="SELECT * FROM users WHERE id='$tamara_payment->user_id'";
                $result1=$this->_NEWDB->execquery($query);
                $user=$result1->fetch_object();
//                if($tamara_payment->currency=='SAR'){
//                    $query="SELECT sar_rate FROM app_settings WHERE id='1'";
//                    $result1=$this->_NEWDB->execquery($query);
//                    $setting=$result1->fetch_object();
//                    $tamara_payment->amount*=($result1&&$result1->num_rows)?$setting->sar_rate:3.75;
//                }
                $query="SELECT sar_rate FROM app_settings WHERE id='1'";
                $result1=$this->_NEWDB->execquery($query);
                $setting=$result1->fetch_object();
                $sarrate=($result1&&$result1->num_rows)?$setting->sar_rate:3.75;
                $tamara_payment->amount=round($tamara_payment->amount*$sarrate);
//                $query="SELECT COUNT('X') FROM `all_payments_transactions` WHERE user_id=5733 AND all_payments_transactions.success_at IS NOT NULL";
//                print_r($tamara_payment->amount);die();
//                global  $sarrate;
//                $tamara_payment->amount=$tamara_payment->amount*$sarrate;
                $category="Course";
                switch ($tamara_payment->charge_table){
                    case'diplomas_charge_transaction':
                        $category='Diploma';
                        break;
                    case'packages_charge_transaction':
                        $category='Package';
                        break;
                    case'mba_charge_transaction':
                        $category='MBA';
                        break;
                    case'new_mba_charge_transaction':
                        $category='NEW MBA';
                        break;
                }
                if($this->_MODE=='TEST'){
                    $tamara_payment->amount=3;
                    $tamara_payment->mobile='533333335';
                }
                $dataSent= [
                    "total_amount" => [
                        "amount" => $tamara_payment->amount,
                        "currency" => "SAR"
                    ],
                    "shipping_amount" => [
                        "amount" => 0,
                        "currency" => "SAR"
                    ],
                    "tax_amount" => [
                        "amount" => 0,
                        "currency" => "SAR"
                    ],
                    "order_reference_id" => $tamara_payment->id,
                    "order_number" => $tamara_payment->all_payments_transaction_id,
                    "discount" => [
                        "amount" => [
                            "amount" => $tamara_payment->amount,
                            "currency" => "SAR"
                        ],
                        "name" => $tamara_payment->charge_name
                    ],
                    "items" => [
                        [
                            "name" => $tamara_payment->charge_name,
                            "type" => $category,
                            "reference_id" => $tamara_payment->id,
                            "sku" => "SA-".$category,
                            "quantity" => 1,
                            "discount_amount" => [
                                "amount" => 0,
                                "currency" => "SAR"
                            ],
                            "tax_amount" => [
                                "amount" => 0,
                                "currency" => "SAR"
                            ],
                            "unit_price" => [
                                "amount" => $tamara_payment->amount,
                                "currency" => "SAR"
                            ],
                            "total_amount" => [
                                "amount" => $tamara_payment->amount,
                                "currency" => "SAR"
                            ]
                        ]
                    ],
                    "consumer" => [
                        "email" => $tamara_payment->email,
                        "first_name" => $tamara_payment->first_name,
                        "last_name" => $tamara_payment->last_name,
                        "phone_number" => $tamara_payment->mobile
                    ],
                    "country_code" => "SA",
                    "description" => $tamara_payment->charge_name,
                    "merchant_url" => [
                        "cancel" => $this->siteURL.'tamaraPayment/cancel',
                        "failure" => $this->siteURL.'tamaraPayment/fail',
                        "success" => $this->siteURL.'tamaraPayment/success',
                        "notification" => $this->siteURL.'tamaraPayment/notification',
                    ],
                    "payment_type" => "PAY_BY_INSTALMENTS",
                    "instalments" => 3,
                    "billing_address" => [
                        "city" => "Riyadh",
                        "country_code" => "SA",
                        "first_name" => $tamara_payment->first_name,
                        "last_name" => $tamara_payment->last_name,
                        "line1" => "Saudi arabia",
                        "line2" => "",
                        "phone_number" => $tamara_payment->mobile,
                        "region" => ""
                    ],
                    "shipping_address" => [
                        "city" => "Riyadh",
                        "country_code" => "SA",
                        "first_name" => $tamara_payment->first_name,
                        "last_name" => $tamara_payment->last_name,
                        "line1" => "Saudi arabia",
                        "line2" => "",
                        "phone_number" => $tamara_payment->mobile,
                        "region" => ""
                    ],
                    "platform" => "Website payment",
                    "is_mobile" => false,
                    "locale" => "en_US",
                    "risk_assessment" => [
                        "customer_age" => null,
                        "customer_dob" => null,
                        "customer_gender" => null,
                        "customer_nationality" => "SA",
                        "is_premium_customer" => true,
                        "is_existing_customer" => true,
                        "is_guest_user" => true,
                        "account_creation_date" => date('d-m-Y',strtotime($user->RegisterDate)),
                        "platform_account_creation_date" => "",
                        "date_of_first_transaction" => null,
                        "is_card_on_file" => true,
                        "is_COD_customer" => true,
                        "has_delivered_order" => false,
                        "is_phone_verified" => true,
                        "is_fraudulent_customer" => true,
                        "total_ltv" => null,
                        "total_order_count" => null,
                        "order_amount_last3months" => null,
                        "order_count_last3months" => null,
                        "last_order_date" => null,
                        "last_order_amount" => null,
                        "reward_program_enrolled" => true,
                        "reward_program_points" => null,
                        "phone_verified" => false
                    ],
                    "additional_data" => [
                        "delivery_method" => "home delivery",
                        "pickup_store" => "Store A",
                        "store_code" => "Store code A",
                        "vendor_amount" => 0,
                        "merchant_settlement_amount" => 0,
                        "vendor_reference_code" => "AZ1234"
                    ]
                ];

//                $dataSent = [
//                    "total_amount" => [
//                        "amount" => 200,
//                        "currency" => "SAR"
//                    ],
//                    "shipping_amount" => [
//                        "amount" => 0,
//                        "currency" => "SAR"
//                    ],
//                    "tax_amount" => [
//                        "amount" => 0,
//                        "currency" => "SAR"
//                    ],
//                    "order_reference_id" => "1231234123-abda-fdfe--afd31241",
//                    "order_number" => "S12356",
//                    "discount" => [
//                        "amount" => [
//                            "amount" => 200,
//                            "currency" => "SAR"
//                        ],
//                        "name" => "Christmas 2020"
//                    ],
//                    "items" => [
//                        [
//                            "name" => "Lego City 8601",
//                            "type" => "Digital",
//                            "reference_id" => "123",
//                            "sku" => "SA-12436",
//                            "quantity" => 1,
//                            "discount_amount" => [
//                                "amount" => 100,
//                                "currency" => "SAR"
//                            ],
//                            "tax_amount" => [
//                                "amount" => 10,
//                                "currency" => "SAR"
//                            ],
//                            "unit_price" => [
//                                "amount" => 490,
//                                "currency" => "SAR"
//                            ],
//                            "total_amount" => [
//                                "amount" => 100,
//                                "currency" => "SAR"
//                            ]
//                        ]
//                    ],
//                    "consumer" => [
//                        "email" => "customer@email.com",
//                        "first_name" => "Mona",
//                        "last_name" => "Lisa",
//                        "phone_number" => "566027755"
//                    ],
//                    "country_code" => "SA",
//                    "description" => "lorem ipsum dolor",
//                    "merchant_url" => [
//                        "cancel" => "http://awesome-qa-tools.s3-website.me-south-1.amazonaws.com/#/cancel",
//                        "failure" => "http://awesome-qa-tools.s3-website.me-south-1.amazonaws.com/#/fail",
//                        "success" => "http://awesome-qa-tools.s3-website.me-south-1.amazonaws.com/#/success",
//                        "notification" => "https://store-demo.com/payments/tamarapay"
//                    ],
//                    "payment_type" => "PAY_BY_INSTALMENTS",
//                    "instalments" => 3,
//                    "billing_address" => [
//                        "city" => "Riyadh",
//                        "country_code" => "SA",
//                        "first_name" => "Mona",
//                        "last_name" => "Lisa",
//                        "line1" => "3764 Al Urubah Rd",
//                        "line2" => "string",
//                        "phone_number" => "532298658",
//                        "region" => "As Sulimaniyah"
//                    ],
//                    "shipping_address" => [
//                        "city" => "Riyadh",
//                        "country_code" => "SA",
//                        "first_name" => "Mona",
//                        "last_name" => "Lisa",
//                        "line1" => "3764 Al Urubah Rd",
//                        "line2" => "string",
//                        "phone_number" => "532298658",
//                        "region" => "As Sulimaniyah"
//                    ],
//                    "platform" => "platform name here",
//                    "is_mobile" => false,
//                    "locale" => "en_US",
//                    "risk_assessment" => [
//                        "customer_age" => 22,
//                        "customer_dob" => "31-01-2000",
//                        "customer_gender" => "Male",
//                        "customer_nationality" => "SA",
//                        "is_premium_customer" => true,
//                        "is_existing_customer" => true,
//                        "is_guest_user" => true,
//                        "account_creation_date" => "31-01-2019",
//                        "platform_account_creation_date" => "string",
//                        "date_of_first_transaction" => "31-01-2019",
//                        "is_card_on_file" => true,
//                        "is_COD_customer" => true,
//                        "has_delivered_order" => true,
//                        "is_phone_verified" => true,
//                        "is_fraudulent_customer" => true,
//                        "total_ltv" => 501.5,
//                        "total_order_count" => 12,
//                        "order_amount_last3months" => 301.5,
//                        "order_count_last3months" => 2,
//                        "last_order_date" => "31-01-2021",
//                        "last_order_amount" => 301.5,
//                        "reward_program_enrolled" => true,
//                        "reward_program_points" => 300,
//                        "phone_verified" => false
//                    ],
//                    "additional_data" => [
//                        "delivery_method" => "home delivery",
//                        "pickup_store" => "Store A",
//                        "store_code" => "Store code A",
//                        "vendor_amount" => 0,
//                        "merchant_settlement_amount" => 0,
//                        "vendor_reference_code" => "AZ1234"
//                    ]
//                ];


                //print_r($dataSent);
                $response=self::makeCheckout($dataSent);
                $tamara_order_id=$response->order_id;
                $tamara_checkout_id=$response->checkout_id;
                $responseJSON=json_encode($response);
                $redirect_url=$response->checkout_url;
                $query="UPDATE  tamara_payments SET tamara_order_id='$tamara_order_id',tamara_checkout_id='$tamara_checkout_id',response='$responseJSON' WHERE id='$tamara_payment->id'";
                $this->_NEWDB->execquery($query);
                $status=strtolower($response->status);
                header('Location:'.$redirect_url);
//                print_r($response);die();
//echo '###' .$status;
//                if($status=='created'){
//                    echo json_encode(['success'=>true,'redirectURL'=>$redirect_url,'tamara_payment_id'=>$tamara_payment_id]);
//                }else{
//                    echo json_encode(['success'=>false,'message'=>'نأسف، تابي غير قادرة على الموافقة على هذه العملية. الرجاء استخدام طريقة دفع أخرى.','$response'=>$response]);
//                }
                // header('Location:'.$redirect_url);

                return '';
            }
        }

    }
    public function makeCheckout($dataSent){
        $key='_BASE_URL_'.$this->_MODE;
        $url=$this->$key.'/checkout';
        $jsonDataSend=json_encode($dataSent);
        // print_r($jsonDataSend);die();
        $authKey='_API_TOKEN_'.$this->_MODE;

        $auth=$this->$authKey;
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $jsonDataSend,
            CURLOPT_HTTPHEADER => array(
                "content-type: application/json",
                "Authorization: Bearer $auth",
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            $responseData=['detail'=>$err];
        } else {
            $responseData=$response;
        }
//        print_r($responseData);
        return json_decode($responseData);
    }


    public function successPayment(){
        $filters=$this->registry->recruitment->getFilterURL();
        if(isset($filters['orderId'])&&isset($filters['paymentStatus'])&&$filters['paymentStatus']=='approved'){
            $tamara_order_id=$filters['orderId'];
            $query="SELECT * FROM  tamara_payments WHERE tamara_order_id='$tamara_order_id'";
            $result=$this->_NEWDB->execquery($query);
            $tamara_payment=$result->fetch_object();
            if(!$tamara_payment->payment_success_date){
                $date=date('Y-m-d H:i:s');
                $query="UPDATE tamara_payments SET payment_success_date='$date' WHERE id='$tamara_payment->id'";
                $this->_NEWDB->execquery($query);
                $this->registry->template->successPayment=true;
                $this->registry->template->page_body = getviewslink().'/academy/payment/payment_status';
                $this->registry->template->show('index_home');
                return '';
            }
            $this->registry->template->hasPaied=true;
            $this->registry->template->page_body = getviewslink().'/academy/payment/payment_status';
            $this->registry->template->show('index_home');
            return '';
        }

        $this->registry->template->page_body = getviewslink().'/academy/payment/payment_status';
        $this->registry->template->show('index_home');

    }
    public function cancelPayment(){
        $filters=$this->registry->recruitment->getFilterURL();
        if(isset($filters['orderId'])){
            $tamara_payment_id=$filters['orderId'];
            $query="SELECT * FROM  tamara_payments WHERE tamara_order_id='$tamara_payment_id'";
            $result=$this->_NEWDB->execquery($query);
            $tamara_payment=$result->fetch_object();
            if(!$tamara_payment->payment_cancel_date){
                $date=date('Y-m-d H:i:s');
                $query="UPDATE tamara_payments SET payment_cancel_date='$date' WHERE id='$tamara_payment->id'";
                $this->_NEWDB->execquery($query);
                $this->registry->template->cancel=true;
                $this->registry->template->page_body = getviewslink().'/academy/payment/payment_status';
                $this->registry->template->show('index_home');
                return '';
            }
            $this->registry->template->hasCancel=true;
            $this->registry->template->page_body = getviewslink().'/academy/payment/payment_status';
            $this->registry->template->show('index_home');
            return '';
        }

        $this->registry->template->page_body = getviewslink().'/academy/payment/payment_status';
        $this->registry->template->show('index_home');
    }
    public function failurePayment(){
        $filters=$this->registry->recruitment->getFilterURL();
        if(isset($filters['orderId'])){
            $tamara_payment_id=$filters['orderId'];
            $query="SELECT * FROM  tamara_payments WHERE tamara_order_id='$tamara_payment_id'";
            $result=$this->_NEWDB->execquery($query);
            $tamara_payment=$result->fetch_object();
            if(!$tamara_payment->payment_failure_date){
                $date=date('Y-m-d H:i:s');
                $query="UPDATE tamara_payments SET payment_failure_date='$date' WHERE id='$tamara_payment->id'";
                $this->_NEWDB->execquery($query);
                $this->registry->template->failure=true;
                $this->registry->template->page_body = getviewslink().'/academy/payment/payment_status';
                $this->registry->template->show('index_home');
                return '';
            }
            $this->registry->template->failure=true;
            $this->registry->template->page_body = getviewslink().'/academy/payment/payment_status';
            $this->registry->template->show('index_home');
            return '';
        }
        $this->registry->template->page_body = getviewslink().'/academy/payment/payment_status';
        $this->registry->template->show('index_home');

    }
    public function webhookPayment(){
        $filters=$this->registry->recruitment->getFilterURL();
        $data_json=json_encode(array_merge(['filters'=>$filters],['POST'=>$_POST],['GET'=>$_GET]));
//        echo $data_json;
        $data_json=$this->_NEWDB->real_escape_string($data_json);
        $date=date('Y-m-d H:i:s');
        $query="INSERT INTO tamara_webhook SET data_json='$data_json',crated_at='$date'";
        $this->_NEWDB->execquery($query);
    }
    public function checkPayment(){
        $payment_id=get('payment_id');
        $query="SELECT * FROM  tamara_payments WHERE tamara_payment_id='$payment_id'";
        $result=$this->_NEWDB->execquery($query);
        $tamara_payment=$result->fetch_object();
        if($tamara_payment){
            $query="SELECT sar_rate FROM app_settings WHERE id='1'";
            $result1=$this->_NEWDB->execquery($query);
            $setting=$result1->fetch_object();
            $sarrate=($result1&&$result1->num_rows)?$setting->sar_rate:3.75;
            $tamara_payment->amount=round($tamara_payment->amount*$sarrate);
            header("Content-type:application/json");
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.tabby.ai/api/v1/payments/'.$payment_id.'/captures',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS =>'{
    "amount":'.$tamara_payment->amount.'
}',
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'Authorization: Bearer sk_test_0a75f023-3e37-43e5-9c7b-64631955d393',
                ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);
            $responseJson=$response;
            $response= json_decode($response);
//        $response=(object)[
//            'status'=>'closed',
//        ];

            $responseJson=$this->_NEWDB->real_escape_string($responseJson);
            if(isset($response->status)&&strtolower($response->status)=='closed'){
                if(!$tamara_payment->payment_success_date){
                    $date=date('Y-m-d H:i:s');
                    $query="UPDATE tamara_payments SET payment_success_date='$date' AND payment_success_data='$responseJson' WHERE id='$tamara_payment->id'";
                    $this->_NEWDB->execquery($query);
                    $query="SELECT * FROM all_payments_transactions WHERE id='$tamara_payment->all_payments_transaction_id'";
                    $result1=$this->_NEWDB->execquery($query);
                    $allPayment=$result1->fetch_object();
                    $user=$this->registry->users->getuserdetails($allPayment->user_id);
                    $subscribe_type='tamara_installment';
                    $period=intval($allPayment->period);
                    $email=$user->Email;
                    $amount=$allPayment->amount;
                    $price=$allPayment->price;
                    $currency=$allPayment->currency;
                    $employee_id=0;
                    $start_date=date('Y-m-d H:i:s');
//                    die($period);
                    ob_start(); // Start output buffering
                    switch ($allPayment->charge_table){
                        case 'charge_transaction':
                            $this->registry->active->activeuser($email,$period,$subscribe_type,$amount,$currency,$allPayment->promotion_id);
                            break;
                        case 'diplomas_charge_transaction':
                            $diploma=$this->registry->users->getDiplomaByID($allPayment->charge_table_id);
                            $_POST['charge_system']='ksa';
                            $_POST['automation_payment_method']='automation';
                            $_POST['payment_method']=$allPayment->payment_method;
                            $this->registry->active->activeDiplomaUser($allPayment->charge_table_id,$diploma->name,$diploma->price,$email,$period,$start_date,$subscribe_type,'ksa',$currency,$employee_id);
                            break;
                        case 'packages_charge_transaction':
                            $package=$this->registry->users->getPackageByID($allPayment->charge_table_id);
                            $this->registry->active->activePackageUser($allPayment->charge_table_id,$package->name,$package->price,$email,$period,$start_date,$subscribe_type,'ksa',$currency,$employee_id);
                            break;

                        case 'lifetime':
                            $this->registry->active->activeuser($email,$period,$subscribe_type,$amount,$allPayment->currency,$allPayment->promotion_id,'lifetime');
                            break;
                        case 'mba_charge_transaction':
                            $this->registry->active->activeMBAUser($price,$email,$period,$start_date,$subscribe_type,'ksa',$currency,$employee_id);
                            break;
                        case 'new_mba_charge_transaction':
                            $this->registry->active->activeNewMBAUser($price,0,$email,$period,$start_date,$subscribe_type,'ksa',$currency,$employee_id,'ksa','ksa');
                            break;
                        case 'other':
                            $this->registry->active->activeuser($email,$period,$subscribe_type,$amount,$allPayment->currency,$allPayment->promotion_id);
                            break;
                    }
                    // Restore the original output (e.g., to the browser)
                    ob_end_flush();
                }
                echo json_encode(['success'=>true,'message'=>' تمت عملية الدفع بنجاح وجاري تحويلك','redirectURL'=>$this->siteURL]);
            }else{
                echo json_encode(['success'=>false,'message'=>'فشل في عملية الدفع يمكنك المحاولة مرة اخري او تجربة طريقة دفع اخري','response'=>$response]);
            }
        }

    }
    public function checkPayments(){
        $query="SELECT * FROM `tamara_payments` WHERE payment_success_date IS NULL AND payment_fail_date IS NULL AND DATE(created_at)>DATE_SUB(CURDATE(), INTERVAL 7 DAY)";
        $result=$this->_NEWDB->execquery($query);
        while ($tamara_payment=$result->fetch_object()){
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.tabby.ai/api/v2/payments/'.$tamara_payment->tamara_payment_id,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'Authorization: Bearer sk_test_0a75f023-3e37-43e5-9c7b-64631955d393',
                ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);
            $responseJson=$response;
            $response= json_decode($response);
            $responseJson=$this->_NEWDB->real_escape_string($responseJson);
            if(isset($response->status)&&strtolower($response->status)=='closed'){
                if(!$tamara_payment->payment_success_date){
                    $date=date('Y-m-d H:i:s');
                    $query="UPDATE tamara_payments SET payment_success_date='$date' AND payment_success_data='$responseJson' WHERE id='$tamara_payment->id'";
                    $this->_NEWDB->execquery($query);
                    $query="SELECT * FROM all_payments_transactions WHERE id='$tamara_payment->all_payments_transaction_id'";
                    $result1=$this->_NEWDB->execquery($query);
                    $allPayment=$result1->fetch_object();
                    $user=$this->registry->users->getuserdetails($allPayment->user_id);
                    $subscribe_type='tamara_installment';
                    $period=intval($allPayment->period);
                    $email=$user->Email;
                    $amount=$allPayment->amount;
                    $price=$allPayment->price;
                    $currency=$allPayment->currency;
                    $employee_id=0;
                    $start_date=date('Y-m-d H:i:s');
//                    die($period);
                    switch ($allPayment->charge_table){
                        case 'charge_transaction':
                            $this->registry->active->activeuser($email,$period,$subscribe_type,$amount,$currency,$allPayment->promotion_id);
                            break;
                        case 'diplomas_charge_transaction':
                            $diploma=$this->registry->users->getDiplomaByID($allPayment->charge_table_id);
                            $_POST['charge_system']='ksa';
                            $_POST['automation_payment_method']='automation';
                            $_POST['payment_method']=$allPayment->payment_method;
                            $this->registry->active->activeDiplomaUser($allPayment->charge_table_id,$diploma->name,$diploma->price,$email,$period,$start_date,$subscribe_type,'ksa',$currency,$employee_id);
                            break;
                        case 'packages_charge_transaction':
                            $package=$this->registry->users->getPackageByID($allPayment->charge_table_id);
                            $this->registry->active->activePackageUser($allPayment->charge_table_id,$package->name,$package->price,$email,$period,$start_date,$subscribe_type,'ksa',$currency,$employee_id);
                            break;

                        case 'lifetime':
                            $this->registry->active->activeuser($email,$period,$subscribe_type,$amount,$allPayment->currency,$allPayment->promotion_id,'lifetime');
                            break;
                        case 'mba_charge_transaction':
                            $this->registry->active->activeMBAUser($price,$email,$period,$start_date,$subscribe_type,'ksa',$currency,$employee_id);
                            break;
                        case 'new_mba_charge_transaction':
                            $this->registry->active->activeNewMBAUser($price,0,$email,$period,$start_date,$subscribe_type,'ksa',$currency,$employee_id,'ksa','ksa');
                            break;
                        case 'other':
                            $this->registry->active->activeuser($email,$period,$subscribe_type,$amount,$allPayment->currency,$allPayment->promotion_id);
                            break;
                    }
                }
            }
        }

    }
//    https://e3melbusiness.com/?page=TamaraPayment&action=capturePayment
    public function capturePayment(){
        $query="SELECT * FROM `tamara_payments` WHERE capture_at IS NULL AND tamara_order_id IS NOT NULL";
        $result=$this->_NEWDB->execquery($query);

        if($result&&$result->num_rows){
            while ( $tamara_payment=$result->fetch_object()){
                $query="SELECT * FROM users WHERE id='$tamara_payment->user_id'";
                $result1=$this->_NEWDB->execquery($query);
                $user=$result1->fetch_object();
                $query="SELECT sar_rate FROM app_settings WHERE id='1'";
                $result1=$this->_NEWDB->execquery($query);
                $setting=$result1->fetch_object();
                $sarrate=($result1&&$result1->num_rows)?$setting->sar_rate:3.75;
                $tamara_payment->amount=round($tamara_payment->amount*$sarrate);
                $category="Course";
                switch ($tamara_payment->charge_table){
                    case'diplomas_charge_transaction':
                        $category='Diploma';
                        break;
                    case'packages_charge_transaction':
                        $category='Package';
                        break;
                    case'mba_charge_transaction':
                        $category='MBA';
                        break;
                    case'new_mba_charge_transaction':
                        $category='NEW MBA';
                        break;
                }
                if($this->_MODE=='TEST'){
                    $tamara_payment->amount=3;
                    $tamara_payment->mobile='566027755';
                }
                $dataSent= [
                    'order_id'=>$tamara_payment->tamara_order_id,
                    "total_amount" => [
                        "amount" => $tamara_payment->amount,
                        "currency" => "SAR"
                    ],
                    "shipping_amount" => [
                        "amount" => 0,
                        "currency" => "SAR"
                    ],
                    "tax_amount" => [
                        "amount" => 0,
                        "currency" => "SAR"
                    ],
                    "order_reference_id" => $tamara_payment->id,
                    "order_number" => $tamara_payment->all_payments_transaction_id,
                    "discount" => [
                        "amount" => [
                            "amount" => $tamara_payment->amount,
                            "currency" => "SAR"
                        ],
                        "name" => $tamara_payment->charge_name
                    ],
                    "items" => [
                        [
                            "name" => $tamara_payment->charge_name,
                            "type" => $category,
                            "reference_id" => $tamara_payment->id,
                            "sku" => "SA-".$category,
                            "quantity" => 1,
                            "discount_amount" => [
                                "amount" => 0,
                                "currency" => "SAR"
                            ],
                            "tax_amount" => [
                                "amount" => 0,
                                "currency" => "SAR"
                            ],
                            "unit_price" => [
                                "amount" => $tamara_payment->amount,
                                "currency" => "SAR"
                            ],
                            "total_amount" => [
                                "amount" => $tamara_payment->amount,
                                "currency" => "SAR"
                            ]
                        ]
                    ],
                    "consumer" => [
                        "email" => $tamara_payment->email,
                        "first_name" => $tamara_payment->first_name,
                        "last_name" => $tamara_payment->last_name,
                        "phone_number" => $tamara_payment->mobile
                    ],
                    "country_code" => "SA",
                    "description" => $tamara_payment->charge_name,
                    "merchant_url" => [
                        "cancel" => $this->siteURL.'tamaraPayment/cancel',
                        "failure" => $this->siteURL.'tamaraPayment/fail',
                        "success" => $this->siteURL.'tamaraPayment/success',
                        "notification" => $this->siteURL.'tamaraPayment/notification',
                    ],
                    "payment_type" => "PAY_BY_INSTALMENTS",
                    "instalments" => 3,
                    "billing_address" => [
                        "city" => "Riyadh",
                        "country_code" => "SA",
                        "first_name" => $tamara_payment->first_name,
                        "last_name" => $tamara_payment->last_name,
                        "line1" => "Saudi arabia",
                        "line2" => "",
                        "phone_number" => $tamara_payment->mobile,
                        "region" => ""
                    ],
                    "shipping_address" => [
                        "city" => "Riyadh",
                        "country_code" => "SA",
                        "first_name" => $tamara_payment->first_name,
                        "last_name" => $tamara_payment->last_name,
                        "line1" => "Saudi arabia",
                        "line2" => "",
                        "phone_number" => $tamara_payment->mobile,
                        "region" => ""
                    ],
                    "platform" => "Website payment",
                    "is_mobile" => false,
                    "locale" => "en_US",
                    "risk_assessment" => [
                        "customer_age" => null,
                        "customer_dob" => null,
                        "customer_gender" => null,
                        "customer_nationality" => "SA",
                        "is_premium_customer" => true,
                        "is_existing_customer" => true,
                        "is_guest_user" => true,
                        "account_creation_date" => date('d-m-Y',strtotime($user->RegisterDate)),
                        "platform_account_creation_date" => "",
                        "date_of_first_transaction" => null,
                        "is_card_on_file" => true,
                        "is_COD_customer" => true,
                        "has_delivered_order" => false,
                        "is_phone_verified" => true,
                        "is_fraudulent_customer" => true,
                        "total_ltv" => null,
                        "total_order_count" => null,
                        "order_amount_last3months" => null,
                        "order_count_last3months" => null,
                        "last_order_date" => null,
                        "last_order_amount" => null,
                        "reward_program_enrolled" => true,
                        "reward_program_points" => null,
                        "phone_verified" => false
                    ],
                    "additional_data" => [
                        "delivery_method" => "home delivery",
                        "pickup_store" => "Store A",
                        "store_code" => "Store code A",
                        "vendor_amount" => 0,
                        "merchant_settlement_amount" => 0,
                        "vendor_reference_code" => "AZ1234"
                    ]
                ];

                $key='_BASE_URL_'.$this->_MODE;
                $url=$this->$key.'/payments/capture';
                $jsonDataSend=json_encode($dataSent);
                // print_r($jsonDataSend);die();
                $authKey='_API_TOKEN_'.$this->_MODE;
                $auth=$this->$authKey;
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => $url,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => $jsonDataSend,
                    CURLOPT_HTTPHEADER => array(
                        "content-type: application/json",
                        "Authorization: Bearer $auth",
                    ),
                ));
                $response = curl_exec($curl);
                $err = curl_error($curl);
                curl_close($curl);
                if ($err) {
                    $responseData=['detail'=>$err];
                } else {
                    $responseData=json_decode($response);
                }
                if(isset($responseData->order_id)){
                    $responseData=json_encode($responseData);
                    $responseData=$this->_NEWDB->real_escape_string($responseData);
                    $date=date('Y-m-d H:i:s');
                    $query="UPDATE tamara_payments SET capture_at='$date',capture_response='$responseData' WHERE id='$tamara_payment->id'";
                    $this->_NEWDB->execquery($query);
                }
                print_r($responseData);die();



            }
        }
    }
    public function authorisePayment(){
        $query="SELECT * FROM `tamara_payments` WHERE authorise_at IS NULL AND tamara_order_id IS NOT NULL";
        $result=$this->_NEWDB->execquery($query);

        if($result&&$result->num_rows){
            while ( $tamara_payment=$result->fetch_object()){
                $query="SELECT * FROM users WHERE id='$tamara_payment->user_id'";
                $result1=$this->_NEWDB->execquery($query);
                $user=$result1->fetch_object();
                $query="SELECT sar_rate FROM app_settings WHERE id='1'";
                $result1=$this->_NEWDB->execquery($query);
                $setting=$result1->fetch_object();
                $sarrate=($result1&&$result1->num_rows)?$setting->sar_rate:3.75;
                $tamara_payment->amount=round($tamara_payment->amount*$sarrate);
                $category="Course";
                switch ($tamara_payment->charge_table){
                    case'diplomas_charge_transaction':
                        $category='Diploma';
                        break;
                    case'packages_charge_transaction':
                        $category='Package';
                        break;
                    case'mba_charge_transaction':
                        $category='MBA';
                        break;
                    case'new_mba_charge_transaction':
                        $category='NEW MBA';
                        break;
                }
                if($this->_MODE=='TEST'){
                    $tamara_payment->amount=3;
                    $tamara_payment->mobile='566027755';
                }
                $dataSent= [];

                $key='_BASE_URL_'.$this->_MODE;
                $url=$this->$key.'/orders/'.$tamara_payment->tamara_order_id.'/authorise';
                $jsonDataSend=json_encode($dataSent);
                // print_r($jsonDataSend);die();
                $authKey='_API_TOKEN_'.$this->_MODE;
                $auth=$this->$authKey;
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => $url,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => $jsonDataSend,
                    CURLOPT_HTTPHEADER => array(
                        "content-type: application/json",
                        "Authorization: Bearer $auth",
                    ),
                ));
                $response = curl_exec($curl);
                $err = curl_error($curl);
                curl_close($curl);
                if ($err) {
                    $responseData=['detail'=>$err];
                } else {
                    $responseData=json_decode($response);
                }
                if(isset($responseData->order_id)){
                    $responseData=json_encode($responseData);
                    $responseData=$this->_NEWDB->real_escape_string($responseData);
                    $date=date('Y-m-d H:i:s');
                    $query="UPDATE tamara_payments SET authorise_at='$date',authorise_response='$responseData' WHERE id='$tamara_payment->id'";
                    $this->_NEWDB->execquery($query);


                    $query="SELECT * FROM all_payments_transactions WHERE id='$tamara_payment->all_payments_transaction_id'";
                    $result1=$this->_NEWDB->execquery($query);
                    $allPayment=$result1->fetch_object();
                    $user=$this->registry->users->getuserdetails($allPayment->user_id);
                    $subscribe_type='tamara_installment';
                    $period=intval($allPayment->period);
                    $email=$user->Email;
                    $amount=$allPayment->amount;
                    $price=$allPayment->price;
                    $currency=$allPayment->currency;
                    $employee_id=0;
                    $start_date=date('Y-m-d H:i:s');
                    ob_start(); // Start output buffering
                    switch ($allPayment->charge_table){
                        case 'charge_transaction':
                            $this->registry->active->activeuser($email,$period,$subscribe_type,$amount,$currency,$allPayment->promotion_id);
                            break;
                        case 'diplomas_charge_transaction':
                            $diploma=$this->registry->users->getDiplomaByID($allPayment->charge_table_id);
                            $_POST['charge_system']='ksa';
                            $_POST['automation_payment_method']='automation';
                            $_POST['payment_method']=$allPayment->payment_method;
                            $this->registry->active->activeDiplomaUser($allPayment->charge_table_id,$diploma->name,$diploma->price,$email,$period,$start_date,$subscribe_type,'ksa',$currency,$employee_id);
                            break;
                        case 'packages_charge_transaction':
                            $package=$this->registry->users->getPackageByID($allPayment->charge_table_id);
                            $this->registry->active->activePackageUser($allPayment->charge_table_id,$package->name,$package->price,$email,$period,$start_date,$subscribe_type,'ksa',$currency,$employee_id);
                            break;

                        case 'lifetime':
                            $this->registry->active->activeuser($email,$period,$subscribe_type,$amount,$allPayment->currency,$allPayment->promotion_id,'lifetime');
                            break;
                        case 'mba_charge_transaction':
                            $this->registry->active->activeMBAUser($price,$email,$period,$start_date,$subscribe_type,'ksa',$currency,$employee_id);
                            break;
                        case 'new_mba_charge_transaction':
                            $this->registry->active->activeNewMBAUser($price,0,$email,$period,$start_date,$subscribe_type,'ksa',$currency,$employee_id,'ksa','ksa');
                            break;
                        case 'other':
                            $this->registry->active->activeuser($email,$period,$subscribe_type,$amount,$allPayment->currency,$allPayment->promotion_id);
                            break;
                    }
                    $output = ob_get_clean();
                }
                print_r($responseData);die();




            }
        }
    }

}
