<?php
Class SAMLController Extends baseController {


    public function index()
    {
        // phpinfo();die();
        require __DIR__.'/../includes/saml/vendor/autoload.php';
        $settings = array (
            // If 'strict' is True, then the PHP Toolkit will reject unsigned
            // or unencrypted messages if it expects them signed or encrypted
            // Also will reject the messages if not strictly follow the SAML
            // standard: Destination, NameId, Conditions ... are validated too.
            'strict' => true,

            // Enable debug mode (to print errors)
            'debug' => false,

            // Set a BaseURL to be used instead of try to guess
            // the BaseURL of the view that process the SAML Message.
            // Ex. http://sp.example.com/
            //     http://example.com/sp/
            'baseurl' => null,

            // Service Provider Data that we are deploying
            'sp' => array (
                // Identifier of the SP entity  (must be a URI)
                'entityId' => '',
                // Specifies info about where and how the <AuthnResponse> message MUST be
                // returned to the requester, in this case our SP.
                'assertionConsumerService' => array (
                    // URL Location where the <Response> from the IdP will be returned
                    'url' => '',
                    // SAML protocol binding to be used when returning the <Response>
                    // message.  SAML Toolkit supports for this endpoint the
                    // HTTP-POST binding only
                    'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                ),
                // If you need to specify requested attributes, set a
                // attributeConsumingService. nameFormat, attributeValue and
                // friendlyName can be omitted. Otherwise remove this section.
                "attributeConsumingService"=> array(
                    "serviceName" => "SP test",
                    "serviceDescription" => "Test Service",
                    "requestedAttributes" => array(
                        array(
                            "name" => "",
                            "isRequired" => false,
                            "nameFormat" => "",
                            "friendlyName" => "",
                            "attributeValue" => ""
                        )
                    )
                ),
                // Specifies info about where and how the <Logout Response> message MUST be
                // returned to the requester, in this case our SP.
                'singleLogoutService' => array (
                    // URL Location where the <Response> from the IdP will be returned
                    'url' => '',
                    // SAML protocol binding to be used when returning the <Response>
                    // message.  SAML Toolkit supports for this endpoint the
                    // HTTP-Redirect binding only
                    'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                ),
                // Specifies constraints on the name identifier to be used to
                // represent the requested subject.
                // Take a look on lib/Saml2/Constants.php to see the NameIdFormat supported
                'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',

                // Usually x509cert and privateKey of the SP are provided by files placed at
                // the certs folder. But we can also provide them with the following parameters
                'x509cert' => '',
                'privateKey' => '',

                /*
                 * Key rollover
                 * If you plan to update the SP x509cert and privateKey
                 * you can define here the new x509cert and it will be
                 * published on the SP metadata so Identity Providers can
                 * read them and get ready for rollover.
                 */
                // 'x509certNew' => '',
            ),

            // Identity Provider Data that we want connect with our SP
            'idp' => array (
                // Identifier of the IdP entity  (must be a URI)
                'entityId' => 'https://futurex.nelc.gov.sa/simplesaml/saml2/idp/metadata.php',
                // SSO endpoint info of the IdP. (Authentication Request protocol)
                'singleSignOnService' => array (
                    // URL Target of the IdP where the SP will send the Authentication Request Message
                    'url' => 'https://futurex.nelc.gov.sa/simplesaml/saml2/idp/SSOService.php',
                    // SAML protocol binding to be used when returning the <Response>
                    // message.  SAML Toolkit supports for this endpoint the
                    // HTTP-Redirect binding only
                    'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                ),
                // SLO endpoint info of the IdP.
                'singleLogoutService' => array (
                    // URL Location of the IdP where the SP will send the SLO Request
                    'url' => '',
                    // URL location of the IdP where the SP will send the SLO Response (ResponseLocation)
                    // if not set, url for the SLO Request will be used
                    'responseUrl' => 'https://futurex.nelc.gov.sa/simplesaml/saml2/idp/SingleLogoutService.php',
                    // SAML protocol binding to be used when returning the <Response>
                    // message.  SAML Toolkit supports for this endpoint the
                    // HTTP-Redirect binding only
                    'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                ),
                // Public x509 certificate of the IdP
                'x509cert' => 'MIIEtTCCAx2gAwIBAgIJAOijmLImc3WwMA0GCSqGSIb3DQEBCwUAMHExCzAJBgNVBAYTAlNBMQ8wDQYDVQQIDAZSaXlhZGgxDzANBgNVBAcMBlJpeWFkaDENMAsGA1UECgwETmVMQzEQMA4GA1UECwwHRnV0dXJlWDEfMB0GA1UEAwwWbmVsYy1zc28uc2h0ZWNoLmNvbS5zYTAeFw0yMTA5MTExNzE1MzFaFw0zMTA5MTExNzE1MzFaMHExCzAJBgNVBAYTAlNBMQ8wDQYDVQQIDAZSaXlhZGgxDzANBgNVBAcMBlJpeWFkaDENMAsGA1UECgwETmVMQzEQMA4GA1UECwwHRnV0dXJlWDEfMB0GA1UEAwwWbmVsYy1zc28uc2h0ZWNoLmNvbS5zYTCCAaIwDQYJKoZIhvcNAQEBBQADggGPADCCAYoCggGBAPzF20/PiFegp8/5T+iDTVOrJPoZLkT+TYnVit2q+PoGhLgiausj/XWmrIvkvF3XhWwthwgDkSR3oGJs3fZFYJy+DqilKhISZDW+oHcys0XBAeLftQgqvALuaryO7aejzgUFf/t5QN/d0bDSd7AcpKToxwE1CETnCm+b9HxbltpI2+DhRiOmH91Br8aZpHG9XAY89AJ9cx27fuoKxiO3TOhxc1Y8+Y7q82O1TBMsRgUPXlojQELogTkubJsEw7aP+zmSnO35pyN25qmRK8Z2yE+AI/6aVGIFIGfko76M07Gb0mx0uxtSWqb4YT4FuufbEhddW7e551iVkuGRV3GMXahpez/XlJWPP50Oiva/1mpjvlfKd3hKRNfOkl13onGrYRClrNAtpSV71kG9vgYiw+fjGtLO5Yr/4MKnitOyA0FFV0vBp5K6CAd3xDA8sWxNACfU1KqrGs09wm1us5OtVB25pfloBlod/Udzxa06KDpxeUf9B140sg+jyQYEiT82iwIDAQABo1AwTjAdBgNVHQ4EFgQUiwxiAFSz3huQK/mmoP+664iUTDgwHwYDVR0jBBgwFoAUiwxiAFSz3huQK/mmoP+664iUTDgwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQsFAAOCAYEAkU+ITU4i18emvGDfxiyTlRFedy4+sJtmx27xmmfwRpNhszivtKbXxvxg1ElUecxZcosdykWLyCadO+XuqZnirXgzAwSHbFjHAK5JY2WhzK6mcW+chWmMEkdzKd+cdI0g/2LR+6Y2h4cHLmC7reFnOUGKV1vukwbVYbRuLs6fnDaO4BPgFEFfQSoP0VZuyN9Iwk3XbMaDuhSCSXV2kFbIs4UfWaoRdlv1oWwD/EKiC9AhM2cOWjbBLDtaKJAZeWVsVyuzilhskiD4OzyhnQOMIROvnhuhEFQV1/mMGjTlbJ/1kkN7Yj34HkslKmOZ4QXBAbHzqJ0h+MB8LTvEB0A+5f2PNjYPisuTHBWnh2yPR3+ktxwd5M4/ERre0F1n/6zqC/Ur1NLJddH1mnufPw3sNsUENDhPy9ADkHYF9w7o+5Lp9ZHPaxTDFXf1tdTbigxNw1kADy0aOiphVSUS4Zy/TmXT1y6MEEh5w+XT76CwLYbfAU7htMq8bPGsMQ96MNAN',
                /*
                 *  Instead of use the whole x509cert you can use a fingerprint in
                 *  order to validate the SAMLResponse, but we don't recommend to use
                 *  that method on production since is exploitable by a collision
                 *  attack.
                 *  (openssl x509 -noout -fingerprint -in "idp.crt" to generate it,
                 *   or add for example the -sha256 , -sha384 or -sha512 parameter)
                 *
                 *  If a fingerprint is provided, then the certFingerprintAlgorithm is required in order to
                 *  let the toolkit know which Algorithm was used. Possible values: sha1, sha256, sha384 or sha512
                 *  'sha1' is the default value.
                 */
                // 'certFingerprint' => '',
                // 'certFingerprintAlgorithm' => 'sha1',
                'contacts' => [
                    [
                        'emailAddress' => 'admin@elc.edu.sa',
                        'contactType' => 'technical',
                        'givenName' => 'Administrator',
                    ],
                ],
                /* In some scenarios the IdP uses different certificates for
                 * signing/encryption, or is under key rollover phase and more
                 * than one certificate is published on IdP metadata.
                 * In order to handle that the toolkit offers that parameter.
                 * (when used, 'x509cert' and 'certFingerprint' values are
                 * ignored).
                 */
                // 'x509certMulti' => array(
                //      'signing' => array(
                //          0 => '<cert1-string>',
                //      ),
                //      'encryption' => array(
                //          0 => '<cert2-string>',
                //      )
                // ),
            ),
        );

    }

}
?>
