<?php $__env->startSection('pageTitle'); ?>
    <title><?php echo e(Lang::get('main.home_page_title')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('contentHeader'); ?>
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="<?php echo e(URL('/admin')); ?>"><?php echo e(Lang::get('main.dashboard')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span><?php echo e(Lang::get('main.futurex_integration_courses')); ?></span>
            </li>
        </ul>

    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> <?php echo e(Lang::get('main.futurex_integration_courses')); ?>

        <small><?php echo e(Lang::get('main.view')); ?></small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<style>
    td {
        word-wrap: break-word;
        overflow-wrap: break-word;
    }
</style>

<div class="row">
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-users font-dark"></i>
                <span class="caption-subject bold uppercase"><?php echo e(Lang::get('main.futurex_integration_courses')); ?></span>
            </div>
            <div class="tools"></div>
        </div>
        <div class="portlet-body">
            <table style=" table-layout: fixed;width: 100%;" class="table table-striped table-bordered table-hover table-checkable" width="100%"
                   id="datatable_ajax">
                <thead>
                <tr role="row" class="heading">
                    <th> #</th>
                    <th><?php echo e(Lang::get('main.name')); ?></th>
                    <th><?php echo e(Lang::get('main.url')); ?></th>
                    <th>Futurex Category</th>
                    <th>Futurex Level</th>
                    <th>Futurex language</th>
                    <th>Futurex Skills</th>
                    <th>Futurex Tags</th>
                    <th>Created At</th>
                    <th></th>
                </tr>
                <tr role="row" class="filter">
                    <td>
                        <input type="hidden" id="_token" name="_token" value="<?php echo e(csrf_token()); ?>">
                        <input type="number" min="1" class="form-control form-filter input-sm" name="id">
                    </td>
                    <td>
                        <input type="text" class="form-control form-filter input-sm" name="course_name">
                    </td>
                    <td>
                        <input type="text" class="form-control form-filter input-sm" name="url">
                    </td>
                    <td>
                        <input type="text" class="form-control form-filter input-sm" name="futurex_category">
                    </td>
                    <td>
                        <input type="text" class="form-control form-filter input-sm" name="futurex_level">
                    </td>
                    <td>
                        <input type="text" class="form-control form-filter input-sm" name="futurex_language">
                    </td>
                    <td>
                        <input type="text" class="form-control form-filter input-sm" name="futurex_skills">
                    </td>
                    <td>
                        <input type="text" class="form-control form-filter input-sm" name="futurex_tags">
                    </td>
                    <td>
                        <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                            <input type="text" class="form-control form-filter input-sm"
                                   name="created_time_from" placeholder="<?php echo e(Lang::get('main.from')); ?>">
                            <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                        </div>
                        <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                            <input type="text" class="form-control form-filter input-sm"
                                   name="created_time_to" placeholder="<?php echo e(Lang::get('main.to')); ?>">
                            <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                        </div>
                    </td>
                    <td>
                        <div class="margin-bottom-5">
                            <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                <i class="fa fa-search"></i> <?php echo e(Lang::get('main.search')); ?></button>
                        </div>
                        <button class="btn btn-sm red btn-outline filter-cancel">
                            <i class="fa fa-times"></i> <?php echo e(Lang::get('main.reset')); ?></button>
                    </td>

                </tr>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scriptCode'); ?>

    <script>
        $(document).ready(function () {
            var token = "<?php echo e(csrf_token()); ?>";
            $(".menu-toggler.sidebar-toggler").trigger('click');
            $('.fromToDate').datepicker({
                rtl: App.isRTL(),
                autoclose: true
            });
            var grid = new Datatable();
            grid.setAjaxParam("_token", "<?php echo e(csrf_token()); ?>");
            // console.log(grid._token)
            grid.init({
                src: $("#datatable_ajax"),
                onSuccess: function (grid, response) {
                    // grid:        grid object
                    // response:    json object of server side ajax response
                    // execute some code after table records loaded
                },
                onError: function (grid) {
                    // execute some code on network or other general error
                },
                onDataLoad: function (grid) {
                },
                loadingMessage: '<?php echo e(Lang::get('main.loading')); ?>',
                dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options
                    // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                    // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                    // So when dropdowns used the scrollable div should be removed.
                    //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
                    "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                    "lengthMenu": [
                        [10, 20, 50, 100, 150, <?php if(PerUser('view_all_rows')): ?> -1 <?php endif; ?>],
                        [10, 20, 50, 100, 150, <?php if(PerUser('view_all_rows')): ?> "All" <?php endif; ?>] // change per page values here
                    ],
                    "pageLength": 10, // default record count per page
                    "ajax": {
                        "url": "<?php echo e(URL('admin/futurex_integration')); ?>", // ajax source
                    },
                    <?php if(getUserSystem('backend_lang')=='ar'): ?> "language": {"url": "<?php echo e(asset('assets/layouts/layout/datatables-arabic.json')); ?>"},<?php endif; ?> "columnDefs": [{
                        "targets": [0], // column or columns numbers
                        "orderable": true  // set orderable for selected columns

                    }],
                    "order": [
                        [0, "desc"]
                    ],// set first column as a default sort by asc
                    dom: 'Blfrtip',
                    buttons: [
                        {extend: 'print', className: 'btn dark btn-outline'},
                        {extend: 'pdf', className: 'btn green btn-outline'},
                        {extend: 'csv', className: 'btn purple btn-outline '}
                    ],
                }
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('auth.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ebacademy/public_html/e3melbusinessyottacourses.elbazdev.com/adminResources/resources/views/auth/futurex_integration_courses/view.blade.php ENDPATH**/ ?>