<?php $__env->startSection('pageTitle'); ?>
    <title><?php echo e(Lang::get('main.home_page_title')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('contentHeader'); ?>
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="<?php echo e(URL('/admin')); ?>"><?php echo e(Lang::get('main.dashboard')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="<?php echo e(URL('/admin/users_curriculum_answers')); ?>"><?php echo e(Lang::get('main.users_curriculum_answers')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span><?php echo e(Lang::get('main.edit')); ?></span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> <?php echo e(Lang::get('main.users_curriculum_answers')); ?>

        <small><?php echo e(Lang::get('main.edit')); ?></small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase"><?php echo e(Lang::get('main.users_curriculum_answers')); ?></span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                <?php echo Form::open(['method'=>'PUT','url'=>'admin/users_curriculum_answers/'.$answer->id,'class'=>"form-horizontal"]); ?>

                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        <?php echo e(Lang::get('main.form_validation_error')); ?>

                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        <?php echo e(Lang::get('main.form_validation_success')); ?>

                    </div>
                </div>

                <div id="messages"></div>
                <div class="form-group col-lg-12">
                    <label class="control-label" for="user"><?php echo e(Lang::get('main.user')); ?> <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($user); ?>" id="user" name="user" data-required="1"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.user')); ?>">
                    </div>
                </div>
                
                    
                           
                           
                
                <div id="users" class="col-lg-12"></div>

                <div class="form-group col-lg-12">
                    <label for="course"><?php echo e(Lang::get('main.course')); ?><span
                                class="required"> * </span></label>
                    <select name="course" class="module_name sel2 form-control form-filter">
                        <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.course')); ?></option>
                        <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id=>$name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php if($answer->course_id==$id): ?> selected="selected" <?php endif; ?> value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group col-lg-12">
                    <label for="curriculum_id"><?php echo e(Lang::get('main.curriculum_id')); ?><span
                                class="required"> * </span></label>
                    <select name="curriculum_id" class="module_name sel2 form-control form-filter">
                        <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.curriculum_id')); ?></option>
                        <?php $__currentLoopData = $curriculums_ids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php if($answer->curriculum_id==$id): ?> selected="selected" <?php endif; ?> value="<?php echo e($id); ?>"><?php echo e($id); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="form-group col-lg-12">
                    <label class="control-label" for="session_user_id"><?php echo e(Lang::get('main.session_user_id')); ?></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control"  value="<?php echo e($answer->session_user_id); ?>" name="session_user_id" data-required="1"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.session_user_id')); ?>">
                    </div>
                </div>

                <div class="form-group col-lg-12">
                    <label for="curriculum_type"><?php echo e(Lang::get('main.curriculum_type')); ?><span
                                class="required"> * </span></label>
                    <select name="curriculum_type" class="module_name sel2 form-control form-filter">
                        <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.curriculum_type')); ?></option>
                        <option <?php if($answer->curriculum_type=='exam'): ?> selected="selected" <?php endif; ?> value="exam">exam</option>
                        <option <?php if($answer->curriculum_type=='training'): ?> selected="selected" <?php endif; ?> value="training">training</option>
                    </select>
                </div>
                <div class="form-group col-lg-12">
                    <label class="control-label" for="right_answers"><?php echo e(Lang::get('main.right_answers')); ?> <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($answer->right_answers); ?>" name="right_answers" data-required="1"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.right_answers')); ?>">
                    </div>
                </div>
                <div class="form-group col-lg-12">
                    <label class="control-label" for="wrong_answers"><?php echo e(Lang::get('main.wrong_answers')); ?> <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($answer->wrong_answers); ?>" name="wrong_answers" data-required="1"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.wrong_answers')); ?>">
                    </div>
                </div>
                <div class="form-group col-lg-12">
                    <label class="control-label" for="duration_time"><?php echo e(Lang::get('main.duration_time')); ?> <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="<?php echo e($answer->duration_time); ?>" name="duration_time" data-required="1"
                               placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.duration_time')); ?>">
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="text-center col-lg-12">
                    <button type="submit" class="btn green"><?php echo e(Lang::get('main.save')); ?></button>
                </div>
                <div class="clearfix"></div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scriptCode'); ?>
    <script>
        $(document).ready(function () {
            $('#user').keyup(function(){
                var query=$(this).val();
                if(query!=''){
                    var token = "<?php echo e(csrf_token()); ?>";
                    $.ajax({
                        type: "POST",
                        url: "<?php echo e(URL('admin/users_curriculum_answers/autoCompleteUsers')); ?>",
                        data: {query: query, _token: token},
                        success: function (data) {
                            $("#users").fadeIn();
                            $("#users").html(data);
                        }
                    })
                }
                else{
                    $("#users").fadeOut();
                }
            });
            $(document).on('click','#users-emails li',function(){
                $('#user').val($(this).text());
                $('#users').fadeOut();
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('auth.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ebacademy/public_html/e3melbusiness.org/adminResources/resources/views/auth/users_curriculum_answers/edit.blade.php ENDPATH**/ ?>