
<?php $__env->startSection('pageTitle'); ?>
    <title><?php echo e(Lang::get('main.home_page_title')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('contentHeader'); ?>
        <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="<?php echo e(URL('/admin')); ?>"><?php echo e(Lang::get('main.dashboard')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span><?php echo e(Lang::get('main.our_products')); ?></span>
            </li>
        </ul>
        <!--<div class="page-toolbar">
            <div id="dashboard-report-range" class="pull-right tooltips btn btn-sm" data-container="body" data-placement="bottom" data-original-title="Change dashboard date range">
                <i class="icon-calendar"></i>&nbsp;
                <span class="thin uppercase hidden-xs"></span>&nbsp;
                <i class="fa fa-angle-down"></i>
            </div>
        </div>-->
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> <?php echo e(Lang::get('main.our_products')); ?>
        <small><?php echo e(Lang::get('main.view')); ?></small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php if(PerUser('our_products_add')): ?>
    <div class="row">
        <div class="col-md-12">
            <div class="btn-group pull-right">
                <a href="<?php echo e(URL('admin/our_products/create')); ?>" id="sample_editable_1_new" class="btn green"> <?php echo e(Lang::get('main.add_new')); ?>
                    <i class="fa fa-plus"></i>
                </a>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <?php if(PerUser('our_products_view')): ?>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-our_products font-dark"></i>
                    <span class="caption-subject bold uppercase"><?php echo e(Lang::get('main.our_products')); ?></span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                <div class="table-container">
                    <table class="table table-striped table-bordered table-hover table-checkable" id="datatable_ajax">
                        <thead>
                        <tr role="row" class="heading">
                            <th width="10%"> # </th>
                            <th width="30%"><?php echo e(Lang::get('main.name')); ?></th>
                            <th width="20%"><?php echo e(Lang::get('main.image')); ?></th>
                            <th width="20%"><?php echo e(Lang::get('main.published')); ?></th>
                            <th width="40%"><?php echo e(Lang::get('main.url')); ?></th>
                            <th width="40%"><?php echo e(Lang::get('main.sort')); ?></th>
                        </tr>
                        <tr role="row" class="filter">
                            <td>
                            </td>
                            <td>
                                <input type="hidden" id="_token" name="_token" value="<?php echo e(csrf_token()); ?>">
                                <input type="text" class="form-control form-filter input-sm" name="name">
                            </td>
                            <td>

                            </td>
                            <td>

                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" name="url">
                            </td>
                            <td>
                                <input type="number" min="1" class="form-control form-filter input-sm" name="sort">
                            </td>
                            <td>
                                <div class="margin-bottom-5">
                                    <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                        <i class="fa fa-search"></i> <?php echo e(Lang::get('main.search')); ?></button>
                                </div>
                                <button class="btn btn-sm red btn-outline filter-cancel">
                                    <i class="fa fa-times"></i> <?php echo e(Lang::get('main.reset')); ?></button>
                            </td>
                        </tr>
                        </thead>
                        <tbody> </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- image modal -->
        <div id="image-modal" class="modal fade modal-scroll" tabindex="-1" data-replace="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    </div>
                    <div class="modal-body">
                        <img width="100%"/>
                        <div class="modal-footer">
                            <button type="button" data-dismiss="modal" class="btn dark btn-outline"><?php echo e(Lang::get('main.close')); ?></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scriptCode'); ?>
    <?php if(PerUser('our_products_view')): ?>

    <script>
        $(document).ready(function(){
            token= '<?php echo e(csrf_token()); ?>';
            <?php if(PerUser('our_products_publish')): ?>
            $(document).on('change','.changeStatues',function(){
                var statues=$(this).is(':checked');
                var id=$(this).attr('data-id');
                if(statues){
                    $.ajax({
                        type: "POST",
                        url: "<?php echo e(URL('admin/our_products/publish')); ?>",
                        data: {"published": "yes", "id": id,_token:token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }else{
                    $.ajax({
                        type: "POST",
                        url: "<?php echo e(URL('admin/our_products/publish')); ?>",
                        data: {"published": "no", "id": id,_token:token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }
            });
            <?php endif; ?>
            <?php if(PerUser('our_products_view')): ?>
            var grid = new Datatable();
            grid.setAjaxParam("_token", "<?php echo e(csrf_token()); ?>")
            // console.log(grid._token)
            grid.init({
                src: $("#datatable_ajax"),
                onSuccess: function (grid, response) {
                    // grid:        grid object
                    // response:    json object of server side ajax response
                    // execute some code after table records loaded
                },
                onError: function (grid) {
                    // execute some code on network or other general error
                },
                onDataLoad: function(grid) {
                    // execute some code on ajax data load
                },
                loadingMessage: '<?php echo e(Lang::get('main.loading')); ?>',
                dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options
                    // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                    // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                    // So when dropdowns used the scrollable div should be removed.
                    //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
                    "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                    "lengthMenu": [
                        [10, 20, 50, 100, 150, <?php if(PerUser('view_all_rows')): ?> -1 <?php endif; ?>],
                        [10, 20, 50, 100, 150, <?php if(PerUser('view_all_rows')): ?> "All" <?php endif; ?>] // change per page values here
                    ],
                    "pageLength": 10, // default record count per page
                    "ajax": {
                        "url": "<?php echo e(URL('admin/our_products/getOurProductsAJAX')); ?>", // ajax source
                    },
                    <?php if(getUserSystem('backend_lang')=='ar'): ?> "language": {"url": "<?php echo e(asset('assets/layouts/layout/datatables-arabic.json')); ?>"},<?php endif; ?>
                    "order": [
                        [0, "desc"]
                    ],// set first column as a default sort by asc
                    dom: 'Blfrtip',
                    buttons: [
                        { extend: 'print', className: 'btn dark btn-outline' },
                        { extend: 'pdf', className: 'btn green btn-outline' },
                        { extend: 'csv', className: 'btn purple btn-outline ' }
                    ],
                }
            });
            <?php endif; ?>
            <?php if(PerUser('our_products_delete')): ?>
            $(document).on('click','.delete_this',function(event){
                event.preventDefault();
                console.log('erl');
                el=$(this);
                deleted_id=$(this).attr("data-id");

                BootstrapDialog.show({
                    title: '<?php echo e(Lang::get('main.delete').lang::get('main.our_products')); ?>',
                    message: '<?php echo e(Lang::get('main.delete_this').lang::get('main.our_products')); ?> ?',
                    buttons: [
                        {
                            label: '<?php echo e(Lang::get('main.yes')); ?>',
                            cssClass: 'btn-primary',
                            action: function(dialogItself){
                                $.ajax({
                                    type: "DELETE",
                                    url: "<?php echo e(URL('admin/our_products')); ?>/"+deleted_id,
                                    data: {"id":deleted_id,_token:token},
                                    success: function (msg) {
                                        $("#errors").html(msg);
                                        el.closest('tr').remove();
                                        dialogItself.close();
                                    }
                                });
                            }
                        },
                        {
                            label: '<?php echo e(Lang::get('main.no')); ?>',
                            action: function(dialogItself){
                                dialogItself.close();
                            }
                        }]
                });
            });
            <?php endif; ?>
            $(document).on("click", ".image-link", function () {
                $("#image-modal .modal-body img").attr('src', $(this).find('img').attr('src') );
            });
        });
    </script>
    <?php endif; ?>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('auth.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ebacademy/public_html/e3melbusiness.org/adminResources/resources/views/auth/our_products/view.blade.php ENDPATH**/ ?>