<?php $__env->startSection('pageTitle'); ?>
    <title><?php echo e(Lang::get('main.home_page_title')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('contentHeader'); ?>
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="<?php echo e(URL('/admin')); ?>"><?php echo e(Lang::get('main.dashboard')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="<?php echo e(URL('/admin/normal_user')); ?>"><?php echo e(Lang::get('main.normal_user')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span><?php echo e(Lang::get('main.add')); ?></span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> <?php echo e(Lang::get('main.normal_user')); ?>

        <small><?php echo e(Lang::get('main.add')); ?></small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase"><?php echo e(Lang::get('main.normal_user')); ?></span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                <?php echo Form::open(['method'=>'POST','url'=>'admin/normal_user','class'=>"form-horizontal",'files'=>true]); ?>

                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        <?php echo e(Lang::get('main.form_validation_error')); ?>

                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        <?php echo e(Lang::get('main.form_validation_success')); ?>

                    </div>
                    <div id="messages"></div>
                    <div class="form-group col-lg-12">
                        <label class="control-label" for="name"><?php echo e(Lang::get('main.name')); ?> <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="<?php echo old('name'); ?>" id="name" name="name" data-required="1"
                                   placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.name')); ?>">
                        </div>
                    </div>
                    
                        
                               
                               
                    

                    <div class="form-group col-lg-12">
                        <label class="control-label" for="email"><?php echo e(Lang::get('main.email')); ?> <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="<?php echo old('email'); ?>" name="email" data-required="1"
                                   placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.email')); ?>">
                        </div>
                    </div>

                    <div class="form-group col-lg-12">
                        <label class="control-label" for="mobile"><?php echo e(Lang::get('main.mobile')); ?> <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="<?php echo old('mobile'); ?>" name="mobile" data-required="1"
                                   placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.mobile')); ?>">
                        </div>
                    </div>

                    <div class="form-group col-lg-12">
                        <label class="control-label" for="image"><?php echo e(Lang::get('main.image')); ?> <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="file" class="form-control" value="" id="image" accept="image/*"
                                   name="image" data-required="1"
                                   placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.image')); ?>">
                        </div>
                    </div>

                    <div class="form-group col-lg-12">
                        <label for="type"><?php echo e(Lang::get('main.type')); ?><span
                                    class="required"> * </span></label>
                        <select id="type" name="type" class="module_name sel2 form-control form-filter">
                            <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.type')); ?></option>
                            <option <?php if(old('type')=='person'): ?> selected="selected" <?php endif; ?> value="person">Person</option>
                            <option <?php if(old('type')=='company'): ?> selected="selected" <?php endif; ?> value="company">Company</option>
                        </select>
                    </div>

                    <div id="companies" class="form-group col-lg-12">
                        <label for="company"><?php echo e(Lang::get('main.company')); ?><span
                                    class="required"> * </span></label>
                        <select name="company" class="module_name sel2 form-control form-filter">
                            <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.company')); ?></option>
                            <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id=>$name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option <?php if(old('company')==$id): ?> selected="selected" <?php endif; ?> value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group col-lg-12">
                        <label for="country"><?php echo e(Lang::get('main.country')); ?><span
                                    class="required"> * </span></label>
                        <select name="country" class="module_name sel2 form-control form-filter">
                            <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.country')); ?></option>
                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id=>$name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option <?php if(old('country')==$id): ?> selected="selected" <?php endif; ?> value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group col-lg-12">
                        <label for="type_of_subscribe"><?php echo e(Lang::get('main.type_of_subscribe')); ?><span
                                    class="required"> * </span></label>
                        <select name="type_of_subscribe" class="module_name sel2 form-control form-filter">
                            <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.type_of_subscribe')); ?></option>
                            <option <?php if(old('type_of_subscribe')=='default'): ?> selected="selected" <?php endif; ?> value="default">Default</option>
                            <option <?php if(old('type_of_subscribe')=='annual'): ?> selected="selected" <?php endif; ?> value="annual">Annual</option>
                            <option <?php if(old('type_of_subscribe')=='percourse'): ?> selected="selected" <?php endif; ?> value="percourse">Per course</option>
                            <option <?php if(old('type_of_subscribe')=='diplomas'): ?> selected="selected" <?php endif; ?> value="diplomas">Diplomas</option>
                        </select>
                    </div>

                    <div class="form-group col-lg-12">
                        <label for="user_type"><?php echo e(Lang::get('main.user_type')); ?><span
                                    class="required"> * </span></label>
                        <select name="user_type" class="module_name sel2 form-control form-filter">
                            <option value=" "><?php echo e(Lang::get('main.select')); ?><?php echo e(Lang::get('main.user_type')); ?></option>
                            <option <?php if(old('user_type')=='corporate'): ?> selected="selected" <?php endif; ?> value="corporate">Corporate</option>
                            <option <?php if(old('user_type')=='individual'): ?> selected="selected" <?php endif; ?> value="individual">Individual</option>
                        </select>
                    </div>
                    <div class="col-md-12 form-group">
                        <label class="control-label" for="payment_expiration_date"><?php echo e(Lang::get('main.payment_expiration_date')); ?></label>
                        <div class="input-group date ped" data-date-format="yyyy-mm-dd">
                            <input type="text" class="form-control" value="<?php echo old('payment_expiration_date'); ?>" name="payment_expiration_date">
                            <span class="input-group-btn">
                                <button class="btn btn-sm default" type="button">
                                    <i class="fa fa-calendar"></i>
                                </button>
                           </span>
                        </div>
                    </div>
                    <div class="col-md-12 form-group">
                        <label class="control-label" for="demo_expiration_date"><?php echo e(Lang::get('main.demo_expiration_date')); ?></label>
                        <div class="input-group date ped" data-date-format="yyyy-mm-dd">
                            <input type="text" class="form-control" value="<?php echo old('demo_expiration_date'); ?>" name="demo_expiration_date">
                            <span class="input-group-btn">
                                <button class="btn btn-sm default" type="button">
                                    <i class="fa fa-calendar"></i>
                                </button>
                           </span>
                        </div>
                    </div>

                    <div class="form-group col-lg-12">
                        <label class="control-label" for="facebook"><?php echo e(Lang::get('main.facebook')); ?></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="<?php echo old('facebook'); ?>" name="facebook"
                                   placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.facebook')); ?>">
                        </div>
                    </div>

                    <div class="form-group col-lg-12">
                        <label class="control-label" for="linkedin"><?php echo e(Lang::get('main.linkedin')); ?></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="<?php echo old('linkedin'); ?>" name="linkedin"
                                   placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.linkedin')); ?>">
                        </div>
                    </div>

                    <div class="form-group col-lg-12">
                        <label class="control-label" for="twitter"><?php echo e(Lang::get('main.twitter')); ?></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="<?php echo old('twitter'); ?>" name="twitter"
                                   placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.twitter')); ?>">
                        </div>
                    </div>

                    <div class="form-group col-lg-12">
                        <label class="control-label" for="google"><?php echo e(Lang::get('main.google')); ?></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="<?php echo old('google'); ?>" name="google"
                                   placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.google')); ?>">
                        </div>
                    </div>

                    <div class="clearfix"></div>
                    <div class="text-center col-lg-12">
                        <button type="submit" class="btn green"><?php echo e(Lang::get('main.add')); ?></button>
                    </div>
                </div>


                <div class="clearfix"></div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scriptCode'); ?>
    <script>
        $(document).ready(function(){
            $('#companies').hide();
            $('#type').change(function(){
                if($(this).val()=='company'){
                    $('#companies').show();
                }
                else{
                    $('#companies').hide();
                }
            })
            $('.ped').datepicker({
                rtl: App.isRTL(),
                autoclose: true
            });
        })

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('auth.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ebacademy/public_html/e3melbusinessyottacourses.elbazdev.com/adminResources/resources/views/auth/normal_user/add.blade.php ENDPATH**/ ?>