    <?php
$selectors=isset($selectors)?$selectors:'.description';
$not_required=isset($not_required)?true:false;
$labels=isset($labels)?$labels:[Lang::get('main.description')];
?>
<script type="text/javascript" src="<?php echo e(asset('js/tinymce/tinymce.min.js?v=2')); ?>"></script>


<script type="text/javascript">
    const useDarkMode = window.matchMedia('(prefers-color-scheme: dark)').matches;
    const isSmallScreen = window.matchMedia('(max-width: 1023.5px)').matches;


    const example_image_upload_handler = (blobInfo, progress) => new Promise((resolve, reject) => {
        const xhr = new XMLHttpRequest();
        xhr.withCredentials = false;
        xhr.open('POST', "<?php echo e(url('admin/description_upload')); ?>");
        var token = '<?php echo e(csrf_token()); ?>';
        xhr.setRequestHeader("X-CSRF-Token", token);

        xhr.upload.onprogress = (e) => {
            progress(e.loaded / e.total * 100);
        };

        xhr.onload = () => {
            if (xhr.status === 403) {
                reject({ message: 'HTTP Error: ' + xhr.status, remove: true });
                return;
            }

            if (xhr.status < 200 || xhr.status >= 300) {
                reject('HTTP Error: ' + xhr.status);
                return;
            }

            const json = JSON.parse(xhr.responseText);

            if (!json || typeof json.location != 'string') {
                reject('Invalid JSON: ' + xhr.responseText);
                return;
            }

            resolve(json.location);
        };

        xhr.onerror = () => {
            reject('Image upload failed due to a XHR Transport error. Code: ' + xhr.status);
        };

        const formData = new FormData();
        formData.append('file', blobInfo.blob(), blobInfo.filename());

        xhr.send(formData);
    });
    <?php $__currentLoopData = explode(',',$selectors); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

    tinymce.init({
        selector:"<?php echo e($value); ?>_container",
        plugins: 'preview importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media template codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap emoticons',
        editimage_cors_hosts: ['picsum.photos'],
        menubar: 'file edit view insert format tools table help',
        toolbar: 'undo redo | bold italic underline strikethrough | fontfamily fontsize blocks | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen  preview save print | insertfile image media template link anchor codesample | ltr rtl',
        autosave_ask_before_unload: true,
        autosave_interval: '30s',
        autosave_prefix: '{path}{query}-{id}-',
        autosave_restore_when_empty: false,
        autosave_retention: '2m',
        image_advtab: true,
        link_list: [
            { title: 'My page 1', value: 'https://www.tiny.cloud' },
            { title: 'My page 2', value: 'http://www.moxiecode.com' }
        ],
        image_list: [
            { title: 'My page 1', value: 'https://www.tiny.cloud' },
            { title: 'My page 2', value: 'http://www.moxiecode.com' }
        ],
        image_class_list: [
            { title: 'None', value: '' },
            { title: 'Some class', value: 'class-name' }
        ],
        importcss_append: true,
        file_picker_callback: function(callback, value, meta) {
            // Provide file and text for the link dialog
            if (meta.filetype == 'file') {
                callback('mypage.html', {text: 'My text'});
            }

            // Provide image and alt text for the image dialog
            if (meta.filetype == 'image') {
                callback('myimage.jpg', {alt: 'My alt text'});
            }

            // Provide alternative source and posted for the media dialog
            if (meta.filetype == 'media') {
                callback('movie.mp4', {source2: 'alt.ogg', poster: 'image.jpg'});
            }
        },
        images_upload_handler: example_image_upload_handler,
        video_template_callback: (data) =>
        `<iframe title="${data.title}" width="${data.width}" height="${data.height}" src="${data.source}"></iframe>`,
        templates: [
            { title: 'New Table', description: 'creates a new table', content: '<div class="mceTmpl"><table width="98%%"  border="0" cellspacing="0" cellpadding="0"><tr><th scope="col"> </th><th scope="col"> </th></tr><tr><td> </td><td> </td></tr></table></div>' },
            { title: 'Starting my story', description: 'A cure for writers block', content: 'Once upon a time...' },
            { title: 'New list with dates', description: 'New List with dates', content: '<div class="mceTmpl"><span class="cdate">cdate</span><br><span class="mdate">mdate</span><h2>My List</h2><ul><li></li><li></li></ul></div>' }
        ],
        template_cdate_format: '[Date Created (CDATE): %m/%d/%Y : %H:%M:%S]',
        template_mdate_format: '[Date Modified (MDATE): %m/%d/%Y : %H:%M:%S]',
        height: 600,
        image_caption: true,
        quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote',
        noneditable_class: 'mceNonEditable',
        toolbar_mode: 'sliding',
        contextmenu: 'link image table',
        skin: useDarkMode ? 'oxide-dark' : 'oxide',
        content_css:'default',
        content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:16px }',
        setup: function (editor) {
            editor.on('change', function () {
                <?php $__currentLoopData = explode(',',$selectors); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                var current_context = $.trim(tinyMCE.get('<?php echo e(ltrim($value,'.')); ?>_container').getContent());
                var current_context_text = $.trim(tinyMCE.get('<?php echo e(ltrim($value,'.')); ?>_container').getContent({format: 'text'}));
                if(current_context_text.length == 0) {
                    $('#<?php echo e(ltrim($value,'.')); ?>').html('');
                    $('#<?php echo e(ltrim($value,'.')); ?>').html( current_context_text);

                }else{
                    $('#<?php echo e(ltrim($value,'.')); ?>').html( current_context );
                }
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            });
        }
    });
   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
    
    
    

    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    

    
    
    
    

    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    

    
    
    
    
    
    
    

    
    
    
    

    

    
    
    
    

    
    


    

    
    
    
    
    

    
    
    

    
    
    
    
    
    
    
    



    
    
    
    
    
    
    
    

    
    
    
    
    
    
    
    
    
    
    
    
    
    

    
    
    

    
    

    
    
    
    

    

    
    
    
    

    
    

    
    

    
    

    
    
    
    

    
    
    
    
    
    
    

    
    

    
    
    
    
    
    
    
    
    
    
    
    

    
    
    
    
    

    
    

    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    



    
</script>
<?php $__currentLoopData = explode(',',$selectors); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="form-group col-lg-12">
        <label class=" control-label" for="<?php echo e(ltrim($value,'.')); ?>"><?php echo e($labels[$key]); ?>  <?php if(!$not_required): ?> <span class="required"> * </span> <?php endif; ?></label>
        <textarea class="form-control <?php echo e(ltrim($value,'.')); ?>_container" style="min-height: 300px;" id="<?php echo e(ltrim($value,'.')); ?>_container"  name="<?php echo e(ltrim($value,'.')); ?>_container" data-required="1" placeholder="<?php echo e(Lang::get('main.enter').$labels[$key]); ?>"><?php if(old(ltrim($value,'.'))): ?><?php echo e(old(ltrim($value,'.'))); ?><?php elseif(isset($posts)): ?><?php echo $posts[$key]; ?><?php endif; ?></textarea>
        <textarea class="form-control <?php echo e(ltrim($value,'.')); ?>" style="height: 0px; visibility: hidden;" id="<?php echo e(ltrim($value,'.')); ?>"  name="<?php echo e(ltrim($value,'.')); ?>" data-required="1" ><?php if(old(ltrim($value,'.'))): ?><?php echo e(old(ltrim($value,'.'))); ?><?php elseif(isset($posts)): ?><?php echo $posts[$key]; ?><?php endif; ?></textarea>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php /**PATH /home/ebacademy/public_html/e3melbusinessyottacourses.elbazdev.com/adminResources/resources/views/auth/description.blade.php ENDPATH**/ ?>