<?php $__env->startSection('pageTitle'); ?>
    <title><?php echo e(Lang::get('main.home_page_title')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('contentHeader'); ?>
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="<?php echo e(URL('/admin')); ?>"><?php echo e(Lang::get('main.dashboard')); ?></a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span><?php echo e(Lang::get('main.futurex_integration_courses')); ?></span>
            </li>
        </ul>

    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> <?php echo e(Lang::get('main.futurex_integration_courses')); ?>

        <small><?php echo e(Lang::get('main.view')); ?></small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<style>
    td {
        word-wrap: break-word;
        overflow-wrap: break-word;
    }
</style>

<div class="row">
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-users font-dark"></i>
                <span class="caption-subject bold uppercase"><?php echo e(Lang::get('main.futurex_integration_courses')); ?></span>
            </div>
            <div class="tools"></div>
        </div>
        <div class="portlet-body">

            <?php echo Form::open(['method'=>'PUT','url'=>'admin/futurex_integration/'.$course->id]); ?>

            <div class="form-group col-lg-12">
                <label class="control-label" for="name"><?php echo e(Lang::get('main.name')); ?></label>
                <input type="text" disabled class="form-control" value="<?php echo e($course->name); ?>" name="name" data-required="1"  placeholder="<?php echo e(Lang::get('main.enter').Lang::get('main.name')); ?>">
            </div>

            <div class="form-group col-lg-4">
                <label for="futurex_course_category_id"><?php echo e(Lang::get('main.futurex_course_category')); ?></label>
                <select id="futurex_course_category_id" name="futurex_course_category_id" style="width: 100%" class="sel2">
                    <?php $__currentLoopData = DB::connection('mysql2')->table('futurex_course_category')->pluck('name','id')->toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id=>$name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($id); ?>" <?php if($futurexCourse&&$futurexCourse->futurex_course_category_id == $id): ?> selected <?php endif; ?>>
                        <?php echo e($name); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form-group col-lg-4">
                <label for="futurex_course_level_id"><?php echo e(Lang::get('main.futurex_course_level')); ?></label>
                <select id="futurex_course_level_id" name="futurex_course_level_id" style="width: 100%" class="sel2">
                    <?php $__currentLoopData = DB::connection('mysql2')->table('futurex_course_level')->pluck('name','id')->toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id=>$name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php if($futurexCourse&&$futurexCourse->futurex_course_level_id == $id): ?> selected <?php endif; ?>>
                            <?php echo e($name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form-group col-lg-4">
                <label for="futurex_language_id"><?php echo e(Lang::get('main.futurex_language')); ?></label>
                <select id="futurex_language_id" name="futurex_language_id" style="width: 100%" class="sel2">
                    <?php $__currentLoopData = DB::connection('mysql2')->table('futurex_language')->pluck('name','id')->toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id=>$name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php if($futurexCourse&&$futurexCourse->futurex_language_id == $id): ?> selected <?php endif; ?>>
                            <?php echo e($name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form-group col-lg-12">
                <label for="futurex_skills_ids"><?php echo e(Lang::get('main.futurex_skills')); ?></label>
                <select id="futurex_skills_ids" multiple name="futurex_skills_ids[]" style="width: 100%" class="sel2">
                    <?php $__currentLoopData = DB::connection('mysql2')->table('futurex_skills')->pluck('name','id')->toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id=>$name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php if($futurexCourse&&is_array($futurexCourse->futurex_skills_ids)&&in_array($id,$futurexCourse->futurex_skills_ids)): ?> selected <?php endif; ?>>
                            <?php echo e($name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form-group col-lg-12">
                <label for="futurex_tags_ids"><?php echo e(Lang::get('main.futurex_tags')); ?></label>
                <select id="futurex_tags_ids" multiple name="futurex_tags_ids[]" style="width: 100%" class="">
                    <?php if($futurexCourse&&$futurexCourse->futurex_tags_ids): ?>
                        <?php $__currentLoopData = DB::connection('mysql2')->table('futurex_tags')->whereIn('id',$futurexCourse->futurex_tags_ids)->pluck('name','id')->toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id=>$name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($id); ?>" <?php if($futurexCourse&&is_array($futurexCourse->futurex_tags_ids)&&in_array($id,$futurexCourse->futurex_tags_ids)): ?> selected <?php endif; ?>>
                                <?php echo e($name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </select>
            </div>


            <div class="clearfix"></div>
            <div class="text-center col-lg-12">
                <button type="submit" class="btn green"><?php echo e(Lang::get('main.save')); ?></button>
            </div>
            <div class="clearfix"></div>
            <?php echo Form::close(); ?>


        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scriptCode'); ?>

    <script>
        $(document).ready(function () {
            var token = "<?php echo e(csrf_token()); ?>";
            $('#futurex_tags_ids').select2({
                ajax: {
                    url: '<?php echo e(request()->fullUrl()); ?>',
                    dataType: 'json'
                    // Additional AJAX parameters go here; see the end of this chapter for the full code of this example
                }
            })
            $(".menu-toggler.sidebar-toggler").trigger('click');
            $('.fromToDate').datepicker({
                rtl: App.isRTL(),
                autoclose: true
            });
            var grid = new Datatable();
            grid.setAjaxParam("_token", "<?php echo e(csrf_token()); ?>");
            // console.log(grid._token)
            grid.init({
                src: $("#datatable_ajax"),
                onSuccess: function (grid, response) {
                    // grid:        grid object
                    // response:    json object of server side ajax response
                    // execute some code after table records loaded
                },
                onError: function (grid) {
                    // execute some code on network or other general error
                },
                onDataLoad: function (grid) {
                },
                loadingMessage: '<?php echo e(Lang::get('main.loading')); ?>',
                dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options
                    // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                    // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                    // So when dropdowns used the scrollable div should be removed.
                    //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
                    "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                    "lengthMenu": [
                        [10, 20, 50, 100, 150, <?php if(PerUser('view_all_rows')): ?> -1 <?php endif; ?>],
                        [10, 20, 50, 100, 150, <?php if(PerUser('view_all_rows')): ?> "All" <?php endif; ?>] // change per page values here
                    ],
                    "pageLength": 10, // default record count per page
                    "ajax": {
                        "url": "<?php echo e(URL('admin/futurex_integration')); ?>", // ajax source
                    },
                    <?php if(getUserSystem('backend_lang')=='ar'): ?> "language": {"url": "<?php echo e(asset('assets/layouts/layout/datatables-arabic.json')); ?>"},<?php endif; ?> "columnDefs": [{
                        "targets": [0], // column or columns numbers
                        "orderable": true  // set orderable for selected columns

                    }],
                    "order": [
                        [0, "desc"]
                    ],// set first column as a default sort by asc
                    dom: 'Blfrtip',
                    buttons: [
                        {extend: 'print', className: 'btn dark btn-outline'},
                        {extend: 'pdf', className: 'btn green btn-outline'},
                        {extend: 'csv', className: 'btn purple btn-outline '}
                    ],
                }
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('auth.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ebacademy/public_html/e3melbusiness.org/adminResources/resources/views/auth/futurex_integration_courses/edit.blade.php ENDPATH**/ ?>