<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html <?php if(app('request')->input('lang')=='ar'): ?> dir="rtl" <?php endif; ?>>
<!--<![endif]-->
<!-- BEGIN HEAD -->
<head>
    <meta charset="utf-8" />
    <?php echo $__env->yieldContent('pageTitle'); ?>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="" name="description" />
    <meta content="" name="author" />
    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <link href="<?php echo e(asset('assets/global/plugins/font-awesome/css/font-awesome.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/global/plugins/simple-line-icons/simple-line-icons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <?php if(app('request')->input('lang')=='ar'): ?>
        <link href="<?php echo e(asset('assets/layouts/layout/css/bootstrap.rtl.min.css')); ?>" rel="stylesheet" type="text/css" />
    <?php else: ?>
        <link href="<?php echo e(asset('assets/global/plugins/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <?php endif; ?>
    <link href="<?php echo e(asset('assets/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- END GLOBAL MANDATORY STYLES -->
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="<?php echo e(asset('assets/global/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/global/plugins/select2/css/select2-bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN THEME GLOBAL STYLES -->
    <link href="<?php echo e(asset('assets/global/css/components.min.css')); ?>" rel="stylesheet" id="style_components" type="text/css" />
    <?php if(app('request')->input('lang')=='ar'): ?>
        <link href="https://fonts.googleapis.com/css?family=Cairo&display=swap" rel="stylesheet">
        <link href="<?php echo e(asset('assets/layouts/layout/css/ar.css')); ?>" rel="stylesheet" type="text/css" />
    <?php else: ?>
        <link href="https://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />
    <?php endif; ?>
    <link href="" rel="stylesheet" type="text/css" />
    <!-- END THEME GLOBAL STYLES -->
    <!-- BEGIN PAGE LEVEL STYLES -->
    <link href="<?php echo e(asset('assets/pages/css/login.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- END PAGE LEVEL STYLES -->
    <!-- BEGIN THEME LAYOUT STYLES -->
    <!-- END THEME LAYOUT STYLES -->
    <link rel="shortcut icon" href="<?php echo e(asset('fav.png')); ?>" type="image/x-icon" /> </head>
<!-- END HEAD -->
<body class=" login">
<!-- BEGIN LOGO -->
<div class="logo">
    <a href="<?php echo e(URL('/')); ?>">
        <img src="<?php echo e(asset('img/logo-big.png')); ?>" alt="" /> </a>
</div>
<!-- END LOGO -->
<!-- BEGIN LOGIN -->
<div class="content">
    <!-- BEGIN LOGIN FORM -->
    <form class="login-form" action="<?php echo e(route('login')); ?>" method="post">
        <?php echo e(csrf_field()); ?>

        <h3 class="form-title font-green"><?php if(app('request')->input('lang')=='ar'): ?> تسجيل الدخول <?php else: ?> Sign in <?php endif; ?> </h3>
        <div class="alert alert-danger display-hide">
            <button class="close" data-close="alert"></button>
            <span> <?php if(app('request')->input('lang')=='ar'): ?> أدخل إسم المستخدم وكلمة المرور. <?php else: ?> Enter any username and password. <?php endif; ?> </span>
        </div>
        <div class="form-group <?php echo e($errors->has('username') ? ' has-error' : ''); ?>">
            <!--ie8, ie9 does not support html5 placeholder, so we just show field title for that-->
            <label class="control-label visible-ie8 visible-ie9"><?php if(app('request')->input('lang')=='ar'): ?> إسم المستخدم <?php else: ?> Username <?php endif; ?></label>
            <input class="form-control form-control-solid placeholder-no-fix" type="text" autocomplete="off" placeholder="<?php if(app('request')->input('lang')=='ar'): ?> إسم المستخدم <?php else: ?> Username <?php endif; ?>" name="username" />
            <?php if($errors->has('username')): ?>
                <span class="help-block">
                        <strong><?php echo e($errors->first('username')); ?></strong>
                    </span>
            <?php endif; ?>
        </div>
        <div class="form-group<?php echo e($errors->has('password') ? ' has-error' : ''); ?>">
            <label class="control-label visible-ie8 visible-ie9"><?php echo e(Lang::get('main.password')); ?></label>
            <input class="form-control form-control-solid placeholder-no-fix" type="password" autocomplete="off" placeholder="<?php if(app('request')->input('lang')=='ar'): ?> كلمة المرور<?php else: ?> Password <?php endif; ?>" name="password" />
            <?php if($errors->has('password')): ?>
                <span class="help-block">
                        <strong><?php echo e($errors->first('password')); ?></strong>
                    </span>
            <?php endif; ?>
        </div>
        <div class="form-actions">
            <button type="submit" class="btn green uppercase"><?php if(app('request')->input('lang')=='ar'): ?> تسجيل الدخول <?php else: ?> Login <?php endif; ?></button>
            <label class="rememberme check mt-checkbox mt-checkbox-outline">
                <input type="checkbox" name="remember" <?php echo e(old('remember') ? 'checked' : ''); ?> value="1" /><?php if(app('request')->input('lang')=='ar'): ?> تذكر <?php else: ?> Remember <?php endif; ?>
                <span></span>
            </label>
            <a href="javascript:;" id="forget-password" class="forget-password"><?php if(app('request')->input('lang')=='ar'): ?> نسيت كلمة المرور؟ <?php else: ?> Forgot Password? <?php endif; ?></a>
        </div>
    </form>
    <!-- END LOGIN FORM -->
    <!-- BEGIN FORGOT PASSWORD FORM -->
    <form class="forget-form" action="index.html" method="post">
        <h3 class="font-green"><?php if(app('request')->input('lang')=='ar'): ?> نسيت كلمة المرور؟ <?php else: ?> Forgot Password? <?php endif; ?></h3>
        <p> <?php if(app('request')->input('lang')=='ar'): ?> أدخل بريدك الإلكتروني بالأسفل لإعادة تعيين كلمة المرور <?php else: ?> Enter your e-mail address below to reset your password. <?php endif; ?> </p>
        <div class="form-group">
            <input class="form-control placeholder-no-fix" type="text" autocomplete="off" placeholder="<?php if(app('request')->input('lang')=='ar'): ?> البريد الإلكتروني <?php else: ?> Email <?php endif; ?>" name="email" /> </div>
        <div class="form-actions">
            <button type="button" id="back-btn" class="btn green btn-outline"><?php if(app('request')->input('lang')=='ar'): ?> رجوع <?php else: ?> Back <?php endif; ?></button>
            <button type="submit" class="btn btn-success uppercase pull-right"><?php if(app('request')->input('lang')=='ar'): ?> ادخال <?php else: ?> Submit <?php endif; ?></button>
        </div>
    </form>
    <!-- END FORGOT PASSWORD FORM -->
</div>
<div class="copyright"> 2014 ©  </div>
<!--[if lt IE 9]>
<script src="<?php echo e(asset('assets/global/plugins/respond.min.js')); ?>"></script>

<![endif]-->
<!-- BEGIN CORE PLUGINS -->
<script src="<?php echo e(asset('assets/global/plugins/jquery.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/global/plugins/bootstrap/js/bootstrap.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/global/plugins/js.cookie.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/global/plugins/jquery-slimscroll/jquery.slimscroll.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/global/plugins/jquery.blockui.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js')); ?>" type="text/javascript"></script>
<!-- END CORE PLUGINS -->
<!-- BEGIN PAGE LEVEL PLUGINS -->
<script src="<?php echo e(asset('assets/global/plugins/jquery-validation/js/jquery.validate.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/global/plugins/jquery-validation/js/additional-methods.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/global/plugins/select2/js/select2.full.min.js')); ?>" type="text/javascript"></script>
<!-- END PAGE LEVEL PLUGINS -->
<!-- BEGIN THEME GLOBAL SCRIPTS -->
<script src="<?php echo e(asset('assets/global/scripts/app.min.js')); ?>" type="text/javascript"></script>
<!-- END THEME GLOBAL SCRIPTS -->
<!-- BEGIN PAGE LEVEL SCRIPTS -->
<script src="<?php echo e(asset('assets/pages/scripts/login.min.js')); ?>" type="text/javascript"></script>
<!-- END PAGE LEVEL SCRIPTS -->
<!-- BEGIN THEME LAYOUT SCRIPTS -->
<!-- END THEME LAYOUT SCRIPTS -->
</body>
</html>
<?php /**PATH /home/ebacademy/public_html/e3melbusinessyottacourses.elbazdev.com/adminResources/resources/views/auth/layouts/app_login.blade.php ENDPATH**/ ?>