
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/suggestion_courses_conditions') }}">{{ Lang::get('main.suggestion_courses_conditions') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.suggestion_courses_conditions') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')
    <style>
        .form-group{
            margin-left: 0px !important;
            margin-right: 0px !important;
        }
    </style>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.suggestion_courses_conditions') }}</span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>'admin/suggestion_courses_conditions','id'=>'addNewsForm','class'=>"form-horizontal",'files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div id="messages"></div>
                    <div class="form-group col-lg-6">
                        <label class="control-label" for="priority">{{ Lang::get('main.if_this') }} <span class="label label-info">لو ظهر</span> <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            @php($array=old('if_this'))
                            <select name="if_this[]" id="if_this" class="select2" data-placeholder="Select Subscription" style="width:100%;" multiple="" >
                                <option @if(is_array($array)&&in_array('AnnualSubscription',$array))   selected="selected" @endif value="AnnualSubscription">Annual Subscription</option>
                                <option @if(is_array($array)&&in_array('MBA',$array))  selected="selected" @endif value="MBA">الماجستير المهني لإدارة الأعمال الاونلاين – MBA</option>
                                <option @if(is_array($array)&&in_array('DBA',$array)) selected="selected" @endif value="DBA">{{ $name }}</option>
                                @foreach(\App\Models\Diplomas::where('published','yes')->pluck('name','id')->toArray() as $id=>$name)
                                    <option @if(is_array($array)&&in_array('diplomas_'.$id,$array)) selected="selected" @endif value="diplomas_{{ $id }}">{{ $name }}</option>
                                @endforeach
                                @foreach(\App\Models\TrainingProgram::where('published','yes')->pluck('name','id')->toArray() as $id=>$name)
                                    <option @if(is_array($array)&&in_array('training_programs_'.$id,$array)) selected="selected" @endif value="training_programs_{{ $id }}">{{ $name }}</option>
                                @endforeach
                                @foreach(\App\Models\Courses::where('published','yes')->pluck('name','id')->toArray() as $id=>$name)
                                    <option @if(is_array($array)&&in_array('courses_'.$id,$array)) selected="selected" @endif value="courses_{{ $id }}">كورس - {{ $name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="form-group col-lg-6">
                        <label class="control-label" for="show_this">{{ Lang::get('main.show_this') }} <span class="label label-info">يظهر</span><span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            @php($array=old('show_this'))
                            <select name="show_this[]" id="show_this" class="select2" data-placeholder="Select Subscription" style="width:100%;" multiple="" >
                                <option @if(is_array($array)&&in_array('AnnualSubscription',$array))   selected="selected" @endif value="AnnualSubscription">Annual Subscription</option>
                                <option @if(is_array($array)&&in_array('MBA',$array))  selected="selected" @endif value="MBA">الماجستير المهني لإدارة الأعمال الاونلاين – MBA</option>
                                <option @if(is_array($array)&&in_array('DBA',$array)) selected="selected" @endif value="DBA">الدكتوراة المهنية لإدارة الأعمال الأونلاين – DBA</option>
                                @foreach(\App\Models\Diplomas::where('published','yes')->pluck('name','id')->toArray() as $id=>$name)
                                    <option @if(is_array($array)&&in_array('diplomas_'.$id,$array)) selected="selected" @endif value="diplomas_{{ $id }}">{{ $name }}</option>
                                @endforeach
                                @foreach(\App\Models\TrainingProgram::where('published','yes')->pluck('name','id')->toArray() as $id=>$name)
                                    <option @if(is_array($array)&&in_array('training_programs_'.$id,$array)) selected="selected" @endif value="training_programs_{{ $id }}">{{ $name }}</option>
                                @endforeach
                                @foreach(\App\Models\Courses::where('published','yes')->pluck('name','id')->toArray() as $id=>$name)
                                    <option @if(is_array($array)&&in_array('courses_'.$id,$array)) selected="selected" @endif value="courses_{{ $id }}">كورس - {{ $name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-lg-12">
                        <label class="control-label" for="priority">{{ Lang::get('main.priority') }} <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="number" class="form-control" value="{{old('priority')?old('priority'):\App\Models\SuggestionCoursesConditions::max('priority')+1}}" id="priority" name="priority" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.priority') }}">
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <div class="text-center col-lg-12">
                        <button type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>


                <div class="clearfix"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function () {
            $('.fromToDate').datepicker({
                rtl: App.isRTL(),
                autoclose: true,
                orientation:"bottom"
            });
        });

        $("#selectbtn-tag").click(function(){
            $("#selectall-tag > option").prop("selected","selected");
            $("#selectall-tag").trigger("change");
        });
        $("#deselectbtn-tag").click(function(){
            $("#selectall-tag > option").prop("selected","");
            $("#selectall-tag").trigger("change");
        });

        $(document).ready(function () {
            $('.select2').select2();
        });

    </script>
@endsection
