
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
    <link rel="stylesheet" type="text/css" href="{{ asset('css/notify.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('css/prettify.css') }}">
    <style>
        /**
 * Nestable
 */

        .dd { position: relative; display: block; margin: 0; padding: 0; max-width: 600px; list-style: none; font-size: 13px; line-height: 20px; }

        .dd-list { display: block; position: relative; margin: 0; padding: 0; list-style: none; }
        .dd-list .dd-list { padding-left: 30px; }
        .dd-collapsed .dd-list { display: none; }

        .dd-item,
        .dd-empty,
        .dd-placeholder { display: block; position: relative; margin: 0; padding: 0; min-height: 20px; font-size: 13px; line-height: 20px; }

        .dd-handle { display: block; height: 30px; margin: 5px 0; padding: 5px 10px; color: #333; text-decoration: none; font-weight: bold; border: 1px solid #ccc;
            background: #fafafa;
            background: -webkit-linear-gradient(top, #fafafa 0%, #eee 100%);
            background:    -moz-linear-gradient(top, #fafafa 0%, #eee 100%);
            background:         linear-gradient(top, #fafafa 0%, #eee 100%);
            -webkit-border-radius: 3px;
            border-radius: 3px;
            box-sizing: border-box; -moz-box-sizing: border-box;
        }
        .dd-handle:hover { color: #2ea8e5; background: #fff; }

        .dd-item > button { display: block; position: relative; cursor: pointer; float: left; width: 25px; height: 20px; margin: 5px 0; padding: 0; text-indent: 100%; white-space: nowrap; overflow: hidden; border: 0; background: transparent; font-size: 12px; line-height: 1; text-align: center; font-weight: bold; }
        .dd-item > button:before { content: '+'; display: block; position: absolute; width: 100%; text-align: center; text-indent: 0; }
        .dd-item > button[data-action="collapse"]:before { content: '-'; }

        .dd-placeholder,
        .dd-empty { margin: 5px 0; padding: 0; min-height: 30px; background: #f2fbff; border: 1px dashed #b6bcbf; box-sizing: border-box; -moz-box-sizing: border-box; }
        .dd-empty { border: 1px dashed #bbb; min-height: 100px; background-color: #e5e5e5;
            background-image: -webkit-linear-gradient(45deg, #fff 25%, transparent 25%, transparent 75%, #fff 75%, #fff),
            -webkit-linear-gradient(45deg, #fff 25%, transparent 25%, transparent 75%, #fff 75%, #fff);
            background-image:    -moz-linear-gradient(45deg, #fff 25%, transparent 25%, transparent 75%, #fff 75%, #fff),
            -moz-linear-gradient(45deg, #fff 25%, transparent 25%, transparent 75%, #fff 75%, #fff);
            background-image:         linear-gradient(45deg, #fff 25%, transparent 25%, transparent 75%, #fff 75%, #fff),
            linear-gradient(45deg, #fff 25%, transparent 25%, transparent 75%, #fff 75%, #fff);
            background-size: 60px 60px;
            background-position: 0 0, 30px 30px;
        }

        .dd-dragel { position: absolute; pointer-events: none; z-index: 9999; }
        .dd-dragel > .dd-item .dd-handle { margin-top: 0; }
        .dd-dragel .dd-handle {
            -webkit-box-shadow: 2px 4px 6px 0 rgba(0,0,0,.1);
            box-shadow: 2px 4px 6px 0 rgba(0,0,0,.1);
        }

        /**
         * Nestable Extras
         */

        .nestable-lists { display: block; clear: both; padding: 30px 0; width: 100%; border: 0; border-top: 2px solid #ddd; border-bottom: 2px solid #ddd; }

        #nestable-menu { padding: 0; margin: 20px 0; }

        #nestable-output,
        #nestable2-output { width: 100%; height: 7em; font-size: 0.75em; line-height: 1.333333em; font-family: Consolas, monospace; padding: 5px; box-sizing: border-box; -moz-box-sizing: border-box; }

        #nestable2 .dd-handle {
            color: #fff;
            border: 1px solid #999;
            background: #bbb;
            background: -webkit-linear-gradient(top, #bbb 0%, #999 100%);
            background:    -moz-linear-gradient(top, #bbb 0%, #999 100%);
            background:         linear-gradient(top, #bbb 0%, #999 100%);
        }
        #nestable2 .dd-handle:hover { background: #bbb; }
        #nestable2 .dd-item > button:before { color: #fff; }

        @media only screen and (min-width: 700px) {

            .dd { float: left; width: 100%; }
            .dd + .dd { margin-left: 2%; }

        }

        .dd-hover > .dd-handle { background: #2ea8e5 !important; }

        /**
         * Nestable Draggable Handles
         */

        .dd3-content { display: block; height: 30px; margin: 5px 0; padding: 5px 10px 5px 40px; color: #333; text-decoration: none; font-weight: bold; border: 1px solid #ccc;
            background: #fafafa;
            background: -webkit-linear-gradient(top, #fafafa 0%, #eee 100%);
            background:    -moz-linear-gradient(top, #fafafa 0%, #eee 100%);
            background:         linear-gradient(top, #fafafa 0%, #eee 100%);
            -webkit-border-radius: 3px;
            border-radius: 3px;
            box-sizing: border-box; -moz-box-sizing: border-box;
        }
        .dd3-content:hover { color: #2ea8e5; background: #fff; }

        .dd-dragel > .dd3-item > .dd3-content { margin: 0; }

        .dd3-item > button { margin-left: 30px; }

        .dd3-handle { position: absolute; margin: 0; left: 0; top: 0; cursor: pointer; width: 30px; text-indent: 100%; white-space: nowrap; overflow: hidden;
            border: 1px solid #aaa;
            background: #ddd;
            background: -webkit-linear-gradient(top, #ddd 0%, #bbb 100%);
            background:    -moz-linear-gradient(top, #ddd 0%, #bbb 100%);
            background:         linear-gradient(top, #ddd 0%, #bbb 100%);
            border-top-right-radius: 0;
            border-bottom-right-radius: 0;
        }
        .dd3-handle:before { content: '≡'; display: block; position: absolute; left: 0; top: 3px; width: 100%; text-align: center; text-indent: 0; color: #fff; font-size: 20px; font-weight: normal; }
        .dd3-handle:hover { background: #ddd; }













        .option-item .input-group-addon button{
            padding: 5px;
            font-size: 10px;
            height: 32px;
        }
        .loading {
            position: relative;
        }
        .loading::after {
            position: absolute;
            background: center 1.7857142857rem no-repeat rgba(255, 255, 255, .5);
            background-image: url('{{ asset('loading.gif') }}');
            background-repeat: no-repeat;
            background-position: center center;
            background-color: rgba(250, 250, 250, .8);
            background-size: 1.7857142857rem auto;
        }
        .loading::after {
            display: block!important;
            width: 100%;
            height: 100%;
            left: 0;
            top: 0;
            z-index: 148;
            content: ' '!important;
            line-height: 0;
        }
    </style>

@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/suggestion_courses') }}">{{ Lang::get('main.suggestion_courses') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>

    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.suggestion_courses') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')
    <div class="row">
        <div class="portlet light bordered col-lg-6">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">Add New Questions</span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body" style="min-height: 350px">
                <div class="form-group">
                    <label for="suggestionCourseQuestionType">Type</label>
                    <div class="input-group">
                        <select name="type" class="sel2" style="width: 100%" id="suggestionCourseQuestionType">
                            @foreach(getEnumFiledFromTable('suggestion_courses_questions','type') as $type)
                                <option value="{{ $type }}">{{ ucfirst(str_replace('_',' ',$type)) }}</option>
                            @endforeach
                        </select>
                        <span class="input-group-addon" style="padding: 0;">
                            <button class="btn btn-success addNewQuestion"><i class="fa fa-plus"></i></button>
                        </span>
                    </div>

                </div>
                <div class="form-body" id="formToAdd">
                </div>
            </div>
        </div>
        <div class="portlet light bordered col-lg-6">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">All Questions</span>
                </div>
                <div id="orderElement" class="pull-right">
                    <button class="btn btn-success btn-show-order pull-right"><i class="fa fa-bars"></i> Order</button>
                </div>


                <div class="tools"></div>
            </div>
            <div class="portlet-body" id="questionsContent" style="min-height: 350px;max-height: 350px;overflow-y: auto">

        </div>

    </div>
@endsection
@section('scriptCode')
    <script src="{{ asset('js/notify.js?v=1') }}"></script>
    <script src="{{ asset('js/prettify.js?v=1') }}"></script>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Nestable/2012-10-15/jquery.nestable.min.js" integrity="sha512-a3kqAaSAbp2ymx5/Kt3+GL+lnJ8lFrh2ax/norvlahyx59Ru/1dOwN1s9pbWEz1fRHbOd/gba80hkXxKPNe6fg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        let htmlSaveAndClose='<button class="btn btn-success btn-save-close"><i class="fa fa-save"></i> Save & Close</button><button style="margin-left: 5px;" class="btn btn-success btn-close"><i class="fa fa-close"></i> Close</button>';
        let htmlOrder='<button class="btn btn-success btn-show-order"><i class="fa fa-bars"></i> Order</button>';

            $(document).on('click','.btn-show-order',function(){
                getQuestions('show_order');
                $("#orderElement").html(htmlSaveAndClose);
            });
            $(document).on('click','.btn-save-close',function(){
                let el =$(this);
                el.attr('disabled','disabled').addClass('loading');
                $.ajax({
                    type: "POST",
                    url: "{{ request()->fullUrl() }}",
                    data: {data:window.JSON.stringify($("#nestable").nestable('serialize'))},
                    success: function (data) {
                        if(data.success){
                            getQuestions();
                            $("#orderElement").html(htmlOrder);
                        }
                    }
                });
            });
            $(document).on('click','.btn-close',function(){
                getQuestions();
                $("#orderElement").html(htmlOrder);
            });

            $(document).ready(function(){
                $(".menu-toggler.sidebar-toggler").trigger('click');
            });
            function makeOptionsIds(){
                x=0;
                $("#suggestionCourseQuestionForm .option-item [name=\"answers[]\"]").each(function(){
                    $(this).attr('id','answers-'+x);
                    $(this).parent().parent().parent().find('.select2_courses_ids').attr('name','courses_ids['+x+'][]')
                    x++;
                });
                $(".select2_courses_ids").select2();
            }

            function getQuestions(type){
                let element=$("#questionsContent");
                element.addClass('loading');
                $.ajax({
                    type: "GET",
                    url: "{{ request()->fullUrl() }}",
                    data: {type},
                    success: function (data) {
                        element.html(data.html).removeClass('loading');
                        if(type=='show_order'){
                            $('.dd').nestable({ /* config options */ });
                        }


                    }
                })

            }
            getQuestions();

            let answerInputHtml='<div class="clearfix"></div><div class="form-group option-item"><div class="form-group col-lg-6"><label id="courses_ids">Courses</label><select name="courses_ids[]" id="courses_ids" class="select2_courses_ids" data-placeholder="Select Courses" style="width:100%;" multiple>@foreach(\App\Models\Diplomas::where('published','yes')->pluck('name','id')->toArray() as $id=>$name)<option value="diplomas_{{ $id }}">{{ $name }}</option>@endforeach<option value="mba_1">الماجستير المهني لإدارة الأعمال الاونلاين – MBA</option>@foreach(\App\Models\DBA::pluck('name','id')->toArray() as $id=>$name)<option value="dba_{{ $id }}">{{ $name }}</option>@endforeach<option value="annual_subscription_1">Annual Subscription </option>@foreach(\App\Models\Courses::where('published','yes')->pluck('name','id')->toArray() as $id=>$name)<option value="courses_{{ $id }}">كورس - {{ $name }}</option>@endforeach</select></div><div class="form-group col-lg-6"><label>Answer of Questions</label><div class="input-group"> <input type="text" name="answers[]" class="form-control"/> <span class="input-group-addon" style="padding: 0;"><button type="button" class="btn btn-danger remove-option" data-toggle="tooltip" data-placement="top" title="Remove"><i class="fa fa-trash"></i></button><button type="button" class="btn btn-success append-option" data-append="before" data-toggle="tooltip" data-placement="top" title="Add Before"><i class="fa fa-arrow-left"></i></button><button type="button" class="btn btn-success append-option" data-append="after" data-toggle="tooltip" data-placement="top" title="Add After"><i class="fa fa-arrow-right"></i></button></div></div></div></div><div class="clearfix"></div>';
            $(document).on('click','.addNewQuestion',function(){
                let type=$("#suggestionCourseQuestionType").val();
                html='<form id="suggestionCourseQuestionForm" class="row"><input type="hidden" name="type" value="'+type+'"><div class="form-group col-lg-12"><label for="name">Name</label><input type="text" name="name" id="name" class="form-control"/></div>';
                if(!['text','textarea'].includes(type)){
                    html+=answerInputHtml;
                    html+=answerInputHtml;
                }
                html+='<div class="clearfix"></div><div class="text-center"><button style="margin-left: 5px;margin-right: 5px;" type="button" class="btn btn-success submitSuggestionCourseQuestionForm" data-type="add_close">Add & Close</button><button style="margin-left: 5px;margin-right: 5px;" type="button" class="btn btn-success submitSuggestionCourseQuestionForm"  data-type="add_continue">Add & Continue</button></div></form>';
                $("#formToAdd").html(html);
                makeOptionsIds();
                $('[data-toggle="tooltip"]').tooltip()
            });
            $(document).on('click','.remove-option',function(){
                if($("#suggestionCourseQuestionForm .option-item").length>2){
                    $(this).parent().parent().parent().parent().remove();
                    makeOptionsIds();
                }else{
                    $.notify('Options must be 2 or more', {blur: 0.2, delay: 0,close: true,color: "#fff", background: "#D44950",animationType:"drop"});
                }
            });
            $(document).on('click','.append-option',function(){
                let type=$(this).attr('data-append');
                if(type=='after'){
                    $(answerInputHtml).insertAfter($(this).parent().parent().parent().parent());
                }else{
                    $(answerInputHtml).insertBefore($(this).parent().parent().parent().parent());
                }
                $('[data-toggle="tooltip"]').tooltip()
                makeOptionsIds();
            });


            $(document).on('click','.submitSuggestionCourseQuestionForm',function(){
                let type=$(this).attr('data-type');
                $(".submitSuggestionCourseQuestionForm").addClass('loading').attr('disabled','disabled');
                let form=$("#suggestionCourseQuestionForm")[0];
                let formData=new FormData(form);
                $.ajax({
                    type: "POST",
                    url: "{{ URL('admin/suggestion_courses') }}",
                    data: formData,
                    contentType: false,
                    processData: false,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function (msg) {
                        $.notify(msg.message, {blur: 0.2, delay: 0,close: true,color: "#fff", background: msg.success?"#20D67B":"#D44950",animationType:"drop"});
                        if(msg.success){
                            form.reset();
                            if(type=='add_close'){
                                $("#formToAdd").html('');
                            }
                            $("#suggestionCourseQuestionForm").find('.has-error').removeClass('has-error');
                            $("#suggestionCourseQuestionForm").find('input').each(function(){
                                let id=$(this).attr('id');
                                $("#error-"+id).remove();
                            })
                            $('.select2_courses_ids').trigger('change');
                            getQuestions();
                        }
                        if(msg.messages){
                           for(let key in msg.messages){
                               let element;
                               $("#error-"+key).remove();
                               if(key.includes('answers')){
                                   let myArray=key.split(".")
                                   let newKey=myArray.join('-');
                                   element=$("#"+newKey).parent().parent();
                               }else{
                                   element=$("#"+key).parent();
                               }
                               element.addClass('has-error').append('<span id="error-'+key+'" class="help-block">'+msg.messages[key][0]+'</span>');
                           }
                        }
                        $(".submitSuggestionCourseQuestionForm").removeClass('loading').removeAttr('disabled');
                    }
                });
            });
            $(document).on('click','.remove_question',function(){
                let deleted_id=$(this).parent().parent().attr('data-id');
                Swal.fire({
                    title: 'Do you really want to delete this?',
                    showCancelButton: true,
                    confirmButtonText: '{{ __('Yes') }}',
                    cancelButtonText: '{{ __('No') }}',
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            type: "DELETE",
                            url: "{{ URL('admin/suggestion_courses') }}/"+deleted_id,
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            success: function (msg) {
                                if(msg.success){
                                    $("#question_"+deleted_id).remove();
                                }
                                $.notify(msg.message, {blur: 0.2, delay: 0,close: true,color: "#fff", background: msg.success?"#20D67B":"#D44950",animationType:"drop"});
                                if(!$(".question-object").length){
                                    $("#questionsContent").html(' <div class="alert alert-info">No questions added</div>')
                                }
                            }
                        });
                    }
                });

            });
            $(document).on('click','.edit_question',function(){
                let button =$(this);
                button.attr('disabled','disabled').addClass('loading');
                let item_id=$(this).parent().parent().attr('data-id');
                $.ajax({
                    type: "GET",
                    url: "{{ URL('admin/suggestion_courses') }}/"+item_id,
                    success: function (msg) {
                        if(!msg.success){
                            $.notify(msg.message, {blur: 0.2, delay: 0,close: true,color: "#fff", background: msg.success?"#20D67B":"#D44950",animationType:"drop"});
                        }
                        $("#formToAdd").html(msg.html);
                        makeOptionsIds();
                        button.removeAttr('disabled').removeClass('loading');
                        $('[data-toggle="tooltip"]').tooltip();
                    }
                });
            })

    </script>
@endsection
