
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.rating') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.rating') }}
        <small>{{ Lang::get('main.view') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')
    <style>
        td {
            word-wrap: break-word;
            overflow-wrap: break-word;
        }
    </style>
    @if(PerUser('courses_rating_export'))
        <div class="row">
            <form action="{{ URL('admin/new_courses_rating_export') }}" >
                <div class="col-md-12">

                    <div class="btn-group pull-right">
                        <input type="hidden" id="form2_id" name="id"value="">
                        <input type="hidden" id="form2_user_id" name="user_id"value="">
                        <input type="hidden" id="form2_user_email" name="user_email"value="">
                        <input type="hidden" id="form2_course" name="course"value="">
                        <input type="hidden" id="form2_instructor" name="instructor"value="">
                        <input type="hidden" id="form2_rating_question1" name="rating_question1"value="">
                        <input type="hidden" id="form2_rating_sub1_question1" name="rating_sub1_question1"value="">
                        <input type="hidden" id="form2_rating_sub2_question1" name="rating_sub2_question1"value="">
                        <input type="hidden" id="form2_rating_question4" name="rating_question4"value="">
                        <input type="hidden" id="form2_rating_question2" name="rating_question2"value="">
                        <input type="hidden" id="form2_rating_question3" name="rating_question3"value="">
                        <input type="hidden" id="form2_rating_sub1_question2" name="rating_sub1_question2"value="">
                        <input type="hidden" id="form2_rating_sub1_question4" name="rating_sub1_question4"value="">
                        <input type="hidden" id="form2_rating_sub2_question4" name="rating_sub2_question4"value="">
                        <input type="hidden" name="created_time_from" id="form2_created_time_from"  value="">
                        <input type="hidden" name="created_time_to" id="form2_created_time_to"  value="">

                        <button type="submit" href="{{ URL('admin/new_courses_rating_export') }}" id="sample_editable_1_new" class="btn btn-primary blue">
                            {{ Lang::get('main.export') }}
                        </button>
                    </div>
                </div>
            </form>
        </div>
    @endif

    @if(PerUser('courses_rating_view'))
        <div class="row">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-users font-dark"></i>
                        <span class="caption-subject bold uppercase">{{ Lang::get('main.rating') }}</span>
                    </div>
                    <div class="tools"></div>
                </div>
                <div class="portlet-body">
                    <table style=" table-layout: fixed;width: 100%;" class="table table-striped table-bordered table-hover table-checkable" width="100%"
                           id="datatable_ajax">
                        <thead>
                        <tr role="row" class="heading">
                            <th width="5%"> #</th>
                            <th>{{ Lang::get('main.user_id') }}</th>
                            <th>{{ Lang::get('main.email') }}</th>
                            <th>{{ Lang::get('main.course') }}</th>
                            <th>{{ Lang::get('main.instructor') }}</th>
                            <th>تقييمك للمحاضر ؟</th>
                            <th>تقييمك لأسلوب المحاضر ؟</th>
                            <th>تقييمك عن مستواه العلمى ؟</th>
                            <th>تقييمك للكورس بشكل عام ؟</th>
                            <th>تقييمك للماده العلميه ؟</th>
                            <th>تقييمك عن جودة التصوير ؟</th>
                            <th>تقييمك لخدمة العملاء بشكل عام ؟</th>
                            <th>تقييمك لأداء الموقع ؟</th>
                            <th>تقييمك لأداء التطبيق ؟</th>
                            <th>{{ Lang::get('main.rating') }}</th>
                            <th>{{ Lang::get('main.comment') }}</th>
                            <th>{{ Lang::get('main.create_date') }}</th>
                            <th></th>
                        </tr>
                        <tr role="row" class="filter">
                            <td>
                                <input type="hidden" id="_token" name="_token" value="{{ csrf_token() }}">
                                <input type="number" min="1" class="form-control form-filter input-sm" name="id">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" id="form_user_id" name="user_id">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" id="form_user_email" name="user_email">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" id="form_course" name="course">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" id="form_instructor" name="instructor">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" id="form_rating_question1" name="rating_question1">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" id="form_rating_sub1_question1" name="rating_sub1_question1">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm"  id="form_rating_sub2_question1" name="rating_sub2_question1">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" id="form_rating_question4" name="rating_question4">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" id="form_rating_question2" name="rating_question2">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" id="form_rating_question3" name="rating_question3">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" id="form_rating_sub1_question2" name="rating_sub1_question2">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" id="form_rating_sub1_question4" name="rating_sub1_question4">
                            </td> <td>
                                <input type="text" class="form-control form-filter input-sm" id="form_rating_sub2_question4" name="rating_sub2_question4">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" id="form_rating" name="rating">
                            </td>
                            <td>
                                <input type="text" class="form-control form-filter input-sm" id="form_comment" name="comment">
                            </td>
                            <td>
                                <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                                    <input type="text" class="form-control form-filter input-sm" readonly id="form_created_time_from"
                                           name="created_time_from" placeholder="{{ Lang::get('main.from') }}">
                                    <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                </div>
                                <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                                    <input type="text" class="form-control form-filter input-sm" readonly id="form_created_time_to"
                                           name="created_time_to" placeholder="{{ Lang::get('main.to') }}">
                                    <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                </div>
                            </td>

                            <td>
                                <div class="margin-bottom-5">
                                    <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                        <i class="fa fa-search"></i> {{ Lang::get('main.search') }}</button>
                                </div>
                                <button class="btn btn-sm red btn-outline filter-cancel">
                                    <i class="fa fa-times"></i> {{ Lang::get('main.reset') }}</button>
                            </td>

                        </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        </div>
    @endif
@endsection
@section('scriptCode')

    <script>
        $(document).ready(function () {
             $('.menu-toggler').click();
            $('.fromToDate').datepicker({
                rtl: App.isRTL(),
                autoclose: true
            });
            $('.filter-submit').click(function (){
                $('#form2_id').val($('#form_id').val());
                $('#form2_user_id').val($('#form_user_id').val());
                $('#form2_user_email').val($('#form_user_email').val());
                $('#form2_course').val($('#form_course').val());
                $('#form2_instructor').val($('#form_instructor').val());
                $('#form2_rating_question1').val($('#form_rating_question1').val());
                $('#form2_rating_sub1_question1').val($('#form_rating_sub1_question1').val());
                $('#form2_rating_sub2_question1').val($('#form_rating_sub2_question1').val());
                $('#form2_rating_question4').val($('#form_rating_question4').val());
                $('#form2_rating_question2').val($('#form_rating_question2').val());
                $('#form2_rating_question3').val($('#form_rating_question3').val());
                $('#form2_rating_sub1_question2').val($('#form_rating_sub1_question2').val());
                $('#form2_rating_sub1_question4').val($('#form_rating_sub1_question4').val());
                $('#form2_rating_sub2_question4').val($('#form_rating_sub2_question4').val());
                $('#form2_created_time_from').val($('#form_created_time_from').val());
                $('#form2_created_time_to').val($('#form_created_time_to').val());
            });
            var grid = new Datatable();
            grid.setAjaxParam("_token", "{{ csrf_token() }}");
            // console.log(grid._token)
            grid.init({
                src: $("#datatable_ajax"),
                onSuccess: function (grid, response) {
                    // grid:        grid object
                    // response:    json object of server side ajax response
                    // execute some code after table records loaded
                },
                onError: function (grid) {
                    // execute some code on network or other general error
                },
                onDataLoad: function (grid) {
                },
                loadingMessage: '{{ Lang::get('main.loading') }}',
                dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options
                    // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                    // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                    // So when dropdowns used the scrollable div should be removed.
                    //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
                    "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                    "lengthMenu": [
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) -1 @endif],
                        [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) "All" @endif] // change per page values here
                    ],
                    "pageLength": 10, // default record count per page
                    "ajax": {
                        "url": "{{ URL('admin/new_courses_rating_search') }}", // ajax source

                    },
                    @if(getUserSystem('backend_lang')=='ar') "language": {"url": "{{ asset('assets/layouts/layout/datatables-arabic.json') }}"},@endif "columnDefs": [{
                        "targets": [0], // column or columns numbers
                        "orderable": true  // set orderable for selected columns

                    }],
                    "order": [
                        [0, "desc"]
                    ],// set first column as a default sort by asc
                    dom: 'Blfrtip',
                    buttons: [
                        {extend: 'print', className: 'btn dark btn-outline'},
                        {extend: 'pdf', className: 'btn green btn-outline'},
                        {extend: 'csv', className: 'btn purple btn-outline '}
                    ],
                }
            });
        });
    </script>
@endsection
