
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('admin/pages') }}">{{ Lang::get('main.pages') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.pages') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.pages') }}</span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>isset($page)?URL('admin/pages/'.$page->id):URL('admin/pages'),'class'=>"form-horizontal",'files'=>true]) !!}
                @if(isset($page))
                    @method('PUT')
                @endif
                <div class="form-body">
                    <x-forms.select id="parent_id" name="parent_id" :label="__('Parent')" :value="isset($page)?$page->parent_id:old('parent_id')" :options="isset($page)?\App\Models\Page::pluck('name','id')->where('id','!=',$page->id)->toArray():\App\Models\Page::pluck('name','id')->toArray()" />
                    <x-forms.input id="slug" :label="__('Slug')" name="slug" :value="isset($page)?$page->slug:old('slug')"/>
                    <x-forms.input id="name" :label="__('Name')" name="name" :value="isset($page)?$page->name:old('name')"/>
                    <x-forms.select id="type" name="type" :label="__('Type')" :value="isset($page)?$page->type:(old('type')?old('type'):'page')" :options="['page'=>'page','polices'=>'polices']" />
                    <x-forms.textarea id="short_description" :label="__('Short Description')" name="short_description" :value="isset($page)?$page->short_description:old('short_description')"/>
                    <x-forms.select id="status" name="status" :label="__('Status')" :value="isset($page)?$page->status:(old('status')?old('status'):'published')" :options="['published'=>'published','unpublished'=>'unpublished','draft'=>'draft']" />
                    <x-forms.input type="number" id="sort" :label="__('Sort')" name="sort" :value="isset($page)?$page->sort:old('sort')"/>
                    <x-forms.input id="meta_title" :label="__('Meta Title')" name="meta_title" :value="isset($page)?$page->meta_title:old('meta_title')"/>
                    <x-forms.textarea id="meta_description" :label="__('Meta Description')" name="meta_description" :value="isset($page)?$page->meta_description:old('meta_description')"/>
                    <x-forms.textarea id="meta_keywords" :label="__('Meta keywords')" name="meta_keywords" :value="isset($page)?$page->meta_keywords:old('meta_keywords')"/>

                    <div class="clearfix"></div>
                    <div class="text-center col-lg-12">
                        <button type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>


                <div class="clearfix"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')

@endsection
