

{{--{{ print_r(json_decode($post->custom_views_projects)).dd() }}--}}
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
    <style>
        .progress {
            position: relative;
            width: 100%;
            height: 30px !important;
            border: 1px solid #7F98B2;
            padding: 1px;
            border-radius: 3px;
        }

        .bar {
            background-color: #B4F5B4;
            width: 0%;
            height: 25px;
            border-radius: 3px;
        }

        .percent {
            position: absolute;
            display: inline-block;
            top: 3px;
            left: 48%;
            color: #7F98B2;
        }
    </style>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/new_modules_courses') }}">{{ Lang::get('main.new_modules_courses') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>
            <li>
                <span>{{ $module_course->name }}</span>
            </li>

        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.new_modules_courses') }}
        <small>{{ Lang::get('main.edit') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.new_modules_courses') }}</span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'PUT','url'=>'admin/new_modules_courses/'.$module_course->id,'id'=>'addModulesForm','files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                </div>

                @if(PerUser('update_all_users'))
                <div class="form-group col-lg-6">
                    {{ Lang::get('main.update_all_users') }} :
                    <input type="checkbox" name="update_all_users" id="update_all_users" value="update_all_users">
                </div>
                @endif


                <div class="form-group col-lg-6">
                    <label class="control-label" for="module_name">{{ Lang::get('main.module_name') }} <span
                                class="required"> * </span></label>
                    <select id="module_name" class="form-control sel2  module_name" required name="module_name">
                        <option value=" ">{{ Lang::get('main.select') }} {{ Lang::get('main.module') }}</option>
                        @foreach($modules as $module)
                            <option @if($module->id == $module_course->module_id ) selected="selected"
                                    @endif value="{{ $module->id}}">{{ $module->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group col-lg-6">
                    <label class="control-label" for="related_course">{{ Lang::get('main.related_course') }} <span
                                class="required"> * </span></label>
                    <select id="related_course" class="form-control sel2 module_name" required name="related_course">
                        <option value=" ">{{ Lang::get('main.select') }} {{ Lang::get('main.course') }}</option>
                        @foreach($courses as $course)
                            <option @if($course->id == $module_course->related_course ) selected="selected"
                                    @endif value="{{ $course->id}}">{{ $course->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group col-lg-6">
                    <label class="control-label" for="part">{{ Lang::get('main.part') }} <span
                                class="required"> * </span></label>
                    <select id="part" class="form-control sel2 module_name" required name="part">
                        <option value=" ">{{ Lang::get('main.select') }} {{ Lang::get('main.part') }}</option>
                        <option @if($module_course->part == "Part One" ) selected="selected"
                                @endif value="Part One" >Part One</option>
                        <option @if($module_course->part == "Part Two" ) selected="selected"
                                @endif value="Part Two" >Part Two</option>
                    </select>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="type">{{ Lang::get('main.type') }} <span
                                class="required"> * </span></label>
                    <select id="type" class="form-control sel2 type" required name="type">
                        <option value=" ">{{ Lang::get('main.select') }} {{ Lang::get('main.type') }}</option>
                        <option value="egypt" @if($module_course->type=='egypt') selected @endif>{{trans('main.egypt')}}</option>
                        <option value="ksa" @if($module_course->type=='ksa') selected @endif>{{trans('main.ksa')}}</option>
                        <option value="both" @if($module_course->type=='both') selected @endif>{{trans('main.both')}}</option>
                    </select>
                </div>

                <div class="form-group col-lg-9">
                    <label class="control-label" for="name">{{ Lang::get('main.name') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{{$module_course->name}}" id="name" name="name" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.name') }}">
                    </div>
                </div>
                <div class="form-group col-lg-3 text-center" style="margin-top:25px;">
                    <input type="checkbox" class="make-switch" name="active" value="yes" @if($module_course->published=="yes") checked @endif data-size="small" data-on-color="success" data-on-text="{{ Lang::get('main.active') }}" data-off-color="default" data-off-text="{{ Lang::get('main.inActive') }}">
                </div>


               {{-- @include('auth/description',['posts' =>[$module_course->description]])--}}

                {{--<div class="form-group col-lg-6 col-lg-offset-3">
                    <label class="control-label">Current Picture</label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <img width="100%" src="{{assetURL($module_course->image) }}">
                    </div>
                </div>

                <div class="form-group col-lg-12">
                    <label class="control-label" for="pic">Replace Picture <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="file" class="form-control" value="" id="pic" accept="image/*"
                               name="pic" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.pic') }}">
                    </div>
                </div>--}}

               {{-- <div class="form-group col-lg-6">
                    <label for="duetime">{{ Lang::get('main.duetime') }}</label>
                    <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                        <input type="text" class="form-control form-filter input-sm" readonly
                               name="duetime" value="{{$module_course->duetime}}" placeholder="{{ Lang::get('main.enter').Lang::get('main.duetime') }}">
                        <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                    </div>
                </div>--}}


                <div class="form-group col-lg-12">
                    <label class="control-label" for="sort">{{ Lang::get('main.sort') }}</label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="number" min="0" class="form-control" value="{{$module_course->sort}}" id="sort" name="sort" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.sort') }}">
                    </div>
                </div>

                <div class="clearfix"></div>
                <div class="text-center col-lg-12">
                    <button type="submit" class="btn green">{{ Lang::get('main.save') }}</button>
                </div>
                <div class="clearfix"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>

        $(document).ready(function () {
            // $('.type').change(function(){
            //     if($(this).val()=='ksa'){
            //        $('.related').html("{{trans('main.ksa_related_course')}}<span class='required'> * </span>");
            //        $('#related_course').attr('name','ksa_related_course');
            //     }else{
            //         $('.related').html("{{trans('main.related_course')}}<span class='required'> * </span>")
            //         $('#related_course').attr('name','related_course');

            //     }
            // });
            $(document).on('change', '#all_projects', function () {
                if ($(this).is(':checked')) {
                    $("#projects_ids").attr('disabled', 'disabled');
                } else {
                    $("#projects_ids").removeAttr('disabled')
                }
            });
            @if(PerUser('new_modules_courses_active'))
            $(document).on('change', '.changeStatues', function () {
                var statues = $(this).is(':checked');
                var id = $(this).attr('data-id');
                if (statues) {
                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/new_modules_courses/activation') }}",
                        data: {"active": 1, "id": id, _token: token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                } else {
                    $.ajax({
                        type: "POST",
                        url: "{{ URL('admin/new_modules_courses/activation') }}",
                        data: {"active": 0, "id": id, _token: token},
                        success: function (msg) {
                            $("#errors").html(msg);
                        }
                    });
                }
            });
            @endif
            $('.fromToDate').datepicker({
                rtl: App.isRTL(),
                autoclose: true
            });
        });
        // $(document).ready(function () {
        //
        //     // function validate(formData, jqForm, options) {
        //     //     var form = jqForm[0];
        //     //     if (!form.file.value) {
        //     //         alert('File not found');
        //     //         return false;
        //     //     }
        //     // }
        //
        //     var bar = $('.bar');
        //     var percent = $('.percent');
        //     var status = $('#status');
        //
        //     $('form').ajaxForm({
        //         // beforeSubmit: validate,
        //         beforeSend: function () {
        //             status.empty();
        //             var percentVal = '0%';
        //             bar.width(percentVal);
        //             percent.html(percentVal);
        //         },
        //         uploadProgress: function (event, position, total, percentCompvare) {
        //             var percentVal = percentCompvare + '%';
        //             bar.width(percentVal);
        //             percent.html(percentVal);
        //         },
        //         success: function (data) {
        //             console.log('data is: ' + data);
        //             if (!data.success) {
        //                 var percentVal = 'Please try again!';
        //                 bar.css('background-color', '#f8d7da');
        //                 percent.css('color', '#721c24');
        //                 bar.width(percentVal);
        //                 percent.html(percentVal);
        //                 $("#messages").html(data.message);
        //                 $([document.documentElement, document.body]).animate({
        //                     scrollTop: $("#messages").offset().top
        //                 }, 2000);
        //             } else {
        //                 var percentVal = 'Wait, Saving';
        //                 bar.css('background-color', '#B4F5B4');
        //                 percent.css('color', '#7F98B2');
        //                 bar.width(percentVal);
        //                 percent.html(percentVal);
        //             }
        //         },
        //         complete: function (xhr) {
        //             console.log(xhr);
        //             if (xhr.statusText == 'OK' && xhr.responseText == "" && $('input[name=name]').val() != '' && $('input[name=title]').val() != '') {
        //                 window.location.reload();
        //             } else if (xhr.statusText != 'OK') {
        //                 var percentVal = 'Please try again!';
        //                 bar.css('background-color', '#f8d7da');
        //                 percent.css('color', '#721c24');
        //                 bar.width(percentVal);
        //                 percent.html(percentVal);
        //             }
        //         }
        //     });
        // });
    </script>
@endsection
