

{{--{{ print_r(json_decode($post->custom_views_projects)).dd() }}--}}
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/new_mba_categories') }}">{{ Lang::get('main.new_mba_categories') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.new_mba_categories') }}
        <small>{{ Lang::get('main.edit') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')

    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.new_mba_categories') }}</span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'PUT','url'=>'admin/new_mba_categories/'.$new_mba_category->id,'files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                </div>

                <div id="messages"></div>
                <div class="form-group col-lg-9">
                    <label class="control-label" for="title">{{ Lang::get('main.name') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{{$new_mba_category->name}}" id="name" name="name"
                               data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.name') }}">
                    </div>
                </div>
                <div class="form-group col-lg-3 text-center" style="margin-top:25px;">
                    <input type="checkbox" class="make-switch" name="published" value="yes"
                           @if($new_mba_category->published=="yes") checked @endif data-size="small" data-on-color="success"
                           data-on-text="{{ Lang::get('main.published') }}" data-off-color="default" data-off-text="{{ Lang::get('main.unpublished') }}">
                </div>
                <div class="form-group col-lg-12">
                <label class="control-label" for="title">{{ Lang::get('main.name_ar') }} <span
                            class="required"> * </span></label>
                <div class="input-icon right">
                    <i class="fa"></i>
                    <input type="text" class="form-control" value="{{$new_mba_category->name_ar}}" id="name_ar" name="name_ar"
                           data-required="1"
                           placeholder="{{ Lang::get('main.enter').Lang::get('main.name_ar') }}">
                </div>
            </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="egy_total_hours">{{ Lang::get('main.egy_total_hours') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="number" class="form-control" value="{{$new_mba_category->egy_total_hours}}" id="egy_total_hours" name="egy_total_hours"
                               data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.egy_total_hours') }}">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="ksa_total_hours">{{ Lang::get('main.ksa_total_hours') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="number" class="form-control" value="{{$new_mba_category->ksa_total_hours}}" id="ksa_total_hours" name="ksa_total_hours"
                               data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.ksa_total_hours') }}">
                    </div>
                </div>
                <div class="form-group col-lg-12">
                    <label class="control-label" for="url">{{ Lang::get('main.url') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{{$new_mba_category->url}}" name="url" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.url') }}">
                    </div>
                </div>

                <div class="form-group col-lg-12">
                    <label class="control-label">{{Lang::get('main.image')}}</label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <img style="width:20%;" src="{{assetURL($new_mba_category->image) }}">
                    </div>
                </div>

                <div class="form-group col-lg-12">
                    <label class="control-label" for="image">{{Lang::get('main.replace')}} {{Lang::get('main.image')}}</label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="file" class="form-control" value="" id="image" accept="image/*"
                               name="image" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.image') }}">
                    </div>
                </div>

                <div class="form-group col-lg-12">
                    <label class="control-label" for="url">{{ Lang::get('main.sort') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{{$new_mba_category->sort}}" id="sort" name="sort" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.sort') }}">
                    </div>
                </div>

                @include('auth/description',['posts' =>[$new_mba_category->description]])

                <div class="form-group col-lg-12">
                        <label class="control-label" for="name">{{ Lang::get('main.meta_description') }} </label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <textarea class="form-control" id="meta_description" name="meta_description">{{ $new_mba_category->meta_description }}</textarea>
                        </div>
                    </div>


                <div class="clearfix"></div>
                <div class="text-center col-lg-12">
                    <button type="submit" class="btn green">{{ Lang::get('main.save') }}</button>
                </div>
                <div class="clearfix"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
