

{{--{{ print_r(json_decode($post->custom_views_projects)).dd() }}--}}
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection

@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/new_landing_page') }}">{{ Lang::get('main.new_landing_page') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>

        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.new_landing_page') }}
        <small>{{ Lang::get('main.edit') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')
    <style>
        .form-group {
            margin-left: 0px !important;
            margin-right: 0px !important;
        }
    </style>
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.new_landing_page') }}</span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'PUT','url'=>'admin/new_landing_page/'.$new_landing->id,'class'=>"form-horizontal",'files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                </div>

                <div id="messages"></div>
                <div class="form-group col-lg-12">
                    <label for="instructor">{{ Lang::get('main.accreditations') }}<span
                                class="required"> * </span></label>
                    <select name="accreditation_categories_details_ids[]" multiple class="sel2 form-control form-filter">
                        @foreach(\Illuminate\Support\Facades\DB::connection('mysql2')->table('accreditation_partners_countries_categories_details')->where('place','outer')->where('type','accreditaion')->select('title','id')->get() as $item)
                            <option @if($new_landing->accreditation_categories_details_ids&&in_array($item->id,json_decode($new_landing->accreditation_categories_details_ids))) selected="selected" @endif value="{{$item->id}}">{{$item->title}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group col-lg-9">
                    <label class="control-label" for="name">{{ Lang::get('main.diploma_name') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{{$new_landing->diploma_name}}" name="diploma_name"
                               data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.diploma_name') }}">
                    </div>
                </div>
                <div class="form-group col-lg-3 text-center" style="margin-top:25px;">
                    <input type="checkbox" class="make-switch" name="published" value="yes"
                           @if($new_landing->published=="yes") checked @endif data-size="small" data-on-color="success"
                           data-on-text="{{ Lang::get('main.published') }}" data-off-color="default" data-off-text="{{ Lang::get('main.unpublished') }}">
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="url">{{ Lang::get('main.url') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{{$new_landing->url}}" name="url" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.url') }}">
                    </div>
                </div>
                <div class="form-group col-lg-6">
                    <label class="control-label" for="leadsource">{{ Lang::get('main.leadsource') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{{$new_landing->leadsource}}" name="leadsource" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.leadsource') }}">
                    </div>
                </div>
                <div class="form-group col-lg-12">
                    <div class="input-group">
                        <input type="text" class="form-control" value="{{ 'https://www.e3melbusiness.com/new-lp/'.$new_landing->url }}" name="full_url" disabled>
                        <span class="input-group-addon" style="padding: 0">
                            <button type="button" id="copy-url" data-clipboard-text="{{ 'https://www.e3melbusiness.com/new-lp/'.$new_landing->url }}" class="btn btn-success">
                                <i class="fa fa-copy"></i>
                            </button>
                        </span>
                    </div>

                </div>
                @include('auth/description',['selectors'=>'.right_form_content', 'labels'=>[Lang::get('main.right_form_content'),], 'posts'=>[$new_landing->right_form_content] ])


                <div class="form-group col-lg-12">
                    <label class="control-label" for="meta_title">{{ Lang::get('main.meta_title') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <input type="text" class="form-control" value="{{ $new_landing->meta_title }}" name="meta_title" data-required="1"
                               placeholder="{{ Lang::get('main.enter').Lang::get('main.meta_title') }}">
                    </div>
                </div>
                <div class="form-group col-lg-12">
                    <label class="control-label" for="meta_description">{{ Lang::get('main.meta_description') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <textarea class="form-control" name="meta_description" data-required="1"
                                  placeholder="{{ Lang::get('main.enter').Lang::get('main.meta_description') }}">{{ $new_landing->meta_description }}</textarea>
                    </div>
                </div>
                <div class="form-group col-lg-12">
                    <label class="control-label" for="meta_keywords">{{ Lang::get('main.meta_keywords') }} <span
                                class="required"> * </span></label>
                    <div class="input-icon right">
                        <i class="fa"></i>
                        <textarea class="form-control" value="" name="meta_keywords" data-required="1"
                                  placeholder="{{ Lang::get('main.enter').Lang::get('main.meta_keywords') }}">{{ $new_landing->meta_keywords }}</textarea>
                    </div>
                </div>


                <div class="clearfix"></div>
                <div class="text-center col-lg-12">
                    <button type="submit" class="btn green">{{ Lang::get('main.save') }}</button>
                </div>
                <div class="clearfix"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script type="text/javascript" src="https://milankyncl.github.io/jquery-copy-to-clipboard/jquery.copy-to-clipboard.js"></script>

    <script>
        $('#copy-url').CopyToClipboard();
        $(document).ready(function () {
        })

    </script>
@endsection
