@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
    @endsection
    @section('contentHeader')
            <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/dba_checklists_user_plan') }}">{{ Lang::get('main.dba_checklists_user_plan') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>

        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.dba_checklists_user_plan') }}
        <small>{{ Lang::get('main.edit') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
    @section('content')
        <style>
            ul li{
                list-style: none;
            }
            ul li ol{
                margin-top: 10px;
            }
        </style>
            <!-- BEGIN PAGE HEADER-->
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-dba_checklists_user_plan font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.dba_checklists_user_plan') }}</span>
                </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'PUT','url'=>'admin/dba_checklists_user_plan/'.$user->id,'id'=>'addProfilesForm','class'=>"form-horizontal"]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div class="form-group col-lg-12">
                        <label class="control-label" for="user">{{ Lang::get('main.user') }} <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{{$user->Email}}" id="user" name="user" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.user') }}">
                        </div>
                    </div>
                    <div id="users" class="col-lg-12"></div>
                    <div class="clearfix"></div>
                        <div class="row">
                            <ul class="col-lg-12 permissions">
                                <?php
                                $x=1;
                                    foreach ($post as $record){

                                    echo   '<li>
                                    <div class="md-checkbox has-success">

                                        <input name="checklists[]" ' ;
                                            if( $record->checked==1){
                                                echo 'checked="checked"';
                                            }

                                  echo 'type="checkbox" id="checkbox-'.$x.'" value="'.$record->checklist_id.'" class="md-check">
                                        <label for="checkbox-'.$x.'">
                                            <span class="inc"></span>
                                            <span class="check"></span>
                                            <span class="box"></span> '.$record->name.' </label>
                                    </div>
                                    </li>
                                    ';
                                    $x++;
                                }
                                ?>

                            </ul>
                        </div>
                    <div class="clearfix" style="height: 30px"></div>
                    <div class="text-center">
                        <button type="submit" class="btn green">{{ Lang::get('main.save') }}</button>
                    </div>
                </div>
                <div class="clearfix" style="height: 30px"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $('#user').keyup(function(){
            var query=$(this).val();
            if(query!=''){
                var token = "{{ csrf_token() }}";
                $.ajax({
                    type: "POST",
                    url: "{{ URL('admin/dba_checklists_user_plan/autoCompleteUsers') }}",
                    data: {query: query, _token: token},
                    success: function (data) {
                        $("#users").fadeIn();
                        $("#users").html(data);
                    }
                })
            }
            else{
                $("#users").fadeOut();
            }
        });
        $(document).on('click','#users-emails li',function(){
            $('#user').val($(this).text());
            $('#users').fadeOut();
        });
    </script>
@endsection