
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/apccd') }}">{{ Lang::get('main.accreditation_partners_countries_categories_details') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.edit') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.accreditation_partners_countries_categories_details') }}
        <small>{{ Lang::get('main.edit') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.accreditation_partners_countries_categories_details') }}</span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'PUT','url'=>'admin/apccd/'.$accreditation_partners_countries_categories_details->id,'id'=>'editAuthorForm','class'=>"form-horizontal",'files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}x
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div id="messages"></div>
                    <div class="form-group col-lg-12">
                        <label class="control-label" for="category">{{ Lang::get('main.accreditation_partners_countries_categories') }} <span
                                    class="required"> * </span></label>
                        <select id="category" class="form-control sel2" required name="category">
                            <option value=" ">{{ Lang::get('main.select') }} {{ Lang::get('main.accreditation_partners_countries_categories') }}</option>
                            @foreach(\App\Models\AccreditationPartnersCountriesCategories::pluck('title','id')->toArray() as $id=>$name)
                                <option @if($accreditation_partners_countries_categories_details->category_id==$id || old('category_id')==$id) selected="selected" @endif value="{{ $id }}">{{ $name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-lg-12">
                        <label class="control-label" for="type">{{ Lang::get('main.type') }} <span
                                    class="required"> * </span></label>
                        <select id="type" class="form-control sel2" required name="type">
                            <option value=" ">{{ Lang::get('main.select') }} {{ Lang::get('main.type') }}</option>
                            <option @if($accreditation_partners_countries_categories_details->type == 'accreditaion'||old('type')=='accreditaion') selected="selected" @endif value="accreditaion">accreditaion</option>
                            <option @if($accreditation_partners_countries_categories_details->type == 'success_partners' || old('type')=='success_partners') selected="selected" @endif value="success_partners">success_partners</option>
                            <option @if($accreditation_partners_countries_categories_details->type == 'both' || old('type')=='both') selected="selected" @endif value="both">both</option>
                        </select>
                    </div>

                    <div class="form-group col-lg-12">
                        <label class="control-label" for="place">{{ Lang::get('main.place') }} <span
                                    class="required"> * </span></label>
                        <select id="place" class="form-control sel2" required name="place">
                            <option value=" ">{{ Lang::get('main.select') }} {{ Lang::get('main.place') }}</option>
                            <option @if($accreditation_partners_countries_categories_details->place == 'outer' || old('place')=='outer') selected="selected" @endif value="outer">outer</option>
                            <option @if($accreditation_partners_countries_categories_details->place == 'inner' || old('place')=='inner') selected="selected" @endif value="inner">inner</option>
                        </select>
                    </div>
                    <div class="form-group col-lg-6 col-lg-offset-3">
                        <label class="control-label">Current logo</label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <img width="100%" src="{{ assetURL($accreditation_partners_countries_categories_details->logo) }}">
                        </div>
                    </div>

                    <div class="form-group col-lg-12">
                        <label class="control-label" for="logo">change {{ Lang::get('main.logo') }} <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="file" class="form-control" value="" id="logo" accept="image/*"
                                   name="logo" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.logo') }}">
                        </div>
                    </div>

                    <div class="form-group col-lg-9">
                        <label class="control-label" for="name">{{ Lang::get('main.title') }} <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{!! $accreditation_partners_countries_categories_details->title ? : old('title') !!}" id="title" name="title" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.title') }}">
                        </div>
                    </div>
                    <div class="form-group col-lg-3 text-center" style="margin-top:25px;">
                        <input type="checkbox" class="make-switch" name="published" value="yes" data-size="small"
                               @if($accreditation_partners_countries_categories_details->published=="yes") checked @endif
                               data-on-color="success" data-on-text="{{ Lang::get('main.published') }}" data-off-color="default"
                               data-off-text="{{ Lang::get('main.unpublished') }}">
                    </div>
                    <div class="form-group col-lg-12">
                        <label class="control-label" for="url">{{ Lang::get('main.url') }} <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{!! $accreditation_partners_countries_categories_details->url ? :old('url') !!}" id="url" name="url" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.url') }}">
                        </div>
                    </div>
 <div class="form-group col-lg-12">
                        <label class="control-label" for="sort">{{ Lang::get('main.sort') }} <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{!! $accreditation_partners_countries_categories_details->sort ? :old('sort') !!}" id="sort" name="sort" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.sort') }}">
                        </div>
                    </div>


                    <div class="col-md-12">
                        <div class="form-group col-lg-12">
                            <div class="input-icon right">
                                <label class="control-label">Current photos</label>
                            </div>
                        </div>
                        @forelse($accreditation_partners_countries_categories_details->images as $image)
                            <div class="form-group col-lg-3" style="margin-right: 0">
                                <div class="input-icon" style="border: 1px solid;border-radius: 5px !important;padding: 1em;">
                                    <button type="button" class="btn btn-circle btn-danger deleteImg"
                                            style="position: absolute" data-id="{{ $image->id }}" >
                                        <i class="fa fa-trash-o"></i>
                                    </button>
                                    <img width="100%" src="{{assetURL($image->image) }}">
                                </div>
                            </div>
                        @empty
                            <div class="form-group col-lg-3">
                                <div class="input-icon right">
                                    <i class="fa"></i>

                                </div>
                            </div>
                        @endforelse
                    </div>
                    <div class="form-group col-lg-12">
                        <label class="control-label" for="images">{{ Lang::get('main.images') }} <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="file" class="form-control" value="" id="images" accept="image/*"
                                   name="images[]" data-required="1" multiple
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.images') }}">
                        </div>
                    </div>

                    @include('auth/description',['posts' =>[$accreditation_partners_countries_categories_details->description]])

                    <div class="clearfix"></div>
                    <div class="text-center col-lg-12">
                        <button type="submit" class="btn green">{{ Lang::get('main.edit') }}</button>
                    </div>
                </div>
                <div class="clearfix"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script type="text/javascript">
        $(document).ready(function () {
            $.ajaxSetup({
                headers:
                    { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') }
            });


            $(document).on('click', '.deleteImg',function(e){
                e.preventDefault();
                if(confirm('Are you sure you want to delete this image？')) {
                    let url = "{{ URL('/admin/apccd/delete_image') }}";
                    let el = $(this);
                    $.post(url, {
                        'id': el.data('id')
                    }, function (response) {
                        if (response.status){
                            el.parent().parent().remove();
                        }
                    });
                }
                return false;
            });
        })
    </script>
@endsection
