
@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
    <style>
        .progress {
            position: relative;
            width: 100%;
            height: 30px !important;
            border: 1px solid #7F98B2;
            padding: 1px;
            border-radius: 3px;
        }

        .bar {
            background-color: #B4F5B4;
            width: 0%;
            height: 25px;
            border-radius: 3px;
        }

        .percent {
            position: absolute;
            display: inline-block;
            top: 3px;
            left: 48%;
            color: #7F98B2;
        }
    </style>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{{ URL('/admin/academy_alumni') }}">{{ Lang::get('main.academy_alumni') }}</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <span>{{ Lang::get('main.add') }}</span>
            </li>
        </ul>
    </div>
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <h1 class="page-title"> {{ Lang::get('main.academy_alumni') }}
        <small>{{ Lang::get('main.add') }}</small>
    </h1>
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection
@section('content')
    <div class="row">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-users font-dark"></i>
                    <span class="caption-subject bold uppercase">{{ Lang::get('main.academy_alumni') }}</span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                {!! Form::open(['method'=>'POST','url'=>'admin/academy_alumni','id'=>'addInstructorsForm','files'=>true]) !!}
                <div class="form-body">
                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_error') }}
                    </div>
                    <div class="alert alert-success display-hide">
                        <button class="close" data-close="alert"></button>
                        {{ Lang::get('main.form_validation_success') }}
                    </div>
                    <div id="messages"></div>
                    <div class="form-group col-lg-10">
                        <label class="control-label" for="name">{{ Lang::get('main.name') }} <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{!! old('name') !!}" id="name" name="name" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.name') }}">
                        </div>
                    </div>
                    <div class="form-group col-lg-2 text-center" style="margin-top:25px;">
                        <input type="checkbox" class="make-switch" name="published" value="yes" checked data-size="small"
                               data-on-color="success" data-on-text="{{ Lang::get('main.published') }}" data-off-color="default"
                               data-off-text="{{ Lang::get('main.unpublished') }}">
                    </div>
                    <script type="text/javascript" src="<?php echo URL('js/tinymce/tinymce.min.js')?>"></script>
                    <script type="text/javascript">
                        tinymce.init({
                            relative_urls : false,
                            remove_script_host : false,
                            document_base_url : "{{ URL('') }}",
                            convert_urls : true,
                            selector: ".editor",
                            theme : "silver",
                            plugins: 'preview importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media template codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
                            editimage_cors_hosts: ['picsum.photos'],
                            menubar: 'file edit view insert format tools table help',
                            toolbar: 'undo redo | bold italic underline strikethrough | fontselect fontsizeselect formatselect | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen  preview save print | insertfile image media template link anchor codesample | ltr rtl',
                            toolbar_sticky: true,
                            autosave_ask_before_unload: true,
                            autosave_interval: '30s',
                            autosave_prefix: '{path}{query}-{id}-',
                            autosave_restore_when_empty: false,
                            autosave_retention: '2m',
                            image_advtab: true,
                            link_list: [
                                { title: 'My page 1', value: 'https://www.tiny.cloud' },
                                { title: 'My page 2', value: 'http://www.moxiecode.com' }
                            ],
                            image_list: [
                                { title: 'My page 1', value: 'https://www.tiny.cloud' },
                                { title: 'My page 2', value: 'http://www.moxiecode.com' }
                            ],
                            image_class_list: [
                                { title: 'None', value: '' },
                                { title: 'Some class', value: 'class-name' }
                            ],
                            importcss_append: true,
                            file_picker_callback: function (callback, value, meta) {
                                /* Provide file and text for the link dialog */
                                if (meta.filetype === 'file') {
                                    callback('https://www.google.com/logos/google.jpg', { text: 'My text' });
                                }

                                /* Provide image and alt text for the image dialog */
                                if (meta.filetype === 'image') {
                                    callback('https://www.google.com/logos/google.jpg', { alt: 'My alt text' });
                                }

                                /* Provide alternative source and posted for the media dialog */
                                if (meta.filetype === 'media') {
                                    callback('movie.mp4', { source2: 'alt.ogg', poster: 'https://www.google.com/logos/google.jpg' });
                                }
                            },
                            templates: [
                                { title: 'New Table', description: 'creates a new table', content: '<div class="mceTmpl"><table width="98%%"  border="0" cellspacing="0" cellpadding="0"><tr><th scope="col"> </th><th scope="col"> </th></tr><tr><td> </td><td> </td></tr></table></div>' },
                                { title: 'Starting my story', description: 'A cure for writers block', content: 'Once upon a time...' },
                                { title: 'New list with dates', description: 'New List with dates', content: '<div class="mceTmpl"><span class="cdate">cdate</span><br /><span class="mdate">mdate</span><h2>My List</h2><ul><li></li><li></li></ul></div>' }
                            ],
                            template_cdate_format: '[Date Created (CDATE): %m/%d/%Y : %H:%M:%S]',
                            template_mdate_format: '[Date Modified (MDATE): %m/%d/%Y : %H:%M:%S]',
                            height: 600,
                            image_caption: true,
                            quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote quickimage quicktable',
                            noneditable_class: 'mceNonEditable',
                            toolbar_mode: 'sliding',
                            contextmenu: 'link image table',
                            content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:16px }',
                            automatic_uploads: true,
                            file_picker_types: 'image',
                            images_upload_url: "{{url('/upload.php')}}",
                            images_upload_handler: function (blobInfo, success, failure) {
                                var xhr, formData;
                                xhr = new XMLHttpRequest();
                                xhr.withCredentials = false;
                                xhr.open('POST', "{{url('/upload.php')}}");

                                xhr.onload = function() {
                                    var json;

                                    if (xhr.status != 200) {
                                        failure('HTTP Error: ' + xhr.status);
                                        return;
                                    }
                                    json = JSON.parse(xhr.responseText);

                                    if (!json || typeof json.location != 'string') {
                                        failure('Invalid JSON: ' + xhr.responseText);
                                        return;
                                    }

                                    success(json.location);
                                };

                                formData = new FormData();
                                formData.append('file', blobInfo.blob(), blobInfo.filename());

                                xhr.send(formData);
                            },

                            file_picker_callback: function (cb, value, meta) {
                                var input = document.createElement('input');
                                input.setAttribute('type', 'file');
                                input.setAttribute('accept', 'image/*');

                                /*
                                  Note: In modern browsers input[type="file"] is functional without
                                  even adding it to the DOM, but that might not be the case in some older
                                  or quirky browsers like IE, so you might want to add it to the DOM
                                  just in case, and visually hide it. And do not forget do remove it
                                  once you do not need it anymore.
                                */

                                input.onchange = function () {
                                    var file = this.files[0];

                                    var reader = new FileReader();
                                    reader.onload = function () {
                                        /*
                                          Note: Now we need to register the blob in TinyMCEs image blob
                                          registry. In the next release this part hopefully won't be
                                          necessary, as we are looking to handle it internally.
                                        */
                                        var id = 'blobid' + (new Date()).getTime();
                                        var blobCache =  tinymce.activeEditor.editorUpload.blobCache;
                                        var base64 = reader.result.split(',')[1];
                                        var blobInfo = blobCache.create(id, file, base64);
                                        blobCache.add(blobInfo);

                                        /* call the callback and populate the Title field with the file name */
                                        cb(blobInfo.blobUri(), { title: file.name });
                                    };
                                    reader.readAsDataURL(file);
                                };

                                input.click();
                            },


                            setup: function (editor) {
                                editor.on('change', function () {
                                    tinymce.triggerSave();
                                });
                            }



                        });
                        {{--tinymce.init({--}}
                        {{--    relative_urls : false,--}}
                        {{--    remove_script_host : false,--}}
                        {{--    document_base_url : "{{ URL('') }}",--}}
                        {{--    convert_urls : true,--}}
                        {{--    selector: "{{$selectors}}",--}}
                        {{--    theme : "silver",--}}

                        {{--    plugins: [--}}
                        {{--        "advlist autolink autosave link image lists charmap print preview hr anchor pagebreak spellchecker",--}}
                        {{--        "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",--}}
                        {{--        "table contextmenu directionality emoticons template textcolor paste textcolor colorpicker textpattern image code "/*fullpage*/--}}
                        {{--    ],--}}
                        {{--    object_resizing : true,--}}
                        {{--    resize: "both",--}}
                        {{--    automatic_uploads: true,--}}
                        {{--    file_picker_types: 'image',--}}
                        {{--    /* without images_upload_url set, Upload tab won't show up*/--}}
                        {{--    // without images_upload_url set, Upload tab won't show up--}}
                        {{--    images_upload_url: "{{url('/upload.php')}}",--}}
                        {{--    images_upload_handler: function (blobInfo, success, failure) {--}}
                        {{--        var xhr, formData;--}}

                        {{--        xhr = new XMLHttpRequest();--}}
                        {{--        xhr.withCredentials = false;--}}
                        {{--        xhr.open('POST', "{{url('/upload.php')}}");--}}

                        {{--        xhr.onload = function() {--}}
                        {{--            var json;--}}

                        {{--            if (xhr.status != 200) {--}}
                        {{--                failure('HTTP Error: ' + xhr.status);--}}
                        {{--                return;--}}
                        {{--            }--}}

                        {{--            json = JSON.parse(xhr.responseText);--}}

                        {{--            if (!json || typeof json.location != 'string') {--}}
                        {{--                failure('Invalid JSON: ' + xhr.responseText);--}}
                        {{--                return;--}}
                        {{--            }--}}

                        {{--            success(json.location);--}}
                        {{--        };--}}

                        {{--        formData = new FormData();--}}
                        {{--        formData.append('file', blobInfo.blob(), blobInfo.filename());--}}

                        {{--        xhr.send(formData);--}}
                        {{--    },--}}

                        {{--    file_picker_callback: function (cb, value, meta) {--}}
                        {{--        var input = document.createElement('input');--}}
                        {{--        input.setAttribute('type', 'file');--}}
                        {{--        input.setAttribute('accept', 'image/*');--}}

                        {{--        /*--}}
                        {{--          Note: In modern browsers input[type="file"] is functional without--}}
                        {{--          even adding it to the DOM, but that might not be the case in some older--}}
                        {{--          or quirky browsers like IE, so you might want to add it to the DOM--}}
                        {{--          just in case, and visually hide it. And do not forget do remove it--}}
                        {{--          once you do not need it anymore.--}}
                        {{--        */--}}

                        {{--        input.onchange = function () {--}}
                        {{--            var file = this.files[0];--}}

                        {{--            var reader = new FileReader();--}}
                        {{--            reader.onload = function () {--}}
                        {{--                /*--}}
                        {{--                  Note: Now we need to register the blob in TinyMCEs image blob--}}
                        {{--                  registry. In the next release this part hopefully won't be--}}
                        {{--                  necessary, as we are looking to handle it internally.--}}
                        {{--                */--}}
                        {{--                var id = 'blobid' + (new Date()).getTime();--}}
                        {{--                var blobCache =  tinymce.activeEditor.editorUpload.blobCache;--}}
                        {{--                var base64 = reader.result.split(',')[1];--}}
                        {{--                var blobInfo = blobCache.create(id, file, base64);--}}
                        {{--                blobCache.add(blobInfo);--}}

                        {{--                /* call the callback and populate the Title field with the file name */--}}
                        {{--                cb(blobInfo.blobUri(), { title: file.name });--}}
                        {{--            };--}}
                        {{--            reader.readAsDataURL(file);--}}
                        {{--        };--}}

                        {{--        input.click();--}}
                        {{--    },--}}

                        {{--    toolbar1: "newdocument fullpage | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify | styleselect formatselect fontselect fontsizeselect",--}}
                        {{--    toolbar2: "cut copy paste | searchreplace | bullist numlist | outdent indent blockquote | undo redo | link unlink anchor image media code | insertdatetime preview | forecolor backcolor",--}}
                        {{--    toolbar3: "table | hr removeformat | subscript superscript | charmap emoticons | print fullscreen | ltr rtl | spellchecker | visualchars visualblocks nonbreaking template pagebreak restoredraft",--}}
                        {{--    image_advtab: true,--}}
                        {{--    menubar: false,--}}
                        {{--    toolbar_items_size: 'small',--}}
                        {{--    style_formats: [--}}
                        {{--        {title: 'Bold text', inline: 'b'},--}}
                        {{--        {title: 'Red text', inline: 'span', styles: {color: '#ff0000'}},--}}
                        {{--        {title: 'Red header', block: 'h1', styles: {color: '#ff0000'}},--}}
                        {{--        {title: 'Example 1', inline: 'span', classes: 'example1'},--}}
                        {{--        {title: 'Example 2', inline: 'span', classes: 'example2'},--}}
                        {{--        {title: 'Table styles'},--}}
                        {{--        {title: 'Table row 1', selector: 'tr', classes: 'tablerow1'}--}}
                        {{--    ],--}}
                        {{--    //content_css: ['//fonts.googleapis.com/css?family=Indie+Flower'],--}}
                        {{--    font_formats: 'Cocon=cocon,Andale Mono=andale mono,monospace;Arial=arial,helvetica,sans-serif;Arial Black=arial black,sans-serif;Book Antiqua=book antiqua,palatino,serif;Comic Sans MS=comic sans ms,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,palatino,serif;Helvetica=helvetica,arial,sans-serif;Impact=impact,sans-serif;Symbol=symbol;Tahoma=tahoma,arial,helvetica,sans-serif;Terminal=terminal,monaco,monospace;Times New Roman=times new roman,times,serif;Trebuchet MS=trebuchet ms,geneva,sans-serif;Verdana=verdana,geneva,sans-serif;Webdings=webdings;Wingdings=wingdings,zapf dingbats;',--}}
                        {{--    templates: [--}}
                        {{--        {title: 'Test template 1', content: 'Test 1'},--}}
                        {{--        {title: 'Test template 2', content: 'Test 2'}--}}
                        {{--    ],--}}
                        {{--    setup: function (editor) {--}}
                        {{--        editor.on('change', function () {--}}
                        {{--            tinymce.triggerSave();--}}
                        {{--        });--}}
                        {{--    }--}}



                        {{--});--}}
                    </script>
                    <div class="col-lg-12 form-group">
                        <label class=" control-label" for="sort">{{ Lang::get('main.sort') }}</label>
                        <input type="number" min="0" class="form-control" value="{{ old('sort') }}" name="sort" id="sort"/>
                    </div>
                    <div class="col-lg-12 form-group">
                        <label class=" control-label" for="short_description">{{ Lang::get('main.short_description') }}</label>
                        <textarea class="form-control" name="short_description" id="short_description">{!! old('short_description')!!}</textarea>
                    </div>
                    <div class="col-lg-12 form-group">
                        <label class=" control-label" for="description">{{ Lang::get('main.description') }}</label>
                        <textarea class="form-control editor" name="description" id="description">{!! old('description') !!}</textarea>
                    </div>
                    {{--@include('auth/description')--}}

                    <div class="form-group col-lg-12">
                        <label class="control-label" for="pic">{{ Lang::get('main.pic') }} <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="file" class="form-control" value="" id="pic" accept="image/*"
                                   name="pic" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.pic') }}">
                        </div>
                    </div>

                    <div class="form-group col-lg-12">
                        <label class="control-label" for="cv">{{ Lang::get('main.cv') }} <span
                                    class="required">(PDF File) * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="file" class="form-control" value="" id="cv" accept="application/pdf"
                                   name="cv" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.cv') }}">
                        </div>
                    </div>


                    <div class="form-group col-lg-12">
                        <label class="control-label" for="linkedin">{{ Lang::get('main.linkedin') }} </label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{!! old('linkedin') !!}" id="linkedin" name="linkedin" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.linkedin') }} Account">
                        </div>
                    </div>
                    <div class="form-group col-lg-12">
                        <label class="control-label" for="facebook">{{ Lang::get('main.facebook') }} </label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{!! old('facebook') !!}" id="facebook" name="facebook" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.facebook') }} Account">
                        </div>
                    </div>
                    <div class="form-group col-lg-12">
                        <label class="control-label" for="url">{{ Lang::get('main.url') }} <span
                                    class="required"> * </span></label>
                        <div class="input-icon right">
                            <i class="fa"></i>
                            <input type="text" class="form-control" value="{!! old('url') !!}" id="url" name="url" data-required="1"
                                   placeholder="{{ Lang::get('main.enter').Lang::get('main.url') }}">
                        </div>
                    </div>


                    <div class="clearfix"></div>
                    <div class="text-center col-lg-12">
                        <button type="submit" class="btn green">{{ Lang::get('main.add') }}</button>
                    </div>
                </div>


                <div class="clearfix"></div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('scriptCode')
    <script>
        $(document).ready(function () {
            $('.module_name').select2();
            $(document).on('change', '#all_projects', function () {
                if ($(this).is(':checked')) {
                    $("#projects_ids").attr('disabled', 'disabled');
                } else {
                    $("#projects_ids").removeAttr('disabled')
                }
            });
        });
        // $(document).ready(function () {
        //
        //     // function validate(formData, jqForm, options) {
        //     //     var form = jqForm[0];
        //     //     if (!form.file.value) {
        //     //         alert('File not found');
        //     //         return false;
        //     //     }
        //     // }
        //
        //     var bar = $('.bar');
        //     var percent = $('.percent');
        //     var status = $('#status');
        //
        //     $('form').ajaxForm({
        //         // beforeSubmit: validate,
        //         beforeSend: function () {
        //             status.empty();
        //             var percentVal = '0%';
        //             bar.width(percentVal);
        //             percent.html(percentVal);
        //         },
        //         uploadProgress: function (event, position, total, percentCompvare) {
        //             var percentVal = percentCompvare + '%';
        //             bar.width(percentVal);
        //             percent.html(percentVal);
        //         },
        //         success: function (data) {
        //             console.log('data is: ' + data);
        //             if (!data.success) {
        //                 // var percentVal = 'Please try again!';
        //                 // bar.css('background-color', '#f8d7da');
        //                 // percent.css('color', '#721c24');
        //                 // bar.width(percentVal);
        //                 // percent.html(percentVal);
        //                 $("#messages").html(data.message);
        //                 $([document.documentElement, document.body]).animate({
        //                     scrollTop: $("#messages").offset().top
        //                 }, 2000);
        //             } else {
        //                 var percentVal = 'Wait, Saving';
        //                 bar.css('background-color', '#B4F5B4');
        //                 percent.css('color', '#7F98B2');
        //                 bar.width(percentVal);
        //                 percent.html(percentVal);
        //             }
        //         },
        //         complete: function (xhr) {
        //             console.log(xhr);
        //             if (xhr.statusText == 'OK' && xhr.responseText == "" && $('input[name=name]').val() != '' && $('input[name=title]').val() != '') {
        //                 window.location.reload();
        //             } else if (xhr.statusText != 'OK') {
        //                 var percentVal = 'Please try again!';
        //                 bar.css('background-color', '#f8d7da');
        //                 percent.css('color', '#721c24');
        //                 bar.width(percentVal);
        //                 percent.html(percentVal);
        //             }
        //         }
        //     });
        // });
    </script>
@endsection
