<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Expose API
    |--------------------------------------------------------------------------
    |
    | This will expose the editor variable.
    | It can be accessed via a window.gjsEditor
    |
    */

    'expose_api' => false,

    /*
    |--------------------------------------------------------------------------
    | Routes
    |--------------------------------------------------------------------------
    |
    | Routes Settings
    |
    */

    'routes' => [
        'middleware' => [
            'web', 'auth',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Force Class
    |--------------------------------------------------------------------------
    |
    | @See https://github.com/artf/grapesjs/issues/546
    |
    */

    'force_class' => false,

    /*
    |--------------------------------------------------------------------------
    | Global Styles
    |--------------------------------------------------------------------------
    |
    | Global Styles for the editor blade file.
    */

    'styles' => [
        'vendor/laravel-grapesjs/assets/editor.css'
    ],

    /*
    |--------------------------------------------------------------------------
    | Global Scripts
    |--------------------------------------------------------------------------
    |
    | Global scripts for the editor blade file.
    */

    'scripts' => [
        'vendor/laravel-grapesjs/assets/editor.js'
    ],

    /*
    |--------------------------------------------------------------------------
    | Canvas styles and scripts
    |--------------------------------------------------------------------------
    |
    | The styles and scripts for the editor content.
    | You need to add these also to your layout.
    | e.g the bootstrap files, etc
    |
    */

    'canvas' => [
        'styles' => [
            'https://e3melbusinesscourses.elbazdev.com/newassets/style/common.min.css?v=1',
            'https://e3melbusinesscourses.elbazdev.com/newassets/style/courses-page.min.css',
            'https://e3melbusinesscourses.elbazdev.com/newassets/style/mobile.min.css?v=',
            'https://e3melbusinesscourses.elbazdev.com/newassets/style/tablet.min.css?v=',
            'https://e3melbusinesscourses.elbazdev.com/newassets/bootstrap-5.0.2-dist/css/bootstrap.min.css?v=',
            'https://e3melbusinesscourses.elbazdev.com/newassets/style/slick-theme.min.css?v=',
            'https://e3melbusinesscourses.elbazdev.com/newassets/style/slick.min.css?v=',
            'https://e3melbusinesscourses.elbazdev.com/assets/js/fancebox/source/jquery.fancybox.css?v=',
            'https://e3melbusinesscourses.elbazdev.com/assets/js/fancebox/source/helpers/jquery.fancybox-thumbs.css?v=',
            'https://e3melbusinesscourses.elbazdev.com/assets/js/fancebox/source/helpers/jquery.fancybox-buttons.css?v=1.0.5',
            'https://e3melbusinesscourses.elbazdev.com/assets/js/fancebox/source/helpers/jquery.fancybox-thumbs.css?v=',

            '',
            '',
            '',
            '',
            '',
        ],
        'scripts' => [
            'https://e3melbusinesscourses.elbazdev.com/newassets/js/jquery-3.5.1.min.js?v=1.1',
            'https://e3melbusinesscourses.elbazdev.com/newassets/js/player_api.js?v=',
            'https://e3melbusinesscourses.elbazdev.com/assets/js/js.cookie.js?v=',
            'https://e3melbusinesscourses.elbazdev.com/newassets/bootstrap-5.0.2-dist/js/bootstrap.bundle.min.js?v=',
            'https://e3melbusinesscourses.elbazdev.com/newassets/js/jquery-ui.js?v=',
            'https://e3melbusinesscourses.elbazdev.com/assets/js/validate/jquery.js?v=',
            'https://e3melbusinesscourses.elbazdev.com/assets/js/validate/jquery.validate.min.js?v=',
            'https://e3melbusinesscourses.elbazdev.com/assets/js/validate.js?ver=',
            'https://e3melbusinesscourses.elbazdev.com/assets/js/action/refer.min.js?ver=',
            'https://e3melbusinesscourses.elbazdev.com/newassets/js/slick.min.js?v=',
            'https://e3melbusinesscourses.elbazdev.com/newassets/js/swiper.js?v=',
            'https://e3melbusinesscourses.elbazdev.com/assets/js/fancebox/source/jquery.fancybox.min.js?v=',

            'https://e3melbusinesscourses.elbazdev.com/assets/js/fancebox/source/helpers/jquery.fancybox-buttons.js?v=1.0.5',

            'https://e3melbusinesscourses.elbazdev.com/assets/js/fancebox/source/helpers/jquery.fancybox-thumbs.min.js?v=',
            'https://e3melbusinesscourses.elbazdev.com/assets/js/fancebox/source/helpers/jquery.fancybox-media.min.js?v=',
            'https://e3melbusinesscourses.elbazdev.com/assets/js/fancebox/source/helpers/jquery.fancybox-buttons.js?v=1.0.5',
            'https://e3melbusinesscourses.elbazdev.com/newassets/js/main.js?v=',
            'https://e3melbusinesscourses.elbazdev.com/newassets/js/bootstrap.min.js',
            '',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Assets Manager
    |--------------------------------------------------------------------------
    |
    | Here you can configure the disk and custom upload URL for your asset
    | manager.
    |
    */

    'assets' => [
        'disk' => 'public', //Default: local
        'path' => null, //Default: 'laravel-grapesjs/media',
        'upload_url' => null,
    ],

    /*
    |--------------------------------------------------------------------------
    | Style Manager
    |--------------------------------------------------------------------------
    |
    | Enable/Disable selectors.
    | @see https://grapesjs.com/docs/api/style_manager.html#stylemanager
    |
    */

    'style_manager' => [
        'limited_selectors' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | Storage Manager
    |--------------------------------------------------------------------------
    |
    | Enable/Disable the autosave function for your editor.
    |
    */

    'storage_manager' => [
        'autosave' => true,
        'steps_before_save' => 10,
    ],

    /*
    |--------------------------------------------------------------------------
    | Plugin Manager
    |--------------------------------------------------------------------------
    |
    | You can enable/disable built-in plugins or can add any custom plugin from
    | this config. Formats for custom plugins are as below.
    |
    | 1. Simplest way
    |   'plugin-name' => 'https://url_to_plugin_script.com'
    |
    | 2. Simple with options (Plugin script will be added to global scrips above)
    |   'plugin-name' => [
    |       //plugin options goes here
    |     ]
    |
    | 3. Advanced way
    |   [
    |       'enabled => true,
    |       'name' => 'plugin-name',
    |       'styles' => [
    |           'https://url_to_plugin_styles.com',
    |       ],
    |       'scripts' => [
    |           'https://url_to_plugin_script.com',
    |       ],
    |       'options' => [
    |           //plugin options goes here
    |       ],
    |   ]
    |
    */

    'plugins' => [
        'default' => [
            'basic_blocks' => true,
            'bootstrap4_blocks' => false,
            'code_editor' => true,
            'image_editor' => false,
            'custom_fonts' => [],
            'templates' => true,
        ],
        'custom' => [
            'grapesjs-custom-code' => 'https://unpkg.com/grapesjs-custom-code',
            [
                'enabled' => true,
                'name' => 'gjs-plugin-ckeditor',
                'scripts' => [
                    'https://cdn.ckeditor.com/4.14.0/full-all/ckeditor.js',
                    'https://unpkg.com/grapesjs-plugin-ckeditor',
                ],
                'options' => [
                    'position' => 'left',
                    /**
                     * Config options for CKeditor
                     * Available options can be found here https://ckeditor.com/docs/ckeditor4/latest/api/CKEDITOR_config.html
                     * Or you can use config builder https://cdn.ckeditor.com/4.14.0/full-all/samples/toolbarconfigurator/index.html
                     */
                    'options' => [
                        'toolbarGroups' => [
                            [ "name" => "document", "groups" => [ "mode", "document", "doctools" ] ],
                            [ "name" => "clipboard", "groups" => [ "clipboard", "undo" ] ],
                            [ "name" => "editing", "groups" => [ "find", "selection", "spellchecker", "editing" ] ],
                            [ "name" => "forms", "groups" => [ "forms" ] ],
                            [ "name" => "basicstyles", "groups" => [ "basicstyles", "cleanup" ] ],
                            [ "name" => "styles", "groups" => [ "styles" ] ],
                            [ "name" => "paragraph", "groups" => [ "list", "indent", "blocks", "align", "bidi", "paragraph" ] ],
                            [ "name" => "links", "groups" => [ "links" ] ],
                            [ "name" => "insert", "groups" => [ "insert" ] ],
                            [ "name" => "colors", "groups" => [ "colors" ] ],
                            [ "name" => "tools", "groups" => [ "tools" ] ],
                            [ "name" => "others", "groups" => [ "others" ] ],
                            [ "name" => "about", "groups" => [ "about" ] ]
                        ],
                        'removeButtons' => 'Save,NewPage,Preview,Print,Templates,Source,Form,Checkbox,Radio,TextField,Textarea,Select,Button,ImageButton,HiddenField,Flash,Table,About'
                    ],
                ],
            ],
            [
                'enabled' => false,
                'name' => 'grapesjs-plugin-forms',
                'options' => [],
                'scripts' => [
                    'https://unpkg.com/grapesjs-plugin-forms',
                ],
            ],
        ],
    ],
];
