<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;


class UserCV extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'users_cv';

    public function user()
    {
        return $this->belongsTo('App\Models\NormalUser','user_id');
    }

    public function cv_logs()
    {
        return $this->hasMany('App\Models\UserCVLog','user_cv_id');
    }
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'update',$model->getTable(),$model->id,$model->toJson());
        });
        static::created(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'create',$model->getTable(),$model->id,$model->toJson());
        });
        static::deleted(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'delete',$model->getTable(),$model->id,$model->toJson());
        });
    }
}
