<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;


class TrainingProgramChargeTransaction extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'training_program_charge_transaction';

    public function user()
    {
        return $this->belongsTo('App\Models\NormalUser','user_id');
    }
    /*
         *
         * retrieved : after a record has been retrieved.
         * creating : before a record has been created.
         * created : after a record has been created.
         * updating : before a record is updated.
         * updated : after a record has been updated.
         * saving : before a record is saved (either created or updated).
         * saved : after a record has been saved (either created or updated).
         * deleting : before a record is deleted or soft-deleted.
         * deleted : after a record has been deleted or soft-deleted.
         * restoring : before a soft-deleted record is going to be restored.
         * restored : after a soft-deleted record has been restored.
         *
         * */
    protected static function boot()
    {
        parent::boot();
        if(Auth::check()){
            static::updated(function ($model) {
                sendTrainingProgramsChargeTransaction($model->id);
                updateAcademyChargeTransaction($model->user_id);
                log_admin_action(Auth::user()->id,Auth::user()->username,'update',$model->getTable(),$model->id,$model->toJson());
            });
            static::created(function ($model) {
                sendTrainingProgramsChargeTransaction($model->id);
                updateAcademyChargeTransaction($model->user_id);
                log_admin_action(Auth::user()->id,Auth::user()->username,'create',$model->getTable(),$model->id,$model->toJson());
            });
            static::deleted(function ($model) {
                deleteChargeTransactionFromCRM($model->id,'training program transaction');
                updateAcademyChargeTransaction($model->user_id);
                log_admin_action(Auth::user()->id,Auth::user()->username,'delete',$model->getTable(),$model->id,$model->toJson());
            });
        }

    }
}
