<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;


class RecruitmentCompany extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'recruitment_companies';

    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'update',$model->getTable(),$model->id,$model->toJson());
        });
        static::created(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'create',$model->getTable(),$model->id,$model->toJson());
        });
        static::deleted(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'delete',$model->getTable(),$model->id,$model->toJson());
        });
    }

    public function industry(){
        return $this->belongsTo('App\Models\RecruitmentIndustry','industry_id');
    }
    public function country(){
        return $this->belongsTo('App\Models\Country','country_id');
    }
    public function city(){
        return $this->belongsTo('App\Models\City','city_id');
    }
    public function state(){
        return $this->belongsTo('App\Models\State','state_id');
    }
}
