<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class DiplomasSupplementaryTestsQuestionsDetails extends Model
{
    use SoftDeletes;
    public $timestamps = false;
    protected $softDelete = true;
    public $connection = 'mysql2';
    protected $table = 'diplomas_supplementary_tests_questions_details';
    protected $fillable =
    [
        'diplomas_supplementary_id',
        'language',
        'quetion_id',
        'name',
        'image',
        'answer',
        'order',
        'name_en',
        'createdtime',
        'deleted_at',
        'deleted_by',
        'deleted_at_old',
    ];

    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            $action=$model->trashed()?'delete':'update';
            log_admin_action(Auth::user()->id,Auth::user()->username,$action,$model->getTable(),$model->id,$model->toJson());
        });
        static::created(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'create',$model->getTable(),$model->id,$model->toJson());
        });
        static::deleted(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'delete',$model->getTable(),$model->id,$model->toJson());
        });
    }

}
