<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class DiplomasSupplementaryTestsQuestions extends Model
{
    use SoftDeletes;
    public $timestamps = false;
    protected $softDelete = true;
    public $connection = 'mysql2';
    protected $table = 'diplomas_supplementary_tests_questions';
    protected $fillable =
    [
        'type',
        'diplomas_supplementary_id',
        'language',
        'name',
        'createdtime',
        'modifiedtime',
        'image',
        'name_en',
        'deleted_at',
        'deleted_by',
        'deleted_at_old',
    ];

    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            $action=$model->trashed()?'delete':'update';
            log_admin_action(Auth::user()->id,Auth::user()->username,$action,$model->getTable(),$model->id,$model->toJson());
        });
        static::created(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'create',$model->getTable(),$model->id,$model->toJson());
        });
        static::deleted(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'delete',$model->getTable(),$model->id,$model->toJson());
        });
    }

    public function DiplomasSupplementaryTestsQuestionsDetails(){
        if($this->type=='true_false'){
            return $this->hasOne('App\Models\DiplomasSupplementaryTestsQuestionsDetails','quetion_id')->orderBy('id','ASC');
        }else{
            return $this->hasMany('App\Models\DiplomasSupplementaryTestsQuestionsDetails','quetion_id')->orderBy('order','ASC')->orderBy('id','ASC');
        }
    }

    public function CurriculumQuestionsDetails(){
        if($this->type=='true_false'){
            return $this->hasOne('App\Models\CurriculumQuestionsDetails','quetion_id')->orderBy('id','ASC');
        }else{
            return $this->hasMany('App\Models\CurriculumQuestionsDetails','quetion_id')->orderBy('order','ASC')->orderBy('id','ASC');
        }
    }

}
