<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;


class CoursesCurriculum extends Model
{
    public $timestamps = false;
    use SoftDeletes;
    protected $softDelete = true;
    public $connection = 'mysql2';
    protected $table = 'cources_curriculum';

    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            $action=$model->trashed()?'delete':'update';
            log_admin_action(Auth::user()->id,Auth::user()->username,$action,$model->getTable(),$model->id,$model->toJson());
            $date=date('Y-m-d H:i:s');
            $query="UPDATE courses SET modifiedtime='$date' WHERE id='$model->course_id'";
            DB::connection('mysql2')->unprepared($query);
            self::trigger($model);
        });
        static::created(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'create',$model->getTable(),$model->id,$model->toJson());
            $date=date('Y-m-d H:i:s');
            $query="UPDATE courses SET modifiedtime='$date' WHERE id='$model->course_id'";
            DB::connection('mysql2')->unprepared($query);
            self::trigger($model);
        });
        static::deleted(function ($model) {
            log_admin_action(Auth::user()->id,Auth::user()->username,'delete',$model->getTable(),$model->id,$model->toJson());
            self::trigger($model);
        });
    }

    public function section()
    {
        return $this->belongsTo('App\Models\CoursesSections','section_id');
    }
    public function course()
    {
        return $this->belongsTo('App\Models\Courses','course_id');
    }

    public static function trigger($model)
    {
        $curriculumNumber=DB::connection('mysql2')->table('cources_curriculum')->where('cources_curriculum.course_id', $model->course_id)->where('cources_curriculum.type','default')->whereNull('deleted_at')->count();
        $query="update courses set curriculum_number ='$curriculumNumber' where id='$model->course_id'" ;
        DB::connection('mysql2')->unprepared($query);
        $query="update users_course_view_completed set total ='$curriculumNumber' where course_id='$model->course_id'" ;
        DB::connection('mysql2')->unprepared($query);
    }
}
