<?php

namespace App\Http\Controllers\Admin;


use App\Http\Controllers\Controller;
use App\Models\UserPdf;
use App\Models\UserPdfTemplate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Response;
use Maatwebsite\Excel\Facades\Excel;


class UsertemplatesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.users_pdf_templete_log.view');
    }

    function search(Request $request)
    {
        $data = $request->input();
        $log = UserPdfTemplate::select('*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $log = $log->where('users_pdf_templete_log.id', '=', $id);
        }
        if (isset($data['user_id']) && !empty($data['user_id'])) {
            $id = $data['user_id'];
            $log = $log->where('users_pdf_templete_log.user_id', '=', $id);
        }
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $user_email = $data['user_email'];
            $log = $log->where('users_pdf_templete_log.Email', 'LIKE', "%$user_email%");
        }
        if (isset($data['user_name']) && !empty($data['user_name'])) {
            $user_name = $data['user_name'];
            $log = $log->where('users_pdf_templete_log.FullName', 'LIKE', "%$user_name%");
        }
        if (isset($data['user_ةmobile']) && !empty($data['user_ةmobile'])) {
            $user_ةmobile = $data['user_ةmobile'];
            $log = $log->where('users_pdf_templete_log.Mobile', 'LIKE', "%$user_ةmobile%");
        }
        if (isset($data['file']) && !empty($data['file'])) {
            $file = $data['file'];
            $log = $log->where('users_pdf_templete_log.pdf', 'LIKE', "%$file%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $log = $log->whereBetween('users_pdf_templete_log.RegisterDate', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }


        $iTotalRecords = $log->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'users_pdf_templete_log.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'users_pdf_templete_log.id';
                break;
             case 1:
                $columnName = 'users_pdf_templete_log.user_id';
                break;
            case 2:
                $columnName = 'users_pdf_templete_log.Email';
                break;
            case 3:
                $columnName = 'users_pdf_templete_log.FullName';
                break;
            case 4:
                $columnName = 'users_pdf_templete_log.Mobile';
                break;
            case 5:
                $columnName = 'users_pdf_templete_log.pdf';
                break;
            case 6:
                $columnName = 'users_pdf_templete_log.RegisterDate';
                break;

        }

        $search = $data['search']['value'];
        if ($search) {
            $log = $log->where(function ($q) use ($search) {
                $q->where('users_pdf_templete_log.id', '=', $search)
                    ->orWhere('users_pdf_templete_log.Email', 'Like', "%$search%")
                    ->orWhere('users_pdf_templete_log.user_id', 'Like', "%$search%")
                    ->orWhere('users_pdf_templete_log.FullName', 'Like', "%$search%")
                    ->orWhere('users_pdf_templete_log.Mobile', 'Like', "%$search%")
                    ->orWhere('users_pdf_templete_log.file', 'Like', "%$search%");

            });
        }

        $log = $log->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($log as $log_record) {

            $records["data"][] = [
                $log_record->id,
                $log_record->user_id,
                $log_record->Email,
                $log_record->FullName,
                $log_record->Mobile,
                '<a href='.e3mURL('assets/images/'. urlencode(basename($log_record->pdf->file))).' target="_blank">' .$log_record->pdf->name.'</a>',
                $log_record->RegisterDate,
                ''
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function export()

    {

//        return Excel::download(new Coursesusers_pdf_templete_logExport(), 'Courses_users_pdf_templete_logs.xlsx');
        $request = Request();
        $data = $request->input();
        $output = [
            '#',
            'User ID',
            'User Email',
            'User Name',
            'User Mobile',
            'File',
            'Register Date'

        ];

        $log = UserPdfTemplate::select(
            'id',
            'user_id',
            'Email',
            'FullName',
            'Mobile',
            'pdf',
            'RegisterDate'
        );
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $log = $log->where('users_pdf_templete_log.id', '=', $id);
        }
        if (isset($data['user_id']) && !empty($data['user_id'])) {
            $id = $data['user_id'];
            $log = $log->where('users_pdf_templete_log.user_id', '=', $id);
        }
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $user_email = $data['user_email'];
            $log = $log->where('users_pdf_templete_log.Email', 'LIKE', "%$user_email%");
        }
        if (isset($data['user_name']) && !empty($data['user_name'])) {
            $user_name = $data['user_name'];
            $log = $log->where('users_pdf_templete_log.FullName', 'LIKE', "%$user_name%");
        }
        if (isset($data['user_ةmobile']) && !empty($data['user_ةmobile'])) {
            $user_ةmobile = $data['user_ةmobile'];
            $log = $log->where('users_pdf_templete_log.Mobile', 'LIKE', "%$user_ةmobile%");
        }
        if (isset($data['file']) && !empty($data['file'])) {
            $file = $data['file'];
            $log = $log->where('users_pdf_templete_log.pdf', 'LIKE', "%$file%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $log = $log->whereBetween('users_pdf_templete_log.RegisterDate', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }

        $log = $log->orderBy('id', 'desc')->get();


        $filename = "Users_pdf_templete_log.csv";
        $handle = fopen($filename, 'w+');
        fputcsv($handle, $output);

        foreach ($log as $log_record) {
            fputcsv($handle, [
                $log_record->id,
                $log_record->user_id,
                $log_record->Email,
                $log_record->FullName,
                $log_record->Mobile,
                $log_record->pdf,
                $log_record->RegisterDate
            ]);
        }

        fclose($handle);

        $headers = array(
            'Content-Type' => 'text/csv',
            'Content-Disposition' => 'attachment; filename="Users_pdf_templete_log.csv"'
        );


        return Response::download($filename, 'users_pdf_templete_log.csv', $headers);

    }


}
