<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\UserSurvey;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Response;

class UserSurveyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public $_arrayOfCol=[
        'age',
        'gender',
        'education_level',
        'job',
        'country',
        'state',
        'recommend_relatives_friends',
        'satisfied_with_price',
        'satisfied_with_quality',
        'satisfied_with_credits',
        'problem_resolved_last_call',
        'subscribe_new_service',
        'fav_contact',
        'number_of_contact',
        'content_prefer_for_contact',
        'new_category_need_to_add',
        'comment'
    ];
    public function index()
    {
        $colNames="'".implode("','",$this->_arrayOfCol)."'";
        $columnDetails=DB::select("SELECT COLUMN_NAME AS col_name,COLUMN_COMMENT AS col_comment
          FROM INFORMATION_SCHEMA.COLUMNS
          WHERE TABLE_NAME = ? AND COLUMN_NAME IN ($colNames)",['user_survey']);
//        dd(getEloquentSqlWithBindings($columnDetails),$columnDetails->get());
        return view('auth.user_survey.view',compact('columnDetails'));
    }

    function search(Request $request)
    {

        $colNames="'".implode("','",$this->_arrayOfCol)."'";
        $columnDetails=DB::select("SELECT COLUMN_NAME AS col_name,COLUMN_COMMENT AS col_comment
          FROM INFORMATION_SCHEMA.COLUMNS
          WHERE TABLE_NAME = ? AND COLUMN_NAME IN ($colNames)",['user_survey']);
        $data = $request->input();
        $report = UserSurvey::select(
            'users.FullName AS user_name',
            'users.email AS user_email',
            'user_survey.*'
        )
            ->join('users','users.id','=','user_survey.user_id')
        ;
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $report = $report->where('user_survey.id', '=', $id);
        }
        if (isset($data['user_name']) && !empty($data['user_name'])) {
            $user_name = $data['user_name'];
            $report = $report->where('users.FullName', 'LIKE', '%'.$user_name.'%');
        }
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $user_email = $data['user_email'];
            $report = $report->where('users.Email', '=', $user_email);
        }
        foreach ($columnDetails as $col){
            if (isset($data[$col->col_name]) && !empty($data[$col->col_name])) {
                $$col->col_name = $data[$col->col_name];
                $report = $report->where('user_survey.'.$col->col_name, 'LIKE', '%'.$$col->col_name.'%');
            }
        }


        if(!empty($data['created_time_from'])||!empty($data['created_time_to'])){
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            if($created_time_from&&$created_time_to){
                $report = $report->whereBetween('user_survey.created_at', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
            }elseif($created_time_to){
                $report=$report->where(DB::raw('DATE_FORMAT(user_survey.created_at,"%Y-%m-%d")'),'<=',$created_time_to);
            }elseif($created_time_from){
                $report=$report->where(DB::raw('DATE_FORMAT(user_survey.created_at,"%Y-%m-%d")'),'>=',$created_time_from);
            }
        }
            //dd($report->toSql(),$created_time_from);
        $iTotalRecords = $report->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'user_survey.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'user_survey.id';
                break;
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'user_survey.age';
                break;
            case 4:
                $columnName = 'user_survey.gender';
                break;
            case 5:
                $columnName = 'user_survey.education_level';
                break;
            case 6:
                $columnName = 'user_survey.job';
                break;
            case 7:
                $columnName = 'user_survey.country';
                break;
            case 8:
                $columnName = 'user_survey.state';
                break;
            case 9:
                $columnName = 'user_survey.recommend_relatives_friends';
                break;
            case 10:
                $columnName = 'user_survey.satisfied_with_price';
                break;
            case 11:
                $columnName = 'user_survey.satisfied_with_quality';
                break;
            case 12:
                $columnName = 'user_survey.max_table1';
                break;
            case 13:
                $columnName = 'user_survey.satisfied_with_credits';
                break;
            case 14:
                $columnName = 'user_survey.problem_resolved_last_call';
                break;
            case 15:
                $columnName = 'user_survey.subscribe_new_service';
                break;
            case 16:
                $columnName = 'user_survey.max_table3';
                break;
            case 17:
                $columnName = 'user_survey.fav_contact';
                break;
            case 18:
                $columnName = 'user_survey.number_of_contact';
                break;
            case 19:
                $columnName = 'user_survey.content_prefer_for_contact';
                break;
            case 20:
                $columnName = 'user_survey.comment';
                break;
            case 21:
                $columnName = 'user_survey.created_at';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $report = $report->where(function ($q) use ($search) {
                $q->where('users.FullName', '=', $search)
                    ->orWhere('users.Email', 'LIKE', "%$search%")
                    ->orWhere('user_survey.age', 'LIKE', "%$search%")
                    ->orWhere('user_survey.gender', 'LIKE', "%$search%")
                    ->orWhere('user_survey.education_level', 'LIKE', "%$search%")
                    ->orWhere('user_survey.job', 'LIKE', "%$search%")
                    ->orWhere('user_survey.country', 'LIKE', "%$search%")
                    ->orWhere('user_survey.state', 'LIKE', "%$search%")
                ;

            });
        }
        if($request->export){
            $report = $report->orderBy($columnName, $data['order'][0]['dir'])->get();
            $output=[];
            $output[]='#';
            $output[]=Lang::get('main.user');
            $output[]=Lang::get('main.email');
            foreach($columnDetails as $col){
                $output[]=$col->col_comment;
            }
            $output[]=Lang::get('main.created_time');

            $filename = 'user_survey_'.time().'.csv';
            $handle = fopen($filename, 'w+');
            fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
            fputcsv($handle, $output);

            foreach ($report as $r) {
                $arrayD=[
                    $r->id,
                    $r->user_name,
                    $r->user_email,
                ];
                foreach ($columnDetails as $col){
                    $n=$col->col_name;
                    $arrayD[]=$r->$n;
                }
                $arrayD[]=$r->created_at->format('Y-m-d H:i:s');
                fputcsv($handle,$arrayD);
            }
            fclose($handle);
            $headers = array(
                'Content-Type' => 'text/csv;',
                'Content-Disposition' => 'attachment; filename="'.$filename.'"'
            );
            return Response::download($filename, $filename, $headers);
        }
        $report = $report->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        foreach ($report as $r) {
            $arrayD=[
                $r->id,
                $r->user_name,
                $r->user_email,
            ];
            foreach ($columnDetails as $col){
                $n=$col->col_name;
                $arrayD[]=$r->$n;
            }
            $arrayD[]=$r->created_at->format('Y-m-d H:i:s');
            $arrayD[]='';
            $records["data"][]=$arrayD;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }
}
