<?php

namespace App\Http\Controllers\Admin;

use App\Models\Diplomas;
use App\Models\Profiles;
use App\Models\UnihanceIntegrations;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;

class UnihanceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.unihance.view');
    }
    public function search(Request $request)
    {
        $data = $request->input();
        $unihances = UnihanceIntegrations::select('unihance_integrations.id','unihance_integrations.diploma_id','diplomas.name','unihance_integrations.code','unihance_integrations.created_at')->leftJoin('diplomas','diplomas.id','=','unihance_integrations.diploma_id');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $unihances = $unihances->where('unihance_integrations.id', '=', $id);
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $unihances = $unihances->where('diplomas.name', 'LIKE', "%$name%");
        }
        if (isset($data['code']) && !empty($data['code'])) {
            $code = $data['code'];
            $unihances = $unihances->where('unihance_integrations.code', 'LIKE', "%$code%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $unihances = $unihances->whereBetween('unihance_integrations.created_at', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }
        $iTotalRecords = $unihances->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'diplomas.id';
                break;
            case 1:
                $columnName = 'diplomas.name';
                break;
            case 3:
                $columnName = 'unihance_integrations.code';
                break;
            case 4:
                $columnName = 'unihance_integrations.created_at';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $unihances = $unihances->where(function ($q) use ($search) {
                $q->where('diplomas.name', 'LIKE', "%$search%")
                    ->orWhere('diplomas.id', '=', $search);
            });
        }

        $unihances = $unihances->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($unihances as $unihance) {
            $records["data"][] = [
                $unihance->id,
                $unihance->name,
                $unihance->code,
                $unihance->created_at->format('Y-m-d H:i:s'),
                '<div class="btn-group text-center" id="single-order-' . $unihance->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('unihance_edit')) ? '<li>
                                            <a href="' . URL('admin/unihance/' . $unihance->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('unihance_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $unihance->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $diplomas=Diplomas::where('published','yes')->whereNotIn('id',UnihanceIntegrations::pluck('diploma_id')->toArray())->pluck('name','id')->toArray();
        return view('auth.unihance.add',compact('diplomas'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $data=$request->input();
        $validator = Validator::make($request->all(),
            array(
                'diploma_id'=>'required|unique:mysql2.unihance_integrations,diploma_id',
                'code'=>'required|unique:mysql2.unihance_integrations,code',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $unihances=new UnihanceIntegrations();
            $unihances->diploma_id=$data['diploma_id'];
            $unihances->code=$data['code'];
            $unihances->created_by=Auth::user()->id;
            $unihances->created_at=date("Y-m-d H:i:s");
            if($unihances->save()){
                Session::flash('success', Lang::get('main.insert').Lang::get('main.unihance'));
                return Redirect::to('admin/unihance/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $post=UnihanceIntegrations::where('id','!=',Auth::user()->id)->where('id','!=',1)->find($id);
        if(count($post)){
            $post=makeDefaultImage($post,'unihance');
            $profiles=Profiles::where('active',1)->get();
            $projects=UnihanceIntegrations::where('active',1)->get();
            return view('auth.unihance.edit',compact('post','profiles','projects'));
        }else{
            return abort(404);
        }

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $data=$request->input();
        $unihances= UnihanceIntegrations::find($id);
        if(count($unihances)){
            $validator = Validator::make($request->all(),
                array(
                    'name'=>'required',
                    'email'=>'required|unique:unihance,email,'.$id,
                    'username'=>'required|unique:unihance,username,'.$id,
                ));
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator->errors())->withInput();
            }else {
                if(!empty($data['password'])){
                    $validator = Validator::make($request->all(),
                        array(
                            'password'=>'required|min:6',
                            'confirm_password'=>'required|same:password',
                        ));
                    if ($validator->fails()) {
                        return redirect()->back()->withErrors($validator->errors())->withInput();
                    }else {
                        $unihances->password=Hash::make($data['password']);
                    }
                }
                if(Input::hasFile('image')){
                    $validator = Validator::make($request->all(),array(
                        'image' => 'mimes:jpeg,jpg,png,gif|required|max:5000'
                    ));
                    if ($validator->fails()) {
                        return redirect()->back()->withErrors($validator->errors())->withInput();
                    }else{
                        if(file_exists(public_path().$unihances->img_dir.$unihances->img)&&!empty($unihances->img_dir)){
                            unlink(public_path().$unihances->img_dir.$unihances->img);
                        }
                        if(file_exists(public_path().$unihances->img_dir.'thumbnail/thumbnail_'.$unihances->img)&&!empty($unihances->img_dir)){
                            unlink(public_path().$unihances->img_dir.'thumbnail/thumbnail_'.$unihances->img);
                        }
                        $file=$request->file('image');
                        $image=FileImage($file,'unihance');
                        $unihances->img=$image['img'];
                        $unihances->img_dir=$image['img_dir'];
                    }
                }
                $active=(isset($data['active']))?1:0;
                $unihances->profile_id=$data['profile_id'];
                $unihances->name=$data['name'];
                $unihances->email=$data['email'];
                $unihances->username=$data['username'];
                if($active==1&&$unihances->active==0){
                    $unihances->active_by=Auth::user()->id;
                    $unihances->active_date=date("Y-m-d H:i:s");
                }
                if($active==0&&$unihances->active==1){
                    $unihances->unactive_by=Auth::user()->id;
                    $unihances->unactive_date=date("Y-m-d H:i:s");
                }

                $unihances->active=$active;
                $unihances->lastedit_by=Auth::user()->id;
                $unihances->lastedit_date=date("Y-m-d H:i:s");
                if($unihances->save()){
                    Session::flash('success', Lang::get('main.update').Lang::get('main.unihance'));
                    return Redirect::to('admin/unihance/'.$id.'/edit');
                }
            }
        }else{
            return abort(404);
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $unihances=UnihanceIntegrations::find($id);
        if(count($unihances)){
            $unihances->deleted_by=auth()->id();
            $unihances->save();
            $unihances->delete();
//            if($unihances->delete()){
//                $unihances->deleted_by=Auth::user()->id;
//                $unihances->save();
//            }
        }
    }
}
