<?php

namespace App\Http\Controllers\Admin;

use App\Models\TrainingProgram;
use App\Models\TrainingProgramTargets;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class TrainingProgramTargetsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $training_programs = TrainingProgram::pluck('name', 'id');
        return view('auth.training_program_targets.view',compact('training_programs'));
    }

    function search(Request $request)
    {

        $data = $request->input();
        $training_programs_targets = TrainingProgramTargets::leftjoin('training_program','training_program.id','=','training_program_targets.diploma_id')
                            ->select('training_program_targets.*','training_program.name as training_program_name');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $training_programs_targets = $training_programs_targets->where('training_program_targets.id', '=', "$id");
        }
        if (isset($data['training_program']) && !empty($data['training_program'])) {
            $training_program = $data['training_program'];
            $training_programs_targets = $training_programs_targets->where('training_program_targets.diploma_id','=', $training_program);
        }
        if (isset($data['target']) && !empty($data['target'])) {
            $target = $data['target'];
            $training_programs_targets = $training_programs_targets->where('training_program_targets.target', '=', $target);
        }
        if (isset($data['date_from']) && !empty($data['date_from']) && isset($data['date_to']) && !empty($data['date_to'])) {
            $date_from = $data['date_from'];
            $date_to = $data['date_to'];
            $training_programs_targets = $training_programs_targets->whereBetween('training_program_targets.date', [$date_from, $date_to]);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $training_programs_targets = $training_programs_targets->whereBetween('training_program_targets.createtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }

        $iTotalRecords = $training_programs_targets->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'training_program_targets.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'training_program_targets.id';
                break;
            case 1:
                $columnName = 'training_program.name';
                break;
            case 2:
                $columnName = 'training_program_targets.target';
                break;
            case 3:
                $columnName = 'training_program_targets.date';
                break;
            case 4:
                $columnName = 'training_program_targets.createtime';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $training_programs_targets = $training_programs_targets->where(function ($q) use ($search) {
                $q->where('training_program_targets.id', '=', $search)
                    ->orWhere('training_program_targets.target', '=', $search)
                    ->orWhere('training_program.name', 'LIKE', "%$search%");
            });
        }

        $training_programs_targets = $training_programs_targets->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($training_programs_targets as $training_program_target) {
            $training_program_name = $training_program_target->diploma_name;
            if(PerUser('training_program_edit') && $training_program_name !=''){
                $training_program_name= '<a target="_blank" href="' . URL('admin/training_program/' . $training_program_target->diploma_id . '/edit') . '">' . $training_program_name . '</a>';
            }
            $records["data"][] = [
                $training_program_target->id,
                $training_program_name,
                $training_program_target->target,
                $training_program_target->date,
                $training_program_target->createtime,
//                '<td class="text-center">
//                                <div class="checkbox-nice checkbox-inline">
//                                    <input data-id="' . $training_program_target->id . '" type="checkbox" ' . ((!PerUser('TrainingProgram_targets_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('TrainingProgram_targets_publish')) ? 'class="changeStatues"' : '') . ' ' . (($training_program_target->published == "yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
//                                    <label for="checkbox-' . $training_program_target->id . '">
//                                    </label>
//                                </div>
//                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $training_program_target->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('training_program_targets_edit')) ? '<li>
                                            <a href="' . URL('admin/training_program_targets/' . $training_program_target->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('training_program_targets_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $training_program_target->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $training_programs = TrainingProgram::pluck('name', 'id');
        return view('auth.training_program_targets.add',compact('training_programs'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'training_program' =>'required|exists:mysql2.training_program,id',
                'target' => 'required|numeric',
                'date' => 'required|date_format:"Y-m-d"',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            //$published = (isset($data['published'])) ? 'yes' : 'no';
            $training_program_target = new TrainingProgramTargets();
            $training_program_target->diploma_id = $data['training_program'];
            $training_program_target->target = $data['target'];
            $training_program_target->date = $data['date'];
//            $training_program_target->published = $published;
            $training_program_target->createtime = date("Y-m-d H:i:s");
//            if ($published == 'yes') {
//                $training_program_target->published_by = Auth::user()->id;
//                $training_program_target->published_date = date("Y-m-d H:i:s");
//            }
//            if ($published == 'no') {
//                $training_program_target->unpublished_by = Auth::user()->id;
//                $training_program_target->unpublished_date = date("Y-m-d H:i:s");
//            }
            $training_program_target->lastedit_by = Auth::user()->id;
            $training_program_target->added_by = Auth::user()->id;
            $training_program_target->lastedit_date = date("Y-m-d H:i:s");
            $training_program_target->added_date = date("Y-m-d H:i:s");
            if ($training_program_target->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.training_program_targets'));
                return Redirect::to('admin/training_program_targets/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {}

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $training_program_target = TrainingProgramTargets::findOrFail($id);
        $training_programs = TrainingProgram::pluck('name', 'id');
        return view('auth.training_program_targets.edit', compact('training_program_target','training_programs'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $training_program_target = TrainingProgramTargets::findOrFail($id);
        $validator = Validator::make($request->all(),
            array(
                'training_program' =>'required|exists:mysql2.training_program,id',
                'target' => 'required|numeric',
                'date' => 'required|date_format:"Y-m-d"'
            ));

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
//            $published = (isset($data['published'])) ? 'yes' : 'no';
            $training_program_target->diploma_id = $data['training_program'];
            $training_program_target->target = $data['target'];
            $training_program_target->date = $data['date'];
//            if ($published == 'yes' && $training_program_target->published=='no') {
//                $training_program_target->published_by = Auth::user()->id;
//                $training_program_target->published_date = date("Y-m-d H:i:s");
//            }
//            if ($published == 'no' && $training_program_target->published=='yes') {
//                $training_program_target->unpublished_by = Auth::user()->id;
//                $training_program_target->unpublished_date = date("Y-m-d H:i:s");
//            }
//            $training_program_target->published = $published;
            $training_program_target->lastedit_by = Auth::user()->id;
            $training_program_target->lastedit_date = date("Y-m-d H:i:s");
            if ($training_program_target->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.training_program_targets'));
                return Redirect::to("admin/training_program_targets/$training_program_target->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $training_program_target = TrainingProgramTargets::findOrFail($id);
        $training_program_target->delete();
    }

//    public function publish(Request $request)
//    {
//        if ($request->ajax()) {
//            $id = $request->input('id');
//            $published = $request->input('published');
//            $training_program_target = TrainingProgramTargets::findOrFail($id);
//            if ($published == 'no') {
//                $training_program_target->published = 'no';
//                $training_program_target->unpublished_by = Auth::user()->id;
//                $training_program_target->unpublished_date = date("Y-m-d H:i:s");
//            } elseif ($published == 'yes') {
//                $training_program_target->published = 'yes';
//                $training_program_target->published_by = Auth::user()->id;
//                $training_program_target->published_date = date("Y-m-d H:i:s");
//            }
//            $training_program_target->save();
//        } else {
//            return redirect(404);
//        }
//    }





}
