<?php

namespace App\Http\Controllers\Admin;

use App\Models\sessionUsers;

use App\Http\Controllers\Controller;

use App\Models\SuggestionCoursesQuestions;
use App\Models\SuggestionCoursesQuestionsOptions;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;


class SuggestionCoursesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->ajax()){
            $questions=\App\SuggestionCoursesQuestions::orderBy('order')->get();
            $html=view('auth.suggestion_courses.get_questions',compact('questions'))->render();
            return response()->json(['success'=>true,'html'=>$html]);
        }
        return view('auth.suggestion_courses.view');
    }
    public function store(Request $request){
        if($request->data){
            $data=json_decode($request->data);
            foreach ($data as $key=>$item){
                SuggestionCoursesQuestions::where('id',$item->id)->update(['order'=>$key+1]);
            }
            return response()->json(['success'=>true]);
        }
        $valid=[
            'name' => 'required',
            'type' => 'required|in:'.implode(',',getEnumFiledFromTable('suggestion_courses_questions','type')),
        ];
        if($request->type=='options'){
            if($request->answers){
                foreach ($request->answers as $key=>$value){
                    $valid['answers.'.$key]='required';
                    //$valid['courses_ids.'.$key]='required';
                }
                if(!isset($valid['answers.1'])){
                    $valid['answers.1']='required';
                    //$valid['courses_ids.1']='required';
                }
            }else{
                $valid['answers.0']='required';
                //$valid['courses_ids.0']='required';
                $valid['answers.1']='required';
                //$valid['courses_ids.1']='required';
            }
        }
        $validator = Validator::make($request->all(),$valid);
        if ($validator->fails()) {
           return response()->json(['success'=>false,'message'=>'Validation Error','messages'=>$validator->errors()]);
        }else {
            $dataInsertOrUpdate=array_merge($request->only('name','type'),['show_in_suggestion_courses'=>$request->show_in_suggestion_courses?1:0]);
            if($request->item_id){
                SuggestionCoursesQuestions::where('id',$request->item_id)->update($dataInsertOrUpdate);
                $question_id=$request->item_id;
            }else{
                $suggestionCoursesQuestions=SuggestionCoursesQuestions::create($dataInsertOrUpdate);
                $question_id=$suggestionCoursesQuestions->id;
            }
            $ids=[];
            if($request->answers){
                foreach ($request->answers as $key=>$answer){
                    $courses_ids=[];
                    $diplomas_ids=[];
                    $training_programs_ids=[];
                    $mba_ids=[];
                    $dba_ids=[];
                    $annual_subscribtion_ids=[];
                    $result = collect($request->input('courses_ids.'.$key))->contains(function ($value) use(&$courses_ids,&$diplomas_ids,&$training_programs_ids,&$mba_ids
                    ,&$dba_ids,&$annual_subscribtion_ids) {
                    if(Str::contains($value, 'courses_')){
                        array_push($courses_ids,str_replace('courses_','',$value));
                    }
                    if(Str::contains($value, 'diplomas_')){
                        array_push($diplomas_ids,str_replace('diplomas_','',$value));
                    } if(Str::contains($value, 'training_programs_')){
                        array_push($training_programs_ids,str_replace('training_programs_','',$value));
                    }
                    if(Str::contains($value, 'DBA')){
                        array_push($dba_ids,1);
                    }
                    if(Str::contains($value, 'MBA')){
                        array_push($mba_ids,1);
                    }
                    if(Str::contains($value, 'AnnualSubscription')){
                        array_push($annual_subscribtion_ids,1);
                    }
                    });

                    $array=[
                        'suggestion_courses_question_id'=>$question_id,
                        'name'=>$answer,
                        'courses_ids'=>json_encode($courses_ids),
                        'diplomas_ids'=>json_encode($diplomas_ids),
                        'training_programs_ids'=>json_encode($training_programs_ids),
                        'mba_ids'=>json_encode($mba_ids),
                        'dba_ids'=>json_encode($dba_ids),
                        'subscriptions'=>json_encode($request->input('courses_ids.'.$key)?$request->input('courses_ids.'.$key):[]),
                        'annual_subscribtion_ids'=>json_encode($annual_subscribtion_ids),
                    ];
                    $answer_id=$request->input('answer_id.'.$key);
                    if($answer_id){
                        SuggestionCoursesQuestionsOptions::where('id',$answer_id)->update($array);
                        $ids[]=$answer_id;
                    }else{
                        $suggestionCoursesQuestionsOptions=SuggestionCoursesQuestionsOptions::create($array);
                        $ids[]=$suggestionCoursesQuestionsOptions->id;
                    }
                }
            }
            SuggestionCoursesQuestionsOptions::where('suggestion_courses_question_id',$question_id)->whereNotIn('id',$ids)->delete();
            return response()->json(['success'=>true,'message'=>'Success Added']);
        }
    }
    public function destroy($id){
        $suggestionCoursesQuestions=SuggestionCoursesQuestions::find($id);
        if($suggestionCoursesQuestions){
            $suggestionCoursesQuestions->Options()->update([
                'deleted_by'=>auth()->id(),
                'deleted_at'=>date('Y-m-d H:i:s'),
            ]);
            $suggestionCoursesQuestions->update([
                'deleted_by'=>auth()->id(),
                'deleted_at'=>date('Y-m-d H:i:s'),
            ]);
            return response()->json(['success'=>true,'message'=>'Deleted Successfully']);
        }
        return response()->json(['success'=>false,'message'=>'No record found']);
    }
    public function sort(Request $request){
        foreach($request->get('order') as $id => $order) {
            SuggestionCoursesQuestions::find($id)->update(['order' => $order]);
        }
    }
    public function show($id){
        $question=SuggestionCoursesQuestions::find($id);
        if($question){
            $html=view('auth.suggestion_courses.show_form',compact('question'))->render();
            return response()->json(['success'=>true,'html'=>$html]);
        }
        return response()->json(['success'=>false,'message'=>'No record found']);
    }
}
