<?php

namespace App\Http\Controllers\Admin;

use App\Models\Courses;
use App\Models\Diplomas;
use App\Models\SuggestionCoursesConditions;
use App\Models\OldUrls;
use App\Models\Tags;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class SuggestionCoursesConditionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.suggestion_courses_conditions.view');
    }


    function search(Request $request)
    {
        $data = $request->input();
        $suggestion_courses_conditions = SuggestionCoursesConditions::select('suggestion_courses_conditions.*');

        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $suggestion_courses_conditions = $suggestion_courses_conditions->where('suggestion_courses_conditions.id', '=', "$id");
        }
        if (isset($data['if_this']) && !empty($data['if_this'])) {
            $if_this = $data['if_this'];
            $suggestion_courses_conditions = $suggestion_courses_conditions->where('suggestion_courses_conditions.if_this', 'LIKE', "%$if_this%");
        }

        if (isset($data['show_this']) && !empty($data['show_this'])) {
            $show_this = $data['show_this'];
            $suggestion_courses_conditions = $suggestion_courses_conditions->where('suggestion_courses_conditions.show_this', 'LIKE', "%$show_this%");
        }
        if (isset($data['priority']) && !empty($data['priority'])) {
            $priority = $data['priority'];
            $suggestion_courses_conditions = $suggestion_courses_conditions->where('suggestion_courses_conditions.priority',$priority);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $suggestion_courses_conditions = $suggestion_courses_conditions->whereBetween('suggestion_courses_conditions.createdtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }
        $iTotalRecords = $suggestion_courses_conditions->count('suggestion_courses_conditions.id');
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'suggestion_courses_conditions.priority';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'suggestion_courses_conditions.id';
                break;
            case 1:
                $columnName = 'suggestion_courses_conditions.if_this';
                break;
            case 5:
                $columnName = 'suggestion_courses_conditions.show_this';
                break;
            case 6:
                $columnName = 'suggestion_courses_conditions.priority';
                break;
            case 7:
                $columnName = 'suggestion_courses_conditions.created_at';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $suggestion_courses_conditions = $suggestion_courses_conditions->where(function ($q) use ($search) {
                $q->where('suggestion_courses_conditions.if_this', 'LIKE', "%$search%")
                    ->orWhere('suggestion_courses_conditions.show_this', 'LIKE', "%$search%")
                    ->orWhere('suggestion_courses_conditions.priority', 'LIKE', "%$search%")
                    ->orWhere('suggestion_courses_conditions.id', '=', $search);
            });
        }

        $suggestion_courses_conditions = $suggestion_courses_conditions->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($suggestion_courses_conditions as $suggestion_courses_condition) {

            $records["data"][] = [
                $suggestion_courses_condition->id,
//                $suggestion_courses_condition->if_this,
//                '<span class="label label-success" style="margin: 5px;">'.implode('</span><span class="label label-success" style="margin: 5px;">',json_decode($suggestion_courses_condition->if_this)).'</span>',
//                '<span class="label label-success" style="margin: 5px;">'.implode('</span><span class="label label-success" style="margin: 5px;">',json_decode($suggestion_courses_condition->show_this)).'</span>',
//                $suggestion_courses_condition->show_this,
                getSuggestionCourseConditionHtml(json_decode($suggestion_courses_condition->if_this)),
                getSuggestionCourseConditionHtml(json_decode($suggestion_courses_condition->show_this)),
                $suggestion_courses_condition->priority,
                $suggestion_courses_condition->created_at,
                '<div class="btn-group text-center" id="single-order-' . $suggestion_courses_condition->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('suggestion_courses_conditions_edit')) ? '<li>
                                            <a href="' . URL('admin/suggestion_courses_conditions/' . $suggestion_courses_condition->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('suggestion_courses_conditions_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $suggestion_courses_condition->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '
                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a suggestion_courses_condition resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        return view('auth.suggestion_courses_conditions.add');
    }

    /**
     * Store a suggestion_courses_conditionly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $request->merge(array('url' => str_replace(' ', '-', $data['url'])));
        $validator = Validator::make($request->all(),
            array(
                'if_this' => 'required',
                'show_this' => 'required',
                'priority' => 'required|unique:mysql2.suggestion_courses_conditions,priority,NULL,NULL,deleted_at',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $suggestion_courses_conditions =SuggestionCoursesConditions::create(array_merge($request->only('priority'),[
                'if_this'=>json_encode($request->if_this),
                'show_this'=>json_encode($request->show_this),
            ]));
            Session::flash('success', Lang::get('main.insert') . Lang::get('main.suggestion_courses_condition'));
            return Redirect::to('admin/suggestion_courses_conditions/create');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $suggestion_courses_condition = SuggestionCoursesConditions::findOrFail($id);
        return view('auth.suggestion_courses_conditions.edit', compact('suggestion_courses_condition'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $suggestion_courses_condition = SuggestionCoursesConditions::find($id);
        $rules=array(
            'if_this' => 'required',
            'show_this' => 'required',
            'priority' => 'required|unique:mysql2.suggestion_courses_conditions,priority,'.$id.',id,deleted_at,NULL',
        );
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $suggestion_courses_condition->update(array_merge($request->only('priority'),[
                'if_this'=>json_encode($request->if_this),
                'show_this'=>json_encode($request->show_this),
            ]));
                Session::flash('success', Lang::get('main.update') . Lang::get('main.suggestion_courses_condition'));
                return Redirect::to("admin/suggestion_courses_conditions/$suggestion_courses_condition->id/edit");

        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $suggestion_courses_condition = SuggestionCoursesConditions::findOrFail($id);
        $suggestion_courses_condition->update(['deleted_at'=>date('Y-m-d H:i:s'),'deleted_by'=>auth()->id()]);



    }
}
