<?php

namespace App\Http\Controllers\Admin;

use App\Models\Stockholders;
use App\Models\OldUrls;
use App\Models\Tags;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class StockholdersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.stockholders.view');
    }


    function search(Request $request)
    {
        $data = $request->input();
        $stockholders = Stockholders::select('stockholders.*');

        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $stockholders = $stockholders->where('stockholders.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $stockholders = $stockholders->where('stockholders.name', 'LIKE', "%$name%");
        }

        if (isset($data['age']) && !empty($data['age'])) {
            $age = $data['age'];
            $stockholders = $stockholders->where('stockholders.age', 'LIKE', "%$age%");
        }
        if (isset($data['nationality']) && !empty($data['nationality'])) {
            $nationality = $data['nationality'];
            $stockholders = $stockholders->where('stockholders.nationality', 'LIKE', "%$nationality%");
        }

        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $stockholders = $stockholders->whereBetween('stockholders.createdtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }
        $iTotalRecords = $stockholders->count('stockholders.id');
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'stockholders.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'stockholders.id';
                break;
            case 1:
                $columnName = 'stockholders.name';
                break;
            case 5:
                $columnName = 'stockholders.age';
                break;
            case 6:
                $columnName = 'stockholders.nationality';
                break;
            case 7:
                $columnName = 'stockholders.inprogress';
                break;
            case 8:
                $columnName = 'stockholders.published';
                break;
            case 9:
                $columnName = 'stockholders.created_at';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $stockholders = $stockholders->where(function ($q) use ($search) {
                $q->where('stockholders.name', 'LIKE', "%$search%")
                    ->orWhere('stockholders.age', 'LIKE', "%$search%")
                    ->orWhere('stockholders.nationality', 'LIKE', "%$search%")
                    ->orWhere('stockholders.id', '=', $search);
            });
        }

        $stockholders = $stockholders->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($stockholders as $stockholder) {
            $records["data"][] = [
                $stockholder->id,
                $stockholder->name,
                $stockholder->age,
                $stockholder->nationality,
                $stockholder->inprogress?'<span class="label label-success">جاري التنفيذ</span>':'',
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $stockholder->id . '" type="checkbox" ' . ((!PerUser('stockholders_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('stockholders_publish')) ? 'class="changeStatues"' : '') . ' ' . (($stockholder->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $stockholder->id . '">
                                    </label>
                                </div>
                            </td>',
                $stockholder->created_at,
                '<div class="btn-group text-center" id="single-order-' . $stockholder->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('stockholders_edit')) ? '<li>
                                            <a href="' . URL('admin/stockholders/' . $stockholder->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('stockholders_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $stockholder->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '
                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a stockholder resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        return view('auth.stockholders.add');
    }

    /**
     * Store a stockholderly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $request->merge(array('url' => str_replace(' ', '-', $data['url'])));
        $validator = Validator::make($request->all(),
            array(
                'name' => 'required',
                'age' => 'required',
                'nationality' => 'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $stockholders = new Stockholders();
            $stockholders->name = $data['name'];
            $stockholders->age = $data['age'];
            $stockholders->nationality = $data['nationality'];
            $stockholders->inprogress = ($request->inprogress)?1:0;
            $stockholders->published = $published;
            if ($published == 'yes') {
                $stockholders->published_by = Auth::user()->id;
                $stockholders->published_at = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $stockholders->unpublished_by = Auth::user()->id;
                $stockholders->unpublished_at = date("Y-m-d H:i:s");
            }
            $stockholders->created_by = Auth::user()->id;
            if ($stockholders->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.stockholder'));
                return Redirect::to('admin/stockholders/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $stockholder = stockholders::findOrFail($id);
        return view('auth.stockholders.edit', compact('stockholder'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $stockholder = Stockholders::find($id);
        $rules=array(
            'name' => 'required',
            'age' => 'required',
            'nationality' => 'required',
        );
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $stockholder->name = $data['name'];
            $stockholder->age = $data['age'];
            $stockholder->nationality = $data['nationality'];
            $stockholder->inprogress = ($request->inprogress)?1:0;
            if ($published == 'yes' && $stockholder->published=='no') {
                $stockholder->published_by = Auth::user()->id;
                $stockholder->published_at = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $stockholder->published=='yes') {
                $stockholder->unpublished_by = Auth::user()->id;
                $stockholder->unpublished_at = date("Y-m-d H:i:s");
            }
            $stockholder->published = $published;
            $stockholder->updated_by = Auth::user()->id;
            $stockholder->updated_at = date("Y-m-d H:i:s");
            if ($stockholder->save()) {

                Session::flash('success', Lang::get('main.update') . Lang::get('main.stockholder'));
                return Redirect::to("admin/stockholders/$stockholder->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $stockholder = Stockholders::findOrFail($id);
        $stockholder->update(['deleted_at'=>date('Y-m-d H:i:s'),'deleted_by'=>auth()->id()]);



    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $stockholder = Stockholders::findOrFail($id);
                if ($published == 'no') {
                    $stockholder->published = 'no';
                    $stockholder->unpublished_by = Auth::user()->id;
                    $stockholder->unpublished_date = date("Y-m-d H:i:s");
                } elseif ($published == 'yes') {
                    $stockholder->published = 'yes';
                    $stockholder->published_by = Auth::user()->id;
                    $stockholder->published_date = date("Y-m-d H:i:s");
                }
                $stockholder->save();

        } else {
            return redirect(404);
        }
    }
}
