<?php

namespace App\Http\Controllers\Admin;

use App\Models\Courses;
use App\Models\CoursesViews;
use App\Exports\CoursesRatingExport;
use App\Http\Controllers\Controller;
use App\Models\Instructors;
use App\Models\Rating;
use App\Models\RatingPopup;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Response;
use Maatwebsite\Excel\Facades\Excel;


class RatingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.rating.view');
    }

    function search(Request $request)
    {
        $data = $request->input();
        $rating = Rating::join('users','users.id','=','rating.rating_userid')
            ->join('courses','courses.id','rating.rating_id')
            ->join('instractors','instractors.id','courses.instractor')
            ->where('rating.rating_type','courses')->where('rating.createtime','<','2022-07-31 00:00:00')
            ->select('rating.*','users.Email as user_email','courses.name as course_name','instractors.name AS instructor_name');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $rating = $rating->where('rating.id', '=', $id);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $rating = $rating->whereBetween('rating.createtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }
        if (isset($data['user_id']) && !empty($data['user_id'])) {
            $user_id = $data['user_id'];
            $rating = $rating->where('rating.rating_userid', 'LIKE', "%$user_id%");
        }
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $user_email = $data['user_email'];
            $rating = $rating->where('users.Email', 'LIKE', "%$user_email%");
        }
        if (isset($data['course']) && !empty($data['course'])) {
            $course = $data['course'];
            $rating = $rating->where('courses.name', 'LIKE', "%$course%");
        }
        if (isset($data['instructor']) && !empty($data['instructor'])) {
            $instructor = $data['instructor'];
            $rating = $rating->where('instractors.name', 'LIKE', "%$instructor%");
        }
        if (isset($data['rating_question1']) && !empty($data['rating_question1'])) {
            $rating_msg = $data['rating_question1'];
            $rating = $rating->where('rating.rating_question1', 'LIKE', "%$rating_msg%");
        }
        if (isset($data['rating_question2']) && !empty($data['rating_question2'])) {
            $rating_msg = $data['rating_question2'];
            $rating = $rating->where('rating.rating_question2', 'LIKE', "%$rating_msg%");
        }
        if (isset($data['rating_question3']) && !empty($data['rating_question3'])) {
            $rating_msg = $data['rating_question3'];
            $rating = $rating->where('rating.rating_question3', 'LIKE', "%$rating_msg%");
        }
        if (isset($data['rating_question4']) && !empty($data['rating_question4'])) {
            $rating_msg = $data['rating_question4'];
            $rating = $rating->where('rating.rating_question4', 'LIKE', "%$rating_msg%");
        }
        if (isset($data['rating']) && !empty($data['rating'])) {
            $rating_msg = $data['rating'];
            $rating = $rating->where('rating.rating_count', 'LIKE', "%$rating_msg%");
        }
        if (isset($data['comment']) && !empty($data['comment'])) {
            $comment = $data['comment'];
            $rating = $rating->where('rating.comment', 'LIKE', "%$comment%");
        }


        $iTotalRecords = $rating->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'rating.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'rating.id';
                break;
            case 1:
                $columnName = 'rating.rating_userid';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'courses.name';
                break;
            case 4:
                $columnName = 'instractors.name';
                break;
            case 5:
                $columnName = 'rating.rating_question1';
                break;
            case 6:
                $columnName = 'rating.rating_question2';
                break;
            case 7:
                $columnName = 'rating.rating_question3';
                break;
            case 8:
                $columnName = 'rating.rating_question4';
                break;
            case 9:
                $columnName = 'rating.rating_count';
                break;
            case 10:
                $columnName = 'rating.comment';
                break;
            case 11:
                $columnName = 'rating.createtime';
                break;

        }

        $search = $data['search']['value'];
        if ($search) {
            $rating = $rating->where(function ($q) use ($search) {
                $q->where('rating.id', '=', $search)
                    ->orWhere('rating.rating_userid', 'Like', "%$search%")
                    ->orWhere('rating.rating_question1', 'Like', "%$search%")
                    ->orWhere('rating.rating_question2', 'Like', "%$search%")
                    ->orWhere('rating.rating_question3', 'Like', "%$search%")
                    ->orWhere('rating.rating_question4', 'Like', "%$search%")
                    ->orWhere('rating.comment', 'Like', "%$search%")
                    ->orWhere('rating.rating_count', 'Like', "%$search%")
                    ->orWhere('courses.name', 'Like', "%$search%")
                    ->orWhere('instractors.name', 'Like', "%$search%")
                    ->orWhere('users.Email', 'Like', "%$search%");

            });
        }

        $rating = $rating->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($rating as $comment) {
            $user_email = $comment->user_email;
            $course_name = $comment->course_name;
            if(PerUser('normal_user_edit') && $user_email !=''){
                $user_email= '<a target="_blank" href="' . URL('admin/normal_user/' . $comment->user_id . '/edit') . '">' . $user_email . '</a>';
            }
            $records["data"][] = [
                $comment->id,
                $comment->rating_userid,
                $user_email,
                $course_name,
                $comment->instructor_name,
                $comment->rating_question1 . (getUserSystem('backend_lang')=='ar'?' من 5':' out of 5'),
                $comment->rating_question2 . (getUserSystem('backend_lang')=='ar'?' من 5':' out of 5'),
                $comment->rating_question3 . (getUserSystem('backend_lang')=='ar'?' من 5':' out of 5'),
                $comment->rating_question4 . (getUserSystem('backend_lang')=='ar'?' من 5':' out of 5'),
                $comment->rating_count . (getUserSystem('backend_lang')=='ar'?' من 5':' out of 5'),
                $comment->comment,
                $comment->createtime,
                ''
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    public function courseView(Request  $request){

        if(in_array($request->method(),['POST','post'])){
            $data = $request->input();
            $cvs = CoursesViews::join('courses', function($join)
            {
                $join->on('courses.id','=','courses_views.course_id')->where('courses.show_on','!=','medical');
            })
                ->leftjoin('instractors','instractors.id','=','courses.instractor')
                ->select('courses_views.course_id',DB::raw('COUNT(course_id) AS count'),'instractors.name AS instructor_name','courses.name as course_name')
                ->groupBy('courses_views.course_id')


            ;
            if (isset($data['id']) && !empty($data['id'])) {
                $id = $data['id'];
                $cvs = $cvs->where('courses_views.id', '=', $id);
            }
            if (isset($data['count']) && !empty($data['count'])) {
                $count = $data['count'];
                $cvs = $cvs->where('courses_views.count', '=', $count);
            }
            if (isset($data['course']) && !empty($data['course'])) {
                $course = $data['course'];
                $cvs = $cvs->where('courses.id','=', $course);
            }
            if (isset($data['instractor']) && !empty($data['instractor'])) {
                $instractor = $data['instractor'];
                $cvs = $cvs->where('courses.instractor','=', $instractor);
            }

            if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
                $created_time_from = $data['created_time_from'];
                $created_time_to = $data['created_time_to'];
                $cvs = $cvs->whereBetween('courses_views.createdtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
            }

            $iTotalRecords = $cvs->get()->count();
            $iDisplayLength = intval($data['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($data['start']);
            $sEcho = intval($data['draw']);
            $records = [];
            $records["data"] = [];
            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
            $columnName = 'courses_views.id';
            switch ($data['order'][0]['column']) {
                case 0:
                    $columnName = 'courses_views.id';
                    break;
                case 1:
                    $columnName = 'courses.name';
                    break;
                case 2:
                    $columnName = 'instractors.name';
                    break;
                case 3:
                    $columnName = 'count';
                    break;
                case 4:
                    $columnName = 'courses_views.createdtime';
                    break;
            }

            $search = $data['search']['value'];
            if ($search) {
                $cvs = $cvs->where(function ($q) use ($search) {
                    $q->where('courses_views.id', '=', $search)
                        ->orWhere('courses_views.count', '=', $search)
                        ->orWhere('courses.name', 'LIKE', "%$search%")
                        ->orWhere('users.Email', 'LIKE', "%$search%");
                });
            }

            $cvs = $cvs->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
                ->get();

            foreach ($cvs as $cv) {
                $course_name = $cv->course_name;
                $user_email = $cv->user_email;
                if(PerUser('courses_edit') && $course_name !=''){
                    $course_name= '<a target="_blank" href="' . URL('admin/courses/' . $cv->course_id . '/edit') . '">' . $course_name . '</a>';
                }
                $records["data"][] = [
                    $course_name,
                    $cv->instructor_name,
                    $cv->count,
                    $cv->createdtime,
                    '',
                ];
            }
            if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }
            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $records['postData'] = $data;
            //return response()->json($data)->setCallback($request->input('callback'));
            return response()->json($records)->setCallback($request->input('callback'));
        }
        $courses=Courses::where('courses.show_on','!=','medical')->pluck('name','id')->toArray();
        $instructors=Instructors::whereIn('id',Courses::where('courses.show_on','!=','medical')->pluck('instractor')->toArray())->pluck('name','id')->toArray();
        return view('auth.rating.courses_views',compact('courses','instructors'));
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function export()

    {

//        return Excel::download(new CoursesRatingExport(), 'Courses_Ratings.xlsx');
        $request =Request();
        $data = $request->input();
        $output =[
            '#',
            'User ID',
            'User Name',
            'Course Name',
            'Instructor Name',
            'ما مدى رضاك عن طريقه عرض المحاضر للماده التدريبيه',
            'ما مدى استفادتك من المحتوي',
            'ما مدى رضاك عن جوده التصوير',
            'ما مدى رضاك عن الكورس بشكل عام',
            'Rating Avg',
            'Comment',
            'Created Time'

        ];

        $rating = Rating::join('users','users.id','=','rating.rating_userid')
            ->join('courses','courses.id','rating.rating_id')
            ->join('instractors','instractors.id','courses.instractor')
            ->where('rating.rating_type','courses')->where('rating.createtime','<','2022-07-31 00:00:00')
            ->select('rating.id',
                'rating.rating_userid',
                'users.Email as user_email',
                'courses.name as course_name',
                'rating.rating_question1',
                'rating.rating_question2',
                'rating.rating_question3',
                'rating.rating_question4',
                'rating.rating_count',
                'rating.comment',
                'rating.createtime',
                'instractors.name AS instructor_name'
            );
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $rating = $rating->where('rating.id', '=', $id);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $rating = $rating->whereBetween('rating.createtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }
        if (isset($data['user_id']) && !empty($data['user_id'])) {
            $user_id = $data['user_id'];
            $rating = $rating->where('rating.rating_userid', 'LIKE', "%$user_id%");
        }
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $user_email = $data['user_email'];
            $rating = $rating->where('users.Email', 'LIKE', "%$user_email%");
        }
        if (isset($data['course']) && !empty($data['course'])) {
            $course = $data['course'];
            $rating = $rating->where('courses.name', 'LIKE', "%$course%");
        }
        if (isset($data['instructor']) && !empty($data['instructor'])) {
            $instructor = $data['instructor'];
            $rating = $rating->where('instractors.name', 'LIKE', "%$instructor%");
        }
        if (isset($data['rating_question1']) && !empty($data['rating_question1'])) {
            $rating_msg = $data['rating_question1'];
            $rating = $rating->where('rating.rating_question1', 'LIKE', "%$rating_msg%");
        }
        if (isset($data['rating_question2']) && !empty($data['rating_question2'])) {
            $rating_msg = $data['rating_question2'];
            $rating = $rating->where('rating.rating_question2', 'LIKE', "%$rating_msg%");
        }
        if (isset($data['rating_question3']) && !empty($data['rating_question3'])) {
            $rating_msg = $data['rating_question3'];
            $rating = $rating->where('rating.rating_question3', 'LIKE', "%$rating_msg%");
        }
        if (isset($data['rating_question4']) && !empty($data['rating_question4'])) {
            $rating_msg = $data['rating_question4'];
            $rating = $rating->where('rating.rating_question4', 'LIKE', "%$rating_msg%");
        }
        if (isset($data['rating']) && !empty($data['rating'])) {
            $rating_msg = $data['rating'];
            $rating = $rating->where('rating.rating_count', 'LIKE', "%$rating_msg%");
        }
        if (isset($data['comment']) && !empty($data['comment'])) {
            $comment = $data['comment'];
            $rating = $rating->where('rating.comment', 'LIKE', "%$comment%");
        }

        $rating= $rating->orderBy('id','desc')->get();


        $filename = "Courses_Rating.csv";
        $handle = fopen($filename, 'w+');
        fputcsv($handle, $output);

        foreach($rating as $comment) {
            fputcsv($handle, [
                $comment->id,
                $comment->rating_userid,
                $comment->user_email,
                $comment->course_name,
                $comment->instructor_name,
                $comment->rating_question1 ,
                $comment->rating_question2,
                $comment->rating_question3,
                $comment->rating_question4,
                $comment->rating_count,
                '"'.$comment->comment.'"',
                $comment->createtime,
            ]);
        }

        fclose($handle);

        $headers = array(
            'Content-Type' => 'text/csv',
            'Content-Disposition' => 'attachment; filename="Courses_Rating.csv"'
        );


        return Response::download($filename, 'Courses_Rating.csv', $headers);

    }

    public function course_view_export(Request $request)

    {
        $data = $request->input();
        $output =[
            'Course Name',
            'Instructor Name',
            'Count',
        ];

        $cvs = CoursesViews::join('courses', function($join)
        {
            $join->on('courses.id','=','courses_views.course_id')->where('courses.show_on','!=','medical');
        })
            ->leftjoin('instractors','instractors.id','=','courses.instractor')
            ->select(
                'courses.name as course_name',
                'instractors.name AS instructor_name',
                DB::raw('COUNT(course_id) AS count'))

            ->groupBy('courses_views.course_id')
        ;
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $cvs = $cvs->where('courses_views.id', '=', $id);
        }
        if (isset($data['count']) && !empty($data['count'])) {
            $count = $data['count'];
            $cvs = $cvs->where('courses_views.count', '=', $count);
        }
        if (isset($data['course']) && !empty($data['course'])) {
            $course = $data['course'];
            $cvs = $cvs->where('courses.id','=', $course);
        }
        if (isset($data['instractor']) && !empty($data['instractor'])) {
            $instractor = $data['instractor'];
            $cvs = $cvs->where('courses.instractor','=', $instractor);
        }

        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $cvs = $cvs->whereBetween('courses_views.createdtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }
        $cvs= $cvs->orderBy('courses_views.id','desc')->get();


        $filename = "Courses_Views.csv";
        $handle = fopen($filename, 'w+');
        fputcsv($handle, $output);

        foreach($cvs as $comment) {
            fputcsv($handle, [
                $comment->course_name,
                $comment->instructor_name,
                $comment->count,
            ]);
        }

        fclose($handle);

        $headers = array(
            'Content-Type' => 'text/csv',
            'Content-Disposition' => 'attachment; filename="Courses_Views.csv"'
        );


        return Response::download($filename, 'Courses_Views.csv', $headers);

    }


}
