<?php

namespace App\Http\Controllers\Admin;

use App\Models\PdfTempletes;
use App\Models\OldUrls;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use PhpOffice\PhpSpreadsheet\Writer\Pdf;

class PdfTempletesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.pdf_templetes.view');
    }

    function search(Request $request)
    {

        $data = $request->input();
        $pdf_templetes = PdfTempletes::select('pdf_templetes.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $pdf_templetes = $pdf_templetes->where('pdf_templetes.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $pdf_templetes = $pdf_templetes->where('pdf_templetes.name', '=', "$name");
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $pdf_templetes = $pdf_templetes->where('pdf_templetes.url', '=', "$url");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $pdf_templetes = $pdf_templetes->whereBetween('pdf_templetes.added_date', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }


        $iTotalRecords = $pdf_templetes->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'pdf_templetes.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'pdf_templetes.id';
                break;
            case 1:
                $columnName = 'pdf_templetes.name';
                break;
             case 2:
                $columnName = 'pdf_templetes.url';
                break;
            case 3:
                $columnName = 'pdf_templetes.added_date';
                break;
            case 4:
                $columnName = 'pdf_templetes.published';
                break;

        }
        $search = $data['search']['value'];
        if ($search) {
            $pdf_templetes = $pdf_templetes->where(function ($q) use ($search) {
                $q->where('pdf_templetes.name', 'LIKE', "%$search%")
                    ->orWhere('pdf_templetes.url', '=', $search)
                    ->orWhere('pdf_templetes.id', '=', $search);
            });
        }

        $pdf_templetes = $pdf_templetes->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($pdf_templetes as $pdf_templete) {
            $pdf_templete = makeDefaultImageGeneral($pdf_templete, 'image');
            $records["data"][] = [
                $pdf_templete->id,
                $pdf_templete->name,
                $pdf_templete->url,
                 $pdf_templete->added_date,
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $pdf_templete->id . '" type="checkbox" ' . ((!PerUser('pdf_templetes_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('pdf_templetes_publish')) ? 'class="changeStatues"' : '') . ' ' . (($pdf_templete->published == "yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $pdf_templete->id}}">
                                    <label for="checkbox-' . $pdf_templete->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $pdf_templete->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('pdf_templetes_edit')) ? '<li>
                                            <a href="' . URL('admin/pdf_templetes/' . $pdf_templete->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('pdf_templetes_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $pdf_templete->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.pdf_templetes.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $request->merge(['url'=>str_replace(' ', '-', $request->url)]);
        $validator = Validator::make($request->all(),
            array(
                'name' => 'required',
                'description' => 'required',
                'url' => 'required',
                'file.*' => 'required|mimes:pdf,doc,csv,xlsx,xls,docx,ppt',
                'image' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
            ));
        if ($validator->fails()) {
            $messsage = '<div class="alert alert-danger"><ul>';
            foreach ($validator->errors()->all() as $m) {
                $messsage .= '<li>' . $m . '</li>';
            }
            $messsage .= '</ul></div>';
            return response()->json($messsage);
        }
        $published = (isset($request->published)) ? 'yes' : 'no';
        $file = $request->file('file');
        $fileName = uploadFileToE3melbusiness($file);
        $pdf_templetes = new PdfTempletes();
        $pdf_templetes->name = $request->name;
        $pdf_templetes->url = $request->url;
        $pdf_templetes->description = $request->description;
//				$pdfFile->category_id = $request->category_id'];
        $pic = $request->file('image');
        $picName = uploadFileToE3melbusiness($pic,false,'',false,false,false,true);
        $pdf_templetes->image = $picName;
        $pdf_templetes->file = $fileName;
        $pdf_templetes->published = $published;
        if ($published == 'yes') {
            $pdf_templetes->published_by = Auth::user()->id;
            $pdf_templetes->published_date = date("Y-m-d H:i:s");
        }
        if ($published == 'no') {
            $pdf_templetes->unpublished_by = Auth::user()->id;
            $pdf_templetes->unpublished_date = date("Y-m-d H:i:s");
        }
        $pdf_templetes->lastedit_by = Auth::user()->id;
        $pdf_templetes->lastedit_date = date("Y-m-d H:i:s");
        $pdf_templetes->added_by = Auth::user()->id;
        $pdf_templetes->added_date = date("Y-m-d H:i:s");

        if ($pdf_templetes->save()) {
            $messsage = '<div class="alert alert-success"><ul>';
            $messsage .= '<li>' . Lang::get('main.insert')  . '</li>';
            $messsage .= '</ul></div>';
            return response()->json($messsage);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $pdf_templete = PdfTempletes::find($id);
        return view('auth.pdf_templetes.edit', compact('pdf_templete'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $data = $request->input();
        $pdf_templete = PdfTempletes::find($id);

        $rules=array(
            'name' => 'required',
            'description' => 'required',
            'url' => 'required',
//            'category_id'=>'required'
        );

        if ( $request->file('file')){
            $rules['file.*']='nullable|mimes:pdf,doc,csv,xlsx,xls,docx,ppt';
        }if ( $request->file('image')){
        $rules['image']='mimes:jpeg,jpg,png,gif|max:5000';
    }
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails()) {
            $messsage = '<div class="alert alert-danger"><ul>';
            foreach ($validator->errors()->all() as $m) {
                $messsage .= '<li>' . $m . '</li>';
            }
            $messsage .= '</ul></div>';
            return response()->json($messsage);
        }else {

            if ( $request->file('file')){
                $file_input = $request->file('file');
                $file_name = uploadFileToE3melbusiness($file_input);
                $pdf_templete->file = $file_name;
            }
            if ( $request->file('image')){
                $pic = $request->file('image');
                $picName = uploadFileToE3melbusiness($pic,false,'',false,false,false,true);
                $pdf_templete->image = $picName;

            }
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $pdf_templete->name = $data['name'];
            $pdf_templete->url = $data['url'];
            $pdf_templete->description = $data['description'];
            if ($published == 'yes' && $pdf_templete->published=='no') {
                $pdf_templete->published_by = Auth::user()->id;
                $pdf_templete->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $pdf_templete->published=='yes') {
                $pdf_templete->unpublished_by = Auth::user()->id;
                $pdf_templete->unpublished_date = date("Y-m-d H:i:s");
            }
            $pdf_templete->published = $published;
            $pdf_templete->lastedit_by = Auth::user()->id;
            $pdf_templete->lastedit_date = date("Y-m-d H:i:s");
            if ($pdf_templete->save()) {
                $messsage = '<div class="alert alert-success"><ul>';
                $messsage .= '<li>' . Lang::get('main.update') . '</li>';
                $messsage .= '</ul></div>';
                return response()->json($messsage);
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */


    public function destroy($id)
    {
        $pdf_templete =PdfTempletes::find($id);

        $pdf_templete->delete();
    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $pdf_templete = PdfTempletes::find($id);
            if ($published == 'no') {

                $pdf_templete->published = 'no';
                $pdf_templete->unpublished_by = Auth::user()->id;
                $pdf_templete->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {


                $pdf_templete->published = 'yes';
                $pdf_templete->published_by = Auth::user()->id;
                $pdf_templete->published_date = date("Y-m-d H:i:s");
            }
            $pdf_templete->save();

        } else {
            return redirect(404);
        }
    }

}
