<?php

	namespace App\Http\Controllers\Admin;

	use App\Models\Authors;
	use App\Models\Books;
	use App\Http\Controllers\Controller;
	use App\Models\OldUrls;
	use App\Models\PdfFiles;
	use Illuminate\Support\Facades\Redirect;
	use Illuminate\Support\Facades\Validator;
	use Illuminate\Http\Request;
	use Illuminate\Support\Facades\Auth;
	use Illuminate\Support\Facades\Lang;
	use Illuminate\Support\Facades\Session;

	class PdfFilesController extends Controller
	{
		/**
		 * Display a listing of the resource.
		 *
		 * @return \Illuminate\Http\Response
		 */
		public function index()
		{
			return view('auth.pdf_files.view');
		}

		function search(Request $request)
		{

			$data = $request->input();
			$files = PdfFiles::query();
			if (isset($data['id']) && !empty($data['id'])) {
				$id = $data['id'];
				$files = $files->where('id', $id);
			}
			if (isset($data['name']) && !empty($data['name'])) {
				$name = $data['name'];
				$files = $files->where('name', 'LIKE', "%$name%");
			}
			if (isset($data['url']) && !empty($data['url'])) {
				$url = $data['url'];
				$files = $files->where('url', 'LIKE', "%$url%");
			}

			if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
				$created_time_from = $data['created_time_from'];
				$created_time_to = $data['created_time_to'];
				$files = $files->whereBetween('added_date', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
			}
//			if (isset($data['url']) && !empty($data['url'])) {
//				$url = $data['url'];
//				$files = $files->where('url', 'LIKE', "%$url%");
//			}

			$iTotalRecords = $files->count();
			$iDisplayLength = intval($data['length']);
			$iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
			$iDisplayStart = intval($data['start']);
			$sEcho = intval($data['draw']);
			$records = [];
			$records["data"] = [];
			$end = $iDisplayStart + $iDisplayLength;
			$end = $end > $iTotalRecords ? $iTotalRecords : $end;
			$columnName = 'pdf_files.id';
			switch ($data['order'][0]['column']) {
				case 0:
					$columnName = 'id';
					break;
				case 1:
					$columnName = 'name';
					break;
				case 2:
					$columnName = 'url';
					break;
				case 3:
					$columnName = 'added_date';
					break;
				case 4:
					$columnName = 'published';
					break;

			}
			$search = $data['search']['value'];
			if ($search) {
				$files = $files->where(function ($q) use ($search) {
					$q->where('name', 'LIKE', "%$search%")
						->orWhere('id', '=', $search)
						->orWhere('url', '=', $search);
				});
			}

			$files = $files->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
				->get();

			foreach ($files as $file) {
				$records["data"][] = [
					$file->id,
					$file->name,
					$file->url,
					$file->added_date,
					'<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $file->id . '" type="checkbox" ' . ((!PerUser('pdf_files_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('pdf_files_publish')) ? 'class="changeStatues"' : '') . ' ' . (($file->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $file->id }}">
                                    <label for="checkbox-' . $file->id . '">
                                    </label>
                                </div>
                            </td>',
					'<div class="btn-group text-center" id="single-order-' . $file->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('pdf_files_edit')) ? '<li>
                                            <a href="' . URL('admin/pdf_files/' . $file->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('pdf_files_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $file->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
				];
			}
			if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
				$records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
				$records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
			}
			$records["draw"] = $sEcho;
			$records["recordsTotal"] = $iTotalRecords;
			$records["recordsFiltered"] = $iTotalRecords;
			$records['postData'] = $data;
			//return response()->json($data)->setCallback($request->input('callback'));
			return response()->json($records)->setCallback($request->input('callback'));

		}


		/**
		 * Show the form for creating a new resource.
		 *
		 * @return \Illuminate\Http\Response
		 */
		public function create()
		{
			return view('auth.pdf_files.add');
		}

		/**
		 * Store a newly created resource in storage.
		 *
		 * @param  \Illuminate\Http\Request $request
		 * @return \Illuminate\Http\Response
		 */
		public function store(Request $request)
		{
			$validator = Validator::make($request->all(),
				array(
					'name' => 'required',
					'description' => 'required',
					'url' => 'required',
                    'file.*' => 'required|mimes:pdf,doc,csv,xlsx,xls,docx,ppt',
					'image' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
//                'category_id'=>'required'
				));
			if ($validator->fails()) {
				//return redirect()->back()->withErrors($validator->errors())->withInput();
				$messsage = '<div class="alert alert-danger"><ul>';
				foreach ($validator->errors()->all() as $m) {
					$messsage .= '<li>' . $m . '</li>';
				}
				$messsage .= '</ul></div>';
				return response()->json($messsage);
			}else {
				$published = (isset($request->published)) ? 'yes' : 'no';
				$file = $request->file('file');
				$fileName = uploadFileToE3melbusiness($file);
				$pdfFile = new PdfFiles();
				$pdfFile->name = $request->name;
				$pdfFile->url = $request->url;
				$pdfFile->description = $request->description;
//				$pdfFile->category_id = $request->category_id'];
				$pic = $request->file('image');
                $picName = uploadFileToE3melbusiness($pic,false,'',false,false,false,true);
				$pdfFile->image = $picName;
				$pdfFile->file = $fileName;
				$pdfFile->published = $published;
				if ($published == 'yes') {
					$pdfFile->published_by = Auth::user()->id;
					$pdfFile->published_date = date("Y-m-d H:i:s");
				}
				if ($published == 'no') {
					$pdfFile->unpublished_by = Auth::user()->id;
					$pdfFile->unpublished_date = date("Y-m-d H:i:s");
				}
				$pdfFile->lastedit_by = Auth::user()->id;
				$pdfFile->lastedit_date = date("Y-m-d H:i:s");
				$pdfFile->added_by = Auth::user()->id;
				$pdfFile->added_date = date("Y-m-d H:i:s");
				if ($pdfFile->save()) {
					$messsage = '<div class="alert alert-success"><ul>';
					$messsage .= '<li>' . Lang::get('main.insert')  . '</li>';
					$messsage .= '</ul></div>';
					return response()->json($messsage);
					//Session::flash('success', Lang::get('main.insert') . Lang::get('main.books'));
//                return Redirect::to('admin/webinars/create');
				}
			}
		}

		/**
		 * Display the specified resource.
		 *
		 * @param  int $id
		 * @return \Illuminate\Http\Response
		 */
		public function show($id)
		{
			//
		}

		/**
		 * Show the form for editing the specified resource.
		 *
		 * @param  int $id
		 * @return \Illuminate\Http\Response
		 */
		public function edit($id)
		{
			$pdf_file = PdfFiles::find($id);
			return view('auth.pdf_files.edit', compact('pdf_file'));
		}

		/**
		 * Update the specified resource in storage.
		 *
		 * @param  \Illuminate\Http\Request $request
		 * @param  int $id
		 * @return \Illuminate\Http\Response
		 */
		public function update(Request $request, $id)
		{
			$data = $request->input();
			$pdf_file = PdfFiles::find($id);

			$rules=array(
				'name' => 'required',
				'description' => 'required',
				'url' => 'required',
//            'category_id'=>'required'
			);

			if ( $request->file('file')){
				$rules['file.*']='nullable|mimes:pdf,doc,csv,xlsx,xls,docx,ppt';
			}if ( $request->file('image')){
				$rules['image']='mimes:jpeg,jpg,png,gif|max:5000';
			}
			$validator = Validator::make($request->all(),$rules);
			if ($validator->fails()) {
				$messsage = '<div class="alert alert-danger"><ul>';
				foreach ($validator->errors()->all() as $m) {
					$messsage .= '<li>' . $m . '</li>';
				}
				$messsage .= '</ul></div>';
				return response()->json($messsage);
			}else {

				if ( $request->file('file')){
					$file_input = $request->file('file');
					$file_name = uploadFileToE3melbusiness($file_input);
					$pdf_file->file = $file_name;
				}
				if ( $request->file('image')){
					$pic = $request->file('image');
					$picName = uploadFileToE3melbusiness($pic,false,'',false,false,false,true);
					$pdf_file->image = $picName;

				}
				$published = (isset($data['published'])) ? 'yes' : 'no';
				$pdf_file->name = $data['name'];
				$pdf_file->url = $data['url'];
				$pdf_file->description = $data['description'];
				if ($published == 'yes' && $pdf_file->published=='no') {
					$pdf_file->published_by = Auth::user()->id;
					$pdf_file->published_date = date("Y-m-d H:i:s");
				}
				if ($published == 'no' && $pdf_file->published=='yes') {
					$pdf_file->unpublished_by = Auth::user()->id;
					$pdf_file->unpublished_date = date("Y-m-d H:i:s");
				}
				$pdf_file->published = $published;
				$pdf_file->lastedit_by = Auth::user()->id;
				$pdf_file->lastedit_date = date("Y-m-d H:i:s");
				if ($pdf_file->save()) {
					$messsage = '<div class="alert alert-success"><ul>';
					$messsage .= '<li>' . Lang::get('main.update') . '</li>';
					$messsage .= '</ul></div>';
					return response()->json($messsage);
				}
			}
		}

		/**
		 * Remove the specified resource from storage.
		 *
		 * @param  int $id
		 * @return \Illuminate\Http\Response
		 */
		public function destroy($id)
		{
			$pdf_file =PdfFiles::find($id);

			$pdf_file->delete();
		}

		public function publish(Request $request)
		{
			if ($request->ajax()) {
				$id = $request->input('id');
				$published = $request->input('published');
				$pdf_file = PdfFiles::find($id);
				if ($published == 'no') {

					$pdf_file->published = 'no';
					$pdf_file->unpublished_by = Auth::user()->id;
					$pdf_file->unpublished_date = date("Y-m-d H:i:s");
				} elseif ($published == 'yes') {


					$pdf_file->published = 'yes';
					$pdf_file->published_by = Auth::user()->id;
					$pdf_file->published_date = date("Y-m-d H:i:s");
				}
				$pdf_file->save();

			} else {
				return redirect(404);
			}
		}


	}
