<?php

namespace App\Http\Controllers\Admin;

use App\Models\Courses;
use App\Models\Package;
use App\Models\PackageUserCourse;
use App\Models\NormalUser;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class PackageUserCourseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $courses=Courses::pluck('name','id')->toArray();
        $packages=Package::pluck('name','id')->toArray();
        return view('auth.package_user_courses.view',compact('courses','packages'));
    }

    function search(Request $request)
    {
        $data = $request->input();
        $package_user_courses = PackageUserCourse::leftjoin('users','users.id','=','packages_users_courses.user_id')
                                ->leftjoin('courses','courses.id','=','packages_users_courses.course_id')
                                ->leftjoin('packages','packages.id','=','packages_users_courses.package_id')
                                ->select('packages_users_courses.*','users.Email as user_email','courses.name as course_name','packages.name as package_name');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $package_user_courses = $package_user_courses->where('packages_users_courses.id', '=', "$id");
        }
        if (isset($data['package']) && !empty($data['package'])) {
            $package = $data['package'];
            $package_user_courses = $package_user_courses->where('packages.name','LIKE', "%$package%");
        }
        if (isset($data['package_id']) && !empty($data['package_id'])) {
            $package_id = $data['package_id'];
            $package_user_courses = $package_user_courses->where('packages.id', $package_id);
        }
        if (isset($data['course']) && !empty($data['course'])) {
            $course = $data['course'];
            $package_user_courses = $package_user_courses->where('courses.id','=', $course);
        }
        if (isset($data['user']) && !empty($data['user'])) {
            $user = $data['user'];
            $package_user_courses = $package_user_courses->where('users.Email','LIKE', "%$user%");
        }
        if (isset($data['exam']) && !empty($data['exam'])) {
            $exam = $data['exam'];
            $package_user_courses = $package_user_courses->where('packages_users_courses.exam', 'LIKE', "%$exam%");
        }
        if (isset($data['sort']) && !empty($data['sort'])) {
            $sort = $data['sort'];
            $package_user_courses = $package_user_courses->where('packages_users_courses.sort', '=', $sort);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $package_user_courses = $package_user_courses->whereBetween('packages_users_courses.createtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }

        $iTotalRecords = $package_user_courses->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'packages_users_courses.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'packages_users_courses.id';
                break;
            case 1:
                $columnName = 'packages_users_courses.exam';
                break;
            case 2:
                $columnName = 'packages_users_courses.createtime';
                break;
            case 3:
                $columnName = 'packages.name';
                break;
            case 4:
                $columnName = 'courses.name';
                break;
            case 5:
                $columnName = 'users.Email';
                break;
            case 6:
                $columnName = 'packages_users_courses.sort';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $package_user_courses = $package_user_courses->where(function ($q) use ($search) {
                $q->where('packages_users_courses.exam', 'LIKE', "%$search%")
                    ->orWhere('packages_users_courses.id', '=', $search)
                    ->orWhere('packages.name', 'LIKE', "%$search%")
                    ->orWhere('courses.name', 'LIKE', "%$search%")
                    ->orWhere('users.Email', 'LIKE', "%$search%")
                    ->orWhere('packages_users_courses.sort', '=', $search);
            });
        }

        $package_user_courses = $package_user_courses->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($package_user_courses as $package_user_course) {
            $package_name = $package_user_course->package_name;
            $course_name = $package_user_course->course_name;
            $user_email = $package_user_course->user_email;
            if(PerUser('packages_edit') && $package_name !=''){
                $package_name= '<a target="_blank" href="' . URL('admin/packages/' . $package_user_course->package_id . '/edit') . '">' . $package_name . '</a>';
            }
            if(PerUser('courses_edit') && $course_name !=''){
                $course_name= '<a target="_blank" href="' . URL('admin/courses/' . $package_user_course->course_id . '/edit') . '">' . $course_name . '</a>';
            }
            if(PerUser('normal_user_edit') && $user_email !=''){
                $user_email= '<a target="_blank" href="' . URL('admin/normal_user/' . $package_user_course->user_id . '/edit') . '">' . $user_email . '</a>';
            }
            $records["data"][] = [
                $package_user_course->id,
                $package_user_course->exam,
                $package_user_course->createtime,
                $package_name,
                $course_name,
                $user_email,
                $package_user_course->sort,
//                '<td class="text-center">
//                                <div class="checkbox-nice checkbox-inline">
//                                    <input data-id="' . $package_user_course->id . '" type="checkbox" ' . ((!PerUser('package_user_courses_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('package_user_courses_publish')) ? 'class="changeStatues"' : '') . ' ' . (($package_user_course->published == "yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
//                                    <label for="checkbox-' . $package_user_course->id . '">
//                                    </label>
//                                </div>
//                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $package_user_course->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('package_user_courses_edit')) ? '<li>
                                            <a href="' . URL('admin/package_user_courses/' . $package_user_course->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('package_user_courses_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $package_user_course->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '
                                        ' . ((PerUser('package_user_courses_delete_all')) ? '<li>
                                            <a class="delete_all_this" data-id="' . $package_user_course->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete_all') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('package_user_courses_copy')) ? '<li>
                                            <a href="'.URL('admin/package_user_courses/copy/'.$package_user_course->id).'" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.copy') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $packages = Package::pluck('name', 'id');
        $courses = Courses::pluck('name', 'id');
        return view('auth.package_user_courses.add', compact('packages', 'courses'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'package' => 'required|exists:mysql2.packages,id',
                'course' => 'required|exists:mysql2.courses,id',
                'user' => 'required|exists:mysql2.users,Email',
                'sort' => 'required|integer',
                'exam' => 'required|in:not exam,pass,fail',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            //$published = (isset($data['published'])) ? 'yes' : 'no';
            $package_user_course = new PackageUserCourse();
            $package_user_course->package_id = $data['package'];
            $package_user_course->course_id = $data['course'];
            $package_user_course->user_id = NormalUser::where('Email', $data['user'])->first()->id;
            $package_user_course->sort = $data['sort'];
            $package_user_course->exam = $data['exam'];
            //$package_user_course->published = $published;
            $package_user_course->createtime = date("Y-m-d H:i:s");
//            if ($published == 'yes') {
//                $package_user_course->published_by = Auth::user()->id;
//                $package_user_course->published_date = date("Y-m-d H:i:s");
//            }
//            if ($published == 'no') {
//                $package_user_course->unpublished_by = Auth::user()->id;
//                $package_user_course->unpublished_date = date("Y-m-d H:i:s");
//            }
            $package_user_course->lastedit_by = Auth::user()->id;
            $package_user_course->added_by = Auth::user()->id;
            $package_user_course->lastedit_date = date("Y-m-d H:i:s");
            $package_user_course->added_date = date("Y-m-d H:i:s");
            if ($package_user_course->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.package_user_course'));
                return Redirect::to('admin/package_user_courses/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $package_user_course = PackageUserCourse::findOrFail($id);
        $packages = Package::pluck('name', 'id');
        $courses = Courses::pluck('name', 'id');
        $user=$package_user_course->user;
        $user=isset($package_user_course->user)?$package_user_course->user->Email:'';
        return view('auth.package_user_courses.edit', compact('package_user_course','packages','courses','user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $package_user_course = PackageUserCourse::findOrFail($id);
        $rules = array(
            'package' => 'required|exists:mysql2.packages,id',
            'course' => 'required|exists:mysql2.courses,id',
            'user' => 'required|exists:mysql2.users,Email',
            'sort' => 'required|integer',
            'exam' => 'required|in:not exam,pass,fail',
        );

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            //$published = (isset($data['published'])) ? 'yes' : 'no';
            $package_user_course->package_id = $data['package'];
            $package_user_course->course_id = $data['course'];
            $package_user_course->user_id = NormalUser::where('Email', $data['user'])->first()->id;
            $package_user_course->sort = $data['sort'];
            $package_user_course->exam = $data['exam'];
//            if ($published == 'yes' && $package_user_course->published=='no') {
//                $package_user_course->published_by = Auth::user()->id;
//                $package_user_course->published_date = date("Y-m-d H:i:s");
//            }
//            if ($published == 'no' && $package_user_course->published=='yes') {
//                $package_user_course->unpublished_by = Auth::user()->id;
//                $package_user_course->unpublished_date = date("Y-m-d H:i:s");
//            }
//            $package_user_course->published = $published;
            $package_user_course->lastedit_by = Auth::user()->id;
            $package_user_course->lastedit_date = date("Y-m-d H:i:s");
            if ($package_user_course->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.package_user_course'));
                return Redirect::to("admin/package_user_courses/$package_user_course->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $package_user_course = PackageUserCourse::findOrFail($id);
        $package_user_course->delete();
    }

//    public function publish(Request $request)
//    {
//        if ($request->ajax()) {
//            $id = $request->input('id');
//            $published = $request->input('published');
//            $package_user_course = packageUserCourse::findOrFail($id);
//            if ($published == 'no') {
//                $package_user_course->published = 'no';
//                $package_user_course->unpublished_by = Auth::user()->id;
//                $package_user_course->unpublished_date = date("Y-m-d H:i:s");
//            } elseif ($published == 'yes') {
//                $package_user_course->published = 'yes';
//                $package_user_course->published_by = Auth::user()->id;
//                $package_user_course->published_date = date("Y-m-d H:i:s");
//            }
//            $package_user_course->save();
//        } else {
//            return redirect(404);
//        }
//    }
    public function copy($id)
    {
        $package_user_course = PackageUserCourse::findOrFail($id);
        $package_user_course->createtime = date("Y-m-d H:i:s");
        $package_user_course->replicate()->save();
        return Redirect::to('admin/package_user_courses/'.$package_user_course->id.'/edit');
    }
    public function delete_all(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $package_user_courses= PackageUserCourse::findOrFail($id);
	        PackageUserCourse::where('package_id',$package_user_courses->package_id)
                ->where('user_id',$package_user_courses->user_id)->delete();

        } else {
            return redirect(404);
        }
    }

}
