<?php

namespace App\Http\Controllers\Admin;

use App\Models\Courses;
use App\Http\Controllers\Controller;
use App\Models\Package;
use App\Models\PackageCourse;
use Illuminate\Contracts\View\Factory;
use Illuminate\Foundation\Application;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\View\View;

class PackageCourseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Factory|Application|View
     */
    public function index()
    {
        $courses=Courses::pluck('name','id')->toArray();
        $packages=Package::pluck('name','id')->toArray();
        return view('auth.packages_courses.view',compact('courses','packages'));
    }

    function search(Request $request)
    {
        $package_courses = PackageCourse::with('course', 'package');
        if (isset($request->id) && !empty($request->id)) {
            $id = $request->id;
            $package_courses = $package_courses->first($id);
        }
        if (isset($request->name) && !empty($request->name)) {
            $name = $request->name;
            $package_courses = $package_courses->where('name', 'LIKE', "%$name%");
        }
        if (isset($request->package) && !empty($request->package)) {
            $package = $request->package;
            $package_courses = $package_courses->where('packages.name','LIKE', "%$package%");
        }
        if (isset($request->package_id) && !empty($request->package_id)) {
            $package_id = $request->package_id;
            $package_courses = $package_courses->where('packages.id', $package_id);
        }
        if (isset($request->related_course) && !empty($request->related_course)) {
            $related_course = $request->related_course;
            $package_courses = $package_courses->where('related_course','=', $related_course);
        }
        if (isset($request->sort) && !empty($request->sort)) {
            $sort = $request->sort;
            $package_courses = $package_courses->where('sort','=', $sort);
        }
        if (isset($request->order_field) && !empty($request->order_field)) {
            $order = $request->order_field;
            $package_courses = $package_courses->where('order','=', $order);
        }
        if (isset($request->created_time_from) && !empty($request->created_time_from) && isset($request->created_time_to) && !empty($request->created_time_to)) {
            $created_time_from = $request->created_time_from;
            $created_time_to = $request->created_time_to;
            $package_courses = $package_courses->whereBetween('createdtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }

        $iTotalRecords = $package_courses->count();
        $iDisplayLength = (int)$request->length;
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = (int)$request->start;
        $sEcho = (int)$request->draw;
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        switch ($request->order[0]['column']) {
            case 0:
	        default:
                $columnName = 'id';
                break;
            case 1:
                $columnName = 'name';
                break;
            case 2:
                $columnName = 'createdtime';
                break;
            case 3:
                $columnName = 'packages.name';
                break;
            case 5:
                $columnName = 'courses.name';
                break;
            case 6:
                $columnName = 'sort';
                break;
            case 7:
                $columnName = 'order';
                break;
        }

        $search = $request->search['value'];
        if ($search) {
            $package_courses = $package_courses->where(function ($q) use ($search) {
                $q->where('name', 'LIKE', "%$search%")
                    ->orWhere('id', '=', $search)
                    ->orWhere('packages.name', 'LIKE', "%$search%")
                    ->orWhere('courses.name', 'LIKE', "%$search%")
                    ->orWhere('sort', '=', $search)
                    ->orWhere('order', '=', $search);
            });
        }
        $package_courses = $package_courses->orderBy($columnName, $request->order[0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($package_courses as $course) {
            $course=makeDefaultImageGeneral($course,'image');
            $package_name = $course->package->name;
            $course_name = $course->course->name;
            if(PerUser('packages_edit') && $package_name !=''){
                $package_name= '<a target="_blank" href="' . URL('admin/packages/' . $course->package->id . '/edit') .
	                '">' . $package_name . '</a>';
            }
            if(PerUser('courses_edit') && $course_name !=''){
                $course_name= '<a target="_blank" href="' . URL('admin/courses/' . $course->course->id . '/edit') . '">'
	                . $course_name . '</a>';
            }
            $records["data"][] = [
                $course->id,
                $course->name,
                $course->createdtime,
                $package_name,
                '<a class="image-link" href="#image-modal" data-toggle="modal"><img width="50%" src="' . assetURL($course->image) . '"/></a>',
                $course_name,
                $course->sort,
                $course->order,
//                '<td class="text-center">
//                                <div class="checkbox-nice checkbox-inline">
//                                    <input data-id="' . $course->id . '" type="checkbox" ' . ((!PerUser('package_courses_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('package_courses_publish')) ? 'class="changeStatues"' : '') . ' ' . (($course->published == "yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
//                                    <label for="checkbox-' . $course->id . '">
//                                    </label>
//                                </div>
//                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $course->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('package_courses_edit')) ? '<li>
                                            <a href="' . URL('admin/package_courses/' . $course->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('package_courses_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $course->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($request->customActionType) && $request->customActionType == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $request->all();
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return Factory|Application|Response|View
     */
    public function create()
    {
        $packages = Package::pluck('name', 'id');
        $courses = Courses::all();
        return view('auth.packages_courses.add', compact('packages', 'courses'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {

        $data = $request->input();
            $rules = array(
            'name' => 'required',
            'description' => 'required',
            'image' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
            'package' => 'required|exists:mysql2.packages,id',
            'related_course' => 'required|exists:mysql2.courses,id',
             'sort' =>'required|integer|unique:mysql2.packages_courses,sort,NULL,id,package_id,'.$request->package,
             'order' =>'required|integer|unique:mysql2.packages_courses,order,NULL,id,package_id,'.$request->package,
            'type' => 'required',
        );

        if(isset($data['ksa_course'])){
            if ($data['type']=='according_to_country') {
                $rules['related_course_ksa'] = 'required_if:type,according_to_country|exists:mysql2.courses,id';
            }
        }


        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
//            $published = (isset($data['published'])) ? 'yes' : 'no';
            $pic = $request->file('image');
            $picName = uploadFileToE3melbusiness($pic);
            $course = new packageCourse();
            $course->name = $request->name;
            $course->type = $data['type'];
            $course->related_course = $request->related_course;
            $course->related_course_ksa = ($data['type']=='according_to_country')?$data['related_course_ksa']:$request->related_course;
            $course->sort = $request->sort;
            $course->order = $request->order;
            $course->description = $data['description'];
            $course->package_id = $request->package;
//            $course->published = $published;
            $course->image = $picName;
            $course->createdtime = date("Y-m-d H:i:s");
//            if ($published == 'yes') {
//                $course->published_by = Auth::user()->id;
//                $course->published_date = date("Y-m-d H:i:s");
//            }
//            if ($published == 'no') {
//                $course->unpublished_by = Auth::user()->id;
//                $course->unpublished_date = date("Y-m-d H:i:s");
//            }
            $course->lastedit_by = Auth::user()->id;
            $course->added_by = Auth::user()->id;
            $course->lastedit_date = date("Y-m-d H:i:s");
            $course->added_date = date("Y-m-d H:i:s");
            if ($course->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.package_course'));
                return Redirect::to('admin/package_courses/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return Factory|Application|Response|View
     */
    public function edit($id)
    {
        $course = PackageCourse::findOrFail($id);
        $courses = Courses::get();
        $packages = Package::pluck('name', 'id');
        return view('auth.packages_courses.edit', compact('packages','courses','course'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Request $request
     * @param  int $id
     * @return Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $course = packageCourse::findOrFail($id);
        $rules = array(
            'name' => 'required',
            'description' => 'required',
            'package' => 'required|exists:mysql2.packages,id',
            'related_course' => 'required|exists:mysql2.courses,id',
            'sort' =>'required|integer|unique:mysql2.packages_courses,sort,'.$id.',id,package_id,'.$request->package,
            'order' =>'required|integer|unique:mysql2.packages_courses,order,'.$id.',id,package_id,'.$request->package,
            'type' => 'required',
        );
        if(isset($data['ksa_course'])){
            if ($data['type']=='according_to_country') {
                $rules['related_course_ksa'] = 'required_if:type,according_to_country|exists:mysql2.courses,id';
            }
        }


        if ($request->file('image')) {
            $rules['image'] = 'mimes:jpeg,jpg,png,gif|required|max:5000';
        }

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
//            $published = (isset($data['published'])) ? 'yes' : 'no';
            $course->name = $request->name;
            $course->type = $data['type'];
            $course->related_course = $request->related_course;
            $course->related_course_ksa = ($data['type']=='according_to_country')?$data['related_course_ksa']:$request->related_course;
            $course->sort = $request->sort;
            $course->order = $request->order;
            $course->description = $data['description'];
            $course->package_id = $request->package;
            if ($request->file('image')) {
                $pic = $request->file('image');
                $picName = uploadFileToE3melbusiness($pic);
                $course->image = $picName;
            }
//            if ($published == 'yes' && $course->published=='no') {
//                $course->published_by = Auth::user()->id;
//                $course->published_date = date("Y-m-d H:i:s");
//            }
//            if ($published == 'no' && $course->published=='yes') {
//                $course->unpublished_by = Auth::user()->id;
//                $course->unpublished_date = date("Y-m-d H:i:s");
//            }
//            $course->published = $published;
            $course->lastedit_by = Auth::user()->id;
            $course->lastedit_date = date("Y-m-d H:i:s");
            if ($course->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.package_course'));
                return Redirect::to("admin/package_courses/$course->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return Response
     */
    public function destroy($id)
    {
        $course = packageCourse::findOrFail($id);
        $course->delete();
    }

//    public function publish(Request $request)
//    {
//        if ($request->ajax()) {
//            $id = $request->input('id');
//            $published = $request->input('published');
//            $course = packageCourse::findOrFail($id);
//            if ($published == 'no') {
//                $course->published = 'no';
//                $course->unpublished_by = Auth::user()->id;
//                $course->unpublished_date = date("Y-m-d H:i:s");
//            } elseif ($published == 'yes') {
//                $course->published = 'yes';
//                $course->published_by = Auth::user()->id;
//                $course->published_date = date("Y-m-d H:i:s");
//            }
//            $course->save();
//        } else {
//            return redirect(404);
//        }
//    }
}
