<?php

namespace App\Http\Controllers\Admin;

use App\Models\News;
use App\Models\OldUrls;
use App\Models\Tags;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class NewsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.news.view');
    }


    function search(Request $request)
    {
        $data = $request->input();
        $news = News::select('news.*');

        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $news = $news->where('news.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $news = $news->where('news.name', 'LIKE', "%$name%");
        }

        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $news = $news->where('news.url', 'LIKE', "%$url%");
        }

        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $news = $news->whereBetween('news.createdtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }
        $iTotalRecords = $news->count('news.id');
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'news.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'news.id';
                break;
            case 1:
                $columnName = 'news.name';
                break;
            case 5:
                $columnName = 'news.url';
                break;
            case 7:
                $columnName = 'news.news_date';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $news = $news->where(function ($q) use ($search) {
                $q->where('news.name', 'LIKE', "%$search%")
                    ->orWhere('news.views', 'LIKE', "%$search%")
                    ->orWhere('news.url', 'LIKE', "%$search%")
                    ->orWhere('news.description', 'LIKE', "%$search%")
                    ->orWhere('news.public', 'LIKE', "%$search%")
                    ->orWhere('news.picpath', 'LIKE', "%$search%")
                    ->orWhere('news.id', '=', $search);
            });
        }

        $news = $news->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($news as $new) {
            $new=makeDefaultImageGeneral($new,'picpath');
            $author=$new->author_name;
            if(PerUser('author_edit') && $author !=''){
                $author= '<a target="_blank" href="' . URL('admin/author/' . $new->author_id . '/edit') . '">' . $author . '</a>';
            }
            $records["data"][] = [
                $new->id,
                $new->name,
                '<a class="image-link" href="#image-modal" data-toggle="modal"><img width="100%" src="' . assetURL($new->picpath) . '"/></a>',
                '<a href="' . e3mURL('blog/' . $new->url) . '" target="_blank">' . $new->url . '</a>',
                date('Y-m-d',strtotime($new->news_date)),
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $new->id . '" type="checkbox" ' . ((!PerUser('news_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('news_publish')) ? 'class="changeStatues"' : '') . ' ' . (($new->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $new->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $new->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('news_edit')) ? '<li>
                                            <a href="' . URL('admin/news/' . $new->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('news_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $new->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '
                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        return view('auth.news.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $request->merge(array('url' => str_replace(' ', '-', $data['url'])));
        $validator = Validator::make($request->all(),
            array(
                'name' => 'required',
                'description' => 'required',
                'picture' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
                'url' => 'required|unique:mysql2.news,url',
                'news_date'=>'required'
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $pic = $request->file('picture');
            $picName = uploadFileToE3melbusiness($pic);
            $news = new News();
            $news->name = $data['name'];
            $news->description = $data['description'];
            $news->meta_description = $data['meta_description'];
            $news->news_date = $data['news_date'];
            $news->picpath = $picName;
            $news->url = str_replace(' ','-',$data['url']);
            $news->published = $published;
            if ($published == 'yes') {
                $news->published_by = Auth::user()->id;
                $news->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $news->unpublished_by = Auth::user()->id;
                $news->unpublished_date = date("Y-m-d H:i:s");
            }
            $news->added_by = Auth::user()->id;
            $news->added_date = date("Y-m-d H:i:s");
            if ($news->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.new'));
                return Redirect::to('admin/news/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $new = news::findOrFail($id);
        $new=makeDefaultImageGeneral($new,'picpath');
        return view('auth.news.edit', compact('new'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $new = News::find($id);
        $request->merge(array('url' => str_replace(' ', '-', $data['url'])));
        $rules=array(
            'name' => 'required',
            'description' => 'required',
            'url' => "required|unique:mysql2.news,url,$id,id",
            'news_date'=>'required'

        );
        if ( $request->file('picture')){
            $rules['picture']='mimes:jpeg,jpg,png,gif|required|max:5000';
        }
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            if ( $request->file('picture')){
                $pic = $request->file('picture');
                $picName = uploadFileToE3melbusiness($pic);
                $new->picpath = $picName;
            }
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $new->name = $data['name'];
            $new->description = $data['description'];
            $new->meta_description = $data['meta_description'];
            $new->news_date = $data['news_date'];
            $old_url = $new->url;
            $new->url = str_replace(' ','-',$data['url']);
            if ($published == 'yes' && $new->published=='no') {
                $new->published_by = Auth::user()->id;
                $new->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $new->published=='yes') {
                $new->unpublished_by = Auth::user()->id;
                $new->unpublished_date = date("Y-m-d H:i:s");
            }
            $new->published = $published;
            $new->lastedit_by = Auth::user()->id;
            $new->lastedit_date = date("Y-m-d H:i:s");
            if ($new->save()) {

                if($old_url != $new->url){
                    saveOldUrl($id,'news',$old_url,$new->url,Auth::user()->id,date("Y-m-d H:i:s"));
                }
                Session::flash('success', Lang::get('main.update') . Lang::get('main.new'));
                return Redirect::to("admin/news/$new->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $new = News::findOrFail($id);

            $old_url=$new->url;
            $new->url='/';
            $new->save();
            if($old_url != $new->url){
                saveOldUrl($id,'news',$old_url,$new->url,Auth::user()->id,date("Y-m-d H:i:s"));
            }
            $new->delete();
//            $new->deleted_by = Auth::user()->id;
//            $new->deleted_at = date("Y-m-d H:i:s");


    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $new = News::findOrFail($id);
                if ($published == 'no') {
                    $old_url=$new->url;
                    $new->url='/';
                    $new->published = 'no';
                    $new->unpublished_by = Auth::user()->id;
                    $new->unpublished_date = date("Y-m-d H:i:s");
                } elseif ($published == 'yes') {
                    $old_urls=OldUrls::where('table_id',$id)->where('table_name','news')->where('new_url','/')->first();
                    $old_url='/';
                    $new->url=$old_urls->old_url;
                    $new->published = 'yes';
                    $new->published_by = Auth::user()->id;
                    $new->published_date = date("Y-m-d H:i:s");
                }
                $new->save();
                if($old_url != $new->url){
                    saveOldUrl($id,'news',$old_url,$new->url,Auth::user()->id,date("Y-m-d H:i:s"));
                }

        } else {
            return redirect(404);
        }
    }


public function description_upload(Request $request)
{
    $pic = $request->file('file');
    $picName = uploadFileToE3melbusiness($pic);
    return response()->json(['location'=>'/assets/images/'.$picName]);

}
}
