<?php

namespace App\Http\Controllers\Admin;

use App\Models\Marketers;
use App\Models\OldUrls;
use App\Models\Tags;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class MarketersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.marketers.view');
    }


    function search(Request $request)
    {
        $data = $request->input();
        $marketers = Marketers::select('marketers.*');

        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $marketers = $marketers->where('marketers.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $marketers = $marketers->where('marketers.name', 'LIKE', "%$name%");
        }

        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $marketers = $marketers->where('marketers.phone', 'LIKE', "%$phone%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $marketers = $marketers->where('marketers.email', 'LIKE', "%$email%");
        }

        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $marketers = $marketers->whereBetween('marketers.createdtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }
        $iTotalRecords = $marketers->count('marketers.id');
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'marketers.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'marketers.id';
                break;
            case 1:
                $columnName = 'marketers.name';
                break;
            case 5:
                $columnName = 'marketers.phone';
                break;
            case 6:
                $columnName = 'marketers.email';
                break;
            case 7:
                $columnName = 'marketers.percentage';
                break;
            case 8:
                $columnName = 'marketers.active';
                break;
            case 9:
                $columnName = 'marketers.created_at';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $marketers = $marketers->where(function ($q) use ($search) {
                $q->where('marketers.name', 'LIKE', "%$search%")
                    ->orWhere('marketers.phone', 'LIKE', "%$search%")
                    ->orWhere('marketers.email', 'LIKE', "%$search%")
                    ->orWhere('marketers.id', '=', $search);
            });
        }

        $marketers = $marketers->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($marketers as $marketer) {
            $records["data"][] = [
                $marketer->id,
                $marketer->name,
                $marketer->phone,
                $marketer->email,
                $marketer->percentage,
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $marketer->id . '" type="checkbox" ' . ((!PerUser('marketers_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('marketers_publish')) ? 'class="changeStatues"' : '') . ' ' . (($marketer->active) ? 'checked="checked"' : '') . '  id="checkbox-'.$marketer->id.'">
                                    <label for="checkbox-' . $marketer->id . '">
                                    </label>
                                </div>
                            </td>',
                $marketer->created_at,
                '<div class="btn-group text-center" id="single-order-' . $marketer->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('marketers_edit')) ? '<li>
                                            <a href="' . URL('admin/marketers/' . $marketer->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('marketers_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $marketer->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '
                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a marketer resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        return view('auth.marketers.add');
    }

    /**
     * Store a marketerly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $request->merge(array('url' => str_replace(' ', '-', $data['url'])));
        $validator = Validator::make($request->all(),
            array(
                'name' => 'required',
                'email' => 'required|email',
                'password' => 'required',
                'percentage' => 'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $active = ($request->active) ? 1 : 0;
            $marketers = new Marketers();
            $marketers->name = $data['name'];
            $marketers->phone = $request->phone;
            $marketers->email = $request->email;
            $marketers->password = $request->password;
            $marketers->percentage = $request->percentage;

            $marketers->active = $active;
            if ($active) {
                $marketers->active_by = Auth::user()->id;
                $marketers->active_at = date("Y-m-d H:i:s");
            }else{
                $marketers->unactive_by = Auth::user()->id;
                $marketers->unactive_at = date("Y-m-d H:i:s");
            }
            $marketers->created_by = Auth::user()->id;
            if ($marketers->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.marketer'));
                return Redirect::to('admin/marketers/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $marketer = Marketers::findOrFail($id);
        return view('auth.marketers.edit', compact('marketer'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $marketer = Marketers::find($id);
        $rules=array(
            'name' => 'required',
            'email' => 'required|email',
            'password' => 'required',
            'percentage' => 'required',
        );
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $active = $request->active ? 1 :0;
            $marketer->name = $data['name'];
            $marketer->phone = $request->phone;
            $marketer->email = $request->email;
            $marketer->percentage = $request->percentage;
            if ($active && !$marketer->active) {
                $marketer->active_by = Auth::user()->id;
                $marketer->unactive_at = date("Y-m-d H:i:s");
            }
            if($request->password){
                $marketer->password = $request->password;
            }

            if (!$active&& $marketer->active) {
                $marketer->unpublished_by = Auth::user()->id;
                $marketer->unpublished_at = date("Y-m-d H:i:s");
            }
            $marketer->active = $active;
            $marketer->updated_by = Auth::user()->id;
            $marketer->updated_at = date("Y-m-d H:i:s");
            if ($marketer->save()) {

                Session::flash('success', Lang::get('main.update') . Lang::get('main.marketer'));
                return Redirect::to("admin/marketers/$marketer->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $marketer = Marketers::findOrFail($id);
        $marketer->update(['deleted_at'=>date('Y-m-d H:i:s'),'deleted_by'=>auth()->id()]);



    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $marketer = Marketers::findOrFail($id);
                if ($published == 'no') {
                    $marketer->active = 0;
                    $marketer->unactive_by = Auth::user()->id;
                    $marketer->unactive_at = date("Y-m-d H:i:s");
                } elseif ($published == 'yes') {
                    $marketer->active = 1;
                    $marketer->active_by = Auth::user()->id;
                    $marketer->active_at = date("Y-m-d H:i:s");
                }
                $marketer->save();

        } else {
            return redirect(404);
        }
    }
    public function report(Request $request){
        if($request->ajax()){
            $data = $request->input();
            $condition="";
            if($request->start_date&&$request->end_date){
                $condition=" AND DATE(created_at) BETWEEN '$request->start_date' AND '$request->end_date'";
            }
            $marketers = Marketers::select('marketers.*',
                DB::raw("( SELECT COUNT('X') FROM `all_payments_transactions` INNER JOIN promotion_code ON promotion_code.id=all_payments_transactions.promotion_id AND success_at IS NOT NULL AND promotion_code.marketer_id=marketers.id $condition) AS count_coupons"),
                DB::raw("( SELECT SUM(all_payments_transactions.amount) FROM `all_payments_transactions` INNER JOIN promotion_code ON promotion_code.id=all_payments_transactions.promotion_id AND success_at IS NOT NULL AND promotion_code.marketer_id=marketers.id $condition) AS sum_amount")
            );
//            dd(getEloquentSqlWithBindings($marketers));
            if (isset($data['id']) && !empty($data['id'])) {
                $id = $data['id'];
                $marketers = $marketers->where('marketers.id', '=', "$id");
            }
            if (isset($data['name']) && !empty($data['name'])) {
                $name = $data['name'];
                $marketers = $marketers->where('marketers.name', 'LIKE', "%$name%");
            }
            $iTotalRecords = $marketers->count('marketers.id');
            $iDisplayLength = intval($data['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($data['start']);
            $sEcho = intval($data['draw']);
            $records = [];
            $records["data"] = [];
            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
            $columnName = 'marketers.id';
            switch ($data['order'][0]['column']) {
                case 0:
                    $columnName = 'marketers.id';
                    break;
                case 1:
                    $columnName = 'marketers.name';
                    break;
                case 2:
                    $columnName = 'count_coupons';
                    break;
                case 3:
                    $columnName = 'sum_amount';
                    break;
            }
            $search = $data['search']['value'];
            if ($search) {
                $marketers = $marketers->where(function ($q) use ($search) {
                    $q->where('marketers.name', 'LIKE', "%$search%")
                        ->orWhere('marketers.phone', 'LIKE', "%$search%")
                        ->orWhere('marketers.email', 'LIKE', "%$search%")
                        ->orWhere('marketers.id', '=', $search);
                });
            }

            $marketers = $marketers->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
                ->get();

            foreach ($marketers as $marketer) {
                $records["data"][] = [
                    $marketer->id,
                    $marketer->name,
                    '<a href="'.URL('admin/marketers/report_details?'.http_build_query(array_merge($request->only('start_date','end_date'),['marketer_id'=>$marketer->id,]))).'">'.$marketer->count_coupons.'</a>',
                    '<a href="'.URL('admin/marketers/report_details?'.http_build_query(array_merge($request->only('start_date','end_date'),['marketer_id'=>$marketer->id,]))).'">'.($marketer->sum_amount?$marketer->sum_amount:0).'</a',
                   '',
                ];
            }
            if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }
            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $records['postData'] = $data;
            //return response()->json($data)->setCallback($request->input('callback'));
            return response()->json($records)->setCallback($request->input('callback'));

        }
        return view('auth.marketers.report');
    }
    public function reportDetails(Request $request){
        if($request->ajax()){
            $data = $request->input();

            $marketers = DB::connection('mysql2')->table('all_payments_transactions')
                ->selectRaw("marketers.id,marketers.name,all_payments_transactions.first_name,all_payments_transactions.last_name,all_payments_transactions.amount,all_payments_transactions.charge_name,all_payments_transactions.created_at")
                ->join('promotion_code','promotion_code.id','=','all_payments_transactions.promotion_id')
                ->join('marketers','marketers.id','=','promotion_code.marketer_id')
            ;
            if($request->start_date&&$request->end_date){
                $marketers=$marketers->whereBetween(DB::raw("DATE(all_payments_transactions.created_at)"),[$request->start_date,$request->end_date]);
            }
            if($request->marketer_ids&&is_array($request->marketer_ids)){
                $marketers=$marketers->whereIn('marketers.id',$request->marketer_ids);
            }
//            dd(getEloquentSqlWithBindings($marketers));
            if (isset($data['id']) && !empty($data['id'])) {
                $id = $data['id'];
                $marketers = $marketers->where('marketers.id', '=', "$id");
            }
            if (isset($data['name']) && !empty($data['name'])) {
                $name = $data['name'];
                $marketers = $marketers->where('marketers.name', 'LIKE', "%$name%");
            }
            $iTotalRecords = $marketers->count('marketers.id');
            $iDisplayLength = intval($data['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($data['start']);
            $sEcho = intval($data['draw']);
            $records = [];
            $records['sql']=getEloquentSqlWithBindings($marketers);
            $records["data"] = [];
            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
            $columnName = 'marketers.id';
            switch ($data['order'][0]['column']) {
                case 0:
                    $columnName = 'marketers.id';
                    break;
                case 1:
                    $columnName = 'marketers.name';
                    break;
                case 2:
                    $columnName = 'all_payments_transactions.first_name';
                    break;
                case 3:
                    $columnName = 'all_payments_transactions.last_name';
                    break;
                case 4:
                    $columnName = 'all_payments_transactions.amount';
                    break;
                case 5:
                    $columnName = 'all_payments_transactions.charge_name';
                    break;
                case 6:
                    $columnName = 'all_payments_transactions.created_at';
                    break;
            }
            $search = $data['search']['value'];
            if ($search) {
                $marketers = $marketers->where(function ($q) use ($search) {
                    $q->where('marketers.name', 'LIKE', "%$search%")
                        ->orWhere('marketers.phone', 'LIKE', "%$search%")
                        ->orWhere('marketers.email', 'LIKE', "%$search%")
                        ->orWhere('marketers.id', '=', $search);
                });
            }

            $marketers = $marketers->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
                ->get();

            foreach ($marketers as $marketer) {
                $records["data"][] = [
                    $marketer->id,
                    $marketer->name,
                    $marketer->first_name,
                    $marketer->last_name,
                    $marketer->amount,
                    $marketer->charge_name,
                    $marketer->created_at,
                   '',
                ];
            }
            if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }
            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $records['postData'] = $data;
            //return response()->json($data)->setCallback($request->input('callback'));
            return response()->json($records)->setCallback($request->input('callback'));

        }
        return view('auth.marketers.report_details');
    }

}
