<?php

namespace App\Http\Controllers\Admin;

use App\Models\Successstories;
use App\Models\EncountersvideosViews;
use App\Http\Controllers\Controller;
use App\Models\NormalUser;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Session;

class EncountersvideosViewsController extends Controller
{

    // index method
    public function index()
    {
        return view('auth.encountersvideos_views.view');
    }

    // search method
    function search(Request $request)
    {

        $data = $request->input();

        $ssvs = EncountersvideosViews::leftjoin('users','users.id','=','encounters_videos_views.user_id')

        ->leftjoin('encountersvideos','encountersvideos.id','=','encounters_videos_views.encountersvideos_id')

        ->select('encounters_videos_views.*','encountersvideos.name as encountersvideos_name','users.Email as user_email');

        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $ssvs = $ssvs->where('encounters_videos_views.id', '=', $id);
        }

        if (isset($data['user']) && !empty($data['user'])) {
            $user = $data['user'];
            $ssvs = $ssvs->where('users.Email','LIKE', "%$user%");
        }

        if (isset($data['count']) && !empty($data['count'])) {
            $count = $data['count'];
            $ssvs = $ssvs->where('encountersvideos_views.count', '=', $count);
        }

        if (isset($data['encountersvideos']) && !empty($data['encountersvideos'])) {
            $encountersvideos = $data['encountersvideos'];
            $ssvs = $ssvs->where('encountersvideos.name','LIKE', "%$encountersvideos%");
        }

        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $ssvs = $ssvs->whereBetween('encounters_videos_views.createdtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }

        $iTotalRecords = $ssvs->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'encountersvideos_views.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'encounters_videos_views.id';
                break;
            case 1:
                $columnName = 'successtories.name';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'encounters_videos_views.count';
                break;
            case 4:
                $columnName = 'encounters_videos_views.createdtime';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $ssvs = $ssvs->where(function ($q) use ($search) {
                $q->where('encounters_videos_views.id', '=', $search)
                    ->orWhere('encountersvideos_views.count', '=', $search)
                    ->orWhere('successtories.name', 'LIKE', "%$search%")
                    ->orWhere('users.Email', 'LIKE', "%$search%");
            });
        }

        $ssvs = $ssvs->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($ssvs as $ssv) {
            $encountersvideo_name = $ssv->encountersvideo_name;
            $user_email = $ssv->user_email;
            if(PerUser('successstories_edit') && $encountersvideo_name !=''){
                $encountersvideo_name= '<a target="_blank" href="' . URL('admin/successstories/' . $ssv->encountersvideo_id . '/edit') . '">' . $encountersvideo_name . '</a>';
            }
            if(PerUser('normal_user_edit') && $user_email !=''){
                $user_email= '<a target="_blank" href="' . URL('admin/normal_user/' . $ssv->user_id . '/edit') . '">' . $user_email . '</a>';
            }
            $records["data"][] = [
                $ssv->id,
                $encountersvideo_name,
                $user_email,
                $ssv->count,
                $ssv->createdtime,
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $ssv->id . '" type="checkbox" ' . ((!PerUser('encountersvideos_views_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('encountersvideos_views_publish')) ? 'class="changeStatues"' : '') . ' ' . (($ssv->published=="yes") ? 'checked="checked"' : '') . ' ">
                                    <label for="checkbox-' . $ssv->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $ssv->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('encountersvideos_views_edit')) ? '<li>
                                            <a href="' . URL('admin/encountersvideos_views/' . $ssv->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('encountersvideos_views_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $ssv->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }

        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }



    public function create()
    {
        $successtories=Successstories::pluck('name', 'id');
        return view('auth.encountersvideos_views.add',compact('successtories'));
    }



    public function store(Request $request)
    {
        $data = $request->input();
        $rules=array(
            'encountersvideo' => 'required|exists:mysql2.successtories,id',
            'user' => 'required',
            'count' => 'required|numeric',
        );
        $user=NormalUser::where('Email', $data['user'])->first();
        if($user===null){
            $rules['user']= 'required|exists:mysql2.users,Email';
        }
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $encountersvideo_view = new EncountersvideosViews();
            $encountersvideo_view->encountersvideo_id = $data['encountersvideo'];
            $encountersvideo_view->user_id = $user->id;
            $encountersvideo_view->count = $data['count'];
            $encountersvideo_view->published = $published;
            $encountersvideo_view->createdtime = date("Y-m-d H:i:s");
            if ($published == 'yes') {
                $encountersvideo_view->published_by = Auth::user()->id;
                $encountersvideo_view->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $encountersvideo_view->unpublished_by = Auth::user()->id;
                $encountersvideo_view->unpublished_date = date("Y-m-d H:i:s");
            }
            $encountersvideo_view->lastedit_by = Auth::user()->id;
            $encountersvideo_view->added_by = Auth::user()->id;
            $encountersvideo_view->lastedit_date = date("Y-m-d H:i:s");
            $encountersvideo_view->added_date = date("Y-m-d H:i:s");
            if ($encountersvideo_view->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.encountersvideo_view'));
                return Redirect::to('admin/encountersvideos_views/create');
            }
        }
    }



    public function edit($id)
    {
        $encountersvideo_view = EncountersvideosViews::findOrFail($id);
        $successtories=Successstories::pluck('name', 'id');
        $user=NormalUser::where('id', $encountersvideo_view->user_id)->first();
        $user=($user!==null)?$user->Email:'';
        return view('auth.encountersvideos_views.edit', compact('encountersvideo_view','successtories','user'));
    }



    public function update(Request $request, $id)
    {
        $data = $request->input();
        $encountersvideo_view = EncountersvideosViews::findOrFail($id);
        $rules=array(
            'encountersvideo' => 'required|exists:mysql2.successtories,id',
            'user' => 'required',
            'count' => 'required|numeric',
        );

        $user=NormalUser::where('Email', $data['user'])->first();
        if($user===null){
            $rules['user']= 'required|exists:mysql2.users,Email';
        }
        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $encountersvideo_view->user_id = $user->id;
            $encountersvideo_view->encountersvideo_id = $data['encountersvideo'];
            $encountersvideo_view->count = $data['count'];
            if ($published == 'yes' && $encountersvideo_view->published=='no') {
                $encountersvideo_view->published_by = Auth::user()->id;
                $encountersvideo_view->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $encountersvideo_view->published=='yes') {
                $encountersvideo_view->unpublished_by = Auth::user()->id;
                $encountersvideo_view->unpublished_date = date("Y-m-d H:i:s");
            }
            $encountersvideo_view->published = $published;
            $encountersvideo_view->lastedit_by = Auth::user()->id;
            $encountersvideo_view->lastedit_date = date("Y-m-d H:i:s");
            $encountersvideo_view->modifiedtime = date("Y-m-d H:i:s");
            if ($encountersvideo_view->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.encountersvideo_view'));
                return Redirect::to("admin/encountersvideos_views/$encountersvideo_view->id/edit");
            }
        }
    }

    // delete method
    public function destroy($id)
    {
        $encountersvideo_view = EncountersvideosViews::findOrFail($id);
        $encountersvideo_view->delete();
    }

    // publish method
    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $encountersvideo_view = EncountersvideosViews::findOrFail($id);
            if ($published == 'no') {
                $encountersvideo_view->published = 'no';
                $encountersvideo_view->unpublished_by = Auth::user()->id;
                $encountersvideo_view->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {
                $encountersvideo_view->published = 'yes';
                $encountersvideo_view->published_by = Auth::user()->id;
                $encountersvideo_view->published_date = date("Y-m-d H:i:s");
            }
            $encountersvideo_view->save();
        } else {
            return redirect(404);
        }
    }
}
