<?php

namespace App\Http\Controllers\Admin;

use App\Models\Courses;
use App\Models\CoursesCurriculum;
use App\Models\CurriculumQuestions;
use App\Models\CurriculumQuestionsDetails;
use App\Models\Diplomas;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\DiplomasSupplementaryTests;
use App\Models\DiplomasSupplementaryTestsQuestions;
use App\Models\DiplomasSupplementaryTestsQuestionsDetails;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use App\Http\Requests\DiplomasSupplementaryRequest;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;
use Illuminate\Validation\Rule;

class DiplomasSupplementaryTestsController extends Controller
{


    public function index() {



        $diplomas = Diplomas::select('diplomas.*');

        $diplomas=$diplomas->get();

        return view('auth.supplementary_tests.view', compact('diplomas'));
    }



    public function search(Request $request) {

        $diplomas_questions = DiplomasSupplementaryTests::select('diplomas_supplementary_tests.*', 'diplomas.name AS diploma_name',DB::raw("(SELECT COUNT(id) FROM diplomas_supplementary_tests_questions WHERE diplomas_supplementary_id=diplomas_supplementary_tests.id)"))
        ->leftJoin('diplomas', 'diplomas_supplementary_tests.diploma_id', '=', 'diplomas.id');

        // $diplomas_questions_count = DiplomasSupplementaryTestsQuestions::
        // leftJoin('diplomas_supplementary_tests', 'diplomas_supplementary_tests_questions.diplomas_supplementary_id', '=', 'diplomas_supplementary_tests.id')
        // ->leftJoin('diplomas', 'diplomas_supplementary_tests.diploma_id', '=', 'diplomas.id')->count();

        $data = $request->input();


        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $diplomas_questions = $diplomas_questions->where('diplomas_supplementary_tests.id', '=', "$id");
        }
        if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
            $diploma_name = $data['diploma_name'];
            $diplomas_questions = $diplomas_questions->where('diplomas.name', 'LIKE', "%$diploma_name%");
        }

        if (isset($data['questions_numbers']) && !empty($data['questions_numbers'])) {
            $questions_numbers = $data['questions_numbers'];
            $diplomas_questions = $diplomas_questions->where('diplomas_supplementary_tests.questions_numbers', '=', $questions_numbers);
        }
        if (isset($data['questions_count']) && !empty($data['questions_count'])) {
            $questions_count = $data['questions_count'];
            $diplomas_questions = $diplomas_questions->where('diplomas_supplementary_tests.questions_count', '=', $questions_count);
        }

        $iTotalRecords = $diplomas_questions->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'diplomas_supplementary_tests.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'diplomas_supplementary_tests.id';
                break;
            case 1:
                $columnName = 'diplomas.name';
                break;

            case 4:
                $columnName = 'diplomas_supplementary_tests.questions_numbers';
                break;
            case 5:
                $columnName = 'questions_count';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $diplomas_questions = $diplomas_questions->where(function ($q) use ($search) {
                $q->orWhere('diplomas.name', 'LIKE', "%$search%")
                    ->orWhere('diplomas_supplementary_tests.questions_numbers', '=', $search)
                    ->orWhere('questions_count', '=', $search)
                    ->orWhere('diplomas_supplementary_tests.id', '=', $search);
            });
        }

        $diplomas_questions = $diplomas_questions->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        foreach ($diplomas_questions as $question) {
            $records["data"][] = [
                $question->id,
                $question->diploma_name,
                $question->questions_numbers,
                $question->questions_count,

                '<div class="btn-group text-center">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('supplementary_tests_edit')) ? '<li>
                                            <a href="' . URL('admin/supplementary_tests/' . $question->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('supplementary_tests_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $question->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '
                                    </ul>
                                </div>'
            ];
        }

        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }




    public function create() {
        admin_activity_action('create', 'diplomas_supplementary_tests', '');

        $diplomas = Diplomas::get();
        return view('auth.supplementary_tests.add', compact('diplomas'));
    }



    public function store(Request $request) {

        $this->validate($request,
            [
                'questions_numbers'  => 'required',
                'diploma_id'    => 'required|unique:mysql2.diplomas_supplementary_tests,deleted_at,NULL|max:255',
            ]
    );
        $diplomasupplementary = DiplomasSupplementaryTests::create([
            'questions_numbers' => $request->questions_numbers,
            'diploma_id' => $request->diploma_id,

            ]);


            if ( $request->file('file')){
                $pic = $request->file('file');
                $picName = uploadFileToE3melbusiness($pic);
                $diplomasupplementary->file = $picName;
            }

            $diplomasupplementary->save();

            return redirect('admin/supplementary_tests/' . $diplomasupplementary->id . '/edit');
    }


    public function show($type,$id) {
        $course_question = DiplomasSupplementaryTests::find($id);
        switch ($type) {
            case 'true_false':
                $returnHTML = view('auth.supplementary_tests.new_questions.true_false')->with(['course_question' => $course_question])->render();
                return response()->json(['html'=>$returnHTML], 200);
                break;
                case 'chose_single':
                    $returnHTML = view('auth.supplementary_tests.new_questions.chose_single')->with(['course_question' => $course_question])->render();
                    return response()->json(['html'=>$returnHTML], 200);
                    break;
                case 'chose_multiple':
                    $returnHTML = view('auth.supplementary_tests.new_questions.chose_multiple')->with(['course_question' => $course_question])->render();
                    return response()->json(['html'=>$returnHTML], 200);
                    break;
                case 'chose_single_with_images':
                    $returnHTML = view('auth.supplementary_tests.new_questions.chose_single_with_images')->with(['course_question' => $course_question])->render();
                    return response()->json(['html'=>$returnHTML], 200);
                    break;
                case 'chose_multiple_with_images':
                    $returnHTML = view('auth.supplementary_tests.new_questions.chose_multiple_with_images')->with(['course_question' => $course_question])->render();
                    return response()->json(['html'=>$returnHTML], 200);
                    break;
            default:
                // code...
                break;
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */

    public function edit($id) {

        admin_activity_action('update', 'diplomas_supplementary_tests');

        $courses = Courses::get();

        $diplomas = Diplomas::get();

        $diploma_question = DiplomasSupplementaryTests::find($id);

        if (count($diploma_question)) {
            $courses_questions = DiplomasSupplementaryTestsQuestions::where('diplomas_supplementary_id', $id)->get();
         //   dd($courses_questions);
            return view('auth.supplementary_tests.edit', compact('course_question','diploma_question', 'courses_questions', 'diplomas','courses'));

        } else {
            return abort(404);
        }
    }



    public function UpdateSupplementary(Request $request,$id)
    {

        $diploma_question = DiplomasSupplementaryTests::find($id);


        $v = Validator::make($request->all(), [
            'questions_numbers' => 'required',
        ]);

        if ($v->fails()) {
            return Response::json(['errors' => $v->errors()]);
        }
        $diploma_question->update([

            'diploma_id' => $request->diploma_id,

            'questions_numbers' => $request->questions_numbers,

        ]);

        if($request->hasFile('file')){

            $validator = Validator::make($request->all(),array(
                'file' => 'required'
            ));
            if ($validator->fails()) {
               return response()->json(['success'=>false,'message'=>$validator->errors()->all()]);
            }else{
                $pic = $request->file('file');
                $picName = uploadFileToE3melbusiness($pic);
                $diploma_question->file = $picName;
            }
        }

        $diploma_question->save();

       return response()->json($diploma_question);

    }



    public function update(DiplomasSupplementaryRequest $request, $id) {

        $Question_id = $request->input('question_id');

        $data = $request->input();
        $supplementary_tests = DiplomasSupplementaryTests::find($id);

        if (count($supplementary_tests)) {

            $diploma_question = DiplomasSupplementaryTestsQuestions::find($Question_id);

            if(!count($diploma_question)) {
                $diploma_question = new DiplomasSupplementaryTestsQuestions();
            }

            $diploma_question->diplomas_supplementary_id = $supplementary_tests->id;
            $diploma_question->diploma_id = $supplementary_tests->diploma_id;
            $diploma_question->type = $data['type'];
            $diploma_question->name = $data['question'];
            if(isset($data['question_en'])) {
                $diploma_question->name_en = $data['question_en'];
            }

            if (Input::hasFile('image')) {
                $image = $request->file('image');
                $fileImage = uploadFileToE3melbusiness($image, false, 'exams_question');
                $diploma_question->image = $fileImage;
            }

            $diploma_question->save();

            switch ($data['type']) {
                case 'true_false':
                    $diploma_question_details = DiplomasSupplementaryTestsQuestionsDetails::where('quetion_id', $Question_id)->first();
                    if(!count($diploma_question_details)){
                        $diploma_question_details = new DiplomasSupplementaryTestsQuestionsDetails();
                    }
                    $diploma_question_details->diplomas_supplementary_id = $supplementary_tests->id;

                    $diploma_question_details->diploma_id = $supplementary_tests->diploma_id;

                    $diploma_question_details->quetion_id = $diploma_question->id;
                    $diploma_question_details->answer = $data['answers'];
                    $diploma_question_details->order = 0;
                    $diploma_question_details->save();
                    break;
                case 'chose_single':
                    $orders = [];
                    $x = 0;
                    foreach ($data['answers_text'] as $key => $answer_text) {
                        if($Question_id == null) {
                            $diploma_question_details = new DiplomasSupplementaryTestsQuestionsDetails();
                        } else {
                            $diploma_question_details = DiplomasSupplementaryTestsQuestionsDetails::find($key);
                            $orders[] = $key;
                        }

                        $diploma_question_details->diplomas_supplementary_id = $supplementary_tests->id;
                        $diploma_question_details->quetion_id = $diploma_question->id;
                        $diploma_question_details->name = $answer_text;
                        if (!empty($data['answers_text_en'])) {
                            $diploma_question_details->name_en = $data['answers_text_en'][$key];
                        }
                        $diploma_question_details->answer = $data['chose_single'] == $key ? 1 : 0;
                        $diploma_question_details->order = $x;
                        $diploma_question_details->save();
                        $x++;
                    }
                    $diploma_question_details = DiplomasSupplementaryTestsQuestionsDetails::where('quetion_id', $Question_id)->whereNotIn('id', $orders)->delete();
                    break;
                case 'chose_multiple':
                    $orders = [];
                    $x=0;
                    foreach ($data['answers_text'] as $key => $answer_text) {
                        if($Question_id == null) {
                            $diploma_question_details = new DiplomasSupplementaryTestsQuestionsDetails();
                        } else {
                            $diploma_question_details = DiplomasSupplementaryTestsQuestionsDetails::find($key);
                            $orders[] = $key;
                        }
                        $diploma_question_details->diplomas_supplementary_id = $supplementary_tests->id;
                        $diploma_question_details->quetion_id = $diploma_question->id;
                        $diploma_question_details->name = $answer_text;
                        if (!empty($data['answers_text_en'])) {
                            $diploma_question_details->name_en = $data['answers_text_en'][$key];
                        }
                        $diploma_question_details->answer = isset($data['chose_multiple'][$key]) && $data['chose_multiple'][$key] == $key ? 1 : 0;
                        $diploma_question_details->order = $x;
                        $diploma_question_details->save();
                        $x++;
                    }
                    $diploma_question_details = DiplomasSupplementaryTestsQuestionsDetails::where('quetion_id', $Question_id)->whereNotIn('id', $orders)->delete();
                    break;
                case 'chose_single_with_images':
                    $delete = [];
                    if($request->input('answers_images_edit') != null) {
                        $x=0;
                        foreach ($request->input('answers_images_edit') as $key => $answer_image) {
                            $diploma_question_details = DiplomasSupplementaryTestsQuestionsDetails::find($key);
                            $delete[] = $key;

                            $diploma_question_details->diplomas_supplementary_id = $supplementary_tests->id;
                            $diploma_question_details->quetion_id = $diploma_question->id;
                            $split_image = explode('images/', $answer_image);
                            $diploma_question_details->image = $split_image[1];
                            $delete[] = $split_image[1];
                            $diploma_question_details->name = '';
                            $diploma_question_details->answer = $data['chose_single'] == $key ? 1 : 0;
                            $diploma_question_details->save();
                            $x++;
                        }
                    }
                    if(Input::hasFile('answers_images')) {
                        $images = Input::file('answers_images');
                        $x=0;
                        foreach ($images as $key => $answer_image) {
                            if($Question_id == null) {
                                $diploma_question_details = new DiplomasSupplementaryTestsQuestionsDetails();
                                $diploma_question_details->order = $x;
                            } else {
                                $diploma_question_details = DiplomasSupplementaryTestsQuestionsDetails::find($key);
                                $delete[]=$key;
                            }
                            $diploma_question_details->diplomas_supplementary_id = $supplementary_tests->id;
                            $diploma_question_details->quetion_id = $diploma_question->id;
                            $img = $answer_image;
                            $img_name = uploadFileToE3melbusiness($img);
                            $diploma_question_details->image = $img_name;
                            $diploma_question_details->name = '';
                            $diploma_question_details->answer = $data['chose_single'] == $key ? 1 : 0;
                            $diploma_question_details->save();
                            $x++;
                        }
                    }
                    $diploma_question_details = DiplomasSupplementaryTestsQuestionsDetails::where('quetion_id', $Question_id)->whereNotIn('id', $delete)->delete();

                    break;
                case 'chose_multiple_with_images':
                    $delete = [];
                    if($request->input('answers_images_edit') != null) {
                        foreach ($request->input('answers_images_edit') as $key => $answer_image) {
                            $diploma_question_details = DiplomasSupplementaryTestsQuestionsDetails::find($key);
                            $delete[] = $key;
                            $diploma_question_details->diplomas_supplementary_id = $supplementary_tests->id;
                            $diploma_question_details->quetion_id = $diploma_question->id;
                            $split_image = explode('images/', $answer_image);
                            $diploma_question_details->image = $split_image[1];
                            $delete[] = $split_image[1];
                            $diploma_question_details->name = '';
                            $diploma_question_details->answer = isset($data['chose_multiple'][$key]) && $data['chose_multiple'][$key] == $key ? 1 : 0;
                            $diploma_question_details->save();
                        }
                    }
                    if(Input::hasFile('answers_images')) {
                        $x=0;
                        foreach (Input::file('answers_images') as $key => $answer_image) {
                            if($Question_id == null) {
                                $diploma_question_details = new DiplomasSupplementaryTestsQuestionsDetails();
                                $diploma_question_details->order = $x;
                            } else {
                                $diploma_question_details = DiplomasSupplementaryTestsQuestionsDetails::find($key);
                                $delete[] = $key;
                            }
                            $diploma_question_details->diplomas_supplementary_id = $supplementary_tests->id;
                            $diploma_question_details->quetion_id = $diploma_question->id;
                            $img = $answer_image;
                            $img_name = uploadFileToE3melbusiness($img);
                            $diploma_question_details->image = $img_name;
                            $diploma_question_details->name = '';
                            $diploma_question_details->answer = isset($data['chose_multiple'][$key]) && $data['chose_multiple'][$key] == $key ? 1 : 0;
                            $diploma_question_details->save();
                            $x++;
                        }
                    }

                    $diploma_question_details = DiplomasSupplementaryTestsQuestionsDetails::where('quetion_id', $Question_id)->whereNotIn('id', $delete)->delete();
                    break;
            }

            $diploma_question = DiplomasSupplementaryTests::find($id);

            $courses_questions = DiplomasSupplementaryTestsQuestions::where('diplomas_supplementary_id', $id)->get();

            $returnHTML = view('auth.supplementary_tests.questions.question_body')->with(['courses_questions' => $courses_questions, 'diploma_question' => $diploma_question])->render();

            return response()->json(['html'=>$returnHTML], 200);
        }
    }




    public function destroy($id) {

        $diploma_questions = DiplomasSupplementaryTests::findOrFail($id);

        $diploma_questions->delete();

        if($diploma_questions) {
            Session::flash('success', Lang::get('main.update') . Lang::get('main.diploma_questions'));
        } else {
            Session::flash('error', Lang::get('main.update') . 'Something went wrong, Please Try again in a moment!');

        }
    }


    public function DeleteSupplementaryQuestions(Request $request) {
        admin_activity_action( 'delete', 'diplomas_supplementary_tests');

        $question = DiplomasSupplementaryTestsQuestions::where('id', $request->id)->first()->delete();

        $details  = DiplomasSupplementaryTestsQuestionsDetails::where('quetion_id', $request->id)->get();

        foreach ($details as $key => $value) {
            $value->delete();
        }

        if($question) {
            Session::flash('success', Lang::get('main.update') . Lang::get('main.diploma_questions'));
        } else {
            Session::flash('error', Lang::get('main.update') . 'Something went wrong, Please Try again in a moment!');

        }
    }


    public function getCourseCurriculums($id) {
        $course_curriculum = CoursesCurriculum::where('course_id', '=', $id)->where('type', '!=', 'default')->get();
        return response()->json($course_curriculum);
    }

    public function getCurriculumQuestions($id) {
        $courses_questions = CurriculumQuestions::where('curriculum_id', $id)->with('CurriculumQuestionsDetails')->get();
        return response()->json($courses_questions);
    }



    public function importCourseQuestions(Request $request) {
        dd($request->input());
    }

    public function searchCurriculumQuestions(Request $request) {
        $search = $request->input('contains');
        $curriculum_id = $request->input('curriculum_id');
        if ($search != null) {
            $courses_questions = CurriculumQuestions::where('curriculum_id', $curriculum_id)->where('name', 'like', "%$search%")->with('CurriculumQuestionsDetails')->get();
            if ($courses_questions->isEmpty()) {
                return response()->json('No search result');
            } else {
                return response()->json($courses_questions);
            }
        } else {
            $courses_questions = CurriculumQuestions::where('curriculum_id', $curriculum_id)->with('CurriculumQuestionsDetails')->get();
            return response()->json($courses_questions);
        }
    }

    public function fetchQuestions(Request $request) {
        $curriculum_questions = CurriculumQuestions::whereIn('id', $request->ids)->get();
        file_put_contents('featch_Q.log','START_CurriculumQuestions:'.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);



        foreach ($curriculum_questions as $key => $question) {
            //dd($question);
            if($question->type == 'true_false') {
                file_put_contents('featch_Q.log','START_ADD_TRUE_FALSE:'.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);
                $curriculum_question = new DiplomasSupplementaryTestsQuestions();
                $curriculum_question->diplomas_supplementary_id = $request->supplementary_tests_id;
                //$curriculum_question->diploma_id = $request->diploma_id;
                $curriculum_question->type = $question->type;
                $curriculum_question->name = $question->name;
                $curriculum_question->name_en = $question->name_en;
                $curriculum_question->image = $question->image;
                $curriculum_question->save();
                file_put_contents('featch_Q.log','START_SAVE_TRUE_FALSE:'.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);
                file_put_contents('featch_Q.log','START_add_DETAILS_TRUE_FALSE:'.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);
                $curriculum_question_details = new DiplomasSupplementaryTestsQuestionsDetails();
                $curriculum_question_details->diplomas_supplementary_id =
                $request->supplementary_tests_id;
                // $curriculum_question_details->diploma_id = $request->diploma_id;
                $curriculum_question_details->quetion_id = $curriculum_question->id;
                $curriculum_question_details->answer = $question->CurriculumQuestionsDetails->answer;
                $curriculum_question_details->order = 0;
                $curriculum_question_details->save();
                file_put_contents('featch_Q.log','START_SAVE_DETAILS_TRUE_FALSE:'.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);
            } else {
                $curriculum_question = new DiplomasSupplementaryTestsQuestions();

                $curriculum_question->diplomas_supplementary_id = $request->supplementary_tests_id;
                // $curriculum_question->diploma_id = $request->diploma_id;
                $curriculum_question->type = $question->type;
                $curriculum_question->name = $question->name;
                $curriculum_question->name_en = $question->name_en;
                $curriculum_question->image = $question->image;
                $curriculum_question->save();
                foreach ($question->CurriculumQuestionsDetails as $subkey => $answers) {
                    $curriculum_question_details = new DiplomasSupplementaryTestsQuestionsDetails();

                    $curriculum_question_details->diplomas_supplementary_id = $request->supplementary_tests_id;

                    $curriculum_question_details->diploma_id = $request->diploma_id;
                    // $curriculum_question_details->quetion_id = $curriculum_question->id;
                    $curriculum_question_details->name = $answers->name;
                    $curriculum_question_details->name_en = $answers->name_en;
                    $curriculum_question_details->image = $answers->image;
                    $curriculum_question_details->answer = $answers->answer;
                    $curriculum_question_details->order = $subkey;
                    $curriculum_question_details->save();
                }
            }
        }
        file_put_contents('featch_Q.log','END_CurriculumQuestions:'.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);

        file_put_contents('featch_Q.log','START_GET_DATA:'.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);

        $courses_questions = DiplomasSupplementaryTestsQuestions::where('diplomas_supplementary_id', $request->supplementary_tests_id)->get();

     $course_question = DiplomasSupplementaryTests::find($request->supplementary_tests_id);



        $returnHTML = view('auth.supplementary_tests.questions.question_body')->with(['courses_questions' => $courses_questions, 'course_question' => $course_question])->render();

        //dd($returnHTML);

        file_put_contents('featch_Q.log','END_GET_DATA:'.date('Y-m-d H:i:s').PHP_EOL , FILE_APPEND | LOCK_EX);
        return response()->json(['html' => $returnHTML], 200);
    }
}
